/*
* @category    Formulario Modelo Nota de Enfermeria
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winAddEvolucionCVMUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Nota de Enfermeria ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCDescripcionQuirurgica',
    initComponent: function() {
        
        //Store Locales
        var dataOjo = [
            ['Ojo Derecho'],
            ['Ojo Izquierdo'],
            ['Ambos Ojos']
        ];
        var stOjo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stOjo.loadData(dataOjo);
               
        var dataNomCirugia = [
            ['EXTRACCION EXTRACAPSULAR DE CATARATA + LIO'],
            ['FACOEMULCIFICACION CATARATA + LIO'],
            ['ARGON LASER'],
            ['YAG LASER'],
            ['AVANTIN O LUCENTIS'],
            ['OTRO']
        ];
        var stNomCirugia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stNomCirugia.loadData(dataNomCirugia);

        var dataGotas = [
            ['TP'],
            ['MYDRIACYL'],
            ['OQSEINA'],
            ['OQSEPTIC'],
            ['ISOPTOCARPINA'],
            ['ALCAINE'],
            ['LIDOCAINA GEL']
        ];
        var stGotas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stGotas.loadData(dataGotas);

        var dataAgujas = [
            ['COMPLETO'],
            ['INCOMPLETO']
        ];
        var stAgujas = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAgujas.loadData(dataAgujas);

        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                //title: 'EVOLUCION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                value: 'SI',
                                                readOnly: true,
                                                id: 'sysINGRESOPROGRAMA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysIdCodPlantillaHC'
                                            },
                                             {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                value: 1,
                                                id: 'sysUsaGridSalida'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                value: 0,
                                                id: 'sysYaGuardoHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysPlantillaHC',
                                                name: 'PLANTILLA'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptMx'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptExa'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysRutaRptRem'
                                            },
                                            /*{
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Actividad',
                                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                                id: 'sysActividadHC',
                                                name: 'PLANTILLA'
                                            },*/
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Empresa',
                                                id: 'sysEmpresaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'IPS',
                                                id: 'sysIPSHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Usuario',
                                                id: 'sysUsuarioHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                id: 'sysIdPacienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Apertura',
                                                id: 'sysAperturaHC'
                                            },/*
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Cliente',
                                                id: 'sysClienteHC'
                                            },*/
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdClienteHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdPlanHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdSubPlanHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Plantilla',
                                                id: 'sysIdContratoHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroPacHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Edad',
                                                id: 'sysEdadPacHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Profesional',
                                                id: 'sysProfesionalAgendaHC'
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'ConsecutivoDetalle',
                                                id: 'sysConsecutivoDetalleHC'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysIdCAS'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysFechaHC'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysHoraHC'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysLegalizaHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                                id: 'sysPacienteHC'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        width: 100,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysGeneroHC'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        width: 100,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysFechaNac'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        width: 350,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysEdadHC'
                                                    }
                                                ]
                                            },
                                            {
                                                html: '<hr>',
                                                style: 'background:transparent;',
                                                border: false
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Profesional',
                                                anchor: '100%',
                                                allowBlank: false,
                                                store: 'StoreProfesionales',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysProfesionalHC'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        width: 120,
                                                        fieldLabel: 'Fecha',
                                                        name: 'Fecha',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'sysFecha'
                                                    },
                                                    {
                                                        html: 'Hora:'
                                                    },
                                                    {
                                                        xtype: 'timefield',
                                                        name: 'Hora',
                                                        width: 90,
                                                        allowBlank: false,
                                                        forceSelection: false,
                                                        minValue: '06:00 AM',
                                                        maxValue: '09:00 PM',
                                                        emptyText: 'p.e. 07:00',
                                                        //format:'H:i',
                                                        id: 'sysHora'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDICION DE INGRESO',
                                                layout: 'form',
                                                labelWidth: 250,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Ingresa Paciente a area de Cirugia Conciente, orientado, Alerta, Desplazandose',
                                                        fieldLabel: 'Ingresa Paciente a area de Cirugia Conciente, orientado, Alerta, Desplazandose',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_1'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Acompanante',
                                                        fieldLabel: 'Acompañante',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_2'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Procedimiento a Realizar',
                                                                fieldLabel: 'Procedimiento a Realizar',
                                                                width: 300,
                                                                allowBlank: true,
                                                                store: stNomCirugia,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strNotaEnf_3'
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 300,
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_3A'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Se Semaforiza Ojo a Operar',
                                                        fieldLabel: 'Se Semaforiza Ojo a Operar',
                                                        width: 300,
                                                        allowBlank: true,
                                                        store: stOjo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strNotaEnf_4'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Se Realiza Toma de Signos Vitales',
                                                        fieldLabel: 'Se Realiza Toma de Signos Vitales',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        value: "NO",
                                                        triggerAction: 'all',
                                                        id: 'strNotaEnf_5'
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'FC'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'FC',
                                                                emptyText: '/min',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_6'
                                                            },
                                                            {
                                                                html: 'FR'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'FR',
                                                                emptyText: '/min',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_7'
                                                            },
                                                            {
                                                                html: 'TA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Sistolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_8'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Diastolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_9'
                                                            },
                                                            {
                                                                html: 'SPO2'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'SP02 %',
                                                                emptyText: '%',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_10'
                                                            },
                                                            {
                                                                html: 'Glucometria'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'Glucometria',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_11'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'checkbox',
                                                                fieldLabel: 'Se Aplican Gotas en Ojo a Operar Previo a Cirugia',
                                                                name: 'Se Aplican Gotas en Ojo a Operar Previo a Cirugia',
                                                                anchor: '100%',
                                                                value: 'false',
                                                                id: 'bolNotaEnf_12'
                                                            },
                                                            {
                                                                html: ' Cual:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Cual',
                                                                width: 200,
                                                                allowBlank: true,
                                                                store: stGotas,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strNotaEnf_13'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Se Administra Premedicacion',
                                                                fieldLabel: 'Se Administra Premedicacion',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                value: "NO",
                                                                triggerAction: 'all',
                                                                id: 'strNotaEnf_14'
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 300,
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_14A'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Se administra Anti-Hipertensivo?',
                                                                fieldLabel: 'Se administra Anti-Hipertensivo?',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strNotaEnf_15',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() === "NO"){
                                                                            Ext.getCmp('strNotaEnf_16').allowBlank = true;
                                                                            Ext.getCmp('strNotaEnf_16').setValue(null);
                                                                            Ext.getCmp('strNotaEnf_16').disable();
                                                                            Ext.getCmp('strNotaEnf_16').clearInvalid();
                                                                            Ext.getCmp('strNotaEnf_16A').allowBlank = true;
                                                                            Ext.getCmp('strNotaEnf_16A').setValue(null);
                                                                            Ext.getCmp('strNotaEnf_16A').disable();
                                                                            Ext.getCmp('strNotaEnf_16A').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strNotaEnf_16').enable();
                                                                            Ext.getCmp('strNotaEnf_16').allowBlank = false;
                                                                            Ext.getCmp('strNotaEnf_16A').enable();
                                                                            Ext.getCmp('strNotaEnf_16A').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                              html: 'Hora'  
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 70,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strNotaEnf_16'
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 150,
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_16A'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Hora'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 70,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_17'
                                                            },
                                                            {
                                                                html: 'TA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Sistolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_18_1'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Diastolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_18_2'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Hora'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 70,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_19'
                                                            },
                                                            {
                                                                html: 'TA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Sistolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_20_1'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Diastolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_20_2'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                html: 'Hora'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 70,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                id: 'strNotaEnf_21'
                                                            },
                                                            {
                                                                html: 'TA'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Sistolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_22_1'
                                                            },
                                                            {
                                                                html: '/'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                name: 'TA-Diastolica',
                                                                width: 60,
                                                                allowBlank: true,
                                                                value: 0,
                                                                id: 'intNotaEnf_22_2'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'PROCEDIMIENTOS QUIRURGICOS',
                                                layout: 'form',
                                                labelWidth: 250,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Hora de Ingreso Paciente a Quirofonos',
                                                        fieldLabel: 'Hora de Ingreso Paciente a Quirofonos',
                                                        width: 70,
                                                        emptyText: 'hh:mm',
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_23'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'HORA DE INICIO PROCEDIMIENTO',
                                                        fieldLabel: 'HORA DE INICIO PROCEDIMIENTO',
                                                        width: 70,
                                                        emptyText: 'hh:mm',
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_25'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'HORA CULMINACION PROCEDIMIENTO',
                                                        fieldLabel: 'HORA CULMINACION PROCEDIMIENTO',
                                                        width: 70,
                                                        emptyText: 'hh:mm',
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_26'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'COMPLICACION',
                                                                fieldLabel: 'COMPLICACION',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strNotaEnf_27',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strNotaEnf_28').allowBlank = true;
                                                                            Ext.getCmp('strNotaEnf_28').setValue(null);
                                                                            Ext.getCmp('strNotaEnf_28').disable();
                                                                            Ext.getCmp('strNotaEnf_28').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strNotaEnf_28').enable();
                                                                            Ext.getCmp('strNotaEnf_28').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strNotaEnf_28'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                name: 'MUESTRA PATOLOGICA',
                                                                fieldLabel: 'MUESTRA PATOLOGICA',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strNotaEnf_29',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strNotaEnf_30').allowBlank = true;
                                                                            Ext.getCmp('strNotaEnf_30').setValue(null);
                                                                            Ext.getCmp('strNotaEnf_30').disable();
                                                                            Ext.getCmp('strNotaEnf_30').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strNotaEnf_30').enable();
                                                                            Ext.getCmp('strNotaEnf_30').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Cual'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Cual',
                                                                width: 500,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strNotaEnf_30'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'RECUENTO DE AGUJAS',
                                                        fieldLabel: 'RECUENTO DE AGUJAS',
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: stAgujas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strNotaEnf_31'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Auxiliar en Quirofano',
                                                        fieldLabel: 'Auxiliar en Quirofano',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_32'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'POST-QUIRURGICOS',
                                                layout: 'form',
                                                labelWidth: 250,
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Se Entrego Formato de Recomendaciones Post-Quirurgicas, Formula Medicamentos, Fecha Control Postoperatorio',
                                                        fieldLabel: 'Se Entrego Formato de Recomendaciones Post-Quirurgicas, Formula Medicamentos, Fecha Control Postoperatorio',
                                                        width: 60,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strNotaEnf_33',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() == "NO"){
                                                                    Ext.getCmp('fecNotaEnf_34').allowBlank = true;
                                                                    Ext.getCmp('fecNotaEnf_34').setValue(null);
                                                                    Ext.getCmp('fecNotaEnf_34').disable();
                                                                    Ext.getCmp('fecNotaEnf_34').clearInvalid();
                                                                    Ext.getCmp('strNotaEnf_35').allowBlank = true;
                                                                    Ext.getCmp('strNotaEnf_35').setValue(null);
                                                                    Ext.getCmp('strNotaEnf_35').disable();
                                                                    Ext.getCmp('strNotaEnf_35').clearInvalid();
                                                                }else{
                                                                    Ext.getCmp('fecNotaEnf_34').enable();
                                                                    Ext.getCmp('fecNotaEnf_34').allowBlank = false;
                                                                    Ext.getCmp('strNotaEnf_35').enable();
                                                                    Ext.getCmp('strNotaEnf_35').allowBlank = false;
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/ano) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecNotaEnf_34'
                                                            },
                                                            {
                                                                html: 'Hora:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Hora',
                                                                width: 150,
                                                                emptyText: 'hh:mm',
                                                                allowBlank: true,
                                                                disabled: true,
                                                                id: 'strNotaEnf_35'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 650,
                                                        fieldLabel: 'OBSERVACIONES',
                                                        name: 'OBSERVACIONES',
                                                        height: 88,            
                                                        allowBlank: true,
                                                        id: 'memNotaEnf_36'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Auxiliar en el Egreso del Paciente',
                                                        fieldLabel: 'Auxiliar en el Egreso del Paciente',
                                                        width: 300,
                                                        allowBlank: true,
                                                        id: 'strNotaEnf_37'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    Ext.getCmp('winHCDescripcionQuirurgica').close();
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    fnGuardarRegistrosMedicinaGeneral();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddEvolucionCVMUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
        Ext.Msg.show({
        title: 'Guardar Evolucion....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes")
            {
                var frm = Ext.getCmp('frmHC').getForm();
                var listacampos = ExtraerCamposFrmHC(frm);
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/asistencial/evolucionhc2014.php',
                        params: {
                            task: 'GUARDA_NOTA_ENFERMERIA',
                            CAMPOS: listacampos,
                            pEmpresa: ID_EMPRESA,
                            pIPS: ID_IPS,
                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                            pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                            pFechaAtencion: Ext.getCmp('sysFecha').getValue(),
                            pHoraAtencion: Ext.getCmp('sysHora').getValue(),
                            pCAS: Ext.getCmp('sysIdCAS').getValue(),
                            pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                            pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                            pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                            pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                            pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                            pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                            pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar SignosVitales',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winHCDescripcionQuirurgica').close();
                                    Ext.getCmp('gridNotasEnfermeria').store.baseParams = {
                                        task: 'LISTAR_NOTAS_ENFERMERIA',
                                        pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                                        pIPS: ID_IPS
                                    };
                                    Ext.getCmp('gridNotasEnfermeria').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar SignosVitales',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}

