/*
* @category    Formulario Control de Signos Vitales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddEvolucion002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Evolucion Enfermeria ::.',
    width: 1000,
    height: 636,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    id: 'winAddEvolucion002',
    initComponent: function() {
        
        var dataParentesco = [
            ['SIN ACOMPAÑANTE'],
            ['CONYUGUE O COMPANERO PERMANENTE'],
            ['HIJO - HIJA'],
            ['PADRE - MADRE'],
            ['OTRO MIEMBRO DE LA FAMILIA'],
            ['OTRO NO PERTENECIENTE A LA FAMILIA']
        ];
        var stParentesco = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stParentesco.loadData(dataParentesco);
        
        var dataPais = [
            ['COLOMBIA'],
            ['BRASIL'],
            ['PERU'],
            ['OTRO']
        ];
        var stPais = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPais.loadData(dataPais);  
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '85%',
                id: 'panelHC',
                border: false,
                autoHeight: true,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmAddHCEvolucion002',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                value: 'NA',
                                fieldLabel: 'Pantalla',
                                id: 'sysPantalla'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoRegistro',
                                id: 'sysConsecutivoRegistro'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdPaciente',
                                id: 'sysIdPaciente'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'FechaRegistro',
                                value: new Date().format('Y-m-d'),
                                id: 'sysFechaRegistro'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>DATOS BASICOS</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnDatosBasicos',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo Doc ID',
                                                anchor: '75%',
                                                name: 'cbTdoc',
                                                allowBlank: false,
                                                store: 'StoreTdocPac',
                                                readOnly: true,
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Tipo Documento....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                id: 'sysTipoDoc'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Documento',
                                                id: 'sysDocumento'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                emptyText: 'Primer Apellido',
                                                id: 'sysPrimerApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Apellido',
                                                id: 'sysSegundoApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Primer Nombre',
                                                id: 'sysPrimerNombre'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Nombre',
                                                id: 'sysSegundoNombre'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 150,
                                                name: 'Fecha Nac',
                                                fieldLabel: 'Fecha Nac',
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Genero'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 200,
                                                name: 'Genero',
                                                allowBlank: false,
                                                readOnly: true,
                                                store: 'StoreGenero',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                emptyText: 'Seleccione Genero....',
                                                forceSelection: true,
                                                id: 'sysGenero'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: false,
                                        readOnly: true,
                                        emptyText: 'CAS',
                                        fieldLabel: 'CAS',
                                        id: 'sysIdCAS'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>Evolucion</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                labelWidth: 100,
                                autoHeight: true,
                                id: 'pnEvolucion',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Profesional',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: 'StoreProfesionales',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                fieldLabel: 'Fecha',
                                                name: 'Fecha',
                                                allowBlank: false,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                value: new Date().format('Y-m-d'),
                                                id: 'sysFecha'
                                            },
                                            {
                                                html: 'Hora:'
                                            },
                                            {
                                                xtype: 'timefield',
                                                name: 'Hora',
                                                width: 90,
                                                allowBlank: false,
                                                forceSelection: false,
                                                minValue: '06:00 AM',
                                                maxValue: '09:00 PM',
                                                emptyText: 'p.e. 07:00',
                                                //format:'H:i',
                                                id: 'sysHora'
                                            }
                                        ]
                                    },
                                    
                                    {
                                        xtype: 'fieldset',
                                        title: 'Acompañante - Responsable',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 5,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Pais Origen',
                                                        name: 'Pais Origen',
                                                        width: 300,
                                                        allowBlank: false,
                                                        store: stPais,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strPais',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "OTRO"){
                                                                    Ext.getCmp('strPaisCual').allowBlank = false;
                                                                    Ext.getCmp('strPaisCual').enable();
                                                                }else{
                                                                    Ext.getCmp('strPaisCual').allowBlank = true;
                                                                    Ext.getCmp('strPaisCual').disable();
                                                                    Ext.getCmp('strPaisCual').clearInvalid();
                                                                    Ext.getCmp('strPaisCual').setValue(null);
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: 'Cual:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Cual',
                                                        width: 300,
                                                        disabled: true,
                                                        allowBlank: true,
                                                        id: 'strPaisCual'
                                                    }    
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: false,
                                                        id: 'strAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 320,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strParentescoAcompanante'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Responsable',
                                                name: 'Responsable',
                                                anchor: '100%',
                                                allowBlank: true,
                                                id: 'strResponsable'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Direccion',
                                                        name: 'Direccion',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDireccionResponsable'
                                                    },
                                                    {
                                                        html: 'Telefono'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Telefono',
                                                        width: 338,
                                                        allowBlank: true,
                                                        id: 'strTelefonoResponsable'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'TOMA SIGNOS',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        labelSeparator: '',
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        fieldLabel: 'T.A.',
                                                        name: 'T.A. Sistolica',
                                                        width: 70,
                                                        minValue: 0,
                                                        maxValue: 300,
                                                        decimalPrecision: 0,
                                                        allowBlank: false,
                                                        emptyText: 'Sistolica',
                                                        id: 'intEXAFISTASistolica'
                                                    },
                                                    {
                                                        html: '/'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'T.A. Diastolica',
                                                        width: 70,
                                                        minValue: 0,
                                                        maxValue: 300,
                                                        decimalPrecision: 0,
                                                        allowBlank: false,
                                                        emptyText: 'Diastolica',
                                                        id: 'intEXAFISTADiastolica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        fieldLabel: 'TALLA (cm)',
                                                        name:"TALLA (cm)",
                                                        emptyText: '(cm)',
                                                        id: 'intEXAFISTalla',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('intEXAFISTalla').setValue(null);
                                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                }else{
                                                                    if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                    }else{
                                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                    }
                                                                }
                                                               if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                }else{
                                                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                    }else{
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEXAFISPeso',
                                                        value: 'PESO (Kg) '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        emptyText: '(Kg)',
                                                        name:"PESO (Kg)",
                                                        id: 'intEXAFISPeso',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('intEXAFISPeso').setValue(null);
                                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                }else{
                                                                    //peso [kg]/ estatura [m2]
                                                                    if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                                    }else{
                                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                                    }
                                                                }
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                                }else{
                                                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                                    }else{
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                                }else{
                                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                                        }else{
                                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                                            }else{
                                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysEXAFISIMC',
                                                        value: 'IMC '
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        name: "IMC",
                                                        id: 'intEXAFISIMC'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        name: "IMC - CLASIFICACION",
                                                        id: 'strEXAFISIMCClasificacon'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        fieldLabel: 'Temp',
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        name: 'Temperatura',
                                                        allowBlank: false,
                                                        id: 'intEXAFISTemp'
                                                    },
                                                    {
                                                        html: 'F.C.'
                                                    },                                                            
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        name: 'FC',
                                                        allowBlank: false,
                                                        id: 'intEXAFISFC'
                                                    },
                                                    {
                                                        html: 'F.R.'
                                                    },                                                            
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        name: 'FR',
                                                        allowBlank: false,
                                                        id: 'intEXAFISFR'
                                                    },
                                                    {
                                                        html: 'SPO2'
                                                    },                                                            
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        name: 'SPO2',
                                                        allowBlank: false,
                                                        id: 'intEXAFISSPO2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        fieldLabel: 'Masa Corporal',
                                                        name: "Masa Corporal",
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        readOnly: true,
                                                        id: 'intMasaCorporal'
                                                    },
                                                    {
                                                        html: "Masa Muscular"
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: "Masa Muscular",
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        readOnly: true,
                                                        id: 'intMasaMuscular'
                                                    },
                                                    {
                                                        html: "Grasa Corporal"
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: "Grasa Corporal",
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        readOnly: true,
                                                        id: 'intGrasaCorporal'
                                                    },
                                                    {
                                                        html: "Grasa Visceral"
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: "Grasa Visceral",
                                                        width: 60,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: false,
                                                        readOnly: true,
                                                        id: 'intGrasaVisceral'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Evolucion',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCrearEvolucion002',
                            listeners:{
                                click : function(){
                                    guardarEvolucionEnfermeria();
                            }
                        }
                    }
                ]
            }
        }];
        winAddEvolucion002Ui.superclass.initComponent.call(this);
    }
});

function guardarEvolucionEnfermeria(){
        Ext.Msg.show({
        title: 'Guardar Evolucion....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes")
            {
                var frm = Ext.getCmp('frmAddHCEvolucion002').getForm();
                var listacampos = ExtraerCamposFrmHC(frm);
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/asistencial/evolucionhc2014.php',
                        params: {
                            task: 'GUARDA_NOTA_ENFERMERIA',
                            CAMPOS: listacampos,
                            pEmpresa: ID_EMPRESA,
                            pIPS: ID_IPS,
                            pPaciente: Ext.getCmp('sysIdPaciente').getValue(),
                            pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                            pFechaAtencion: Ext.getCmp('sysFecha').getValue(),
                            pHoraAtencion: Ext.getCmp('sysHora').getValue(),
                            pCAS: Ext.getCmp('sysIdCAS').getValue(),
                            pDiagppal: "Z038",
                            pDiagrel1: "",
                            pDiagrel2: "",
                            pDiagrel3: "",
                            pTipodiag: "1",
                            pFinalidad: "10",
                            pCausa: "13",
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar SignosVitales',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winAddEvolucion002').close();
                                    Ext.getCmp('gridNotasEnfermeria').store.baseParams = {
                                        task: 'LISTAR_NOTAS_ENFERMERIA',
                                        pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                                        pIPS: ID_IPS
                                    };
                                    Ext.getCmp('gridNotasEnfermeria').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar SignosVitales',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
