/*
* @category    Formulario Adicionar Historial Laboral
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddHistorialLaboralUi = Ext.extend(Ext.Window, {
    title: '.:: Historial Laboral ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddHistorialLaboralUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddHistoLaboral',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intPacienteHistoLaboral',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Empresa',
                                anchor: '100%',
                                name: 'EMPRESA',
                                allowBlank: true,
                                store: 'StoreEmpresaTrabaja',
                                forceSelection: false,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'strEmpresaHistoLaboral'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cargo',
                                anchor: '100%',
                                allowBlank: true,
                                store: 'StoreCargoActual',
                                forceSelection: false,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                id: 'strCargoHistoLaboral'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Tiempo',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'strTiempoHistoLaboral'
                            },
                            {
                                xtype: 'panel',
                                layout: 'table',
                                columns: 2,
                                border: false,
                                items: [
                                    {
                                        xtype: 'panel',
                                        width: 791,
                                        layout: 'form',
                                        autoHeight: true,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                fieldLabel: 'Factores de Riesgo',
                                                height: 35,
                                                anchor: '99%',
                                                grow: true,
                                                growMin: 35,
                                                growMax: 400,
                                                allowBlank: true,
                                                id: 'memFactorRiesgoHistoLaboral'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        id: 'sysSelectRiesgoHistoLaboral',
                                        items:[
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Seleccionar Riesgos',
                                                id: 'btnSelectRiesgoHistoLaboral',
                                                listeners:{
                                                    click : function(){
                                                        var searchFactoresRiesgo = new winSeleccionarRiesgosUi();
                                                        Ext.getCmp('sysOpcionFacRiesgo').setValue("HistorialLaboral");
                                                        searchFactoresRiesgo.show();
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'table',
                                columns: 2,
                                border: false,
                                items: [
                                    {
                                        xtype: 'panel',
                                        width: 791,
                                        layout: 'form',
                                        autoHeight: true,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                fieldLabel: 'Elementos de Protección',
                                                height: 35,
                                                anchor: '99%',
                                                grow: true,
                                                growMin: 35,
                                                growMax: 400,
                                                allowBlank: true,
                                                id: 'memElementosProtecHistoLaboral'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        id: 'sysSelectElementosProtecHistoLaboral',
                                        items:[
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Seleccionar Riesgos',
                                                id: 'btnSelectElementosProtecHistoLaboral',
                                                listeners:{
                                                    click : function(){
                                                        var searchElementosProtec = new winSeleccionarElementosUi();
                                                        Ext.getCmp('sysOpcionElementosProtec').setValue("HistorialLaboral");
                                                        searchElementosProtec.show();
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Guardar Historial',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                fnGuardarRegItemHisLab("GUARDAR_HISTORIAL_LABORAL","SI","winAddHistorialLaboralUi","frmAddHistoLaboral","../../controlador/asistencial/saludocupacional.php","gridHistorialLaboral");
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddHistorialLaboralUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemHisLab(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
