/*
* @category    Formulario Salud Ocupacional Partysalud
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCPartisalud001ValoracionMedicaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Valoración Medica - Salud Ocupacional ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var xSolMX = new SolMx003SOUi();
        Ext.getCmp('gridMedicamentosHC').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS,
                pPaciente: wPaciente,
                pCAS: wCAS
            }
        });
        
        var xSolEXA = new SolExa003SOUi();
        Ext.getCmp('gridExamenesHC').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS,
                pPaciente: wPaciente,
                pCAS: wCAS
            }
        });
        
        var xSolREM = new SolRem003SOUi();
        Ext.getCmp('gridRemisionesHC').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS,
                pPaciente: wPaciente,
                pCAS: wCAS
            }
        });
                
        var stProfesionales = new StoreProfesionales();
        stProfesionales.load({
            params: {
                pUsuario: ID_USUARIO
            }
        });
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        var stGridHistorialLaboral = new StoreGridHistorialLaboral();
        stGridHistorialLaboral.load({
            params: {
                pPaciente: paramIdPaciente,
                IdNew: '1180'
            }
        });
        var stGridHistorialAtenciones = new StoreGridProcesosxPacientePartisalud();
        stGridHistorialAtenciones.load({
            params: {
                pPaciente: paramIdPaciente,
                IdNew: '1190'
            }
        });
                            
        this.items = [
            {
                xtype: 'panel',
                layout: 'form',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 0,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        value: 'VALORACION MEDICA',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysFechaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        //autoHeight: true,
                        height: 560,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'HISTORIA CLINICA OCUPACIONAL',
                                autoScroll: true,
                                frame: true,
                                border: false,
                                anchor: '100%',
                                id: 'fichaHCOcupacional',
                                layout: 'form',
                                tbar: {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'button',
                                            text: 'Ver Historia Clínica',
                                            iconCls: 'btnVerHC',
                                            id: 'btnVerHC',
                                            listeners:{
                                                click : function(){
                                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                                        renderTo: Ext.getBody()
                                                    });
                                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                                        params: {
                                                            pEmpresa: ID_EMPRESA,
                                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                                        }
                                                    });
                                                    cmpResumenHC.show();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar Historia',
                                            iconCls: 'btnGuardar',
                                            id: 'btnGuardarEvolucion',
                                            listeners:{
                                                click : function(){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que desea guardar la evolución, si hace esto ya no podra realizar ningun cambio?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn)
                                                        {
                                                            if(btn=="yes")
                                                            {
                                                                fnModificarRegistrosValoracionMedica();
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        url: '../../controlador/asistencial/saludocupacional.php',
                                        padding: 0,
                                        border: false,
                                        autoScroll: true,
                                        autoHeight: true,
                                        style: 'background:transparent;',
                                        items: [ // UNO
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        width: 230,
                                                        allowBlank: true,
                                                        value: 'ASISTE SOLO',
                                                        id: 'strAcompananteNombrePacSO'
                                                    },
                                                    {
                                                        html: 'Parentesco'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 200,
                                                        allowBlank: true,
                                                        id: 'strAcompananteParentescoPacSO'
                                                    },
                                                    {
                                                        html: 'Telefono'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 140,
                                                        allowBlank: true,
                                                        id: 'strAcompanantePacTelefonoSO'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IDENTIFICACION DEL TRABAJADOR',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs0',
                                                labelWidth: 170,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        fieldLabel: 'Paciente',
                                                        id: 'sysPacienteHC'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Nacimiento',
                                                                anchor: '100%',
                                                                allowBlank: false,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFechaNacPacSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_1',
                                                                value: 'Edad:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 515,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                id: 'strEdadPacSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Estado Civil - Nivel Academico',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 340,
                                                                store: 'StoreEstadoCivil',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                emptyText: 'Estado Civil',
                                                                allowBlank: true,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                triggerAction: 'all',
                                                                id: 'strEstadoCivilSO'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 350,
                                                                store: 'StoreEscolaridad',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                emptyText: 'Nivel Academico',
                                                                allowBlank: true,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                triggerAction: 'all',
                                                                id: 'strNivelAcademicoSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dirección - Teléfono - Municipio',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtDireccion',
                                                                allowBlank: false,
                                                                emptyText: 'Dirección....',
                                                                style: 'text-transform:uppercase;',
                                                                width: 260,
                                                                id: 'strDireccionSO'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTelefono',
                                                                allowBlank: false,
                                                                emptyText: 'Telefono',
                                                                width: 140,
                                                                id: 'strTelefonoSO'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 285,
                                                                name: 'cbDeptoMuni',
                                                                allowBlank: false,
                                                                store: 'StoreDeptoMuni',
                                                                valueField: 'IdDeptoMunicipio',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Municipio - Departamento....',
                                                                mode: 'local',
                                                                listWidth: 450,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'strMunicipioSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Numero de Personas a Cargo',
                                                        allowBlank: true,
                                                        value: 0,
                                                        width: 100,
                                                        id: 'strNroPersonasCargoSO'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Cargo que Aspira',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 300,
                                                                id: 'strCargoAspiraSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_1a',
                                                                value: 'Empresa:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 335,
                                                                allowBlank: false,
                                                                id: 'strEmpresaAspiraSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Cargo Actual',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 300,
                                                                id: 'strCargoEmpresaActualSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_1b',
                                                                value: 'Empresa:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 175,
                                                                allowBlank: true,
                                                                id: 'strEmpresaActualSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_1c',
                                                                value: 'Sede:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 110,
                                                                allowBlank: true,
                                                                id: 'strNomSedeEmpresaActualSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Antigudad',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_1e',
                                                                value: 'En el Cargo Actual:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 100,
                                                                emptyText: 'Años',
                                                                id: 'strAntiguedadCargoActualSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_1f',
                                                                value: 'En el Oficio:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 100,
                                                                emptyText: 'Años',
                                                                id: 'strAntiguedadOficioSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'Empresa',
                                                        name: 'EMPRESA',
                                                        anchor: "100%",
                                                        allowBlank: true,
                                                        id: 'strEmpresaSaludOcupacional'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Examen',
                                                                width: 100,
                                                                listWidth: 150,
                                                                name: 'TIPO EXAMEN',
                                                                allowBlank: false,
                                                                store: 'StoreTipoExamenSaludOcupacional',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                submitValue: true,
                                                                id: 'strTipoExamen',
                                                                listeners:{
                                                                    scope: this,
                                                                    select: function(cmb, rec, idx) {
                                                                        if(cmb.getValue() !== "Ingreso" || cmb.getValue() !== "Otro"){
                                                                            Ext.getCmp('strEmpresaActualSO').allowBlank = false;
                                                                            Ext.getCmp('strCargoAspiraSO').allowBlank = true;
                                                                            Ext.getCmp('strEmpresaAspiraSO').allowBlank = true;
                                                                        }else{
                                                                            Ext.getCmp('strEmpresaActualSO').allowBlank = true;
                                                                            Ext.getCmp('strCargoAspiraSO').allowBlank = false;
                                                                            Ext.getCmp('strEmpresaAspiraSO').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys1',
                                                                value: 'EPS:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 180,
                                                                listWidth: 500,
                                                                name: 'EPS',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSEPS',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NO APLICA',
                                                                id: 'strEPS'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2',
                                                                value: 'PENSION:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 145,
                                                                listWidth: 500,
                                                                name: 'PENSION',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSPENSION',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NO APLICA',
                                                                id: 'strPENSION'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys3',
                                                                value: 'ARL:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 140,
                                                                listWidth: 500,
                                                                name: 'ARP',
                                                                allowBlank: false,
                                                                store: 'StoreSGSSARP',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'DESCONOCIDO',
                                                                id: 'strARP'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Tipo Vinculación',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 315,
                                                                allowBlank: false,
                                                                store: 'StoreTipoVinculacionContrato',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'strTipoVinculacionContratoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys_1g',
                                                                value: 'Turno:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 315,
                                                                allowBlank: false,
                                                                store: 'StoreTurnoLaboral',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'strTurnoSO'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs2',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 860,
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 50,
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs2_1',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 50,
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                anchor: '100%',
                                                autoHeight: true,
                                                layout: 'form',
                                                collapsible: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 6
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                anchor: '50%',
                                                                height: 150,
                                                                layout: 'form',
                                                                padding: 10,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Infecciones',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPInfeccionesSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Patológicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPPatologicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Tóxicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPToxicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Alérgicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPAlergicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Traumáticos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPTraumaticosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                anchor: '50%',
                                                                height: 150,
                                                                layout: 'form',
                                                                padding: 10,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Quirúrgicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPQuirurgicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Inmunológicos',
                                                                        allowBlank: false,
                                                                        store: 'StoreCompletasIncompletas',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "COMPLETAS",
                                                                        id: 'strAPInmunologicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Hospitalarios',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPHospitalariosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Enfermedades Psiquiátricas',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPEnfPsiquiatraSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 430,
                                                                height: 150,
                                                                colspan: 4,
                                                                layout: 'table',
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        labelAlign: 'top',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textarea',
                                                                                width: 420,
                                                                                fieldLabel: 'OTROS',
                                                                                name: 'ANTECEDENTES PERSONALES',
                                                                                height: 60,         
                                                                                allowBlank: false,
                                                                                value: 'NINGUNO',
                                                                                id: 'memAntecedentesPersonales'
                                                                            }
                                                                        ]
                                                                    }
                                                                    
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'GINECO–OBSTÉTRICOS',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        id: 'fsAPGINECO',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Menarquia',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 120,
                                                                        id: 'strAPGinecoMenarquiaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_a',
                                                                        value: 'Ciclos:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 140,
                                                                        store: 'StoreCiclosMestruales',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        triggerAction: 'all',
                                                                        id: 'strAPGinecoCiclosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_b',
                                                                        value: 'FUM:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        id: 'fecAPGinecoFUMSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_c',
                                                                        value: 'FUP:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        id: 'fecAPGinecoFUPSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: '',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_d',
                                                                        value: 'G:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 40,
                                                                        id: 'strAPGinecoNumGSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_e',
                                                                        value: 'P:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 40,
                                                                        id: 'strAPGinecoNumPSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_f',
                                                                        value: 'A:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 40,
                                                                        id: 'strAPGinecoNumASO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_g',
                                                                        value: 'V:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 40,
                                                                        id: 'strAPGinecoNumVSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_h',
                                                                        value: 'C:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 40,
                                                                        id: 'strAPGinecoNumCSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_i',
                                                                        value: 'M:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 40,
                                                                        id: 'strAPGinecoNumMSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_j',
                                                                        value: 'FUC:'
                                                                    },
                                                                    {
                                                                        xtype: 'datefield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        emptyText: '(dia/mes/año) ',
                                                                        id: 'fecAPGinecoFUCSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_k',
                                                                        value: 'Resultado:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        id: 'strAPGinecoFUCResultadoSO'
                                                                    },
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: '',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Planifica Actualente',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPPlanificaActualmenteSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_l',
                                                                        value: 'Metodo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 340,
                                                                        store: 'StoreMetodosPlanificacion',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        allowBlank: true,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        triggerAction: 'all',
                                                                        id: 'strAPPlanificaMetodoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_m',
                                                                        value: 'Tiempo:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        id: 'strAPPlanificaTiempoSO'
                                                                    },
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ANTECEDENTES TÓXICOS',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Fuma Actualente',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPToxicosFuamaActualmenteSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_o',
                                                                        value: 'Nro Cigarrillos Dia:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        id: 'strAPToxicosNroCigarrillosActualSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_p',
                                                                        value: 'Tiempo:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        emptyText: "Años",
                                                                        id: 'strAPToxicosFumaActualmenteTiempoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Fumó Anteriormente',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPToxicosFuamoAnteriormenteSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_q',
                                                                        value: 'Nro Cigarrillos Dia:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        id: 'strAPToxicosNroCigarrillosAnteriorSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_r',
                                                                        value: 'Tiempo:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 140,
                                                                        emptyText: "Años",
                                                                        id: 'strAPToxicosFumaAnteriormenteTiempoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Consumo de Alcohol',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPToxicosConsumoAlcoholSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_s',
                                                                        value: 'Freciencia:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 130,
                                                                        allowBlank: false,
                                                                        store: 'StoreFrecuenciaConsumo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NUNCA",
                                                                        id: 'strAPToxicosConsumoAlcoholTipoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_t',
                                                                        value: 'Estado de Embriaguez:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPToxicosConsumoAlcoholEmbiaguezSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Consumé Drogas o Alguna Otra Sustancia?',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPToxicosConsumoDrograsSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys2_v',
                                                                        value: 'Cual:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        allowBlank: true,
                                                                        width: 500,
                                                                        value: "NINGUNA",
                                                                        id: 'strAPToxicosConsumoDrograsCualSO'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'EN EL PUESTO DE TRABAJO ACTUAL O ANTERIOR ESTÁ (O ESTUVO) EXPUESTO A',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Frio Intenso',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a1',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaFrioIntensoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b1',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroFrioIntensoSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Calor Intenso',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a2',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaCalorIntensoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b2',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroCalorIntensoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Ventilación Inadecuada',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a3',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaVentilacioninadecuadaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b3',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroVentilacioninadecuadaSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Ruido',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a4',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaRuidoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b4',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroRuidoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Vibraciones',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a5',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaVibracionesSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b5',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroVibracionesSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Luz Excesiva',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a6',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaLuzexcesivaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b6',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroLuzexcesivaSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Luz Deficiente',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a7',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaLuzdeficienteSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b7',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroLuzdeficienteSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Radiacion No Ionizante',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a8',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaRadiacionNoIonizanteSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b8',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroRadiacionNoIonizanteSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Radiacion Ionizante',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a9',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaRadiacionIonizanteSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b9',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroRadiacionIonizanteSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Humos',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a10',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaHumosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b10',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroHumosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Polvos',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a11',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaPolvosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b11',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroPolvosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Gases',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a12',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaGasesSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b12',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroGasesSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Vapores',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a13',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaVaporesSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b13',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroVaporesSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Contacto de Piel con Quimicos',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a14',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaContactodepielconquimicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b14',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroContactodepielconquimicosSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Humos Metalicos',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a15',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaHumosmetalicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b15',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroHumosmetalicosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Agentes Biologicos',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a16',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaAgentesBiologicosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b16',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroAgentesBiologicosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Diseño Inadecuado de Muebles',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a17',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaDisenoinadecuadodemueblesSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b17',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroDisenoinadecuadodemueblesSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Movimientos Repetitivos',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a18',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaMovimientosRepetitivosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b18',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroMovimientosRepetitivosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Posturas Inadecuadas',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a19',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaPosturasInadecuadasSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b19',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroPosturasInadecuadasSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Levantamiento de Cargas',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a20',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaLevantamientodecargasSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b20',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroLevantamientodecargasSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Espacio Trabajo Inadecuado',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a21',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaEspacioTrabajoInadecuadoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b21',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroEspacioTrabajoInadecuadoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Estrés',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a22',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaEstrasSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b22',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroEstrasSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Trabajo Monotono',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a23',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaTrabajomonotonoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b23',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroTrabajomonotonoSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Sobrecarga de Trabajo',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a24',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaSobrecargadetrabajoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b24',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroSobrecargadetrabajoSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Horas Extras Sobretiempo',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a25',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaHorasextrasSobretiempoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b25',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroHorasextrasSobretiempoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Manejo de Publico',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a26',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaManejodepublicoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b26',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroManejodepublicoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Conflicto de Autoridad',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a27',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaConflictodeAutoridadSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b27',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroConflictodeAutoridadSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Violencia Comun',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a28',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaViolenciacomunSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b28',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroViolenciacomunSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Herramientas Manuales',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a29',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaHerramientasmanualesSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b29',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroHerramientasmanualesSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Proyeccion de Particulas',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a30',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaProyecciondeparticulasSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b30',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroProyecciondeparticulasSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Mecanismos en Movimiento',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a31',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaMecanismosenmovimientoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b31',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroMecanismosenmovimientoSO'
                                                                    }
                                                                ]
                                                            }, 
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Equipos a Presion',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a32',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaEquiposapresionSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b32',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroEquiposapresionSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Electricos',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_a33',
                                                                        value: 'Empresa:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoEmpresaElectricosSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys3_b33',
                                                                        value: 'Otro:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strAPExpuestoOtroElectricosSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Empresa',
                                                                name: 'Empresa',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'strExpuestoEmpresaSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Cómo realiza sus tareas?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: 'StoreComoRealizaTareas',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'strAPComoRealizaTareasSO'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ELEMENTOS DE PROTECCIÓN PERSONAL',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Casco',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a1',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCascoNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b1',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCascoTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c1',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCascoUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Cofias',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a2',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCofiasNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b2',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCofiasTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c2',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCofiasUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Gorro',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a3',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGorroNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b3',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGorroTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c3',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGorroUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Careta de Acetato',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a4',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCaretadeacetatoNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b4',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCaretadeacetatoTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c4',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCaretadeacetatoUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Gafas de Seguridad',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a5',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGafasdeSeguridadNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b5',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGafasdeSeguridadTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c5',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGafasdeSeguridadUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Mascarilla Desechable',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a6',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strMascarilladesechableNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b6',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strMascarilladesechableTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c6',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strMascarilladesechableUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Protectores Auriculares',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a7',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strProtectoresAuricularesNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b7',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strProtectoresAuricularesTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c7',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strProtectoresAuricularesUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Guantes',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a8',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGuantesNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b8',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGuantesTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c8',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strGuantesUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Braceras',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a9',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strBracerasNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b9',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strBracerasTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c9',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strBracerasUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Peto',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a10',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strPetoNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b10',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strPetoTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c10',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strPetoUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Delantal',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a11',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strDelantalNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b11',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strDelantalTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c11',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strDelantalUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Calzado de Seguridad',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a12',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCalzadodeSeguridadNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b12',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCalzadodeSeguridadTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c12',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strCalzadodeSeguridadUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Bata',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a13',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strBataNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b13',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strBataTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c13',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strBataUtilizoSO'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                fieldLabel: 'Otros',
                                                                items: [
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_a14',
                                                                        value: 'Necesita:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strOtrosNecesitaSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_b14',
                                                                        value: 'Tiene:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strOtrosTieneSO'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sys4_c14',
                                                                        value: 'Utilizo:'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strOtrosUtilizoSO'
                                                                    },
                                                                    {
                                                                        xtype: 'textarea',
                                                                        width: 200,
                                                                        name: 'OTROS ELEMENTOS DE PROTECCION PERSONAL',
                                                                        allowBlank: true,
                                                                        id: 'memOtrosElementosProtecionPersonalSO'
                                                                    }
                                                                ]
                                                            } 
                                                        // FIN
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        title: '',
                                                        unstyled: true,
                                                        layoutConfig: {
                                                            columns: 4
                                                        },
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',// col6
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Realiza Deporte',
                                                                        name: 'HACE DEPORTE',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        forceSelection: false,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NO',
                                                                        id: 'strAPDeporte',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if (cmb.getValue() == "SI"){
                                                                                    Ext.getCmp('strAPDeporteOtros').enable();
                                                                                    Ext.getCmp('strAPDeporteOtros').allowBlank = false;
                                                                                }else{
                                                                                    Ext.getCmp('strAPDeporteOtros').setValue('');
                                                                                    Ext.getCmp('strAPDeporteOtros').disable();
                                                                                    Ext.getCmp('strAPDeporteOtros').allowBlank = true;
                                                                                    Ext.getCmp('strAPDeporteOtros').clearInvalid();
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',// col7
                                                                width: 750,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                colspan: 2,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        fieldLabel: 'Cuáles Practica?',
                                                                        name: 'CUALES PRACTICA',
                                                                        disabled: true,
                                                                        anchor: '99%',
                                                                        height: 25,
                                                                        grow: true,
                                                                        growMin: 25,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'strAPDeporteOtros'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ACCIDENTE DE TRABAJO',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ha tenido algún accidente de trabajo?',
                                                                name: 'Ha tenido algún accidente de trabajo?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strSufrioAccidenteTrabajoSO'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Diagnóstico',
                                                                name: 'Diagnóstico',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'strSufrioAccidenteTrabajoDxSO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 140,
                                                                allowBlank: true,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecSufrioAccidenteTrabajo'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                id: 'strSufrioAccidenteTrabajoIncSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ENFERMEDAD PROFESIONAL',
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        layout: 'form',
                                                        collapsible: true,
                                                        labelWidth: 200,
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ha tenido alguna enfermedad profesional?',
                                                                name: 'Ha tenido alguna enfermedad profesional?',
                                                                width: 100,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strSufrioEnfProfesionalSO'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                fieldLabel: 'Diagnóstico',
                                                                name: 'Diagnóstico',
                                                                anchor: '99%',
                                                                height: 25,
                                                                grow: true,
                                                                growMin: 25,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'strSufrioEnfProfesionalDxSO'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 140,
                                                                allowBlank: true,
                                                                fieldLabel: 'Fecha',
                                                                name: 'Fecha',
                                                                style: 'text-align:center;',
                                                                emptyText: '(dia/mes/año) ',
                                                                id: 'fecSufrioEnfProfesionalSO'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '99%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                id: 'strSufrioEnfProfesionalIncSO'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                anchor: '100%',
                                                autoHeight: true,
                                                layout: 'form',
                                                collapsible: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'HTA',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_a1',
                                                                value: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFHTAPadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_b1',
                                                                value: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFHTAMadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_c1 ',
                                                                value: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFHTAHnoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_d1',
                                                                value: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFHTATioMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_e1',
                                                                value: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFHTATioPSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_f1',
                                                                value: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFHTAAbuMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_g1',
                                                                value: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFHTAAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Enf. Coronaria',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_a2',
                                                                value: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfCoronariaPadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_b2',
                                                                value: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfCoronariaMadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_c2 ',
                                                                value: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfCoronariaHnoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_d2',
                                                                value: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfCoronariaTioMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_e2',
                                                                value: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfCoronariaTioPSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_f2',
                                                                value: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfCoronariaAbuMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_g2',
                                                                value: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfCoronariaAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'ACV',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_a3',
                                                                value: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFACVPadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_b3',
                                                                value: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFACVMadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_c3 ',
                                                                value: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFACVHnoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_d3',
                                                                value: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFACVTioMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_e3',
                                                                value: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFACVTioPSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_f3',
                                                                value: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFACVAbuMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_g3',
                                                                value: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFACVAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Diabetes',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_a4',
                                                                value: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFDiabetesPadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_b4',
                                                                value: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFDiabetesMadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_c4 ',
                                                                value: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFDiabetesHnoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_d4',
                                                                value: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFDiabetesTioMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_e4',
                                                                value: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFDiabetesTioPSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_f4',
                                                                value: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFDiabetesAbuMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_g4',
                                                                value: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFDiabetesAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Enf. Mental',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_a5',
                                                                value: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfMentalPadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_b5',
                                                                value: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfMentalMadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_c5 ',
                                                                value: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfMentalHnoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_d5',
                                                                value: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfMentalTioMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_e5',
                                                                value: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfMentalTioPSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_f5',
                                                                value: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfMentalAbuMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_g5',
                                                                value: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFEnfMentalAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Síndrome Convulsivo',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_a6',
                                                                value: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFSindromeConvulsivoPadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_b6',
                                                                value: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFSindromeConvulsivoMadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_c6 ',
                                                                value: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFSindromeConvulsivoHnoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_d6',
                                                                value: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFSindromeConvulsivoTioMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_e6',
                                                                value: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFSindromeConvulsivoTioPSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_f6',
                                                                value: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFSindromeConvulsivoAbuMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_g6',
                                                                value: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFSindromeConvulsivoAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Alcoholismo Drogadicción',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_a7',
                                                                value: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFAlcoholDrogaPadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_b7',
                                                                value: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFAlcoholDrogaMadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_c7 ',
                                                                value: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFAlcoholDrogaHnoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_d7',
                                                                value: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFAlcoholDrogaTioMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_e7',
                                                                value: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFAlcoholDrogaTioPSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_f7',
                                                                value: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFAlcoholDrogaAbuMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_g7',
                                                                value: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFAlcoholDrogaAbuPSO'
                                                            }
                                                        ]
                                                    }, 
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        fieldLabel: 'Cáncer',
                                                        items: [
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_a8',
                                                                value: 'Padre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFCAPadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_b8',
                                                                value: 'Madre:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFCAMadSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_c8 ',
                                                                value: 'Hnos:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFCAHnoSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_d8',
                                                                value: 'Tio(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFCATioMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_e8',
                                                                value: 'Tio(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFCATioPSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_f8',
                                                                value: 'Abu(M):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFCAAbuMSO'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys5_g8',
                                                                value: 'Abu(P):'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 60,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAFCAAbuPSO'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        height: 50,     
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: false,
                                                        value: 'NINGUNO',
                                                        id: 'memAntecedentesFamiliaresSO'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'REVISION POR SISTEMAS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs5',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Oftalmológico',
                                                        name: 'Oftalmológico',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSOftalmologico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'ORL',
                                                        name: 'ORL',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSORL'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Respiratorio',
                                                        name: 'RESPIRATORIO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSRespiratorio'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Cardiovascular',
                                                        name: 'Cardiovascular',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSCardiovascular'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Digestivo',
                                                        name: 'DIGESTIVO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSDigestivo'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Genito-Urinario',
                                                        name: 'Genito-Urinario',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSUrogenital'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Osteo-muscular',
                                                        name: 'Osteo-muscular',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSLocomotor'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Nervioso',
                                                        name: 'NERVIOSO',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSNervioso'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Psico-emocional',
                                                        name: 'Psico-emocional',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        value: "NO REFIERE",
                                                        id: 'memRSHematopoyetico'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        fieldLabel: 'Observaciones',
                                                        name: 'Observaciones',
                                                        anchor: '100%',
                                                        height: 50,   
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true,
                                                        id: 'memRSOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs6',
                                                items: [
                                                    { // Tabla Examen Fisico
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        unstyled: true,
                                                        layoutConfig: {
                                                            columns: 5
                                                        },
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Estado General',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ESTADO GENERAL",
                                                                        id: 'strEF_EstadoGeneral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_EstadoGeneralH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_EstadoGeneralH').setValue(null);
                                                                                    Ext.getCmp('memEF_EstadoGeneralH').disable();
                                                                                    Ext.getCmp('memEF_EstadoGeneralH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_EstadoGeneralH').enable();
                                                                                    Ext.getCmp('memEF_EstadoGeneralH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ESTADO GENERAL - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_EstadoGeneralH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Estado General',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - CABEZA",
                                                                        id: 'strEF_Cabeza',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_CabezaH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_CabezaH').setValue(null);
                                                                                    Ext.getCmp('memEF_CabezaH').disable();
                                                                                    Ext.getCmp('memEF_CabezaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_CabezaH').enable();
                                                                                    Ext.getCmp('memEF_CabezaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - CABEZA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_CabezaH'
                                                                    }
                                                                ]
                                                            },
                                                            
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Ojos',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - OJOS",
                                                                        id: 'strEF_Ojos1',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_Ojos1H').allowBlank = true;
                                                                                    Ext.getCmp('memEF_Ojos1H').setValue(null);
                                                                                    Ext.getCmp('memEF_Ojos1H').disable();
                                                                                    Ext.getCmp('memEF_Ojos1H').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_Ojos1H').enable();
                                                                                    Ext.getCmp('memEF_Ojos1H').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - OJOS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_Ojos1H'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Oidos',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - OIDOS",
                                                                        id: 'strEF_Oidos',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_OidosH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_OidosH').setValue(null);
                                                                                    Ext.getCmp('memEF_OidosH').disable();
                                                                                    Ext.getCmp('memEF_OidosH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_OidosH').enable();
                                                                                    Ext.getCmp('memEF_OidosH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - OIDOS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_OidosH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Nariz',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - NARIZ",
                                                                        id: 'strEF_Nariz',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_NarizH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_NarizH').setValue(null);
                                                                                    Ext.getCmp('memEF_NarizH').disable();
                                                                                    Ext.getCmp('memEF_NarizH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_NarizH').enable();
                                                                                    Ext.getCmp('memEF_NarizH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - NARIZ - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_NarizH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Boca',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - BOCA",
                                                                        id: 'strEF_Boca',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_BocaH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_BocaH').setValue(null);
                                                                                    Ext.getCmp('memEF_BocaH').disable();
                                                                                    Ext.getCmp('memEF_BocaH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_BocaH').enable();
                                                                                    Ext.getCmp('memEF_BocaH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - BOCA - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_BocaH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Cuello',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - CUELLO",
                                                                        id: 'strEF_Cuello',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_CuelloH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_CuelloH').setValue(null);
                                                                                    Ext.getCmp('memEF_CuelloH').disable();
                                                                                    Ext.getCmp('memEF_CuelloH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_CuelloH').enable();
                                                                                    Ext.getCmp('memEF_CuelloH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - CUELLO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_CuelloH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Tórax',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - TORAX",
                                                                        id: 'strEF_Torax',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_ToraxH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_ToraxH').setValue(null);
                                                                                    Ext.getCmp('memEF_ToraxH').disable();
                                                                                    Ext.getCmp('memEF_ToraxH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_ToraxH').enable();
                                                                                    Ext.getCmp('memEF_ToraxH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - TORAX - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_ToraxH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 5.1
                                                                        fieldLabel: 'Abdomen',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - ABDOMEN",
                                                                        id: 'strEF_Abdomen',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_AbdomenH').setValue("RsIs: POSITIVOS NORMALES");
                                                                                }else{
                                                                                    Ext.getCmp('memEF_AbdomenH').setValue(null);
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ABDOMEN - HALLAZGOS",
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: false,
                                                                        value: 'RsIs: POSITIVOS NORMALES',
                                                                        id: 'memEF_AbdomenH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Sistema Genital',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - GENITALES",
                                                                        id: 'strEF_Genitales',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_GenitalesH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_GenitalesH').setValue(null);
                                                                                    Ext.getCmp('memEF_GenitalesH').disable();
                                                                                    Ext.getCmp('memEF_GenitalesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_GenitalesH').enable();
                                                                                    Ext.getCmp('memEF_GenitalesH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - GENITALES - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        value: "NO SE EXPLORA",
                                                                        id: 'memEF_GenitalesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Aparato Músculo–Esquelético',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - MUSCULO ESQUELETICO",
                                                                        id: 'strEF_Musculo',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_MusculoH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_MusculoH').setValue(null);
                                                                                    Ext.getCmp('memEF_MusculoH').disable();
                                                                                    Ext.getCmp('memEF_MusculoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_MusculoH').enable();
                                                                                    Ext.getCmp('memEF_MusculoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - MUSCULO ESQUELETICO - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_MusculoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Sistema Vascular',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - SISTEMA VASCULAR",
                                                                        id: 'strEF_Vascular',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_VascularH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_VascularH').setValue(null);
                                                                                    Ext.getCmp('memEF_VascularH').disable();
                                                                                    Ext.getCmp('memEF_VascularH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_VascularH').enable();
                                                                                    Ext.getCmp('memEF_VascularH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - SISTEMA VASCULAR",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_VascularH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Sistema Nervioso',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - SISTEMA NERVIOSO",
                                                                        id: 'strEF_Nervioso',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_NerviosoH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_NerviosoH').setValue(null);
                                                                                    Ext.getCmp('memEF_NerviosoH').disable();
                                                                                    Ext.getCmp('memEF_NerviosoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_NerviosoH').enable();
                                                                                    Ext.getCmp('memEF_NerviosoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - SISTEMA NERVIOSO",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_NerviosoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', // col 2.1
                                                                        fieldLabel: 'Piel',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - PIEL Y FANERAS",
                                                                        id: 'strEF_PielFaneras',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_PielFanerasH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_PielFanerasH').setValue(null);
                                                                                    Ext.getCmp('memEF_PielFanerasH').disable();
                                                                                    Ext.getCmp('memEF_PielFanerasH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_PielFanerasH').enable();
                                                                                    Ext.getCmp('memEF_PielFanerasH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 2.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - PIEL Y FANERAS - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_PielFanerasH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo', 
                                                                        fieldLabel: 'Estado Mental',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreNormalAnormal',
                                                                        forceSelection: true,
                                                                        triggerAction: 'all',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        mode: 'local',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        emptyText: 'Seleccione....',
                                                                        value: 'NORMAL',
                                                                        name:"EXANEN FISICO - GENITALES - ESFERA MENTAL",
                                                                        id: 'strEF_EsfMental',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(Ext.getCmp('strEF_EsfMental').getValue() == "NORMAL"){
                                                                                    Ext.getCmp('memEF_EsfMentalH').allowBlank = true;
                                                                                    Ext.getCmp('memEF_EsfMentalH').setValue(null);
                                                                                    Ext.getCmp('memEF_EsfMentalH').disable();
                                                                                    Ext.getCmp('memEF_EsfMentalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEF_EsfMentalH').enable();
                                                                                    Ext.getCmp('memEF_EsfMentalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', // col 5.2-5
                                                                width: 780,
                                                                colspan:4,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"EXANEN FISICO - ESFERA MENTAL - HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEF_EsfMentalH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'DIAGNOSTICO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs11',
                                                items: [
                                                    {
                                                        xtype: 'combo', 
                                                        fieldLabel: 'Paciente Sano',
                                                        name: 'PACIENTE SANO',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: 'StoreSiNo',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        value: 'SI',
                                                        id: 'strDx_PacienteSano'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: '1',
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 15,
                                                        id: 'sysCausaExternaHC'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros Diagnosticos Relacionados',
                                                        name: 'Otros Diagnosticos Relacionados',
                                                        height: 50, 
                                                        grow: true,
                                                        minGrow: 50,
                                                        allowBlank: true  ,
                                                        id: 'memResumenDx'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONCEPTO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs13',
                                                items: [
                                                     {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 3,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO SIN RESTRICCIONES',
                                                                        name: 'APTO SIN RESTRICCIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoSinRest'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO CON RESTRICCIONES',
                                                                        name: 'APTO CON RESTRICCIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoConRest'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO CON CONDICIONES',
                                                                        name: 'APTO CON CONDICIONES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoConCondi'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'NO APTO TEMPORALMENTE',
                                                                        name: 'NO APTO TEMPORALMENTE',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPNoAptoTempo'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'NO APTO',
                                                                        name: 'NO APTO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPNoApto'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO PARA TRABAJAR EN ALTURAS',
                                                                        name: 'APTO PARA TRABAJAR EN ALTURAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoTrabajoAlturas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'APTO PARA MANIPULAR ALIMENTOS',
                                                                        name: 'APTO PARA MANIPULAR ALIMENTOS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPAptoManipularAlimentos'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'POSIBLE PATOLOGIA ORIGEN LABORAL',
                                                                        name: 'POSIBLE PATOLOGIA ORIGEN LABORAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPPatologiaLaboral'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'CON SECUELAS DE ACCIDENTE LABORAL',
                                                                        name: 'CON SECUELAS DE ACCIDENTE LABORAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPSecuelasLaboral'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EXAMEN PERIODICO NORMAL',
                                                                        name: 'EXAMEN PERIODICO NORMAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPExamenPeriodicoNormal'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EXAMEN RETIRO NORMAL',
                                                                        name: 'EXAMEN RETIRO NORMAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPExamenRetiroNormal'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EXAMEN DE RETIRO CON ENFERMEDAD GENERAL',
                                                                        name: 'EXAMEN DE RETIRO CON ENFERMEDAD GENERAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPExamenRetiroEnfermedadGeneral'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                     },
                                                     {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 2,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PACIENTE SANO',
                                                                        name: 'PACIENTE SANO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPPacienteSano'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PACIENTE CON PROBALE ENFERMEDAD PROFESIONAL',
                                                                        name: 'PACIENTE CON PROBALE ENFERMEDAD PROFESIONAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPProbableEnfProfesional'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PACIENTE CON SECUELAS DE ACCIDENTE DE TRABAJO',
                                                                        name: 'PACIENTE CON SECUELAS DE ACCIDENTE DE TRABAJO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCONCEPSecuelasAccidenteTrabajo'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                     },
                                                     {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Descripción',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: true,
                                                        id: 'memConcepto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'TIPO DE RESTRICCIONES O CAUSA DE APLAZAMIENTO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs12',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Descripción',
                                                        name: 'TIPO DE RESTRICCIONES O CAUSA DE APLAZAMIENTO',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: false,
                                                        value: 'NINGUNO',
                                                        id: 'memRestricciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INGRESO A PROGRAMAS ESPECIALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs19',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 3,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'CARDIOVASCULAR',
                                                                        name: 'CARDIOVASCULAR',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENCardiovascular'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'ERGONÓMICO',
                                                                        name: 'ERGONÓMICO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENErgonomico'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'VISUAL',
                                                                        name: 'VISUAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENVisual'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'PSICOSOCIAL',
                                                                        name: 'PSICOSOCIAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENPsicosocial'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'BIOLÓGICO',
                                                                        name: 'BIOLÓGICO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENBiologico'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'RUIDO',
                                                                        name: 'RUIDO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRuido'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'RADIACIÓN IONIZANTE',
                                                                        name: 'RADIACIÓN IONIZANTE',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRadiacionIonizante'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'RADIACIÓN NO IONIZANTE',
                                                                        name: 'RADIACIÓN NO IONIZANTE',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRadiacionNoIonizante'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 100,
                                                                        fieldLabel: 'Seguimiento de Salud Ocupacional',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strRECOMENSegtoSaludOcupacSO'
                                                                    }                                                                    
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RECOMENDACIONES Y OBSERVACIONES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                id: 'fs15',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        columns: 3,
                                                        border: false,
                                                        items: [
                                                            {
                                                                xtype: 'panel', // col 4.1
                                                                width: 105,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: []
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'USO ADECUADO DE ELEMENTOS DE PROTECCION',
                                                                        name: 'USO ADECUADO DE ELEMENTOS DE PROTECCION',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENUsoAdecuadoElem'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'CONTROL ANUAL POR OPTOMETRIA EN LA EPS',
                                                                        name: 'CONTROL ANUAL POR OPTOMETRIA EN LA EPS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENControlAnualOptometria'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PAUSAS ACTIVAS',
                                                                        name: 'REALIZAR PAUSAS ACTIVAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRealizaPausasActivas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DEBE CERTIFICARSE PARA TRABJAR EN ALTURAS',
                                                                        name: 'DEBE CERTIFICARSE PARA TRABJAR EN ALTURAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENCertificarTrabajoAlturas'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'USAR MEDIAS DE SOPORTE ELASTICO PARA VARICES',
                                                                        name: 'USAR MEDIAS DE SOPORTE ELASTICO PARA VARICES',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENUsarMediasVarices'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR CITOLOGIA ANUAL',
                                                                        name: 'REALIZAR CITOLOGIA ANUAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRealizarCitologia'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR DIETA, EJERCICIO Y REDUCIR PESO',
                                                                        name: 'REALIZAR DIETA, EJERCICIO Y REDUCIR PESO',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENRealizarDietaEjercicio'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 400,
                                                                layout: 'form',
                                                                labelWidth: 250,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'EVALUAR POR NUTRICION EN LA EPS',
                                                                        name: 'EVALUAR POR NUTRICION EN LA EPS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENEvaluarxNutricion'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DEJAR EL HABITO DE FUMAR',
                                                                        name: 'DEJAR EL HABITO DE FUMAR',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENDejarFumar'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'DISMINUIR CONSUMO DE ALCOHOL',
                                                                        name: 'DISMINUIR CONSUMO DE ALCOHOL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENDisminuirConsumoAlcohol'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'INGRESAR AL SISTEMA DE VIGILANCIA EPIDEMIOLOGICA',
                                                                        name: 'INGRESAR AL SISTEMA DE VIGILANCIA EPIDEMIOLOGICA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENIngresarProgaEpidemio'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PRUEBAS PARA MANIPULACION DE ALIMENTOS',
                                                                        name: 'REALIZAR PRUEBAS PARA MANIPULACION DE ALIMENTOS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENPruebasManipulaAlimentos'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'REALIZAR PRUEBAS COMPLEMENTARIAS',
                                                                        name: 'REALIZAR PRUEBAS COMPLEMENTARIAS',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENPruebasComplementarias'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'HIGIENE POSTURAL',
                                                                        name: 'HIGIENE POSTURAL',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolRECOMENHigienePostural'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'OTROS',
                                                        height: 50,            
                                                        grow: true,
                                                        minGrow: true,
                                                        allowBlank: true,
                                                        id: 'memRECOMENOtros'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Profesional Responsable',
                                                anchor: '99%',
                                                name: 'Profesional',
                                                allowBlank: false,
                                                store: stProfesionales,
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'sysProfesionalHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Concepto',
                                                width: 150,
                                                name: 'CONCEPTO',
                                                allowBlank: false,
                                                store: 'StoreAptoNoApto',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'strConceptoMedicoOcupacional'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'HISTORIAL LABORAL',
                                //autoHeight: true,
                                //height: 300,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                id: 'fichaHistorialLaboral',
                                layout: 'form',
                                items: [
                                     {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridHistorialLaboral',
                                        store: stGridHistorialLaboral,
                                        anchor: "100%",
                                        height: 320,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'idConsecutivo',
                                                id: 'idConsecutivo'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Paciente',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'idPaciente',
                                                id: 'idPaciente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Empresa',
                                                sortable: false,
                                                width: 250,
                                                dataIndex: 'descEmpresa',
                                                id: 'descEmpresa'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Cargo',
                                                sortable: false,
                                                width: 180,
                                                dataIndex: 'descCargo',
                                                id: 'descCargo'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Tiempo',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'descTiempo',
                                                id: 'descTiempo'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Riesgo',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'descRisego',
                                                renderer: DescripcionGrid,
                                                id: 'descRisego'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Elementos Protección',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'descElementos',
                                                renderer: DescripcionGrid,
                                                id: 'descElementos'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar Registro',
                                                        iconCls: 'btnAddRow',
                                                        id: 'btnAddHistorialLaboral',
                                                        listeners: {
                                                            click : function() {
                                                                var winHistorialLobral = new winAddHistorialLaboralPartisaludUi();
                                                                Ext.getCmp('intPacienteHistoLaboral').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                winHistorialLobral.show();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar Registro',
                                                        iconCls: 'btnDelRow',
                                                        id: 'btnDelHistorialLaboral',
                                                        listeners: {
                                                            click : function() {
                                                                 if(Ext.getCmp('gridHistorialLaboral').selModel.getCount() == 1)
                                                                {
                                                                    var selections = Ext.getCmp('gridHistorialLaboral').selModel.getSelections();
                                                                    Ext.Msg.show({
                                                                        title: 'Historial Laboral',
                                                                        msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descEmpresa + ', ' + selections[0].json.descCargo + '?',
                                                                        buttons: Ext.Msg.YESNO,
                                                                        icon: Ext.Msg.QUESTION,
                                                                        fn: function(btn)
                                                                        {
                                                                            if(btn=="yes")
                                                                            {
                                                                                fnEliminarRegistros("../../controlador/asistencial/saludocupacional.php",{task: "ELIMINAR_HISTORIAL_LABORAL", pIdHistorial: selections[0].json.idConsecutivo}, 'gridHistorialLaboral')
                                                                            }
                                                                        }
                                                                    });
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    }
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'HISTORIAL DE ATENCIONES',
                                autoScroll: true,
                                frame: true,
                                border: false,
                                id: 'fichaHistorialAtenciones',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'grid',
                                        id: 'gridProcesoPartisaludxPac',
                                        store: stGridHistorialAtenciones,
                                        title: '',
                                        anchor: "100%",
                                        border: false,
                                        frame: true,
                                        height: 510,
                                        tbar:{
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Actualizar',
                                                    iconCls: 'btnActualizarGrid',
                                                    tooltip: 'Actualizar',
                                                    id: 'btnActualizarInfoPac1',
                                                    listeners:{
                                                        click : function(){
                                                            Ext.getCmp('gridProcesoPartisaludxPac').store.reload();
                                                        }
                                                    }
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Imprimir Historia',
                                                    iconCls: 'btnImprimir',
                                                    tooltip: 'Imprimir Historia',
                                                    id: 'btnPrintHCSO1',
                                                    listeners:{
                                                        click : function(){
                                                            if(Ext.getCmp('gridProcesoPartisaludxPac').selModel.getCount() == 1){
                                                                var selections = Ext.getCmp('gridProcesoPartisaludxPac').selModel.getSelections();
                                                                window.open ("../../controlador/asistencial/printsaludocupa.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Historia Ocupacional");
                                                            }
                                                        }
                                                    }
                                                }
                                            ]
                                        },
                                        columns: [
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'IdCliente',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdCliente'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'CAS',
                                                sortable: false,
                                                width: 80,
                                                hidden: false,
                                                hideable: false,
                                                dataIndex: 'CAS'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: false,
                                                width: 80,
                                                hidden: false,
                                                hideable: false,
                                                dataIndex: 'FechaAtencion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Cliente',
                                                sortable: false,
                                                width: 200,
                                                hidden: false,
                                                hideable: false,
                                                dataIndex: 'Cliente'
                                            },
                                            {
                                                header: 'Concepto Final',
                                                dataIndex: 'ConceptoFinal',
                                                sortable: true,
                                                width: 100
                                            },
                                            {
                                                header: 'Tamizaje Visual',
                                                dataIndex: 'ConceptoTomaSignos',
                                                sortable: true,
                                                width: 130
                                            },
                                            {
                                                header: 'Concepto Laboratorio',
                                                dataIndex: 'ConceptoLaboratorio',
                                                sortable: true,
                                                width: 130
                                            },
                                            {
                                                header: 'Concepto Fonoaudiologia',
                                                dataIndex: 'ConceptoFonoaudiologia',
                                                sortable: true,
                                                width: 130
                                            },
                                            {
                                                header: 'Concepto Medicina',
                                                dataIndex: 'ConceptoMedicoOcupacional',
                                                sortable: true,
                                                width: 130
                                            },
                                            {
                                                header: 'Tipo Examen',
                                                dataIndex: 'TipoExamen',
                                                sortable: false,
                                                width: 150
                                            }
                                        ],
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                switch(record.get('ConceptoFinal')){
                                                    case "APTO":
                                                        return 'Apto';
                                                        break;
                                                    case "NO APTO":
                                                        return 'NoApto';
                                                        break;
                                                    default:
                                                        break;
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted no ha guardado la historia clinica y se perdera la informacion. Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnSalirValoracionMedica();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                //alert("OPCION: " + paramOpcion);
                if(paramOpcion != "Nuevo"){
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.load({
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                            task: 'SALUDOCUPA_CARGAR_DATA_VALORACIONMEDICA'
                        }
                    });
                }else{
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.load({
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                            task: 'PARTISALUD_CARGAR_DATA_VALORACIONMEDICA_BASICO'
                        },
                        callback: function(){
                            if(Ext.getCmp('strTipoExamen').getValue() !== "Ingreso" || Ext.getCmp('strTipoExamen').getValue() !== "Otro"){
                                Ext.getCmp('strEmpresaActualSO').allowBlank = false;
                                Ext.getCmp('strCargoAspiraSO').allowBlank = true;
                                Ext.getCmp('strEmpresaAspiraSO').allowBlank = true;
                            }else{
                                Ext.getCmp('strEmpresaActualSO').allowBlank = true;
                                Ext.getCmp('strCargoAspiraSO').allowBlank = false;
                                Ext.getCmp('strEmpresaAspiraSO').allowBlank = false;
                            }
                        }
                    });
                    var frm1 = Ext.getCmp('frmHC').getForm();
                    frm1.load({
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                            task: 'PARTISALUD_CARGAR_DATA_VALORACIONMEDICA_ANTECEDENTES'
                        }
                    });
                }
                
            }}
        }); 
        winHCPartisalud001ValoracionMedicaUi.superclass.initComponent.call(this);
    }
});

function fnModificarRegistrosValoracionMedica(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/saludocupacional.php',
            params:{
                task: 'SALUDOCUPA_VALORACIONMEDICA',
                CAMPOS: listacampos,
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoHC: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnSalirValoracionMedica(){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: '../../controlador/asistencial/saludocupacional.php',
        params:{
            task: 'PARTISALUD_SALIR_VALORACIONMEDICA',
            pCAS: Ext.getCmp('sysCASHC').getValue(),
            pConsecutivoHC: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
        },
        callback: function(res,req)
        {
            Ext.getCmp('gridFormulario').store.reload();
            Ext.getCmp('winHC').close();
        }
    });
}
