/*
* @category    Formulario Grid Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmVerAgendaUi = Ext.extend(Ext.Window, {
    //title: 'OfiClinic© Web..! .:: Agenda por Profesional ::.',
    id: 'winFrmVerAgenda',
    closable:false,
    draggable : false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    padding: 5,
    frame: true,
    layout: 'form',
    initComponent: function() {
        function VerHoraLegaliza(value, metaData, record, rowIndex, colIndex, store){
            metaData.attr = '<style="white-space:normal;"';
            return '<p style="color: red; font-weight:bold; text-decoration:blink; text-align:center;">'+value + '</p>Hora Estimada Atención: </br>' + record.get('HoraAtencion');
	}
        
        function VerPaciente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<p>' + record.get('TipDoc') + '-' + record.get('Documento') + '</br>' + record.get('PrimerNombre') + ' ' + record.get('SegundoNombre') + ' ' + record.get('PrimerApellido') + ' ' + record.get('SegundoApellido') + '</br>Genero: ' + record.get('Genero') + ' FecNac: ' + record.get('FecNac') + '</br>' + record.get('Edad');  
        }
        
        function VerCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('DescAdiHora');  
        }
        
        function VerCliente(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return record.get('Cliente') + '</br>' + record.get('Actividad') + '</br>Programa: ' + record.get('Programa');  
        }
        
        function renderEstado(value, p, record){
            return String.format(
                '<b style="color:#36C;">{0}</b><table border="0"><tr><td>Codigo Interno:</td><td>{1}</td></tr><tr><td>Codigo CUPS:</td><td>{2}</td></tr></table>',
                value, record.data.CodProced, record.data.CUPSCodigo);
        }
        
        function DescripcionProfesional(val, x, store){
            if(store.data.ConceptoMedicoOcupacional == "" || store.data.ConceptoMedicoOcupacional == null){
                return "";
            }else{
                return val;
            }
        }
        
        var mybbar = new utilBbarUi();
        var stGrid = new StoreGridProcesosPartisalud();
        stGrid.load({
            params: {
                pFecha: 10
            }
        })
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'hidden',
                fieldLabel: 'Profesional',
                allowBlank: true,
                store: 'StoreVerAgendaProfesionales',
                forceSelection: true,
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                typeAheadDelay: 50,
                emptyText: 'Seleccione Profesional....',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                anchor: '100%',
                submitValue: true,
                value: 1,
                id: 'sysProfeAgenda'
            },
            {
                xtype: 'hidden',
                fieldLabel: 'Ubicación',
                allowBlank: true,
                store: 'StoreVerUbicacionAgenda',
                forceSelection: true,
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                typeAheadDelay: 50,
                emptyText: 'Seleccione Ubicacion....',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                anchor: '100%',
                submitValue: true,
                disabled: true,
                value: 1,
                id: 'sysUbicacionAgenda'
            },
            {
                xtype: 'datefield',
                fieldLabel: 'Fecha Proceso',
                width: 120,
                allowBlank: false,
                style: 'text-align:center;',
                emptyText: '(dia/mes/año) ',
                id: 'sysFechaAgenda'
            },
            {
                xtype: 'grid',
                id: 'gridFormulario',
                store: stGrid,
                anchor: "100%",
                height: 400,
                border: false,
                frame: true,
                //loadMask: true,
                //stripeRows: true,
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'IdCliente',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdCliente'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Paciente',
                        sortable: false,
                        width: 200,
                        hidden: false,
                        hideable: false,
                        dataIndex: 'NomPaciente'
                    },
                    {
                        header: 'Proceso Actual',
                        dataIndex: 'ProcesoActual',
                        sortable: true,
                        width: 130
                    },
                    {
                        header: 'Ubicación Actual',
                        dataIndex: 'UbicacionActual',
                        sortable: true,
                        width: 100
                    },
                    {
                        header: 'Tamizaje Visual',
                        dataIndex: 'ConceptoTomaSignos',
                        sortable: true,
                        width: 130
                    },
                    {
                        header: 'Toma Muestras',
                        dataIndex: 'TomaMuestras',
                        sortable: false,
                        width: 70
                    },
                    {
                        header: 'Concepto Laboratorio',
                        dataIndex: 'ConceptoLaboratorio',
                        sortable: true,
                        width: 130
                    },
                    {
                        header: 'Concepto Fonoaudiologia',
                        dataIndex: 'ConceptoFonoaudiologia',
                        sortable: true,
                        width: 130
                    },
                    {
                        header: 'Concepto Medicina',
                        dataIndex: 'ConceptoMedicoOcupacional',
                        sortable: true,
                        width: 130
                    },
                    {
                        header: 'Medico Ocupacional',
                        dataIndex: 'NomProfesional',
                        sortable: true,
                        renderer: DescripcionProfesional,
                        width: 130
                    },
                    {
                        header: 'Tipo Examen',
                        dataIndex: 'TipoExamen',
                        sortable: false,
                        width: 150
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cliente',
                        sortable: false,
                        width: 200,
                        hidden: false,
                        hideable: false,
                        dataIndex: 'Cliente'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'CAS',
                        sortable: false,
                        width: 80,
                        hidden: false,
                        hideable: false,
                        dataIndex: 'CAS'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.grid.GroupingView({
                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                    getRowClass: function(record, index, rowParams, store){
                        //viewConfig: {
                        //getRowClass: function(record, index) {
                        switch(record.get('ProcesoActual')){
                            case "TOMA DE SIGNOS":
                                return 'PasoTomaSignos';
                                break;
                            case "LABORATORIO":
                                return 'PasoLaboratorio';
                                break;
                            case "FONOAUDIOLOGIA":
                                return 'PasoFonoaudiologia';
                                break;
                            case "VALORACION MEDICA":
                                return 'PasoMedico';
                                break;
                            case "TOMA MUESTRAS":
                                return 'PasoTomaMuestras';
                                break;
                            case "PROCESO CERRADO":
                                if(record.get('ConceptoFinal') == "APTO"){
                                    return 'Apto';
                                }else{
                                    return 'NoApto';
                                }
                                break;
                            default:
                                break;
                        }
                    }
                }),
                columnLines: true,
                bbar:{
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'cycle',
                            prependText: 'Vista por: ',
                            iconCls: 'btnGrouping',
                            showText: true,
                            items: [
                                {
                                    xtype: 'menucheckitem',
                                    id: 'btnGrouping1',
                                    text: 'Ubicación Actual',
                                    checked: true
                                },
                                {
                                    xtype: 'menucheckitem',
                                    id: 'btnGrouping2',
                                    text: 'Proceso Actual'
                                }
                            ]
                        }/*,
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imprimir Historia',
                            iconCls: 'btnImprimir',
                            tooltip: 'Imprimir Historia',
                            id: 'btnPrintHCSO'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Imprimir Certificado',
                            iconCls: 'btnImprimir',
                            tooltip: 'Imprimir Certificado',
                            id: 'btnPrintCertificadoSO'
                        },
                        {
                            xtype: 'tbseparator'
                        }*/
                    ]
                },
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Actualizar Agenda',
                                iconCls: 'btnActualizarGrid',
                                tooltip: 'Actualizar Agenda',
                                id: 'btnActualizarAgenda'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Toma de Signos',
                                iconCls: 'btnTomaSignos',
                                tooltip: 'Toma de Signos',
                                id: 'btnTomaSignosSO'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Toma Muestras',
                                iconCls: 'btnLaboratorio',
                                tooltip: 'Toma Muestras',
                                id: 'btnTomaMuestrasSO'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Resultados Laboratorio',
                                iconCls: 'btnLaboratorio',
                                tooltip: 'Resultados Laboratorio',
                                id: 'btnLaboratorioSO'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Fonoaudiologia',
                                iconCls: 'btnFonoaudiologia',
                                tooltip: 'Fonoaudiologia',
                                id: 'btnFonoaudiologiaSO'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Historia Ocupacional',
                                iconCls: 'btnMedicoOcupacional',
                                tooltip: 'Historia Ocupacional',
                                id: 'btnHistoriaOcupacionalSO'
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
                
            }
        ];
        winFrmVerAgendaUi.superclass.initComponent.call(this);
    }
});
