/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerAgenda = Ext.extend(winFrmVerAgendaUi, {
    initComponent: function() {
        winFrmVerAgenda.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        paramIdPaciente = 0;
        paramOpcion = "Nuevo";
        wPaciente = 0;
        wCAS = 0;
        objREMADD = "new winSolRem002Ui();";
        objEXAADD = "new winSolExa002Ui();";
        objMXADD = "new winSolMx002Ui();";
        
        /*Ext.getCmp('sysProfeAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pUsuario: ID_USUARIO
            }
        });*/ 
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        Ext.getCmp('sysFechaAgenda').setValue(new Date().format("d/m/Y"));
        
        var sysProfesionalAgenda = Ext.getCmp('sysProfeAgenda').on("select",this.CargaUbicacionAgenda,this);
        var sysUbicacionAgenda = Ext.getCmp('sysUbicacionAgenda').on("select",this.CargaFechasAgenda,this);
        var sysFechaAgenda = Ext.getCmp('sysFechaAgenda').on("select",this.CargaDetalleAgenda,this);
        var btnActualizarAgenda = Ext.getCmp('btnActualizarAgenda').on("click",this.ActualizarAgenda,this);
        var btnTomaSignosSO = Ext.getCmp('btnTomaSignosSO').on("click",this.TomaSignosSO,this);
        var btnTomaMuestrasSO = Ext.getCmp('btnTomaMuestrasSO').on("click",this.TomaMuestrasSO,this);
        var btnLaboratorioSO = Ext.getCmp('btnLaboratorioSO').on("click",this.LaboratorioSO,this);
        var btnFonoaudiologiaSO = Ext.getCmp('btnFonoaudiologiaSO').on("click",this.FonoaudiologiaSO,this);
        var btnHistoriaOcupacionalSO = Ext.getCmp('btnHistoriaOcupacionalSO').on("click",this.HistoriaOcupacionalSO,this);
        //var btnPrintHCSO = Ext.getCmp('btnPrintHCSO').on("click",this.PrintHistoriaOcupacionalSO,this);
        var btnGrouping1 = Ext.getCmp('btnGrouping1').on("click",this.GroupingUbicacionActual,this);
        var btnGrouping2 = Ext.getCmp('btnGrouping2').on("click",this.GroupingProcesoActual,this);

        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
    },
    GroupingUbicacionActual: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("UbicacionActual");
    },
    GroupingProcesoActual: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("ProcesoActual");
    },
    PrintHistoriaOcupacionalSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            window.open ("../../controlador/asistencial/saludocupa004/printsaludocupa.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Historia Ocupacional");
        }
    },
    HistoriaOcupacionalSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.PasoTomaSignos == '1' && selections[0].json.UbicacionActual == "RECEPCION"){
                wPaciente = selections[0].json.Paciente;
                wCAS = selections[0].json.CAS;
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_VALMEDICA",
                        pUbicacion: "VALORACION MEDICA",
                        pProceso: "VALORACION MEDICA",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            paramIdPaciente = selections[0].json.Paciente;
                            if(selections[0].json.PasoMedicoOcupacional == "0"){
                                paramOpcion = "Nuevo";
                            }else{
                                if(selections[0].json.ConceptoMedicoOcupacional == "SIN DEFINIR"){
                                    paramOpcion = "Nuevo";
                                }else{
                                    paramOpcion = "Modificar";
                                }
                            }
                            var winTomaSignos = new winHCPartisalud001ValoracionMedicaUi();
                            if(selections[0].json.TipoExamen != null){
                                Ext.getCmp('memMotivoConsulta').setValue("EXAMEN DE " + selections[0].json.TipoExamen.toUpperCase());
                            }
                            Ext.getCmp('memEnfermedadActual').setValue("ASINTOMATICO");
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            if(selections[0].json.GeneroPaciente == "M"){
                                Ext.getCmp('fsAPGINECO').setVisible(false);
                            }else{
                                Ext.getCmp('fsAPGINECO').setVisible(true);
                            }
                            winTomaSignos.show();
                            
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo el proceso de valoración medica y/o no se ha registrado la toma de signos o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    FonoaudiologiaSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.UbicacionActual == "RECEPCION"){ //&& selections[0].json.UbicacionActual == "RECEPCION"
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_FONOAUDIOLOGIA",
                        pUbicacion: "FONOAUDIOLOGIA",
                        pProceso: "FONOAUDIOLOGIA",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response');
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        wPaciente = selections[0].json.Paciente;
                        wCAS = selections[0].json.CAS;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            if(selections[0].json.PasoFonoaudiologia == "0"){
                                paramOpcion = "Nuevo";
                            }else{
                                paramOpcion = "Modificar";
                            }
                            Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winFono = new winHCPartisalud001FonoaudiologiaUi();
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            winFono.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo el proceso de fonoaudiologia o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    LaboratorioSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.UbicacionActual == "RECEPCION"){
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_TOMALABO",
                        pUbicacion: "TOMA DE MUESTRAS",
                        pProceso: "TOMA DE MUESTRAS",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response');
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winResultLabo = new winHCPartisalud001ResultLaboUi();
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            winResultLabo.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo el proceso de laboratorio o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    TomaSignosSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (selections[0].json.PasoTomaSignos == '0' && selections[0].json.UbicacionActual == "RECEPCION"){
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.UbicacionActual == "RECEPCION"){ // && selections[0].json.UbicacionActual == "RECEPCION"
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_TOMASIGNOS",
                        pUbicacion: "TOMA DE SIGNOS",
                        pProceso: "TOMA DE SIGNOS",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winTomaSignos = new winHCPartisalud001TomaSignosUi();
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            winTomaSignos.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo la toma de signos o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    TomaMuestrasSO: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (selections[0].json.PasoTomaSignos == '0' && selections[0].json.UbicacionActual == "RECEPCION"){
            if (selections[0].json.ConceptoFinal == 'SIN DEFINIR' && selections[0].json.UbicacionActual == "RECEPCION"){ // && selections[0].json.UbicacionActual == "RECEPCION"
                Ext.Ajax.request(
                {
                    waitMsg: 'Por favor Espere...',
                    url: "../../controlador/asistencial/saludocupacional.php",
                    params:{
                        task: "CAMBIAR_UBICACION_TOMAMUESTRAS",
                        pUbicacion: "TOMA DE SIGNOS",
                        pProceso: "TOMA DE SIGNOS",
                        pConsecutivoHC: selections[0].json.ConsecutivoHC
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); 
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        var NroCAS = Contenido[0];
                        paramIdPaciente = selections[0].json.Paciente;
                        if(NroCAS > 0){
                            Ext.getCmp('gridFormulario').store.reload();
                            Ext.Msg.wait('Cargando Formulario... por favor espere!');
                            var winTomaSignos = new winHCPartisalud001TomaMuestrasUi();
                            Ext.getCmp('sysPacienteHC').setValue(selections[0].json.TipDoc + " " + selections[0].json.Documento + ' - ' + selections[0].json.PrimerNombre + " " + selections[0].json.SegundoNombre + " " + selections[0].json.PrimerApellido + " " + selections[0].json.SegundoApellido);
                            Ext.getCmp('sysCASHC').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysConsecutivoDetalleHC').setValue(selections[0].json.ConsecutivoHC);
                            Ext.getCmp('sysIdPacienteHC').setValue(selections[0].json.Paciente);
                            winTomaSignos.show();
                        } else {
                            Ext.Msg.hide();
                            Ext.MessageBox.show({
                                title: 'eOfiClinic',
                                msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    },
                    failure: function(response,options)
                    {
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'eOfiClinic',
                    msg: 'Ya se realizo la toma de signos o el paciente no esta ubicado en la recepción',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormulario').store.reload();
    },
    CargaDetalleAgenda: function(f, d) {
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pAgenda: d.format("Y-m-d")
            }
        }); 
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});

