/*
* @category    Formulario Modelo Evolucion CRI Rehabilitacion Pulmonar Primera Vez
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCRehabilitaCRI002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Rehabilitacion Pulmonar Primera Vez ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        var dataCRIIntensidad = [
            ['LEVE'],
            ['MODERADA'],
            ['VIGIROSA']
        ];
        var stCRIIntensidad = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIIntensidad.loadData(dataCRIIntensidad);
        
        var dataCRIDuracion = [
            ['< 15 MIN'],
            ['15 - 30 MIN'],
            ['30 - 45 MIN'],
            ['45 - 60 MIN'],
            ['> 60 MIN']
        ];
        var stCRIDuracion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIDuracion.loadData(dataCRIDuracion);
        
        var dataCRIAHAACSM = [
            ['A1'],
            ['A2'],
            ['A3'],
            ['B'],
            ['C'],
            ['D']
        ];
        var stCRIAHAACSM = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIAHAACSM.loadData(dataCRIAHAACSM);
        
        var dataCRIRiesgoEventos = [
            ['BAJO'],
            ['MODERADO'],
            ['ALTO']
        ];
        var stCRIRiesgoEventos = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIRiesgoEventos.loadData(dataCRIRiesgoEventos);
        
        var dataCRIEntrenamiento = [
            ['60%'],
            ['65%'],
            ['70%'],
            ['80%']
        ];
        var stCRIEntrenamiento = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIEntrenamiento.loadData(dataCRIEntrenamiento);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                fieldLabel: 'Medico Remitente',
                                                name: 'Medico Remitente',
                                                allowBlank: true,
                                                id: 'strMedicoRemitente'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Iterconsulta',
                                                name: 'Iterconsulta',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strInterconsulta'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 550,
                                                        fieldLabel: 'En Caso de Emergencia Avisar',
                                                        name: 'En Caso de Emergencia Avisar',
                                                        allowBlank: true,
                                                        id: 'strEnCasoEmergenciaAvisar'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCRI001',
                                                        value: 'Telefono: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        name: 'Telefono',
                                                        allowBlank: true,
                                                        id: 'strEnCasoEmergenciaAvisarTel'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'numberfield',
                                                minValue: 1,
                                                fieldLabel: 'Nro Sesiones',
                                                name: 'No Sesiones Programadas',
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                id: 'intNroSesionesProgramadas'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE INGRESO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Diagnostico Cardiologico',
                                                        name: 'Diagnostico Cardiologico',
                                                        allowBlank: true,
                                                        id: 'strDiagnoCardiologico'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 120,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strIncapacidadIngreso'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCRI002',
                                                                value: 'Fecha: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Fecha',
                                                                width: 450,
                                                                allowBlank: true,
                                                                id: 'strIncapacidadIngresoFec'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 120,
                                                                fieldLabel: 'Tto Psicologico Previo',
                                                                name: 'Tto Psicologico Previo',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strTtoPsicologicoPrevio'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCRI002',
                                                                value: 'Fecha: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Fecha',
                                                                width: 450,
                                                                allowBlank: true,
                                                                id: 'strTtoPsicologicoPrevioFec'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 120,
                                                                fieldLabel: 'Rehab. Pulmonar Previa',
                                                                name: 'Rehab. Pulmonar Previa',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strRehabilitaPulmonarPrevio'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCRI002',
                                                                value: 'Fecha: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Fecha',
                                                                width: 450,
                                                                allowBlank: true,
                                                                id: 'strRehabilitaPulmonarPrevioFec'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES CARDIOVASCULARES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                labelWidth: 150,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'IAM',
                                                                name: 'IAM',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_IAM',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_IAMH').allowBlank = true;
                                                                            Ext.getCmp('strAC_IAMH').setValue(null);
                                                                            Ext.getCmp('strAC_IAMH').disable();
                                                                            Ext.getCmp('strAC_IAMH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_IAMH').enable();
                                                                            Ext.getCmp('strAC_IAMH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_IAMH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Proced. Cardiovascular',
                                                                name: 'Proced. Cardiovascular',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_ProcedCardiovascular',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_ProcedCardiovascularH').allowBlank = true;
                                                                            Ext.getCmp('strAC_ProcedCardiovascularH').setValue(null);
                                                                            Ext.getCmp('strAC_ProcedCardiovascularH').disable();
                                                                            Ext.getCmp('strAC_ProcedCardiovascularH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_ProcedCardiovascularH').enable();
                                                                            Ext.getCmp('strAC_ProcedCardiovascularH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_ProcedCardiovascularH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'R.V.M',
                                                                name: 'R.V.M',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_RVM',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_RVMH').allowBlank = true;
                                                                            Ext.getCmp('strAC_RVMH').setValue(null);
                                                                            Ext.getCmp('strAC_RVMH').disable();
                                                                            Ext.getCmp('strAC_RVMH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_RVMH').enable();
                                                                            Ext.getCmp('strAC_RVMH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_RVMH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'I.C.C',
                                                                name: 'I.C.C',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_ICC',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_ICCH').allowBlank = true;
                                                                            Ext.getCmp('strAC_ICCH').setValue(null);
                                                                            Ext.getCmp('strAC_ICCH').disable();
                                                                            Ext.getCmp('strAC_ICCH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_ICCH').enable();
                                                                            Ext.getCmp('strAC_ICCH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_ICCH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Otros Antecedentes Clinicos',
                                                        name: 'Otros Antecedentes Clinicos',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strAC_OtrosAntecedentes'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PULMONARES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                labelWidth: 150,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'EPOC',
                                                                name: 'EPOC',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAP_EPOC',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAP_EPOCH').allowBlank = true;
                                                                            Ext.getCmp('strAP_EPOCH').setValue(null);
                                                                            Ext.getCmp('strAP_EPOCH').disable();
                                                                            Ext.getCmp('strAP_EPOCH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAP_EPOCH').enable();
                                                                            Ext.getCmp('strAP_EPOCH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAP_EPOCH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'ASMA',
                                                                name: 'ASMA',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAP_ASMA',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAP_ASMAH').allowBlank = true;
                                                                            Ext.getCmp('strAP_ASMAH').setValue(null);
                                                                            Ext.getCmp('strAP_ASMAH').disable();
                                                                            Ext.getCmp('strAP_ASMAH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAP_ASMAH').enable();
                                                                            Ext.getCmp('strAP_ASMAH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAP_ASMAH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Bronquiectasias',
                                                                name: 'R.V.M',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAP_Bronquiectasias',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAP_BronquiectasiasH').allowBlank = true;
                                                                            Ext.getCmp('strAP_BronquiectasiasH').setValue(null);
                                                                            Ext.getCmp('strAP_BronquiectasiasH').disable();
                                                                            Ext.getCmp('strAP_BronquiectasiasH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAP_BronquiectasiasH').enable();
                                                                            Ext.getCmp('strAP_BronquiectasiasH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAP_BronquiectasiasH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'TEP',
                                                                name: 'TEP',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAP_TEP',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAP_TEPH').allowBlank = true;
                                                                            Ext.getCmp('strAP_TEPH').setValue(null);
                                                                            Ext.getCmp('strAP_TEPH').disable();
                                                                            Ext.getCmp('strAP_TEPH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAP_TEPH').enable();
                                                                            Ext.getCmp('strAP_TEPH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAP_TEPH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Otros Antecedentes Clinicos',
                                                        name: 'Otros Antecedentes Clinicos',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strAP_OtrosAntecedentes'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FACTORES DE RIESGO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                labelWidth: 150,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 885,
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {           
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                autoHeight: true,
                                                                width: 440,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Dislipidemia',
                                                                        name: 'Dislipidemia',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_Dislipidemia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'HTA',
                                                                        name: 'HTA',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_HTA'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'DM Tipo 1',
                                                                        name: 'DM Tipo 1',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_DMT1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'DM Tipo 2',
                                                                        name: 'DM Tipo 2',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_DMT2'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                autoHeight: true,
                                                                width: 440,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Hipotiroidismo',
                                                                        name: 'Hipotiroidismo',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_Hipotiroidismo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Post-Menopausia',
                                                                        name: 'Post-Menopausia',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_PostMenopausia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Sobrepeso',
                                                                        name: 'Sobrepeso',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_Sobrepeso'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Obesidad',
                                                                        name: 'Obesidad',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_Obesidad'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Fuma Actualente',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strFR_FuamaActualmente'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_o',
                                                                value: 'Nro Cigarrillos Dia:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                id: 'strFR_NroCigarrillosActual'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_p',
                                                                value: 'Tiempo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                emptyText: "Años",
                                                                id: 'strFR_FumaActualmenteTiempo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Fumó Anteriormente',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strFR_FuamoAnteriormente'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_q',
                                                                value: 'Nro Cigarrillos Dia:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                id: 'strFR_NroCigarrillosAnterior'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_r',
                                                                value: 'Tiempo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                emptyText: "Años",
                                                                id: 'strFR_FumaAnteriormenteTiempo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Consumo de Alcohol',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strFR_ConsumoAlcohol'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_s',
                                                                value: 'Freciencia:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 130,
                                                                allowBlank: false,
                                                                store: 'StoreFrecuenciaConsumo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NUNCA",
                                                                id: 'strFR_ConsumoAlcoholFrecuencia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Tipo Alcohol',
                                                        name: 'Tipo Alcohol',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strFR_ConsumoAlcoholTipo'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Consumo Drogas Alucinogenas',
                                                        name: 'Consumo Drogas Alucinogenas',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strFR_ConsumoDrogasAlucinogenas'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ANTECEDENTES FAMILIARES (Fallecimiento)',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        titleCollapse: false,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        labelWidth: 100,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 885,
                                                                layout: {
                                                                    columns: 2,
                                                                    type: 'table'
                                                                },
                                                                items: [
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 400,
                                                                        items:[
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Padre',
                                                                                name: 'Padre',
                                                                                anchor: '98%',
                                                                                allowBlank: true,
                                                                                id: 'strFR_AF_FallecePadre'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Madre',
                                                                                name: 'Madre',
                                                                                anchor: '98%',
                                                                                allowBlank: true,
                                                                                id: 'strFR_AF_FalleceMadre'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 400,
                                                                        items:[
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Hermano',
                                                                                name: 'Hermano',
                                                                                anchor: '98%',
                                                                                allowBlank: true,
                                                                                id: 'strFR_AF_FalleceHermano'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Hermana',
                                                                                name: 'Hermana',
                                                                                anchor: '98%',
                                                                                allowBlank: true,
                                                                                id: 'strFR_AF_FalleceHermana'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '1. ESPIROMETRIA',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 100,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                html: 'PRE: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'CVF',
                                                                name: 'CVF',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaCVFPre'
                                                            },
                                                            {
                                                                html: 'POST: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'POST',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaCVFPost'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                emtyText: 'OBSERVACIONES',
                                                                width: 420,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaCVFH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                html: 'PRE: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'VEF1',
                                                                name: 'VEF1',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaVEF1Pre'
                                                            },
                                                            {
                                                                html: 'POST: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'POST',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaVEF1Post'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                emtyText: 'OBSERVACIONES',
                                                                width: 420,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaVEF1H'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                html: 'PRE: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'VEF1/CVF',
                                                                name: 'VEF1/CVF',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaVEF1CVFPre'
                                                            },
                                                            {
                                                                html: 'POST: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'POST',
                                                                width: 100,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaVEF1CVFPost'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                emtyText: 'OBSERVACIONES',
                                                                width: 420,
                                                                allowBlank: true,
                                                                id: 'strEspirometriaVEF1CVFH'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '2. LIMITACION EN LAS AVD',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 150,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 905,
                                                        labelWidth: 1,
                                                        layout: {
                                                            columns: 10,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                title: '<center>ACTIVIDAD</center>',
                                                                width: 210,
                                                                labelWidth: 1,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Actividad 1',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionActividad1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Actividad 2',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionActividad2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Actividad 3',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionActividad3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Actividad 4',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionActividad4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Actividad 5',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionActividad5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>SpO2.Ini</center>',
                                                                width: 60,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Inicial 1',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Ini1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Inicial 2',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Ini2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Inicial 3',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Ini3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Inicial 4',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Ini4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Inicial 5',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Ini5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>SpO2.Fin</center>',
                                                                width: 60,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Final 1',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Fin1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Final 2',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Fin2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Final 3',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Fin3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Final 4',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Fin4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'SpO2 Final 5',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionSPO2Fin5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>FC Inicial</center>',
                                                                width: 60,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Inicial 1',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCIni1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Inicial 2',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCIni2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Inicial 3',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCIni3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Inicial 4',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCIni4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Inicial 5',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCIni5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>FC Final</center>',
                                                                width: 60,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Final 1',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCFin1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Final 2',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCFin2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Final 3',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCFin3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Final 4',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCFin4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'FC Final 5',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFCFin5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>Borg.Ini</center>',
                                                                width: 60,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Inicial 1',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgIni1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Inicial 2',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgIni2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Inicial 3',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgIni3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Inicial 4',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgIni4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Inicial 5',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgIni5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>Borg.Fin</center>',
                                                                width: 60,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Final 1',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgFin1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Final 2',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgFin2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Final 3',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgFin3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Final 4',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgFin4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Borg Final 5',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionBorgFin5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>Fatiga.Ini</center>',
                                                                width: 60,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Inicial 1',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaIni1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Inicial 2',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaIni2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Inicial 3',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaIni3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Inicial 4',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaIni4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Inicial 5',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaIni5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>Fatiga.Fin</center>',
                                                                width: 60,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Final 1',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaFin1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Final 2',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaFin2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Final 3',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaFin3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Final 4',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaFin4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Fatiga Final 5',
                                                                        allowBlank: true,
                                                                        id: 'strLimitacionFatigaFin5'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                title: '<center>COMENTARIOS</center>',
                                                                width: 160,
                                                                labelWidth: 1,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Comentarios 1',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionComentarios1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Comentarios 2',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionComentarios2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Comentarios 3',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionComentarios3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Comentarios 4',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionComentarios4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '99%',
                                                                        name: 'Comentarios 5',
                                                                        allowBlank: true,
                                                                        fieldLabel: '',
                                                                        id: 'strLimitacionComentarios5'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '3. COMPLEMENTARIOS',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Suplemento Nutricional',
                                                        name: 'Suplemento Nutricional',
                                                        allowBlank: true,
                                                        id: 'strComplementarios1'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Suplemento de Oxigeno',
                                                        name: 'Suplemento de Oxigeno',
                                                        allowBlank: true,
                                                        id: 'strComplementarios2'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Inhaladores',
                                                        name: 'Inhaladores',
                                                        allowBlank: true,
                                                        id: 'strComplementarios3'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Vacunacion',
                                                        name: 'Vacunacion',
                                                        allowBlank: true,
                                                        id: 'strComplementarios4'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Examenes Laboratorio',
                                                        name: 'Examenes Laboratorio',
                                                        allowBlank: true,
                                                        id: 'strComplementarios5'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '4. CAPACIDAD FUNCIONAL - TEST DE CAMINATA DE 6 MINUTOS',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'Talla (cm)',
                                                                name: "Talla (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Peso (kg)'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO ACTUAL (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 0,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEF_IMCClasificacon'
                                                            },
                                                            {
                                                                html: 'Cintura (cm): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(cm)',
                                                                name:"CINTURA (cm)",
                                                                id: 'intEF_Cintura'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SIGOS INICIALES',
                                                        labelWidth: '150',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'FC (Lpm)',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intEF_FC'
                                                                    },
                                                                    {
                                                                        html: 'FR: (Rpm)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "FR: (Rpm)",
                                                                        emptyText: 'Rpm',
                                                                        id: 'intEF_FR'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intEF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'TAS/TAD: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "TAS/TAD",
                                                                        id: 'strEF_TA'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Disnea',
                                                                        width: 210,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strEF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 210,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strEF_Fatiga'
                                                                    },
                                                                    {
                                                                        html: 'Angina: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 210,
                                                                        allowBlank: true,
                                                                        name: "Recorrido Minimo",
                                                                        id: 'strEF_RecorridoMinimo'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SIGNOS DURANTE LA PRUEBA',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 1',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins1EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins1EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins1EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins1EF_Fatiga'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 2',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins2EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins2EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins2EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins2EF_Fatiga'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 3',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins3EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins3EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins3EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins3EF_Fatiga'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 4',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins4EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins4EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins4EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins4EF_Fatiga'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 5',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins5EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins5EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins5EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins5EF_Fatiga'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 6',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins6EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins6EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins6EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins6EF_Fatiga'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'SIGNOS DESPUES DE LA PRUEBA (RECUPERACION)',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 7',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins7EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins7EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins7EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins7EF_Fatiga'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 8',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins8EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins8EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins8EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins8EF_Fatiga'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'FC (Lpm):'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        fieldLabel: 'Minuto 9',
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intTEST6Mins9EF_FC'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2 (%)",
                                                                        emptyText: '%',
                                                                        id: 'intTEST6Mins9EF_SPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins9EF_Disnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTEST6Mins9EF_Fatiga'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'DATOS FINALES',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        fieldLabel: 'Dist. Predicha',
                                                                        name:"Distancia Predicha",
                                                                        emptyText: 'Trooster',
                                                                        allowBlank: true,
                                                                        id: 'strDATAFINDistanciaPredicha'
                                                                    },
                                                                    {
                                                                        html: 'Dist. Recorrida:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        name:"Distancia Recorrida",
                                                                        emptyText: 'metros',
                                                                        allowBlank: true,
                                                                        id: 'strDATAFINDistanciaRecorrida'
                                                                    },
                                                                    {
                                                                        html: 'FCM alcanzada:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        name:"FC (Lpm)",
                                                                        emptyText: '(Lpm)',
                                                                        allowBlank: true,
                                                                        id: 'intDATAFINFC'
                                                                    },
                                                                    {
                                                                        html: 'VO2 Estimado:'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        name:"VO2 Estimado",
                                                                        allowBlank: true,
                                                                        id: 'intDATAFINVO2Estimado'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        fieldLabel: 'Numero Paradas',
                                                                        name:"Numero Paradas",
                                                                        allowBlank: true,
                                                                        id: 'strDATAFINNumeroParadas'
                                                                    },
                                                                    {
                                                                        html: 'Tiempo Paradas:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        name:"Tiempo Paradas",
                                                                        allowBlank: true,
                                                                        id: 'strDATAFINTiempoParadas'
                                                                    },
                                                                    {
                                                                        html: 'Tiempo Total Caminado:'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        name:"Tiempo Total Caminado",
                                                                        allowBlank: true,
                                                                        id: 'strDATAFINTiempoTotalCaminado'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                fieldLabel: 'Onservaciones',
                                                                name:"Obserbaciones",
                                                                allowBlank: true,
                                                                value: 'Realiza caminata de 6 minutos, segun protocolo establecido, no presenta complicacion durante o despues de la evaluacion fisioterapeutica.',
                                                                id: 'memDATAFINObservaciones'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '5. CALIDAD DE VIDA',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        name: 'CRQ',
                                                        fieldLabel: 'CRQ',
                                                        allowBlank: true,
                                                        id: 'strCALVIDCRQ'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 1,
                                                                fieldLabel: 'Disnea',
                                                                name: 'Disnea',
                                                                width: 120,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intCALVIDDisnea1'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 1,
                                                                name: 'Disnea',
                                                                width: 120,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intCALVIDDisnea2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 1,
                                                                fieldLabel: 'Fatiga',
                                                                name: 'Fatiga',
                                                                width: 120,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intCALVIDFatiga1'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 1,
                                                                name: 'Fatiga',
                                                                width: 120,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intCALVIDFatiga2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 1,
                                                                fieldLabel: 'Emocional',
                                                                name: 'Emocional',
                                                                width: 120,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intCALVIDEmocional1'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 1,
                                                                name: 'Emocional',
                                                                width: 120,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intCALVIDEmocional2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 1,
                                                                fieldLabel: 'Control',
                                                                name: 'Control',
                                                                width: 120,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intCALVIDControl1'
                                                            },
                                                            {
                                                                html: ' - '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                minValue: 1,
                                                                name: 'Control',
                                                                width: 120,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                id: 'intCALVIDControl2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Actividades Seleccionadas',
                                                        name: 'Actividades Seleccionadas',
                                                        allowBlank: true,
                                                        id: 'memCALVIDActividadesSeleccionadas'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '6. TEST ESCALON INICIAL',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Inicial',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        titleCollapse: false,
                                                        anchor: '100%',
                                                        labelWidth: 40,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        minValue: 1,
                                                                        name: 'FC',
                                                                        fieldLabel: 'FC',
                                                                        width: 120,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intTESTESCALONInicialFC'
                                                                    },
                                                                    {
                                                                        html: 'TAS/TAD: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "TAS/TAD",
                                                                        id: 'strTESTESCALONInicialTA'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2",
                                                                        emptyText: '%',
                                                                        id: 'intTESTESCALONInicialSPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTESTESCALONInicialDisnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        name: "Fatiga",
                                                                        id: 'strTESTESCALONInicialFatiga'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'Final',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        titleCollapse: false,
                                                        anchor: '100%',
                                                        labelWidth: 40,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        minValue: 1,
                                                                        name: 'FC',
                                                                        fieldLabel: 'FC',
                                                                        width: 100,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intTESTESCALONFinalFC'
                                                                    },
                                                                    {
                                                                        html: 'TAS/TAD: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "TAS/TAD",
                                                                        id: 'strTESTESCALONFinalTA'
                                                                    },
                                                                    {
                                                                        html: 'SPO2: (%)'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 120,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        name: "SPO2",
                                                                        emptyText: '%',
                                                                        id: 'intTESTESCALONFinalSPO2'
                                                                    },
                                                                    {
                                                                        html: 'Disnea: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTESTESCALONFinalDisnea'
                                                                    },
                                                                    {
                                                                        html: 'Fatiga: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        name: "Disnea",
                                                                        id: 'strTESTESCALONFinalFatiga'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                allowBlank: true,
                                                                name: "VO2",
                                                                fieldLabel: "VO2",
                                                                id: 'strTESTESCALONVO2'
                                                            },
                                                            {
                                                                html: 'N. Repeticiones: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                allowBlank: true,
                                                                name: "Repeticiones",
                                                                id: 'strTESTESCALONRepeticiones'
                                                            },
                                                            {
                                                                html: 'Peso: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Lb)',
                                                                name:"Peso",
                                                                id: 'intTESTESCALONPeso'
                                                            },
                                                            {
                                                                html: 'FIO2: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 120,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"FIO2",
                                                                id: 'intTESTESCALONFIO2'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '7. PRUEBA INCREMENTAL DE MMSS',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Lb)',
                                                                name:"Peso",
                                                                fieldLabel: 'Peso',
                                                                id: 'intPRUEINCREPeso'
                                                            },
                                                            {
                                                                html: 'N. Repeticiones: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                allowBlank: true,
                                                                name: "Repeticiones",
                                                                id: 'strPRUEINCRERepeticiones'
                                                            },
                                                            {
                                                                html: 'Etapa: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                allowBlank: true,
                                                                name: "Etapa",
                                                                id: 'strPRUEINCREEtapa'
                                                            },
                                                            {
                                                                html: 'FIO2: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 120,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                name:"FIO2",
                                                                id: 'intPRUEINCREFIO2'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '8. PRUEBA EN BANDA SIN FIN',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                allowBlank: true,
                                                                name: "Duracion Prueba",
                                                                fieldLabel: 'Duracion Prueba',
                                                                id: 'strPRUEINCREDuracionPrueba'
                                                            },
                                                            {
                                                                html: 'Inclinacion: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                allowBlank: true,
                                                                name: "Inclinacion",
                                                                id: 'strPRUEINCREInclinacion'
                                                            },
                                                            {
                                                                html: 'Velocidad: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                allowBlank: true,
                                                                name: "Velocidad",
                                                                id: 'strPRUEINCREVelocidad'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '9. EXAMEN FISICO',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'Talla (cm)',
                                                                name: "Talla (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEXAFIS_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFIS_Talla').setValue(null);
                                                                            Ext.getCmp('intEXAFIS_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFIS_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFIS_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEXAFIS_IMC').setValue(Ext.getCmp('intEXAFIS_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFIS_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFIS_IMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFIS_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFIS_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEXAFIS_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFIS_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEXAFIS_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEXAFIS_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Peso (kg)'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO ACTUAL (Kg)",
                                                                id: 'intEXAFIS_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEXAFIS_Peso').setValue(null);
                                                                            Ext.getCmp('intEXAFIS_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEXAFIS_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEXAFIS_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEXAFIS_IMC').setValue(Ext.getCmp('intEXAFIS_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEXAFIS_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEXAFIS_IMC').getValue()<1){
                                                                           Ext.getCmp('strEXAFIS_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFIS_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEXAFIS_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFIS_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEXAFIS_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEXAFIS_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 0,
                                                                name: "IMC",
                                                                id: 'intEXAFIS_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEXAFIS_IMCClasificacon'
                                                            },
                                                            {
                                                                html: 'Cintura (cm): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: false,
                                                                emptyText: '(cm)',
                                                                name:"CINTURA (cm)",
                                                                id: 'intEXAFIS_Cintura'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                allowBlank: true,
                                                                name: "Auscultacion Pulmonar",
                                                                fieldLabel: 'Auscultacion Pulmonar',
                                                                id: 'strEXAFIS_AuscultacionPulmonar'
                                                            },
                                                            {
                                                                html: 'Auscultacion Cardiaca:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 150,
                                                                allowBlank: true,
                                                                name: "Auscultacion Cardiaca",
                                                                id: 'strEXAFIS_AuscultacionCardiaca'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea guardar la evolución, si hace esto ya no podra realizar ningun cambio?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'La evolución ya se guardo y no podra ser modificada nuevamente',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCRehabilitaCRI002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
