/*
* @category    Formulario Adicionar Tratamiento Laser
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddTtoLaser001Ui = Ext.extend(Ext.Window, {
    title: '.:: Tratamiento Laser ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddTtoLaser001Ui',
    initComponent: function() {
        var dataTratamientoLaser = [
            ['DEPILACION'],
            ['REJUVENECIMIENTO'],
            ['DESPIGMENTACION'],
            ['VARICES']
        ];
        var stTratamientoLaser = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTratamientoLaser.loadData(dataTratamientoLaser);
        
        var dataLongitudOnda = [
            ['530'],
            ['585'],
            ['610']
        ];
        var stLongitudOnda = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stLongitudOnda.loadData(dataLongitudOnda);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddTratamientoLaser',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'strFormato',
                                value: "Laser_BRestrepo",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteTtoLaser',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoTtoLaser',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioTtoLaser',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha',
                                        name: 'Fecha',
                                        width: 110,
                                        allowBlank: false,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        value: new Date().format('d/m/Y'),
                                        id: 'fecFecTtoLaser'
                                    },
                                    {
                                        html: '# SESION:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: '# Sesion',
                                        width: 50,
                                        minValue: 1,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intSesionTtoLaser'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tratamiento',
                                        name: 'Tratamiento',
                                        width: 565,
                                        allowBlank: false,
                                        store: stTratamientoLaser,
                                        forceSelection: false,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        id: 'strTratamientoTtoLaser'
                                    },
                                    {
                                        html: 'Longitud de Onda:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Longitud de Onda',
                                        width: 70,
                                        allowBlank: false,
                                        store: stLongitudOnda,
                                        forceSelection: false,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        id: 'strLongitudOndaTtoLaser'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Tipo Piel',
                                name: 'Tipo Piel',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strTipoPielTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Numbers',
                                name: 'Numbers',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strNumbersTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: '1 Pulse',
                                name: '1 Pulse',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'str1PulseTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: '1 Delay',
                                name: '1 Delay',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'str1DelayTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Sub-Pulses',
                                name: 'Sub-Pulses',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strSubPulsesTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Sub-Delay',
                                name: 'Sub-Delay',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strSubDelayTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Times',
                                name: 'Times',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strTimesTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Energy',
                                name: 'Energy',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strEnergyTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'RF Energy',
                                name: 'RF Energy',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strRFEnergyTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'RF Time',
                                name: 'RF Time',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strRFTimeTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Area Tratada',
                                name: 'Area Tratada',
                                anchor: '100%',
                                allowBlank: true,
                                maxLength: 250,
                                id: 'strAreaTratadaTtoLaser'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'strObservacionesTtoLaser'
                            }
                            /*{
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                id: 'intCantidadMx',
                                width: 80,
                                allowBlank: false,
                                minValue: 1,
                                //maxValue: 360,
                                value: 1
                            },*/
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    fnGuardarRegTtoLaser("GUARDAR_TTOLASER","SI","winAddTtoLaser001Ui","frmAddTratamientoLaser","../../controlador/asistencial/brestrepo.php","gridFormularioLaser");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddTtoLaser001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegTtoLaser(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.load({
                                    params:{
                                        pPaciente: Ext.getCmp('intPacienteTtoLaser').getValue()
                                    }
                                });
                            }
                        }
                        if(pCerrar === "SI"){
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
