/*
* @category    Formulario Modelo Evolucion Historia Clinica Fisioterapia Evolucion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCFisioterapia002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Evolucion Fisioterapia ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
    var dataFinTratamiento = [
        ['SI'],
        ['NO'],
        ['ABANDONO']
    ];
    var stFinTratamiento = new Ext.data.ArrayStore({
        fields: [
            {name: 'Descripcion'}
        ]
    });
    stFinTratamiento.loadData(dataFinTratamiento);
             
    var dataMiembros = [
        ['Miembros Superiores'],
        ['Miembros Inferiores']
    ];
    var stMiembros = new Ext.data.ArrayStore({
        fields: [
            {name: 'Descripcion'}
        ]
    });
    stMiembros.loadData(dataMiembros);
    
    this.items = [
        {
            xtype: 'panel',
            frame: true,
            anchor: '100%',
            id: 'panelHC',
            //padding: 10,
            border: false,
            height: 610,
            autoScroll: true,
            layout: 'form',
            style: 'background:transparent;',
            items: [
                {
                    xtype: 'tabpanel',
                    anchor: '100%',//width: 945,
                    autoHeight: true,
                    border: false,
                    ref: 'fTabPanel',
                    id: 'fTabPanel',
                    activeTab: 0,
                    items: [
                        {
                            xtype: 'panel',
                            title: 'Evolucion',
                            autoHeight: true,
                            autoScroll: true,
                            anchor: '100%',//width: 935,
                            frame: true,
                            border: false,
                            id: 'fichaIdentifica',
                            layout: 'form',
                            items:[
                                {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Fecha',
                        id: 'sysFechaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysHoraHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Hora',
                        id: 'sysLegalizaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'numberfield',
                        fieldLabel: 'Nro Sesion',
                        name: 'Nro Sesion',
                        width: 90,
                        allowBlank: true,
                        minValue: 1,
                        maxValue: 30,
                        id: 'intNroSesion'
                    },
                    {
                        xtype: 'timefield',
                        fieldLabel: 'Hora Inicio',
                        name: 'Hora Inicio',
                        width: 90,
                        allowBlank: true,
                        forceSelection: false,
                        minValue: '6:00 AM',
                        maxValue: '9:00 PM',
                        emptyText: 'p.e. 07:00',
                        //format:'H:i',
                        id: 'strHoraInicio'
                    },
                    {
                        xtype: 'textfield',
                        name: 'OCUPACION',
                        fieldLabel: 'OCUPACION',
                        width: 650,
                        allowBlank: true,
                        id: 'strOcupacion'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'TERMOTERAPIA',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Tiempo',
                                name: 'Tiempo',
                                width: 90,
                                allowBlank: true,
                                minValue: 0,
                                maxValue: 720,
                                emptyText: 'mm',
                                id: 'intTERMOTERAPIA_Tiempo'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Parafina',
                                        name: 'Parafina',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTERMOTERAPIA_Parafina',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').allowBlank = true;
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').setValue(null);
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').disable();
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').enable();
                                                    Ext.getCmp('intTERMOTERAPIA_ParafinaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTERMOTERAPIA_ParafinaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Calor Humedo',
                                        name: 'Calor Humedo',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTERMOTERAPIA_CalorHumedo',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').allowBlank = true;
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').setValue(null);
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').disable();
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').enable();
                                                    Ext.getCmp('intTERMOTERAPIA_CalorHumedoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'min',
                                        id: 'intTERMOTERAPIA_CalorHumedoTiempo'
                                    }
                                ]
                            },
                            /*{
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Infrarrojo',
                                        name: 'Infrarrojo',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTERMOTERAPIA_Infrarojo',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').allowBlank = true;
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').setValue(null);
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').disable();
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').enable();
                                                    Ext.getCmp('intTERMOTERAPIA_InfrarojoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'min',
                                        id: 'intTERMOTERAPIA_InfrarojoTiempo'
                                    }
                                ]
                            },*/
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Crioterapia',
                                        name: 'Crioterapia',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTERMOTERAPIA_Crioterapia',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').allowBlank = true;
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').setValue(null);
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').disable();
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').enable();
                                                    Ext.getCmp('intTERMOTERAPIA_CrioterapiaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'min',
                                        id: 'intTERMOTERAPIA_CrioterapiaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesTermoterapia'
                            }
                        ]
                    },
                    /*{
                        xtype: 'fieldset',
                        title: 'II. HIDROTERAPIA',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesHidroterapia'
                            }
                        ]
                    },*/
                    {
                        xtype: 'fieldset',
                        title: 'ELECTROTERAPIA',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'TENS',
                                        name: 'TENS',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_TENS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_TENSTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_TENSTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'EMS',
                                        name: 'EMS',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_EMS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_EMSTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_EMSTiempo'
                                    }
                                ]
                            },
                            /*{
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'IFC',
                                        name: 'IFC',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_IFC',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_IFCTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_IFCTiempo'
                                    }
                                ]
                            },*/
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Premodulada',
                                        name: 'Premodulada',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_Premodulada',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_PremoduladaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_PremoduladaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'RUSA',
                                        name: 'RUSA',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_RUSA',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_RUSATiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_RUSATiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'VMS',
                                        name: 'VMS',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_VMS',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_VMSTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_VMSTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Microcorrientes',
                                        name: 'Microcorrientes',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_Microcorrientes',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_MicrocorrientesTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_MicrocorrientesTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Alto Voltaje',
                                        name: 'Alto Voltaje',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_AltoVoltaje',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_AltoVoltajeTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_AltoVoltajeTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'TENS Clinico',
                                        name: 'TENS Clinico',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_TENSClinico',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_TENSClinicoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_TENSClinicoTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Corriente Directa Interrumpida',
                                        name: 'Corriente Directa Interrumpida',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_CteDirectaInterrumpida',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaInterrumpidaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_CteDirectaInterrumpidaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Corriente Directa Continua',
                                        name: 'Corriente Directa Continua',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strELECTROTERAPIA_CteDirectaContinua',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').allowBlank = true;
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').setValue(null);
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').disable();
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').enable();
                                                    Ext.getCmp('intELECTROTERAPIA_CteDirectaContinuaTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intELECTROTERAPIA_CteDirectaContinuaTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesElectroterapia'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'ULTRASONIDO',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Pulsado',
                                        name: 'Pulsado',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strULTRASONIDO_Pulsado',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').allowBlank = true;
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').setValue(null);
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').disable();
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').enable();
                                                    Ext.getCmp('intULTRASONIDO_PulsadoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intULTRASONIDO_PulsadoTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Continuo',
                                        name: 'Continuo',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strULTRASONIDO_Continuo',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').allowBlank = true;
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').setValue(null);
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').disable();
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').enable();
                                                    Ext.getCmp('intULTRASONIDO_ContinuoTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intULTRASONIDO_ContinuoTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesUltrasonido'
                            }
                        ]
                    },
                    /*{
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'TRACCION',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Cervical',
                                        name: 'Cervical',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTRACCION_Cervical',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').allowBlank = true;
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').setValue(null);
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').disable();
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').enable();
                                                    Ext.getCmp('intTRACCION_CervicalTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTRACCION_CervicalTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Lumbar',
                                        name: 'Lumbar',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTRACCION_Lumbar',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').allowBlank = true;
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').setValue(null);
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').disable();
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').enable();
                                                    Ext.getCmp('intTRACCION_LumbarTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTRACCION_LumbarTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesTraccion'
                            }
                        ]
                    },*/
                    /*{
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'VI. BANDA SIN FIN',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesBandasinFin'
                            }
                        ]
                    },*/
                    /*{
                        xtype: 'fieldset',
                        title: 'VII. BICICLETA ESTATICA',
                        labelWidth: 210,
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesBicicletaEstatica'
                            }
                        ]
                    },*/
                    /*{
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'VIII. ESCALADOR',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesEscalador'
                            }
                        ]
                    },*/
                    {
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'EJERCICIOS',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Activos Asistidos',
                                        name: 'Activos Asistidos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_ActivosAsistidos',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosPeso').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosPeso').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosPeso').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosRepeticiones').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosRepeticiones').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosPeso').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosPeso').allowBlank = true;
                                                    
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosRepeticiones').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosAsistidosRepeticiones').allowBlank = true;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_ActivosAsistidosPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_ActivosAsistidosRepeticiones'
                                    }*/
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Activos Libres',
                                        name: 'Activos Libres',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_ActivosLibres',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresPeso').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresPeso').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresPeso').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresRepeticiones').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresRepeticiones').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresPeso').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresPeso').allowBlank = true;
                                                    
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresRepeticiones').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosLibresRepeticiones').allowBlank = true;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_ActivosLibresPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_ActivosLibresRepeticiones'
                                    }*/
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Activos Resistidos',
                                        name: 'Activos Resistidos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_ActivosResistidos',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosPeso').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosPeso').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosPeso').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosRepeticiones').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosRepeticiones').disable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosPeso').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosPeso').allowBlank = true;
                                                    
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosRepeticiones').enable();
                                                    Ext.getCmp('intEJERCICIOS_ActivosResistidosRepeticiones').allowBlank = true;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_ActivosResistidosPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_ActivosResistidosRepeticiones'
                                    }*/
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Pasivos',
                                        name: 'Pasivos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_Pasivos',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_PasivosPeso').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_PasivosPeso').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_PasivosPeso').disable();
                                                    Ext.getCmp('intEJERCICIOS_PasivosPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intEJERCICIOS_PasivosRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_PasivosRepeticiones').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_PasivosRepeticiones').disable();
                                                    Ext.getCmp('intEJERCICIOS_PasivosRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_PasivosPeso').enable();
                                                    Ext.getCmp('intEJERCICIOS_PasivosPeso').allowBlank = true;
                                                    
                                                    Ext.getCmp('intEJERCICIOS_PasivosRepeticiones').enable();
                                                    Ext.getCmp('intEJERCICIOS_PasivosRepeticiones').allowBlank = true;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_PasivosPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_PasivosRepeticiones'
                                    }*/
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Isometricos',
                                        name: 'Isometricos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_Isometricos',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_IsometricosPeso').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_IsometricosPeso').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_IsometricosPeso').disable();
                                                    Ext.getCmp('intEJERCICIOS_IsometricosPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intEJERCICIOS_IsometricosRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_IsometricosRepeticiones').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_IsometricosRepeticiones').disable();
                                                    Ext.getCmp('intEJERCICIOS_IsometricosRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_IsometricosPeso').enable();
                                                    Ext.getCmp('intEJERCICIOS_IsometricosPeso').allowBlank = true;
                                                    
                                                    Ext.getCmp('intEJERCICIOS_IsometricosRepeticiones').enable();
                                                    Ext.getCmp('intEJERCICIOS_IsometricosRepeticiones').allowBlank = true;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_IsometricosPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_IsometricosRepeticiones'
                                    }*/
                                ]
                            },
                            /*{
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Dinamicos Concentricos',
                                        name: 'Dinamicos Concentricos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_DinamicosConcentricos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosPeso').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosPeso').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosPeso').disable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosRepeticiones').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosRepeticiones').disable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosPeso').enable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosPeso').allowBlank = true;
                                                    
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosRepeticiones').enable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosConcentricosRepeticiones').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_DinamicosConcentricosPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_DinamicosConcentricosRepeticiones'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Dinamicos Excentricos',
                                        name: 'Isotonicos Excentricos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEJERCICIOS_DinamicosExcentricos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosPeso').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosPeso').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosPeso').disable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosRepeticiones').setValue(null);
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosRepeticiones').disable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosPeso').enable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosPeso').allowBlank = true;
                                                    
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosRepeticiones').enable();
                                                    Ext.getCmp('intEJERCICIOS_DinamicosExcentricosRepeticiones').allowBlank = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_DinamicosExcentricosPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intEJERCICIOS_DinamicosExcentricosRepeticiones'
                                    }
                                ]
                            },*/
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesEjercicios'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Estiramientos',
                                        name: 'Estiramientos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strOTROS_Estiramientos',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intOTROS_EstiramientosPeso').allowBlank = true;
                                                    Ext.getCmp('intOTROS_EstiramientosPeso').setValue(null);
                                                    Ext.getCmp('intOTROS_EstiramientosPeso').disable();
                                                    Ext.getCmp('intOTROS_EstiramientosPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intOTROS_EstiramientosRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intOTROS_EstiramientosRepeticiones').setValue(null);
                                                    Ext.getCmp('intOTROS_EstiramientosRepeticiones').disable();
                                                    Ext.getCmp('intOTROS_EstiramientosRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_EstiramientosPeso').enable();
                                                    Ext.getCmp('intOTROS_EstiramientosPeso').allowBlank = false;
                                                    
                                                    Ext.getCmp('intOTROS_EstiramientosRepeticiones').enable();
                                                    Ext.getCmp('intOTROS_EstiramientosRepeticiones').allowBlank = false;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intOTROS_EstiramientosPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intOTROS_EstiramientosRepeticiones'
                                    }*/
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Propiocepcion',
                                        name: 'Propiocepcion',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strOTROS_Propiocepcion',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intOTROS_PropiocepcionPeso').allowBlank = true;
                                                    Ext.getCmp('intOTROS_PropiocepcionPeso').setValue(null);
                                                    Ext.getCmp('intOTROS_PropiocepcionPeso').disable();
                                                    Ext.getCmp('intOTROS_PropiocepcionPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intOTROS_PropiocepcionRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intOTROS_PropiocepcionRepeticiones').setValue(null);
                                                    Ext.getCmp('intOTROS_PropiocepcionRepeticiones').disable();
                                                    Ext.getCmp('intOTROS_PropiocepcionRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_PropiocepcionPeso').enable();
                                                    Ext.getCmp('intOTROS_PropiocepcionPeso').allowBlank = false;
                                                    
                                                    Ext.getCmp('intOTROS_PropiocepcionRepeticiones').enable();
                                                    Ext.getCmp('intOTROS_PropiocepcionRepeticiones').allowBlank = false;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intOTROS_PropiocepcionPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intOTROS_PropiocepcionRepeticiones'
                                    }*/
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Equilibrio',
                                        name: 'Equilibrio',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strOTROS_Equilibrio',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intOTROS_EquilibrioPeso').allowBlank = true;
                                                    Ext.getCmp('intOTROS_EquilibrioPeso').setValue(null);
                                                    Ext.getCmp('intOTROS_EquilibrioPeso').disable();
                                                    Ext.getCmp('intOTROS_EquilibrioPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intOTROS_EquilibrioRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intOTROS_EquilibrioRepeticiones').setValue(null);
                                                    Ext.getCmp('intOTROS_EquilibrioRepeticiones').disable();
                                                    Ext.getCmp('intOTROS_EquilibrioRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_EquilibrioPeso').enable();
                                                    Ext.getCmp('intOTROS_EquilibrioPeso').allowBlank = false;
                                                    
                                                    Ext.getCmp('intOTROS_EquilibrioRepeticiones').enable();
                                                    Ext.getCmp('intOTROS_EquilibrioRepeticiones').allowBlank = false;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intOTROS_EquilibrioPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intOTROS_EquilibrioRepeticiones'
                                    }*/
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Reeducacion de Marcha',
                                        name: 'Reeducacion de Marcha',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strOTROS_ReeducacionMarcha',
                                        listeners:{
                                            /*select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaPeso').allowBlank = true;
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaPeso').setValue(null);
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaPeso').disable();
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaPeso').clearInvalid();
                                                    
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaRepeticiones').allowBlank = true;
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaRepeticiones').setValue(null);
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaRepeticiones').disable();
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaRepeticiones').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaPeso').enable();
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaPeso').allowBlank = false;
                                                    
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaRepeticiones').enable();
                                                    Ext.getCmp('intOTROS_ReeducacionMarchaRepeticiones').allowBlank = false;
                                                }
                                            }*/
                                        }
                                    }/*,
                                    {
                                        html: 'Peso:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intOTROS_ReeducacionMarchaPeso'
                                    },
                                    {
                                        html: 'Repeticiones:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Repeticiones',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        id: 'intOTROS_ReeducacionMarchaRepeticiones'
                                    }*/
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'TECNICAS MANUALES',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Masaje',
                                        name: 'Masaje',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTECMANUALES_Masaje',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTECMANUALES_MasajeTiempo').allowBlank = true;
                                                    Ext.getCmp('intTECMANUALES_MasajeTiempo').setValue(null);
                                                    Ext.getCmp('intTECMANUALES_MasajeTiempo').disable();
                                                    Ext.getCmp('intTECMANUALES_MasajeTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intOTROS_TherabyteTiempo').enable();
                                                    Ext.getCmp('intOTROS_TherabyteTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTECMANUALES_MasajeTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Movilizaciones Articulares',
                                        name: 'Movilizaciones Articulares',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTECMANUALES_MovilizacionesArticulares',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').allowBlank = true;
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').setValue(null);
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').disable();
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').enable();
                                                    Ext.getCmp('intTECMANUALES_MovilizacionesArticularesTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTECMANUALES_MovilizacionesArticularesTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Liberacion Miofascial',
                                        name: 'Liberacion Miofascial',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTECMANUALES_LiberacionMiofacial',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTECMANUALES_LiberacionMiofacialTiempo').allowBlank = true;
                                                    Ext.getCmp('intTECMANUALES_LiberacionMiofacialTiempo').setValue(null);
                                                    Ext.getCmp('intTECMANUALES_LiberacionMiofacialTiempo').disable();
                                                    Ext.getCmp('intTECMANUALES_LiberacionMiofacialTiempo').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTECMANUALES_LiberacionMiofacialTiempo').enable();
                                                    Ext.getCmp('intTECMANUALES_LiberacionMiofacialTiempo').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTECMANUALES_MovilizacionesArticularesTiempo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Vendaje Neuromuscular',
                                        name: 'Vendaje Neuromuscular',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strTECMANUALES_VendajeNeuromuscular',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('intTECMANUALES_VendajeNeuromuscular').allowBlank = true;
                                                    Ext.getCmp('intTECMANUALES_VendajeNeuromuscular').setValue(null);
                                                    Ext.getCmp('intTECMANUALES_VendajeNeuromuscular').disable();
                                                    Ext.getCmp('intTECMANUALES_VendajeNeuromuscular').clearInvalid();
                                                }else{
                                                    Ext.getCmp('intTECMANUALES_VendajeNeuromuscular').enable();
                                                    Ext.getCmp('intTECMANUALES_VendajeNeuromuscular').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'Tiempo',
                                        width: 90,
                                        allowBlank: true,
                                        disabled: true,
                                        minValue: 0,
                                        maxValue: 720,
                                        emptyText: 'mim',
                                        id: 'intTECMANUALES_VendajeNeuromuscular'
                                    }
                                ]
                            },
                            /*{
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Vendaje Neuromuscular',
                                name: 'Vendaje Neuromuscular',
                                height: 100,            
                                allowBlank: true,
                                id: ''
                            },*/
                            {
                                xtype: 'textarea',
                                width: 650,
                                fieldLabel: 'Observaciones',
                                name: 'Observaciones',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservacionesTecnicasManuales'
                            }
                        ]
                    },
                    /*{
                        xtype: 'fieldset',
                        labelWidth: 210,
                        title: 'ENFASIS DE LA CLASE',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Abdomen',
                                        name: 'Abdomen',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_Abdomen',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_AbdomenH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_AbdomenH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_AbdomenH').disable();
                                                    Ext.getCmp('strEnfasisClase_AbdomenH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_AbdomenH').enable();
                                                    Ext.getCmp('strEnfasisClase_AbdomenH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Abdomen',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_AbdomenH'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Cintura',
                                        name: 'Cintura',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_Cintura',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_CinturaH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_CinturaH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_CinturaH').disable();
                                                    Ext.getCmp('strEnfasisClase_CinturaH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_CinturaH').enable();
                                                    Ext.getCmp('strEnfasisClase_CinturaH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Cintura',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_CinturaH'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Escapular',
                                        name: 'Escapular',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_Escapular',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_EscapularH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_EscapularH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_EscapularH').disable();
                                                    Ext.getCmp('strEnfasisClase_EscapularH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_EscapularH').enable();
                                                    Ext.getCmp('strEnfasisClase_EscapularH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Escapular',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_EscapularH'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Columna Lumbar',
                                        name: 'Columna Lumbar',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_ColumnaLumbar',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_ColumnaLumbarH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_ColumnaLumbarH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_ColumnaLumbarH').disable();
                                                    Ext.getCmp('strEnfasisClase_ColumnaLumbarH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_ColumnaLumbarH').enable();
                                                    Ext.getCmp('strEnfasisClase_ColumnaLumbarH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Columna Lumbar',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_ColumnaLumbarH'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Miembros Superiores',
                                        name: 'Miembros Superiores',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_MiembrosSuperiores',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_MiembrosSuperioresH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_MiembrosSuperioresH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_MiembrosSuperioresH').disable();
                                                    Ext.getCmp('strEnfasisClase_MiembrosSuperioresH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_MiembrosSuperioresH').enable();
                                                    Ext.getCmp('strEnfasisClase_MiembrosSuperioresH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Miembros Superiores',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_MiembrosSuperioresH'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Miembros Inferiores',
                                        name: 'Miembros Inferiores',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_MiembrosInferiores',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_MiembrosInferioresH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_MiembrosInferioresH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_MiembrosInferioresH').disable();
                                                    Ext.getCmp('strEnfasisClase_MiembrosInferioresH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_MiembrosInferioresH').enable();
                                                    Ext.getCmp('strEnfasisClase_MiembrosInferioresH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Miembros Inferiores',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_MiembrosInferioresH'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Coordinacion',
                                        name: 'Coordinacion',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_Coordinacion',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_CoordinacionH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_CoordinacionH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_CoordinacionH').disable();
                                                    Ext.getCmp('strEnfasisClase_CoordinacionH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_CoordinacionH').enable();
                                                    Ext.getCmp('strEnfasisClase_CoordinacionH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Coordinacion',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_CoordinacionH'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Pleometricos',
                                        name: 'Pleometricos',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_Pleometricos',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_PleometricosH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_PleometricosH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_PleometricosH').disable();
                                                    Ext.getCmp('strEnfasisClase_PleometricosH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_PleometricosH').enable();
                                                    Ext.getCmp('strEnfasisClase_PleometricosH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Pleometricos',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_PleometricosH'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 70,
                                        fieldLabel: 'Equilibrio',
                                        name: 'Equilibrio',
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: "NO",
                                        id: 'strEnfasisClase_Equilibrio',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() == "NO"){
                                                    Ext.getCmp('strEnfasisClase_EquilibrioH').allowBlank = true;
                                                    Ext.getCmp('strEnfasisClase_EquilibrioH').setValue(null);
                                                    Ext.getCmp('strEnfasisClase_EquilibrioH').disable();
                                                    Ext.getCmp('strEnfasisClase_EquilibrioH').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strEnfasisClase_EquilibrioH').enable();
                                                    Ext.getCmp('strEnfasisClase_EquilibrioH').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Enfasis Clase - Equilibrio',
                                        width: 390,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'strEnfasisClase_EquilibrioH'
                                    }
                                ]
                            }
                        ]
                    },
                    /*{
                        xtype: 'fieldset',
                        title: 'PILATES',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'fieldset',
                                title: 'REFORMER',
                                layout: 'table',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                layoutConfig: {
                                    columns: 2
                                },
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Rollo',
                                        name: 'Rollo',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERRollo'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Balón de Bobath',
                                        name: 'Balón de Bobath',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERBalonBobath'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Balón Pequeño',
                                        name: 'Balón Pequeño',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERBalonPequeno'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Aro',
                                        name: 'Aro',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERAro'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Bosu',
                                        name: 'Bosu',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERBosu'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Mancuernas',
                                        name: 'Mancuernas',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERMancuernas'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Pesas MMII',
                                        name: 'Pesas MMII',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERPesasMMII'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Tabla de Salto',
                                        name: 'Tabla de Salto',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERTablaSalto'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Caja',
                                        name: 'Caja',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERCaja'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Silla',
                                        name: 'Silla',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERSilla'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        boxLabel: 'Theraban',
                                        name: 'Theraban',
                                        width: 250,
                                        value: 'false',
                                        id: 'bolPILATESREFORMERTheraban'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        emptyText: 'Color',
                                        id: 'strPILATESREFORMERTherabanColor'
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                title: 'SPRING BOARD',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numberfield',
                                                fieldLabel: 'Posicion',
                                                name: 'Posicion',
                                                width: 90,
                                                allowBlank: true,
                                                minValue: 1,
                                                maxValue: 10,
                                                id: 'strPILATESSPRINGBOARDPosicion'
                                            },
                                            {
                                                html: 'Resortes'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Resortes',
                                                width: 200,
                                                allowBlank: true,
                                                store: stMiembros,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPILATESSPRINGBOARDResortes'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },*/
                    {
                        xtype: 'timefield',
                        fieldLabel: 'Hora Salida',
                        name: 'Hora Salida',
                        width: 90,
                        allowBlank: true,
                        forceSelection: false,
                        minValue: '6:00 AM',
                        maxValue: '9:00 PM',
                        emptyText: 'p.e. 07:00',
                        //format:'H:i',
                        id: 'strHoraSalida'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'OBSERVACIONES',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 700,
                                fieldLabel: 'OBSERVACIONES',
                                name: 'OBSERVACIONES',
                                height: 100,            
                                allowBlank: true,
                                id: 'memObservaciones'
                            },
                            {
                                xtype: 'combo',
                                name: 'Fin Tratamiento',
                                fieldLabel: 'Fin Tratamiento',
                                width: 150,
                                allowBlank: true,
                                store: stFinTratamiento,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                value: "NO",
                                id: 'strFinTratamiento'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'EVOLUCION FINAL TRATAMIENTO',
                        layout: 'table',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 885,
                                fieldLabel: 'EVOLUCION FINAL TRATAMIENTO',
                                name: 'EVOLUCION FINAL TRATAMIENTO',
                                height: 100,            
                                allowBlank: true,
                                id: 'memEvolucionFinal'
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'RIPS',
                        layout: 'form',
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        id: 'fsRips',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: false,
                                        fieldLabel: 'Diagnostico Principal',
                                        id: 'sysDiagPpalHC',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagPpalHCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Principal',
                                        id: 'btnSearchDiagPpalHC',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                                        id: 'sysDiagRel1HC',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                        Ext.Ajax.request(
                                                        {
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagRel1HCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Relacionado1',
                                        id: 'btnSearchDiagRel1HC',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                                        id: 'sysDiagRel2HC',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                        Ext.Ajax.request(
                                                        {
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagRel2HCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Relacionado2',
                                        id: 'btnSearchDiagRel2HC1',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                                        id: 'sysDiagRel3HC',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                        Ext.Ajax.request(
                                                        {
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagRel3HCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Relacionado3',
                                        id: 'btnSearchDiagRel3HC',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo de Diagnostico',
                                width:750,
                                name: 'Tipo de Diagnostico',
                                allowBlank: false,
                                store: 'StoreTipoDiagnostico',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'sysTipoDiagosticoHC'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Finalidad Consulta',
                                width:750,
                                name: 'Finalidad Consulta',
                                allowBlank: false,
                                store: 'StoreFinalidadConsulta',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                value: 10,
                                id: 'sysFinalidadConsultaHC'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Causa Externa',
                                width:750,
                                name: 'Causa Externa',
                                allowBlank: false,
                                store: 'StoreCausaExterna',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                value: 13,
                                id: 'sysCausaExternaHC'
                            }                            
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: 'Solicitud Medicamentos',
                            height: 352,
                            width: 921,
                            frame: true,
                            border: false,
                            id: 'fichaMedicamentos',
                            items: [
                                xSolMX
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: 'Solicitud Servicios',
                            height: 355,
                            width: 921,
                            frame: true,
                            border: false,
                            id: 'fichaServicios',
                            items: [
                                xSolEXA
                            ]
                        },
                        {
                            xtype: 'panel',
                            title: 'Solicitud Remisiones',
                            height: 355,
                            width: 921,
                            frame: true,
                            border: false,
                            id: 'fichaRemisiones',
                            items: [
                                xSolREM
                            ]
                        }
                    ]
                }
            ]
        }
    ];
    winHCFisioterapia002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

