/*
* @category    Formulario Salud Ocupacional Partysalud - Toma Signos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCPartisalud001TomaSignosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Toma de Signos - Salud Ocupacional ::.',
    width: 990,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var stProfesionales = new StoreProfesionales();
        stProfesionales.load({
            params: {
                pUsuario: ID_USUARIO
            }
        });
        
        var stGridHistorialAtencionesTomaSignos = new StoreGridProcesosxPacientePartisalud();
        stGridHistorialAtencionesTomaSignos.load({
            params: {
                pPaciente: paramIdPaciente,
                IdNew: '1190'
            }
        });
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                id: 'btnSalirEvolucion',
                listeners:{
                    click : function(){
                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea cerrar la ventana?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn)
                                {
                                    if(btn=="yes")
                                    {
                                        Ext.getCmp('gridFormulario').store.reload();
                                        Ext.getCmp('winHC').close();
                                    }
                                }
                            });
                        else{
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'No se puede salir hasta que se guarde el proceso ',
                                buttons: Ext.Msg.OK,
                                icon: Ext.Msg.ERROR
                            });
                        }
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'tabpanel',
                anchor: '99%',
                //autoHeight: true,
                height: 560,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'VALORACION',
                        autoScroll: true,
                        frame: true,
                        border: false,
                        anchor: '100%',
                        id: 'fichaHCValoracionTomaSignos',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'form',
                                frame: true,
                                anchor: '100%',
                                id: 'frmHCSignos',
                                url: '../../controlador/asistencial/saludocupacional.php',
                                padding: 0,
                                border: false,
                                height: 610,
                                autoScroll: true,
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        value: 'TOMA DE SIGNOS VITALES Y TAMIZAJE VISUAL',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'REHUSA EXAMEN FISICO',
                                        name: 'REHUSA EXAMEN FISICO',
                                        id: 'bolTomaSignosRehusaExamenFisico'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'EXAMEN FISICO',
                                        labelWidth: '150',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '98%',
                                        autoHeight: true,
                                        id: 'fs6',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        fieldLabel: 'TALLA',
                                                        name:"TALLA (cm)",
                                                        emptyText: '(cm)',
                                                        id: 'intTomaSignosTalla',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('intTomaSignosTalla').setValue(null);
                                                                    Ext.getCmp('intTomaSignosIMC').setValue(0);
                                                                }else{
                                                                    //peso [kg]/ estatura [m2]
                                                                    if(Ext.getCmp('intTomaSignosPeso').getValue() > 0){
                                                                        var pTalla = Ext.getCmp('intTomaSignosTalla').getValue() / 100; 
                                                                        Ext.getCmp('intTomaSignosIMC').setValue(Ext.getCmp('intTomaSignosPeso').getValue()/(pTalla*pTalla));
                                                                    }else{
                                                                        Ext.getCmp('intTomaSignosIMC').setValue(0);
                                                                    }
                                                                }
                                                                if(Ext.getCmp('intTomaSignosIMC').getValue()<1){
                                                                   Ext.getCmp('strTomaSignosIMCClasificacon').setValue(null);
                                                                }else{
                                                                    if(Ext.getCmp('intTomaSignosIMC').getValue()<24.9){
                                                                       Ext.getCmp('strTomaSignosIMCClasificacon').setValue("ACEPTABLE");
                                                                    }else{
                                                                        if(Ext.getCmp('intTomaSignosIMC').getValue()<29.9){
                                                                           Ext.getCmp('strTomaSignosIMCClasificacon').setValue("SOBREPESO");
                                                                        }else{
                                                                            Ext.getCmp('strTomaSignosIMCClasificacon').setValue("OBESIDAD");
                                                                        }

                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosEF1',
                                                        value: 'PESO (Kg):'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        minValue: 0,
                                                        maxValue: 250,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        emptyText: '(Kg)',
                                                        name:"PESO ACTUAL (Kg)",
                                                        id: 'intTomaSignosPeso',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                if(pNew == null || pNew == 0){
                                                                    Ext.getCmp('intTomaSignosPeso').setValue(null);
                                                                    Ext.getCmp('intTomaSignosIMC').setValue(0);
                                                                }else{
                                                                    //peso [kg]/ estatura [m2]
                                                                    if(Ext.getCmp('intTomaSignosTalla').getValue() > 0){
                                                                        var pTalla = Ext.getCmp('intTomaSignosTalla').getValue() / 100; 
                                                                        Ext.getCmp('intTomaSignosIMC').setValue(Ext.getCmp('intTomaSignosPeso').getValue()/(pTalla*pTalla));
                                                                    }else{
                                                                        Ext.getCmp('intTomaSignosIMC').setValue(0);
                                                                    }
                                                                }
                                                                if(Ext.getCmp('intTomaSignosIMC').getValue()<1){
                                                                   Ext.getCmp('strTomaSignosIMCClasificacon').setValue(null);
                                                                }else{
                                                                    if(Ext.getCmp('intTomaSignosIMC').getValue()<24.9){
                                                                       Ext.getCmp('strTomaSignosIMCClasificacon').setValue("ACEPTABLE");
                                                                    }else{
                                                                        if(Ext.getCmp('intTomaSignosIMC').getValue()<29.9){
                                                                           Ext.getCmp('strTomaSignosIMCClasificacon').setValue("SOBREPESO");
                                                                        }else{
                                                                            Ext.getCmp('strTomaSignosIMCClasificacon').setValue("OBESIDAD");
                                                                        }

                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosEF2',
                                                        value: 'IMC:'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        value: 0,
                                                        name: "IMC",
                                                        id: 'intTomaSignosIMC'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 100,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        name: "IMC - CLASIFICACION",
                                                        id: 'strTomaSignosIMCClasificacon'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Lateralidad',
                                                anchor: '98%',
                                                name: 'LATERALIDAD',
                                                allowBlank: true,
                                                store: 'StoreLateralidad',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'strTomaSignosLateralidad'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        fieldLabel:"FC",
                                                        name: "FC",
                                                        id: 'strTomaSignosFC'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosFC',
                                                        value: 'Por Minuto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        fieldLabel:"TA",
                                                        name: "TA SISTOLICA",
                                                        id: 'strTomaSignosTASistolica'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosTA1',
                                                        value: '/'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        name: "TA DISTOLICA",
                                                        id: 'strTomaSignosTADiatolica'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosTA2',
                                                        value: 'MmHg'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 100,
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        fieldLabel:"FR",
                                                        name: "FR",
                                                        id: 'strTomaSignosFR'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosFR',
                                                        value: 'Por Minuto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textarea',
                                                width: 790,
                                                fieldLabel: 'Observaciones',
                                                name: 'OBSERVACIONES',
                                                height: 30,
                                                grow: true,
                                                minGrow: 30,
                                                allowBlank: true,
                                                id: 'memTomaSignosObservaciones'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'TAMIZAJE VISUAL',
                                        labelWidth: '150',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '98%',
                                        autoHeight: true,
                                        id: 'fsa',
                                        items: [
                                            { // Tabla Examen Fisico
                                                xtype: 'panel',
                                                layout: 'table',
                                                unstyled: true,
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        width: 110,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'combo', // col 3.1
                                                                fieldLabel: 'Ojos',
                                                                name:"EXANEN FISICO - OJOS",
                                                                width: 100,
                                                                allowBlank: true,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strTomaSignosOjos',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NORMAL"){
                                                                            Ext.getCmp('memTomaSignosOjosH').allowBlank = true;
                                                                            Ext.getCmp('memTomaSignosOjosH').setValue(null);
                                                                            Ext.getCmp('memTomaSignosOjosH').disable();
                                                                            Ext.getCmp('memTomaSignosOjosH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('memTomaSignosOjosH').enable();
                                                                            Ext.getCmp('memTomaSignosOjosH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 780,
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        border: false,
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                emptyText: 'HALLAZGOS',
                                                                name:"EXANEN FISICO - OJOS - HALLAZGOS",
                                                                disabled: true,
                                                                height: 20,
                                                                anchor: '98%',
                                                                grow: true,
                                                                growMin: 20,
                                                                growMax: 400,
                                                                allowBlank: true,
                                                                id: 'memTomaSignosOjosH'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        style: 'text-align:center;',
                                                        fieldLabel: 'AV.Lejana: OD',
                                                        name: 'AV.LEJANA:OD',
                                                        value: '20/',
                                                        width: 80,
                                                        allowBlank: true,
                                                        id: 'strTomaSignosAVLejanaOD'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosAV1',
                                                        value: 'AV.Lejana: OI'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        style: 'text-align:center;',
                                                        name: 'AV.LEJANA:OI',
                                                        value: '20/',
                                                        width: 80,
                                                        allowBlank: true,
                                                        id: 'strTomaSignosAVLejanaOI'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosAV2',
                                                        value: 'AV.Cercana: OD'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        style: 'text-align:center;',
                                                        nameLabel: 'AV.CERCANA: OD',
                                                        value: '20/',
                                                        width: 80,
                                                        allowBlank: true,
                                                        id: 'strTomaSignosAVCercanaOD'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosAV3',
                                                        value: 'AV.Cercana: OI'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        style: 'text-align:center;',
                                                        name: 'AV.CERCANA: OI',
                                                        value: '20/',
                                                        width: 80,
                                                        allowBlank: true,
                                                        id: 'strTomaSignosAVCercanaOI'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaSignosAVx4',
                                                        value: 'Se Hizo con Correción?'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        width: 80,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'strTomaSignosAVCorrecion'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Profesional Responsable',
                                        anchor: '98%',
                                        name: 'Profesional',
                                        allowBlank: false,
                                        store: stProfesionales,
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Concepto',
                                        width: 150,
                                        name: 'CONCEPTO',
                                        allowBlank: false,
                                        store: 'StoreAptoNoApto',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strTomaSignosConcepto'
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btnGuardarTomaSignos',
                                            listeners:{
                                                click : function(){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que desea Modificar la evolución, si hace esto no podra realizar ningun cambio?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn)
                                                        {
                                                            if(btn=="yes")
                                                            {
                                                                fnModificarRegistrosTomaSignos();
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'HISTORIAL DE ATENCIONES',
                        autoScroll: true,
                        frame: true,
                        border: false,
                        id: 'fichaHistorialAtencionesTomaSignos',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridProcesoPartisaludxPacTomaSignos',
                                store: stGridHistorialAtencionesTomaSignos,
                                title: '',
                                anchor: "100%",
                                border: false,
                                frame: true,
                                height: 510,
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            tooltip: 'Actualizar',
                                            id: 'btnActualizarInfoPac_22',
                                            listeners:{
                                                click : function(){
                                                    Ext.getCmp('gridProcesoPartisaludxPacTomaSignos').store.reload();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imprimir Historia',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Historia',
                                            id: 'btnPrintHCSO_2',
                                            listeners:{
                                                click : function(){
                                                    if(Ext.getCmp('gridProcesoPartisaludxPacTomaSignos').selModel.getCount() == 1){
                                                        var selections = Ext.getCmp('gridProcesoPartisaludxPacTomaSignos').selModel.getSelections();
                                                        window.open ("../../controlador/asistencial/printpartisalud.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Historia Ocupacional");
                                                    }
                                                }
                                            }
                                        }
                                    ]
                                },
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'IdCliente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'IdCliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'FechaAtencion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Cliente',
                                        sortable: false,
                                        width: 200,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Cliente'
                                    },
                                    {
                                        header: 'Concepto Final',
                                        dataIndex: 'ConceptoFinal',
                                        sortable: true,
                                        width: 100
                                    },
                                    {
                                        header: 'Concepto Enfermeria',
                                        dataIndex: 'ConceptoTomaSignos',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Laboratorio',
                                        dataIndex: 'ConceptoLaboratorio',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Fonoaudiologia',
                                        dataIndex: 'ConceptoFonoaudiologia',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Medicina',
                                        dataIndex: 'ConceptoMedicoOcupacional',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Tipo Examen',
                                        dataIndex: 'TipoExamen',
                                        sortable: false,
                                        width: 150
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        switch(record.get('ConceptoFinal')){
                                            case "APTO":
                                                return 'Apto';
                                                break;
                                            case "NO APTO":
                                                return 'NoApto';
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                var frm = Ext.getCmp('frmHCSignos').getForm();
                frm.load({
                    params:{
                        pCAS: Ext.getCmp('sysCASHC').getValue(),
                        pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                        task: 'PARTISALUD_CARGAR_DATA_TOMASIGNOS'
                    }
                });
            }}//jorge
        }); 
        winHCPartisalud001TomaSignosUi.superclass.initComponent.call(this);
    }
});


function fnModificarRegistrosTomaSignos(){
    var frm = Ext.getCmp('frmHCSignos').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/saludocupacional.php',
            params:{
                task: 'PARTISALUD_TOMASIGNOS',
                CAMPOS: listacampos,
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoHC: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        Ext.getCmp('gridFormulario').store.reload();
                        Ext.getCmp('winHC').close();
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
