/*
* @category    Formulario Salud Ocupacional Partysalud - Toma Muestras
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCPartisalud001ResultLaboUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Resultados de Laboratorio - Salud Ocupacional ::.',
    width: 990,
    height: 600,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        var stGridHistorialAtencionesResLabo = new StoreGridProcesosxPacientePartisalud();
        stGridHistorialAtencionesResLabo.load({
            params: {
                pPaciente: paramIdPaciente,
                IdNew: '1190'
            }
        });
        var stProfesionales = new StoreProfesionales();
        stProfesionales.load({
            params: {
                pUsuario: ID_USUARIO
            }
        });
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                id: 'btnSalirEvolucion',
                listeners:{
                    click : function(){
                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea cerrar la ventana?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn)
                                {
                                    if(btn=="yes")
                                    {
                                        Ext.getCmp('gridFormulario').store.reload();
                                        Ext.getCmp('winHC').close();
                                    }
                                }
                            });
                        else{
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'No se puede salir hasta que se guarde el proceso ',
                                buttons: Ext.Msg.OK,
                                icon: Ext.Msg.ERROR
                            });
                        }
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'tabpanel',
                anchor: '99%',
                //autoHeight: true,
                height: 560,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'RESULTADOS LABORATORIO',
                        autoScroll: true,
                        frame: true,
                        border: false,
                        anchor: '100%',
                        id: 'fichaHCValoracionResLabo',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'form',
                                frame: true,
                                anchor: '100%',
                                id: 'frmHCResultLab',
                                url: '../../controlador/asistencial/saludocupacional.php',
                                padding: 0,
                                border: false,
                                height: 510,
                                autoScroll: true,
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        value: 'RESULTADOS DE LABORATORIO',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'EXAMENES',
                                        labelWidth: '150',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        id: 'fs6',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaMuestras1',
                                                        value: 'Tipo:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: "Hemoclasificación",
                                                        name: "Hemoclasificación",
                                                        width: 90,
                                                        allowBlank: true,
                                                        store: 'StoreHemoclasificacion',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        id: 'strLaboHemoclasificaGrupo'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaMuestras2',
                                                        value: 'Rh:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: "Hemoclasificación",
                                                        width: 150,
                                                        allowBlank: true,
                                                        store: 'StorePositivoNegativo',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        id: 'strLaboHemoclasificaRH'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: '800',
                                                allowBlank: true,
                                                fieldLabel: 'Glucometria',
                                                name: 'Glucometria',
                                                id: 'strLaboGlucometria'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: '800',
                                                allowBlank: true,
                                                fieldLabel: 'Glicemia',
                                                name: 'Glicemia',
                                                id: 'strLaboGlicemia'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo', 
                                                        fieldLabel: "Serologia VDRL Tipo I",
                                                        name:"Serologia VDRL Tipo I",
                                                        width: 180,
                                                        allowBlank: true,
                                                        store: 'StoreReactivoNoReactivo',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        id: 'strLaboSerologia'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaMuestras2',
                                                        value: 'Obs.:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: '580',
                                                        allowBlank: true,
                                                        name: 'Res Serologia VDRL Tipo I',
                                                        id: 'strLaboSerologiaH'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                allowBlank: true,
                                                id: 'strLaboPruebaEmbarazo'
                                            },
                                            {
                                                xtype: 'hidden',
                                                allowBlank: true,
                                                id: 'strLaboPruebaEmbarazoH'
                                            },
                                            /*{
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: "Serologia VDRL Tipo II",
                                                        name:"Serologia VDRL Tipo II",
                                                        width: 180,
                                                        allowBlank: true,
                                                        store: 'StoreReactivoNoReactivo',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        id: 'strLaboPruebaEmbarazo'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'systxtTomaMuestras2',
                                                        value: 'Obs.:'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: '580',
                                                        allowBlank: true,
                                                        name: 'Res Serologia VDRL Tipo II',
                                                        id: 'strLaboPruebaEmbarazoH'
                                                    }
                                                ]
                                            },*/
                                            {
                                                xtype: 'textfield',
                                                width: '800',
                                                allowBlank: true,
                                                fieldLabel: 'Colesterol',
                                                name: 'Colesterol',
                                                id: 'strLaboColesterol'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: '800',
                                                allowBlank: true,
                                                fieldLabel: 'Colesterol HDL',
                                                name: 'Colesterol HDL',
                                                id: 'strLaboColesterolHDL'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: '800',
                                                allowBlank: true,
                                                fieldLabel: 'Colesterol LDL',
                                                name: 'Colesterol LDL',
                                                id: 'strLaboColesterolLDL'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: '800',
                                                allowBlank: true,
                                                fieldLabel: 'Trigliceridos',
                                                name: 'Trigliceridos',
                                                id: 'strLaboTrigliceridos'
                                            },
                                            {
                                                xtype: 'textarea',
                                                width: '800',
                                                allowBlank: true,
                                                fieldLabel: 'Otros',
                                                name: 'Otros',
                                                id: 'memLaboOtros'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Profesional Responsable',
                                        anchor: '100%',
                                        name: 'Profesional',
                                        allowBlank: false,
                                        store: stProfesionales,
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Concepto',
                                        width: 150,
                                        name: 'CONCEPTO',
                                        allowBlank: false,
                                        store: 'StoreAptoNoApto',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strLaboratorioConcepto'
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btnGuardarTomaSignos',
                                            listeners:{
                                                click : function(){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que desea Modificar la evolución, si hace esto no podra realizar ningun cambio?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn)
                                                        {
                                                            if(btn=="yes")
                                                            {
                                                                fnModificarRegistrosResultLabo();
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'HISTORIAL DE ATENCIONES',
                        autoScroll: true,
                        frame: true,
                        border: false,
                        id: 'fichaHistorialAtencionesResLabo',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridProcesoPartisaludxPacResLabo',
                                store: stGridHistorialAtencionesResLabo, 
                                title: '',
                                anchor: "100%",
                                border: false,
                                frame: true,
                                height: 510,
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            tooltip: 'Actualizar',
                                            id: 'btnActualizarInfoPac_3',
                                            listeners:{
                                                click : function(){
                                                    Ext.getCmp('gridProcesoPartisaludxPacResLabo').store.reload();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imprimir Historia',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Historia',
                                            id: 'btnPrintHCSO_3',
                                            listeners:{
                                                click : function(){
                                                    if(Ext.getCmp('gridProcesoPartisaludxPacResLabo').selModel.getCount() == 1){
                                                        var selections = Ext.getCmp('gridProcesoPartisaludxPacResLabo').selModel.getSelections();
                                                        window.open ("../../controlador/asistencial/printpartisalud.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Historia Ocupacional");
                                                    }
                                                }
                                            }
                                        }
                                    ]
                                },
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'IdCliente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'IdCliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'FechaAtencion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Cliente',
                                        sortable: false,
                                        width: 200,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Cliente'
                                    },
                                    {
                                        header: 'Concepto Final',
                                        dataIndex: 'ConceptoFinal',
                                        sortable: true,
                                        width: 100
                                    },
                                    {
                                        header: 'Concepto Enfermeria',
                                        dataIndex: 'ConceptoTomaSignos',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Laboratorio',
                                        dataIndex: 'ConceptoLaboratorio',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Fonoaudiologia',
                                        dataIndex: 'ConceptoFonoaudiologia',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Medicina',
                                        dataIndex: 'ConceptoMedicoOcupacional',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Tipo Examen',
                                        dataIndex: 'TipoExamen',
                                        sortable: false,
                                        width: 150
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        switch(record.get('ConceptoFinal')){
                                            case "APTO":
                                                return 'Apto';
                                                break;
                                            case "NO APTO":
                                                return 'NoApto';
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                var frm = Ext.getCmp('frmHCResultLab').getForm();
                frm.load({
                    params:{
                        pCAS: Ext.getCmp('sysCASHC').getValue(),
                        pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                        task: 'PARTISALUD_CARGAR_DATA_RESULTLABO'
                    }
                });
            }}//jorge
        }); 
        winHCPartisalud001ResultLaboUi.superclass.initComponent.call(this);
    }
});


function fnModificarRegistrosResultLabo(){
    var frm = Ext.getCmp('frmHCResultLab').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/saludocupacional.php',
            params:{
                task: 'PARTISALUD_RESULTLABO',
                CAMPOS: listacampos,
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoHC: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        Ext.getCmp('gridFormulario').store.reload();
                        Ext.getCmp('winHC').close();
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
