/*
* @category    Formulario Salud Ocupacional Partysalud - Fonoaudiologia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCPartisalud001FonoaudiologiaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Tamizaje Auditivo - Salud Ocupacional ::.',
    width: 990,
    height: 600,
    closable: false,
    resizable: false,
    //draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {

        var stAudiograma = new StoreAudiograma();
        var stProfesionales = new StoreProfesionales();
        stProfesionales.load({
            params: {
                pUsuario: ID_USUARIO
            }
        });
        chartAudiograma = new Ext.chart.LineChart({
            id: 'chartAudiograma',
            store: stAudiograma,
            xField: 'frecuencia',
            extraStyle: {
                 legend: {
                    display: 'right'
                 }
            },
            yAxis: new Ext.chart.NumericAxis({
                reverse: true, // ### here
                maximum: 130,
                minimum: -20,
                majorUnit: 10,
                minorUnit: 5//,
                //displayName: 'Rank'
            }),
            series: [
                {
                    yField: 'OD',
                    displayName: 'OD',
                    style: {
                        color: '#FE2E2E'
                    },
                    markerCfg: {
                        type: 'circle'
                    }
                },{
                    yField: 'OI',
                    displayName: 'OI',
                    style: {
                        color: 0x15428B
                    },
                    markerCfg: {
                        type: 'cross'
                    }
                }
            ]
        });
        var stGridHistorialAtencionesResFono = new StoreGridProcesosxPacientePartisalud();
        stGridHistorialAtencionesResFono.load({
            params: {
                pPaciente: paramIdPaciente,
                IdNew: '1190'
            }
        });
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                id: 'btnSalirEvolucion',
                listeners:{
                    click : function(){
                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea cerrar la ventana?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn)
                                {
                                    if(btn=="yes")
                                    {
                                        Ext.getCmp('gridFormulario').store.reload();
                                        Ext.getCmp('winHC').close();
                                    }
                                }
                            });
                        else{
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'No se puede salir hasta que se guarde el proceso ',
                                buttons: Ext.Msg.OK,
                                icon: Ext.Msg.ERROR
                            });
                        }
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'tabpanel',
                anchor: '99%',
                //autoHeight: true,
                height: 560,
                border: false,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'VALORACION',
                        autoScroll: true,
                        frame: true,
                        border: false,
                        anchor: '100%',
                        id: 'fichaHCValoracionFono',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'form',
                                frame: true,
                                anchor: '98%',
                                id: 'frmHCFono',
                                url: '../../controlador/asistencial/saludocupacional.php',
                                padding: 0,
                                border: false,
                                height: 510,
                                autoScroll: true,
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        value: 'TAMIZAJE AUDITIVO',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '98%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'ANTECEDENTES OTOLOGICOS',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '99%',
                                        autoHeight: true,
                                        id: 'fs0',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                autoHeight: true,
                                                autoScroll: true,
                                                anchor: '100%',
                                                //frame: true,
                                                border: false,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        width: 400,
                                                        height: 105,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Otalqia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAO_Otalqia'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Otitis Extrena',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAO_OtitisExterna'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Otitis Media',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAO_OtitisMedia'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Acúfenos',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAO_Acufenos'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        width: 400,
                                                        height: 105,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Vértigo',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAO_Vertigo'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Otorrea',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAO_Otorrea'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                fieldLabel: 'Otorragia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAO_Otorragia'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                fieldLabel: 'Otros',
                                                                id: 'strAO_Otros'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'ANTECEDENTES FAMILIARES',
                                        layout: 'table',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '99%',
                                        autoHeight: true,
                                        id: 'fsAF',
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                width: '980',
                                                allowBlank: true,
                                                fieldLabel: 'Antecedentes Familiares',
                                                name: 'Antecedentes Familiares',
                                                id: 'memFonoAntecedentesFamiliares'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'EXPOSICIÓN A OTROS',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '99%',
                                        autoHeight: true,
                                        id: 'fsEOTR',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Servicio Militar',
                                                name: 'Servicio Militar',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strExpoOtros_ServicioMilitar'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Moto',
                                                name: 'Moto',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strExpoOtros_Moto'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Dispositivos de Sonido',
                                                name: 'Dispositivos de Sonido',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strExpoOtros_DispositivoSonido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                allowBlank: true,
                                                fieldLabel: 'Otros',
                                                id: 'strExpoOtros_Otros'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'EXPLORACION CLINICA',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '99%',
                                        autoHeight: true,
                                        id: 'fs1',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                autoHeight: true,
                                                autoScroll: true,
                                                anchor: '100%',
                                                //frame: true,
                                                border: false,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 3
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: 'Descripción',
                                                        labelWidth: 1,
                                                        width: 300,
                                                        height: 185,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Otoscopia:',
                                                                style: 'background:transparent;',
                                                                id: 'sysOtoscopia1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Pabellón Auricular:',
                                                                style: 'background:transparent;',
                                                                id: 'sysOtoscopia2'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Conducto Auditivo Externo:',
                                                                style: 'background:transparent;',
                                                                id: 'sysOtoscopia3'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Tapón de Cerumen Parcial:',
                                                                style: 'background:transparent;',
                                                                id: 'sysOtoscopia4'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Membrana Timpánica:',
                                                                style: 'background:transparent;',
                                                                id: 'sysOtoscopia5'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 'Otros:',
                                                                style: 'background:transparent;',
                                                                id: 'sysOtoscopia6'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'OD',
                                                        labelWidth: 1,
                                                        width: 110,
                                                        height: 185,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Otoscopia',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOD_Otoscopia'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Pabellón Auricular',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOD_PabellonAuricular'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Conducto Auditivo Externo',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOD_ConductoAuditivoExterno'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Tapón de Cerumen Parcial',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOD_TaponCerumen'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Membrana Timpánica',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOD_membranaTimpanica'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                name: 'Otros',
                                                                id: 'strOtoscopiaOD_Otros'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'OI',
                                                        labelWidth: 1,
                                                        width: 110,
                                                        height: 185,
                                                        layout: 'form',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Otoscopia',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOI_Otoscopia'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Pabellón Auricular',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOI_PabellonAuricular'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Conducto Auditivo Externo',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOI_ConductoAuditivoExterno'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Tapón de Cerumen Parcial',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOI_TaponCerumen'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 100,
                                                                name: 'Membrana Timpánica',
                                                                allowBlank: false,
                                                                store: 'StoreNormalAnormal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NORMAL',
                                                                id: 'strOtoscopiaOI_membranaTimpanica'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                anchor: '100%',
                                                                allowBlank: true,
                                                                name: 'Otros',
                                                                id: 'strOtoscopiaOI_Otros'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'EVALUACION AUDIOMETRICA',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '99%',
                                        autoHeight: true,
                                        id: 'fs3',
                                        items: [
                                            {
                                                xtype: 'panel',
                                                autoHeight: true,
                                                autoScroll: true,
                                                anchor: '100%',
                                                //frame: true,
                                                border: false,
                                                layout: 'table',
                                                layoutConfig: {
                                                    columns: 2
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: 'VIA AEREA',
                                                        labelWidth: 1,
                                                        width: 335,
                                                        height: 260,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 3
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                title: 'Frecuencia',
                                                                labelWidth: 1,
                                                                width: 105,
                                                                height: 255,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: '250',
                                                                        style: 'background:transparent;color:#800000; font-weight:bold',
                                                                        id: 'sysAudiogramaVA1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: '500',
                                                                        style: 'background:transparent;color:#800000; font-weight:bold',
                                                                        id: 'sysAudiogramaVA2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: '1000',
                                                                        style: 'background:transparent;color:#800000; font-weight:bold',
                                                                        id: 'sysAudiogramaVA3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: '2000',
                                                                        style: 'background:transparent;color:#800000; font-weight:bold',
                                                                        id: 'sysAudiogramaVA4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: '3000',
                                                                        style: 'background:transparent;color:#800000; font-weight:bold',
                                                                        id: 'sysAudiogramaVA5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: '4000',
                                                                        style: 'background:transparent;color:#800000; font-weight:bold',
                                                                        id: 'sysAudiogramaVA6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: '6000',
                                                                        style: 'background:transparent;color:#800000; font-weight:bold',
                                                                        id: 'sysAudiogramaVA7'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        anchor: '100%',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        value: '8000',
                                                                        style: 'background:transparent;color:#800000; font-weight:bold',
                                                                        id: 'sysAudiogramaVA8'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'OD',
                                                                labelWidth: 1,
                                                                width: 105,
                                                                height: 255,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OD',
                                                                        //minValue: -10,
                                                                        //maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OD250'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OD',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OD500'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OD',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OD1000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OD',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OD2000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OD',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OD3000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OD',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OD4000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OD',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OD6000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OD',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OD8000'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                title: 'OI',
                                                                labelWidth: 1,
                                                                width: 105,
                                                                height: 255,
                                                                layout: 'form',
                                                                items: [
                                                                    {
                                                                        xtype: 'hidden',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OI',
                                                                        //minValue: -10,
                                                                        //maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OI250'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OI',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OI500'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OI',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OI1000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OI',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OI2000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OI',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OI3000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OI',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OI4000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OI',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OI6000'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        anchor: '99%',
                                                                        name: 'Audiograma Via AEREA OI',
                                                                        minValue: -10,
                                                                        maxValue: 120,
                                                                        allowBlank: true,
                                                                        style: 'text-align:center;',
                                                                        id: 'intAudiogramaVA_OI8000'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'AUDIOGRAMA',
                                                        width: 550,
                                                        height: 260,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        border: true,
                                                        items: [
                                                            chartAudiograma //Grafica
                                                        ],
                                                        tbar:{
                                                            items: [
                                                                {
                                                                    xtype: 'tbfill'
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                },
                                                                {
                                                                    xtype: 'button',
                                                                    text: 'Graficar',
                                                                    iconCls: 'btnGraficar',
                                                                    id: 'btnGraficarAudiograma',
                                                                    listeners:{
                                                                        click : function(){
                                                                            DrawAudiograma();
                                                                        }
                                                                    }
                                                                },
                                                                {
                                                                    xtype: 'tbseparator'
                                                                }
                                                            ]
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textarea',
                                        width: '800',
                                        allowBlank: true,
                                        fieldLabel: 'Tamizaje',
                                        name: 'Tamizaje',
                                        id: 'memAudiometria'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Profesional Responsable',
                                        anchor: '98%',
                                        name: 'Profesional',
                                        allowBlank: false,
                                        store: stProfesionales,
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Concepto',
                                        width: 150,
                                        name: 'CONCEPTO',
                                        allowBlank: false,
                                        store: 'StoreAptoNoApto',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strFonoaudiologiaConcepto'
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btnGuardarTomaSignos',
                                            listeners:{
                                                click : function(){
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que desea Modificar la evolución, si hace esto no podra realizar ningun cambio?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn)
                                                        {
                                                            if(btn=="yes")
                                                            {
                                                                fnModificarRegistrosFonoaudiologia();
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'HISTORIAL DE ATENCIONES',
                        autoScroll: true,
                        frame: true,
                        border: false,
                        id: 'fichaHistorialAtencionesResFono',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridProcesoPartisaludxPacResFono',
                                store: stGridHistorialAtencionesResFono, 
                                title: '',
                                anchor: "100%",
                                border: false,
                                frame: true,
                                height: 510,
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            tooltip: 'Actualizar',
                                            id: 'btnActualizarInfoPac_4',
                                            listeners:{
                                                click : function(){
                                                    Ext.getCmp('gridProcesoPartisaludxPacResFono').store.reload();
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imprimir Historia',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Historia',
                                            id: 'btnPrintHCSO_4',
                                            listeners:{
                                                click : function(){
                                                    if(Ext.getCmp('gridProcesoPartisaludxPacResFono').selModel.getCount() == 1){
                                                        var selections = Ext.getCmp('gridProcesoPartisaludxPacResFono').selModel.getSelections();
                                                        window.open ("../../controlador/asistencial/printpartisalud.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.CAS,"Historia Ocupacional");
                                                    }
                                                }
                                            }
                                        }
                                    ]
                                },
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'IdCliente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'IdCliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'FechaAtencion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Cliente',
                                        sortable: false,
                                        width: 200,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'Cliente'
                                    },
                                    {
                                        header: 'Concepto Final',
                                        dataIndex: 'ConceptoFinal',
                                        sortable: true,
                                        width: 100
                                    },
                                    {
                                        header: 'Concepto Enfermeria',
                                        dataIndex: 'ConceptoTomaSignos',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Laboratorio',
                                        dataIndex: 'ConceptoLaboratorio',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Fonoaudiologia',
                                        dataIndex: 'ConceptoFonoaudiologia',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Concepto Medicina',
                                        dataIndex: 'ConceptoMedicoOcupacional',
                                        sortable: true,
                                        width: 130
                                    },
                                    {
                                        header: 'Tipo Examen',
                                        dataIndex: 'TipoExamen',
                                        sortable: false,
                                        width: 150
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        switch(record.get('ConceptoFinal')){
                                            case "APTO":
                                                return 'Apto';
                                                break;
                                            case "NO APTO":
                                                return 'NoApto';
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                if(paramOpcion != "Nuevo"){
                    var frm = Ext.getCmp('frmHCFono').getForm();
                    frm.load({
                        params:{
                            pCAS: Ext.getCmp('sysCASHC').getValue(),
                            pConsecutivo: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                            task: 'PARTISALUD_CARGAR_DATA_FONOAUDIOLOGIA'
                        }
                    });
                }
            }}
        }); 
        winHCPartisalud001FonoaudiologiaUi.superclass.initComponent.call(this);
    }
});


function fnModificarRegistrosFonoaudiologia(){
    var frm = Ext.getCmp('frmHCFono').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/saludocupacional.php',
            params:{
                task: 'PARTISALUD_FONOAUDIOLOGIA',
                CAMPOS: listacampos,
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoHC: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        Ext.getCmp('gridFormulario').store.reload();
                        Ext.getCmp('winHC').close();
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function DrawAudiograma(){
    /*if(Ext.getCmp('intAudiogramaVA_OD500').getValue() == null || Ext.getCmp('intAudiogramaVA_OD500').getValue() == "" || Ext.getCmp('intAudiogramaVA_OD1000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD1000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OD2000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD2000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OD3000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD3000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OD4000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD4000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OD6000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD6000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OD8000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD8000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OI250').getValue() == null || Ext.getCmp('intAudiogramaVA_OI250').getValue() == "" || Ext.getCmp('intAudiogramaVA_OI500').getValue() == null || Ext.getCmp('intAudiogramaVA_OI500').getValue() == "" || Ext.getCmp('intAudiogramaVA_OI1000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI1000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OI2000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI2000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OI3000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI3000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OI4000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI4000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OI6000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI6000').getValue() == "" || Ext.getCmp('intAudiogramaVA_OI8000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI8000').getValue() == ""){
        Ext.MessageBox.show({
            title: 'Audiograma',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }else{*/
        Ext.getCmp('chartAudiograma').store.removeAll();
        var recId;
        var st = new StoreAudiograma();
        //recId = 1;
        //Ext.getCmp('chartAudiograma').store.add(new st.recordType({
        //        IDReg: recId,
        //       frecuencia: 250,
        //        OD: Ext.getCmp('intAudiogramaVA_OD250').getValue(),
        //        OI: Ext.getCmp('intAudiogramaVA_OI250').getValue()
        //    })
        //);
        recId = 2;
        if(Ext.getCmp('intAudiogramaVA_OD500').getValue() == null || Ext.getCmp('intAudiogramaVA_OD500').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OD500').setValue(0);  
        }
        if(Ext.getCmp('intAudiogramaVA_OI500').getValue() == null || Ext.getCmp('intAudiogramaVA_OI500').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OI500').setValue(0);  
        }
        Ext.getCmp('chartAudiograma').store.add(new st.recordType({
                IDReg: recId,
                frecuencia: 500,
                OD: Ext.getCmp('intAudiogramaVA_OD500').getValue(),
                OI: Ext.getCmp('intAudiogramaVA_OI500').getValue()
            })
        );
        recId = 3;
        if(Ext.getCmp('intAudiogramaVA_OD1000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD1000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OD1000').setValue(0);  
        }
        if(Ext.getCmp('intAudiogramaVA_OI1000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI1000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OI1000').setValue(0);  
        }
        Ext.getCmp('chartAudiograma').store.add(new st.recordType({
                IDReg: recId,
                frecuencia: 1000,
                OD: Ext.getCmp('intAudiogramaVA_OD1000').getValue(),
                OI: Ext.getCmp('intAudiogramaVA_OI1000').getValue()
            })
        );
        recId = 4;
        if(Ext.getCmp('intAudiogramaVA_OD2000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD2000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OD2000').setValue(0);  
        }
        if(Ext.getCmp('intAudiogramaVA_OI2000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI2000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OI2000').setValue(0);  
        }
        Ext.getCmp('chartAudiograma').store.add(new st.recordType({
                IDReg: recId,
                frecuencia: 2000,
                OD: Ext.getCmp('intAudiogramaVA_OD2000').getValue(),
                OI: Ext.getCmp('intAudiogramaVA_OI2000').getValue()
            })
        );
        recId = 5;
        if(Ext.getCmp('intAudiogramaVA_OD3000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD3000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OD3000').setValue(0);  
        }
        if(Ext.getCmp('intAudiogramaVA_OI3000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI3000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OI3000').setValue(0);  
        }
        Ext.getCmp('chartAudiograma').store.add(new st.recordType({
                IDReg: recId,
                frecuencia: 3000,
                OD: Ext.getCmp('intAudiogramaVA_OD3000').getValue(),
                OI: Ext.getCmp('intAudiogramaVA_OI3000').getValue()
            })
        );
        recId = 6;
        if(Ext.getCmp('intAudiogramaVA_OD4000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD4000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OD4000').setValue(0);  
        }
        if(Ext.getCmp('intAudiogramaVA_OI4000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI4000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OI4000').setValue(0);  
        }
        Ext.getCmp('chartAudiograma').store.add(new st.recordType({
                IDReg: recId,
                frecuencia: 4000,
                OD: Ext.getCmp('intAudiogramaVA_OD4000').getValue(),
                OI: Ext.getCmp('intAudiogramaVA_OI4000').getValue()
            })
        );
        recId = 7;
        if(Ext.getCmp('intAudiogramaVA_OD6000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD6000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OD6000').setValue(0);  
        }
        if(Ext.getCmp('intAudiogramaVA_OI6000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI6000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OI6000').setValue(0);  
        }
        Ext.getCmp('chartAudiograma').store.add(new st.recordType({
                IDReg: recId,
                frecuencia: 6000,
                OD: Ext.getCmp('intAudiogramaVA_OD6000').getValue(),
                OI: Ext.getCmp('intAudiogramaVA_OI6000').getValue()
            })
        );
        recId = 8;
        if(Ext.getCmp('intAudiogramaVA_OD8000').getValue() == null || Ext.getCmp('intAudiogramaVA_OD8000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OD8000').setValue(0);  
        }
        if(Ext.getCmp('intAudiogramaVA_OI8000').getValue() == null || Ext.getCmp('intAudiogramaVA_OI8000').getValue() == ""){
            Ext.getCmp('intAudiogramaVA_OI8000').setValue(0);  
        }
        Ext.getCmp('chartAudiograma').store.add(new st.recordType({
                IDReg: recId,
                frecuencia: 8000,
                OD: Ext.getCmp('intAudiogramaVA_OD8000').getValue(),
                OI: Ext.getCmp('intAudiogramaVA_OI8000').getValue()
            })
        );
        Ext.getCmp('chartAudiograma').refresh();
    //}
}