/*
* @category    Formulario Cierra Proceso
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winDesbloquearProcesoUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Desbloquear Proceso ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winDesbloquearProceso',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmDesbloquearProceso',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASDesbloquearProceso'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Proceso',
                        width: 150,
                        name: 'Proceso',
                        allowBlank: false,
                        store: 'StoreProcesosPartisalud',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione....',
                        submitValue: true,
                        id: 'strProcesos'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Desbloquear Proceso',
                            iconCls: 'btnDesbloquear',
                            id: 'btnDesbloquear_Proceso',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmDesbloquearProceso').getForm();
                                    if (frm.isValid())
                                    {
                                        frm.submit({
                                            url: '../../controlador/asistencial/saludocupacional.php',
                                            params: {
                                                task: 'PARTISALUD_DESBLOQUEAR_PROCESO',
                                                pCAS: Ext.getCmp('sysCASDesbloquearProceso').getValue(),
                                                pProceso: Ext.getCmp('strProcesos').getValue()
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.MessageBox.show({
                                                            title: 'Desbloquear Proceso',
                                                            msg: 'Se Cerro el Proceso con Exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        Ext.getCmp('winDesbloquearProceso').close();
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Desbloquear Proceso',
                                                            msg: 'Ocurrio un error al desbloquear el proceso o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos desbloquear el Proceso en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Proceso es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winDesbloquearProcesoUi.superclass.initComponent.call(this);
    }
});
