/*
* @category    Formulario Adicionar Acompañante 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winIngresoHogarPaso002Ui = Ext.extend(Ext.Window, {
    title: '.:: Registro de Ingreso del Acompañante ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winIngresoHogarPaso002Ui',
    initComponent: function() {
        
        var showFotoAcompanante = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/controlador/hogarpaso/showfotoacompanante.php?pTDoc=&pDocumento=',
                scripts:true,
                scope:this
            },
            id:'showFotoAcompanante',
            autoHeight: true,
            autoScroll:true
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddAcoIngresoHogar',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIngresoAcoHogarPaso',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                value: 0,
                                id: 'sysIdAcompanante'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioAcoIngresoHogarPaso',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Ingreso',
                                        width: 120,
                                        allowBlank: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecfechaIngresoAcoHogarPaso'
                                    },
                                    {
                                        html: 'Hora: '
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 90,
                                        allowBlank: false,
                                        forceSelection: false,
                                        minValue: '06:00 AM',
                                        maxValue: '09:00 PM',
                                        emptyText: 'p.e. 07:00',
                                        id: 'strHoraIngresoAcoHogarPaso'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Doc',
                                        anchor: '100%',
                                        name: 'cbTdoc',
                                        allowBlank: false,
                                        //store: 'StoreTdocPac',
                                        store: 'StoreTdocPac',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Tipo Documento....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'strTdocAcoHogarPaso'
                                    },
                                    {
                                        html: 'Documento:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: false,
                                        width: 150,
                                        id: 'strDocIDAcoHogarPaso',
                                        listeners: {
                                            blur: function(t){
                                                if(Ext.getCmp('strTdocAcoHogarPaso').getValue() !== "" && Ext.getCmp('strTdocAcoHogarPaso').getValue() !== null && Ext.getCmp('strDocIDAcoHogarPaso').getValue() !== "" && Ext.getCmp('strDocIDAcoHogarPaso').getValue() !== null){
                                                    var updater = Ext.getCmp('showFotoAcompanante').getUpdater();
                                                    updater.setDefaultUrl('../../../app/controlador/hogarpaso/showfotoacompanante.php?pTDoc=' + Ext.getCmp('strTdocAcoHogarPaso').getValue() + '&pDocumento=' + Ext.getCmp('strDocIDAcoHogarPaso').getValue());
                                                    updater.refresh();
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Genero:'
                                    },
                                    {
                                        xtype: 'combo',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: 'StoreGenero',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        emptyText: 'Seleccione Genero....',
                                        forceSelection: true,
                                        id: 'strGeneroAcoHogarPaso'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnCamera',
                                        tooltip: 'Registrar Fotografia',
                                        id: 'btnFotoAcoHogarPaso',
                                        listeners: {
                                            click: function(){
                                                if(Ext.getCmp('strTdocAcoHogarPaso').getValue() !== "" && Ext.getCmp('strTdocAcoHogarPaso').getValue() !== null && Ext.getCmp('strDocIDAcoHogarPaso').getValue() !== "" && Ext.getCmp('strDocIDAcoHogarPaso').getValue() !== null){
                                                    window.open ("../../../app/controlador/hogarpaso/fotoacompanante.php?pTdocAco=" + Ext.getCmp('strTdocAcoHogarPaso').getValue() + "&pDocAco=" + Ext.getCmp('strDocIDAcoHogarPaso').getValue(),"Registro Foto");
                                                }else{
                                                    Ext.MessageBox.show({
                                                        title: 'Error',
                                                        msg: 'Los datos de tipo de documento y documento son requeridos',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnActualizarGrid',
                                        tooltip: 'Ver Fotografia',
                                        listeners: {
                                            click: function(){
                                                if(Ext.getCmp('strTdocAcoHogarPaso').getValue() !== "" && Ext.getCmp('strTdocAcoHogarPaso').getValue() !== null && Ext.getCmp('strDocIDAcoHogarPaso').getValue() !== "" && Ext.getCmp('strDocIDAcoHogarPaso').getValue() !== null){
                                                    var updater = Ext.getCmp('showFotoAcompanante').getUpdater();
                                                    updater.setDefaultUrl('../../../app/controlador/hogarpaso/showfotoacompanante.php?pTDoc=' + Ext.getCmp('strTdocAcoHogarPaso').getValue() + '&pDocumento=' + Ext.getCmp('strDocIDAcoHogarPaso').getValue());
                                                    updater.refresh();
                                                }else{
                                                    Ext.MessageBox.show({
                                                        title: 'Error',
                                                        msg: 'Los datos de tipo de documento y documento son requeridos',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            }
                                        }
                                    }        
                                ]
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Nombre',
                                allowBlank: false,
                                anchor: '100%',
                                id: 'strNombreAcoHogarPaso'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Parentesco',
                                        allowBlank: false,
                                        width: 350,
                                        id: 'strParentescoAcoHogarPaso'
                                    },
                                    {
                                        html: 'Telefono:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: false,
                                        width: 300,
                                        id: 'strTelefonoAcoHogarPaso'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        html: '<b>Ingresa el Acompañante al Hogar?:</b>'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 100,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        typeAhead: true,
                                        typeAheadDelay: 450,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'strIngresoAcoHogarPaso',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if (cmb.getValue() === "SI"){
                                                    Ext.getCmp('strDesayunoAcoHogarPaso').setDisabled(false);
                                                    Ext.getCmp('strAlmuerzoAcoHogarPaso').setDisabled(false);
                                                    Ext.getCmp('strComidaAcoHogarPaso').setDisabled(false);
                                                    Ext.getCmp('intCamaAcoHogarPaso').setDisabled(true);
                                                    Ext.getCmp('intHabitacionAcoHogarPaso').store.load({
                                                        params: {
                                                            pGenero: ""
                                                        },
                                                        callback: function(){
                                                            Ext.getCmp('intHabitacionAcoHogarPaso').setDisabled(false);
                                                            Ext.getCmp('intHabitacionAcoHogarPaso').allowBlank = true;
                                                            Ext.getCmp('intCamaAcoHogarPaso').allowBlank = true;
                                                        }
                                                    });
                                                }else{
                                                    Ext.getCmp('strDesayunoAcoHogarPaso').setDisabled(true);
                                                    Ext.getCmp('strAlmuerzoAcoHogarPaso').setDisabled(true);
                                                    Ext.getCmp('strComidaAcoHogarPaso').setDisabled(true);
                                                    Ext.getCmp('intHabitacionAcoHogarPaso').setDisabled(true);
                                                    Ext.getCmp('intCamaAcoHogarPaso').setDisabled(true);
                                                    Ext.getCmp('intHabitacionAcoHogarPaso').setValue(null);
                                                    Ext.getCmp('intCamaAcoHogarPaso').setValue(null);
                                                    Ext.getCmp('intHabitacionAcoHogarPaso').allowBlank = true;
                                                    Ext.getCmp('intCamaAcoHogarPaso').allowBlank = true;
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                layoutConfig: {
                                    columns: 3
                                },
                                padding: 5,
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Alimentacion',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        width: 190,
                                        height: 150,
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Desayuno',
                                                width: 60,
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                value: 'NO',
                                                disabled: true,
                                                id: 'strDesayunoAcoHogarPaso'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Almuerzo',
                                                width: 60,
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                value: 'NO',
                                                disabled: true,
                                                id: 'strAlmuerzoAcoHogarPaso'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Comida',
                                                width: 60,
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                value: 'NO',
                                                disabled: true,
                                                id: 'strComidaAcoHogarPaso'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Hospedaje',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        width: 200,
                                        height: 150,
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Habitacion',
                                                width: 70,
                                                allowBlank: true,
                                                store: 'StoreHogarPasoHabitacionDisponible',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                disabled: true,
                                                id: 'intHabitacionAcoHogarPaso',
                                                listeners:{
                                                    select : function(cmb, rec, idx){
                                                        Ext.getCmp('intCamaAcoHogarPaso').setValue(null);
                                                        //alert("ojo: " + cmb.getValue());
                                                        Ext.getCmp('intCamaAcoHogarPaso').store.load({
                                                            params: {
                                                                pHabitacion: Ext.getCmp('intHabitacionAcoHogarPaso').getValue()
                                                            },
                                                            callback: function(){
                                                                Ext.getCmp('intCamaAcoHogarPaso').setDisabled(false);
                                                                Ext.getCmp('intCamaAcoHogarPaso').allowBlank = true;
                                                            }
                                                        });
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Cama',
                                                width: 70,
                                                allowBlank: true,
                                                store: 'StoreHogarPasoCamaDisponible',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                disabled: true,
                                                id: 'intCamaAcoHogarPaso'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Fotografia',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        width: 200,
                                        height: 150,
                                        items: [
                                            showFotoAcompanante
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddAco',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Guardar Acompañante',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn=="yes"){
                                                fnGuardarRegAcompananteHogarPaso("GUARDAR_INGRESO_ACOMPANANTE","SI","winIngresoHogarPaso002Ui","frmAddAcoIngresoHogar","../../controlador/asistencial/hogardepaso.php","gridFormularioAcompanantes");
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winIngresoHogarPaso002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegAcompananteHogarPaso(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                pAcompanante: Ext.getCmp('sysIdAcompanante').getValue(),
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        /*Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });*/
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
