/*
* @category    Formulario Adicionar Solicitud Examenes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winIngresoHogarPaso001Ui = Ext.extend(Ext.Window, {
    title: '.:: Registro de Ingreso ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winIngresoHogarPaso001Ui',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddIngresoHogar',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                value: 0,
                                id: 'sysIdEgresoIngresoHogarPaso'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteIngresoHogarPaso',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strGeneroIngresoHogarPaso',
                                value: "",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioIngresoHogarPaso',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Ingreso',
                                        width: 120,
                                        allowBlank: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecfechaIngresoHogarPaso'
                                    },
                                    {
                                        html: 'Hora: '
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 90,
                                        allowBlank: false,
                                        forceSelection: false,
                                        minValue: '06:00 AM',
                                        maxValue: '09:00 PM',
                                        emptyText: 'p.e. 07:00',
                                        id: 'strHoraIngresoHogarPaso'
                                    },
                                    {
                                        html: 'Diagnostico:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: false,
                                        maxLength: 15,
                                        id: 'strDxIngresoHogarPaso'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Entidad',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreHogarPasoEntidadRemite',
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'strEntidadRemiteHogarPaso'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Servicio',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreHogarPasoServicioRemite',
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'strServicioRemiteHogarPaso'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'EPS-ARS',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreHogarPasoEPSARSRemite',
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'strEPSARSRemiteHogarPaso'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        html: '<b>Ingresa el Paciente al Hogar?:</b>'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 100,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        typeAhead: true,
                                        typeAheadDelay: 450,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'strIngresoPacienteHogarPaso',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if (cmb.getValue() === "SI"){
                                                    Ext.getCmp('strDesayunoPacHogarPaso').setDisabled(false);
                                                    Ext.getCmp('strAlmuerzoPacHogarPaso').setDisabled(false);
                                                    Ext.getCmp('strComidaPacHogarPaso').setDisabled(false);
                                                    Ext.getCmp('intCamaPacHogarPaso').setDisabled(false);
                                                    Ext.getCmp('intHabitacionPacHogarPaso').store.load({
                                                        params: {
                                                            pGenero: Ext.getCmp('strGeneroIngresoHogarPaso').getValue()
                                                        },
                                                        callback: function(){
                                                            Ext.getCmp('intHabitacionPacHogarPaso').setDisabled(false);
                                                            Ext.getCmp('intHabitacionPacHogarPaso').allowBlank = true;
                                                        }
                                                    });
                                                }else{
                                                    Ext.getCmp('strDesayunoPacHogarPaso').setDisabled(true);
                                                    Ext.getCmp('strAlmuerzoPacHogarPaso').setDisabled(true);
                                                    Ext.getCmp('strComidaPacHogarPaso').setDisabled(true);
                                                    Ext.getCmp('intHabitacionPacHogarPaso').setDisabled(true);
                                                    Ext.getCmp('intCamaPacHogarPaso').setDisabled(true);
                                                    Ext.getCmp('intHabitacionPacHogarPaso').setValue(null);
                                                    Ext.getCmp('intCamaPacHogarPaso').setValue(null);
                                                    Ext.getCmp('intHabitacionPacHogarPaso').allowBlank = true;
                                                    Ext.getCmp('intCamaPacHogarPaso').allowBlank = true;
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                layoutConfig: {
                                    columns: 2
                                },
                                padding: 5,
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Alimentacion',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        width: 190,
                                        height: 120,
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Desayuno',
                                                width: 60,
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                value: 'NO',
                                                disabled: true,
                                                id: 'strDesayunoPacHogarPaso'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Almuerzo',
                                                width: 60,
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                value: 'NO',
                                                disabled: true,
                                                id: 'strAlmuerzoPacHogarPaso'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Comida',
                                                width: 60,
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                value: 'NO',
                                                disabled: true,
                                                id: 'strComidaPacHogarPaso'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Hospedaje',
                                        layout: 'form',
                                        collapsible: false,
                                        titleCollapse: false,
                                        width: 200,
                                        height: 120,
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Habitacion',
                                                width: 70,
                                                allowBlank: true,
                                                store: 'StoreHogarPasoHabitacionDisponible',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                disabled: true,
                                                id: 'intHabitacionPacHogarPaso',
                                                listeners:{
                                                    select : function(cmb, rec, idx){
                                                        Ext.getCmp('intCamaPacHogarPaso').setValue(null);
                                                        Ext.getCmp('intCamaPacHogarPaso').store.load({
                                                            params: {
                                                                pHabitacion: Ext.getCmp('intHabitacionPacHogarPaso').getValue()
                                                            },
                                                            callback: function(){
                                                                Ext.getCmp('intCamaPacHogarPaso').setValue(null);
                                                                Ext.getCmp('intCamaPacHogarPaso').setDisabled(false);
                                                                Ext.getCmp('intCamaPacHogarPaso').allowBlank = true;
                                                            }
                                                        });
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Cama',
                                                width: 70,
                                                allowBlank: true,
                                                store: 'StoreHogarPasoCamaDisponible',
                                                typeAhead: true,
                                                typeAheadDelay: 450,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                disabled: true,
                                                id: 'intCamaPacHogarPaso'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Guardar Ingreso',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn=="yes"){
                                                fnGuardarRegIngresoHogarPaso("GUARDAR_INGRESO","SI","winIngresoHogarPaso001Ui","frmAddIngresoHogar","../../controlador/asistencial/hogardepaso.php","gridFormulario");
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winIngresoHogarPaso001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegIngresoHogarPaso(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                pIdIngreso: Ext.getCmp('sysIdEgresoIngresoHogarPaso').getValue(),
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.load({
                                    params: {
                                        pPaciente: Ext.getCmp('intPacienteIngresoHogarPaso').getValue()
                                    }
                                });
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
