/*
* @category    Formulario Adicionar Item Actividad Realizada
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddDienteActividadProxCitaUi = Ext.extend(Ext.Window, {
    title: '.:: Actividad Proxima Cita ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddDienteActividadProxCitaUi',
    initComponent: function() {
        Ext.QuickTips.init();
        Ext.form.Field.prototype.msgTarget = 'title';
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddDienteActividadProxCita',
                padding: 10,
                labelWidth: 200,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intPacienteDienteProxCita',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASDienteProxCita',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysTipoAfiliadoDienteProxCita',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPorCopagoDienteProxCita',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Nro. Diente',
                                        width: 60,
                                        name: 'Nro. Diente',
                                        allowBlank: false,
                                        store: 'StoreDientesOdontograma',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Diente',
                                        displayField: 'Diente',
                                        emptyText: 'Seleccione....',
                                        id: 'intNroDienteDienteProxCita'
                                    },
                                    {
                                        html: 'Superficie: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 85,
                                        readOnly: true,
                                        allowBlank: false,
                                        value: 'N-N-N-N-N',
                                        plugins: [
                                            new Ext.ux.InputTextMask({
                                                mask:'X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X',
                                                clearInvalid: false
                                            })
                                        ],
                                        id: 'strSuperficiesDienteProxCita',
                                        listeners: {
                                            blur: function(t){
                                                CalcularCopagoOdoProxCita();
                                            }
                                        }
                                    },
                                    {
                                        html: 'Cantidad:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        minValue: 1,
                                        width: 50,
                                        value: 1,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        readOnly: true,
                                        id: 'intCantidadDienteProxCita'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Procedimiento / Actividad',
                                anchor: '99%',
                                name: 'Procedimiento / Actividad',
                                allowBlank: false,
                                store: 'StoreConceptosxServicioOdoxEntidad',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                tpl: '<tpl for="."><div class="cbProcedProxAct"><h3>{Descripcion}</h3><p style="font-size: 13; color:#00F; text-align:right;">Tarifa: {infoTarifa}</p><hr /></div></tpl>',
                                itemSelector: 'div.cbProcedProxAct',
                                id: 'intIdProcedDienteProxCita',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        if (cmb.getValue() === "" && cmb.getValue() === null){
                                            Ext.getCmp('intTarifaDienteProxCita').setValue(0);
                                        }else{
                                            Ext.getCmp('intTarifaDienteProxCita').setValue(rec.data.Tarifa);
                                        }
                                        CalcularCopagoOdoProxCita();
                                    }
                                }
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        fieldLabel: 'Vlr Unitario',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intTarifaDienteProxCita',
                                        readOnly: true
                                    },
                                    {
                                        html: 'Vlr Total:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'sysTotalDienteProxCita',
                                        readOnly: true
                                    },
                                    {
                                        html: 'Vlr a Pagar Paciente (COPAGO): '
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intCopagoDienteProxCita',
                                        readOnly: true
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddItemDienteProxCita',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemDienteProxCita("GUARDAR_DIENTE_PROXIMACITA","SI","winAddDienteActividadProxCitaUi","frmAddDienteActividadProxCita","../../controlador/asistencial/controlador_odontologia.php","gridDientesActividadesProximaCitaDetalle");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddDienteActividadProxCitaUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemDienteProxCita(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                //Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave !== 'undefined'){
                            if (pCampoLlave !== 'NA'){
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave !== 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        var SubtotalProxCita = 0;
                        var CopagosProxCita = 0;
                        Ext.getCmp('gridAtencionesProximaCitaxPaciente').store.load({
                            params: {
                                pPaciente: Ext.getCmp('intPacienteDienteProxCita').getValue()
                            }
                        });
                        Ext.getCmp('gridDientesActividadesProximaCitaDetalle').store.load({
                            params: {
                                pPaciente: Ext.getCmp('intPacienteDienteProxCita').getValue(),
                                pCAS: Ext.getCmp('intCASDienteProxCita').getValue()
                            },
                            callback: function(){
                                Ext.getCmp('gridDientesActividadesProximaCitaDetalle').store.each(function(record){
                                    SubtotalProxCita = SubtotalProxCita + (parseInt(record.get('Cantidad')) * parseInt(record.get('VlrActividad')));
                                    CopagosProxCita = CopagosProxCita + parseInt(record.get('VlrCopago'));
                                });
                                Ext.getCmp('sysSubTotProxCita').setValue(SubtotalProxCita);
                                Ext.getCmp('sysCOPProxCita').setValue(CopagosProxCita);
                            }
                        });            
                        if(pCerrar === "SI"){
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function CalcularCopagoOdoProxCita(){
    var Cantidad = 0;
    if(Ext.getCmp('strSuperficiesDienteProxCita').getValue() === "N-N-N-N-N"){
        Ext.getCmp('intCantidadDienteProxCita').setValue(1);
    }else{
        var Superficie = Ext.getCmp('strSuperficiesDienteProxCita').getValue().replace(/-N/g,"");
        var Contenido = Superficie.split('-');    
        Ext.getCmp('intCantidadDienteProxCita').setValue(Contenido.length);
    }
    if(Ext.getCmp('intCantidadDienteProxCita').getValue() !== null){
        Ext.getCmp('sysTotalDienteProxCita').setValue(Ext.getCmp('intTarifaDienteProxCita').getValue() * Ext.getCmp('intCantidadDienteProxCita').getValue());
        if(Ext.getCmp('sysTipoAfiliadoDienteProxCita').getValue() === "BENEFICIARIO"){
            var Copago = Ext.getCmp('sysTotalDienteProxCita').getValue() * Ext.getCmp('sysPorCopagoDienteProxCita').getValue();
            Ext.getCmp('intCopagoDienteProxCita').setValue(Copago);
        }
    }    
}