/*
* @category    Formulario Adicionar Necesidad de Atencion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddNecesidadAtencionUi = Ext.extend(Ext.Window, {
    title: '.:: Necesidad Atencion ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddNecesidadAtencionUi',
    initComponent: function() {
        Ext.QuickTips.init();
        Ext.form.Field.prototype.msgTarget = 'side';
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddNecesidadAtencion',
                padding: 10,
                labelWidth: 200,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysNuevoNesecidad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysIdConsecutivoNesecidad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorNesecidad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSNesecidad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalNesecidad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASNesecidad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteNesecidad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioNesecidad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                allowBlank: true,
                                readOnly: true,
                                id: 'strFechaSolNesecidad'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Servicio',
                                anchor: '100%',
                                name: 'Servicio',
                                allowBlank: false,
                                store: 'StorePrograma',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'IdPrograma',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'intServicioNesecidad'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Prioridad',
                                width: 50,
                                name: 'Prioridad',
                                id: 'intPrioridadNesecidad',
                                minValue: 0,
                                maxValue: 20,
                                allowBlank: false
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Necesidades Atencion',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memNesecidad'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddNecesidadAten',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Guardar',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn=="yes"){
                                                if(parseInt(Ext.getCmp('sysNuevoNesecidad').getValue()) === 0){
                                                    fnGuardarRegItemNecesidadAtencion("GUARDAR_NECESIDAD_ATENCION","SI","winAddNecesidadAtencionUi","frmAddNecesidadAtencion","../../controlador/asistencial/controlador_odontologia.php","gridNecesidadesAtencion");
                                                }else{
                                                    fnGuardarRegItemNecesidadAtencion("MODIFICAR_NECESIDAD_ATENCION","SI","winAddNecesidadAtencionUi","frmAddNecesidadAtencion","../../controlador/asistencial/controlador_odontologia.php","gridNecesidadesAtencion");
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddNecesidadAtencionUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemNecesidadAtencion(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                pIdConsecutivoNecesidad: Ext.getCmp('sysIdConsecutivoNesecidad').getValue(),
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
