/*
* @category    Actividades Realizadas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

                                    
ActividadesRealizdas201401Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        function DescripcionNotasEvolucion(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Ambito){
                case "1":
                    mostrarHC += 'Ambito: 1 - Ambulatorio';
                    break;
                case "2":
                    mostrarHC += 'Ambito: 2 - Hospitalario';
                    break;
                case "3":
                    mostrarHC += 'Ambito: 3 - Urgencias';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '<tr><td>';
            switch(store.data.Finalidad){
                case "1":
                    mostrarHC += 'Finalidad: 1 - Diagnostico';
                    break;
                case "2":
                    mostrarHC += 'Finalidad: 2 - Terapeutico';
                    break;
                case "3":
                    mostrarHC += 'Finalidad: 3 - Proteccion Especifica';
                    break;
                case "4":
                    mostrarHC += 'Finalidad: 4 - Deteccion Temprana de Enfermedad General';
                    break;
                case "5":
                    mostrarHC += 'Finalidad: 5 - Deteccion Temprana de Enfermedad Profesional';
                    break;
                default:
                    break;
            }
            mostrarHC += '</td></tr>';
            mostrarHC += '</table>';
            return mostrarHC;
        }
        var stGridDienteActividadesRealizadas = new StoreGridDienteActividadesRealizadas();
        stGridDienteActividadesRealizadas.load({
            params: {
                pPaciente: wPaciente
            }
        });
        this.items = [
            {
                xtype: 'hidden',
                id: 'IdOdontogramaUltimo'
            },
            {
                xtype: 'grid',
                layout: 'fit',
                id: 'gridDientesActividadesRealizadas',
                store: stGridDienteActividadesRealizadas,
                anchor: "100%",
                height: 470,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdConsecutivoDientesActividad',
                        id: 'IdConsecutivoDientesActividad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Fecha',
                        sortable: true,
                        width: 110,
                        dataIndex: 'FechaAtencion',
                        id: 'FechaAtencion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Profesional',
                        sortable: true,
                        width: 170,
                        dataIndex: 'Profesional',
                        id: 'Profesional'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Diente',
                        sortable: true,
                        width: 60,
                        dataIndex: 'Diente',
                        id: 'Diente'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Superficie',
                        sortable: true,
                        width: 60,
                        dataIndex: 'Superficie',
                        id: 'Superficie'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Procedimiento/Actividad',
                        sortable: true,
                        width: 170,
                        dataIndex: 'DesProced',
                        renderer: DescripcionGrid,
                        id: 'DesProced'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Notas Evolución',
                        sortable: false,
                        width: 360,
                        dataIndex: 'NotasEvolucion',
                        renderer: DescripcionNotasEvolucion,
                        id: 'NotasEvolucion'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView(),
                tbar:
                {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Adicionar Registro',
                            iconCls: 'btnAddRow',
                            id: 'btnAddActividadDiente',
                            listeners: {
                                click : function() {
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1){
                                        var winAddDienteActividadRealizada = new winAddDienteActividadRealizada201401Ui();
                                        Ext.getCmp('intPacienteDienteActividad201401').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                        Ext.getCmp('intCASDienteActividad201401').setValue(Ext.getCmp('sysCASHC').getValue());
                                        Ext.getCmp('sysTipoAfiliadoDienteActividad201401').setValue(Ext.getCmp('sysTipoAfiliadoHC').getValue());
                                        Ext.getCmp('sysPorCopagoDienteActividad201401').setValue(Ext.getCmp('sysPorCopagoAfiliadoHC').getValue());
                                        Ext.getCmp('intNroDienteDienteActividad201401').store.load({
                                            params: {
                                                pTipo: "MIXTA"
                                            }
                                        });
                                        //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                        if(parseInt(myCAS) === 0){
                                            myCAS = Ext.getCmp('sysCASHC').getValue();
                                        }
                                        Ext.getCmp('intIdProcedDienteActividad201401').store.load({
                                            params: {
                                                pServicio: "%ODONTOLO%",
                                                pCAS: myCAS
                                            }
                                        });
                                        winAddDienteActividadRealizada.show();
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Historia',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Eliminar Registro',
                            iconCls: 'btnDelRow',
                            id: 'btnDelActividadDiente',
                            listeners: {
                                click : function() {
                                    if(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount() == 1)
                                    {
                                        var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                        if(selections[0].json.CAS == Ext.getCmp('sysCASHC').getValue()){
                                            Ext.Msg.show({
                                                title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn=="yes"){
                                                        fnEliminarActividadesRealizadas("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Odontograma',
                            iconCls: 'btnDiente',
                            listeners:{
                                click : function(){
                                    window.open ("../../controlador/asistencial/imprimirodontograma.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pEvolucion=0" + "&pConsecutivoDetalle=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Odontograma");
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Convenciones',
                            iconCls: 'btnDiente',
                            listeners:{
                                click : function(){
                                    Ext.getCmp('winConvencionesOdontograma').show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                }
            }
        ];
        ActividadesRealizdas201401Ui.superclass.initComponent.call(this);
    }
});

function fnEliminarActividadesRealizadas(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}