/*
* @category    Formulario Adicionar Item Actividad Realizada
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddDienteActividadRealizada002Ui = Ext.extend(Ext.Window, {
    title: '.:: Actividad Realizada ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddDienteActividadRealizada002Ui',
    initComponent: function() {
        Ext.QuickTips.init();
        Ext.form.Field.prototype.msgTarget = 'title';
        
        //Store Locales
        var dataAmbitoActividadDiente = [
            ['1','1 - Ambulatorio'],
            ['2','2 - Hospitalario'],
            ['3','3 - Urgencias']
        ];
        var stAmbitoActividadDiente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAmbitoActividadDiente.loadData(dataAmbitoActividadDiente);
        
        var dataFinalidadActividadDiente = [
            ['1','1 - Diagnostico','Los  procedimientos  tienen  la  finalidad  diagnostica cuando  se  realizan  para  establecer  (confirmar  o descartar) un diagnostico presuntivo; o aun si no existiere un diagnóstico presuntivo, se realizan para establecer las condiciones  del  paciente  en  relacion  con  la sintomatologia,  la  causa  o  motivo  de  la  solicitud  de atencion y la anamnesis.'],
            ['2','2 - Terapeutico','Los  procedimientos  tienen  la  finalidad  terapeutica, cuando se realizan para tratar el problema de salud por el cual consulto el paciente, tanto en la consulta externa como en la urgencia o la hospitalizacion.'],
            ['3','3 - Proteccion Especifica','Los  procedimientos  tienen  una  finalidad  de  proteccion especifica cuando se realizan para "evitar" una condicion de  salud  especifica  (embarazo) o una  enfermedad (inmunoprevenible)  mediante  la  aplicacion  de  un dispositivo o una vacuna'],
            ['4','4 - Deteccion Temprana de Enfermedad General','Los  procedimientos  se  realizan  con  una  finalidad  de deteccion temprana, cuando se busca identificar valores de  los  indicadores  vitales  que  indiquen  un  riesgo  de desarrollar una enfermedad.'],
            ['5','5 - Deteccion Temprana de Enfermedad Profesional','Los  procedimientos  se  realizan  con  una  finalidad  de deteccion temprana, cuando se busca identificar valores de  los  indicadores  vitales  que  indiquen  un  riesgo  de desarrollar una enfermedad.']
        ];

        var stFinalidadActividadDiente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'Ayuda'}
            ]
        });
        stFinalidadActividadDiente.loadData(dataFinalidadActividadDiente);
        
        var stDxOdontograma = new StoreDiagnosticoOdontograma();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddDienteActividadRealizada002',
                padding: 10,
                labelWidth: 200,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intPacienteDienteActividad002',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASDienteActividad002',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysAfectaDienteActividad002',
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Afecta Diente',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        id: 'sysAfectaDienteAcividad002',
                                        listeners:{
                                            select : function(cmb, rec, idx){
                                                if(cmb.getValue() === "SI"){
                                                    Ext.getCmp('intNroDienteDienteActividad002').setReadOnly(false);
                                                    Ext.getCmp('intNroDienteDienteActividad002').allowBlank = false;
                                                    Ext.getCmp('strDiagnosticoDienteActividad002').setReadOnly(false);
                                                    Ext.getCmp('strDiagnosticoDienteActividad002').setReadOnly(false);
                                                    Ext.getCmp('strSuperficiesDienteActividad002').setReadOnly(false);
                                                    Ext.getCmp('strSuperficiesDienteActividad002').allowBlank = false;
                                                    
                                                }else{
                                                    Ext.getCmp('intNroDienteDienteActividad002').allowBlank = true;
                                                    Ext.getCmp('intNroDienteDienteActividad002').setReadOnly(true);
                                                    Ext.getCmp('intNroDienteDienteActividad002').clearValue();
                                                    Ext.getCmp('intNroDienteDienteActividad002').clearInvalid();
                                                    Ext.getCmp('strDiagnosticoDienteActividad002').setReadOnly(true);
                                                    Ext.getCmp('strDiagnosticoDienteActividad002').allowBlank = true;
                                                    Ext.getCmp('strDiagnosticoDienteActividad002').clearValue();
                                                    Ext.getCmp('strDiagnosticoDienteActividad002').clearInvalid();
                                                    Ext.getCmp('strSuperficiesDienteActividad002').setReadOnly(true);
                                                    Ext.getCmp('strSuperficiesDienteActividad002').allowBlank = true;
                                                    Ext.getCmp('strSuperficiesDienteActividad002').setValue("N-N-N-N-N");
                                                    Ext.getCmp('strSuperficiesDienteActividad002').clearInvalid();
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Diente: '
                                    },
                                    {
                                        xtype: 'combo',
                                        //fieldLabel: 'Nro. Diente',
                                        width: 60,
                                        name: 'Nro. Diente',
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreDientesOdontograma',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Diente',
                                        displayField: 'Diente',
                                        emptyText: 'Seleccione....',
                                        id: 'intNroDienteDienteActividad002'
                                    },
                                    {
                                        html: 'Act. Odontograma: '
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 290,
                                        name: 'Diagnostico',
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreDiagnosticoOdontograma',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        id: 'strDiagnosticoDienteActividad002',
                                        listeners:{
                                            blur: function(f) {
                                                if(f.getValue() !== "" && f.getValue() !== null){
                                                    var dx = f.getValue();
                                                    stDxOdontograma.filterBy(function(record,id){  
                                                        return record.get('Codigo') === dx;
                                                    });  
                                                    stDxOdontograma.each(function(record){  
                                                        Ext.getCmp('sysAfectaDienteActividad002').setValue(record.get('Afecta'));
                                                    });  
                                                    stDxOdontograma.clearFilter();
                                                    if(Ext.getCmp('sysAfectaDienteActividad002').getValue() === "Diente"){
                                                        Ext.getCmp('strSuperficiesDienteActividad002').setValue("N-N-N-N-N");
                                                        Ext.getCmp('strSuperficiesDienteActividad002').readOnly = true;
                                                    }else{
                                                        Ext.getCmp('strSuperficiesDienteActividad002').readOnly = false;
                                                    }
                                                }else{
                                                    Ext.getCmp('sysAfectaDienteActividad002').setValue(null);
                                                    Ext.getCmp('strSuperficiesDienteActividad002').setValue("N-N-N-N-N");
                                                    Ext.getCmp('strSuperficiesDienteActividad002').readOnly = true;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Superficie: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 85,
                                        readOnly: true,
                                        allowBlank: false,
                                        value: 'N-N-N-N-N',
                                        plugins: [
                                            new Ext.ux.InputTextMask({
                                                mask:'X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X',
                                                clearInvalid: false
                                            })
                                        ],
                                        id: 'strSuperficiesDienteActividad002'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Procedimiento / Actividad',
                                anchor: '99%',
                                name: 'Procedimiento / Actividad',
                                allowBlank: false,
                                store: 'StoreConceptosxServicioOdoxEntidad',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'intIdProcedDienteActividad002'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Ambito',
                                anchor: '99%',
                                name: 'Ambito',
                                allowBlank: false,
                                store: stAmbitoActividadDiente,
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'strAmbitoDienteActividad002'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Finalidad',
                                anchor: '99%',
                                name: 'Finalidad',
                                allowBlank: false,
                                store: stFinalidadActividadDiente,
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                tpl: '<tpl for="."><div class="cbFinalidad"><h3>{Descripcion}</h3><p style="font-size: 10;">{Ayuda}<hr /></div></tpl>',
                                itemSelector: 'div.cbFinalidad',
                                id: 'strFinalidadDienteActividad002'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Notas Evolucion',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memNotasDienteActividad002'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddItemDienteActividad002',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemDienteActividad002("GUARDAR_DIENTE_ACTIVIDAD002","SI","winAddDienteActividadRealizada002Ui","frmAddDienteActividadRealizada002","../../controlador/asistencial/controlador_odontologia.php","gridDientesActividadesRealizadas");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddDienteActividadRealizada002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemDienteActividad002(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    if(Ext.getCmp('sysAfectaDienteAcividad002').getValue() === "SI"){
        Ext.getCmp('intNroDienteDienteActividad002').setReadOnly(false);
        Ext.getCmp('intNroDienteDienteActividad002').allowBlank = false;
        Ext.getCmp('strDiagnosticoDienteActividad002').setReadOnly(false);
        Ext.getCmp('strDiagnosticoDienteActividad002').setReadOnly(false);
        Ext.getCmp('strSuperficiesDienteActividad002').setReadOnly(false);
        Ext.getCmp('strSuperficiesDienteActividad002').allowBlank = false;

    }else{
        Ext.getCmp('intNroDienteDienteActividad002').allowBlank = true;
        Ext.getCmp('intNroDienteDienteActividad002').setReadOnly(true);
        Ext.getCmp('intNroDienteDienteActividad002').clearValue();
        Ext.getCmp('intNroDienteDienteActividad002').clearInvalid();
        Ext.getCmp('strDiagnosticoDienteActividad002').setReadOnly(true);
        Ext.getCmp('strDiagnosticoDienteActividad002').allowBlank = true;
        Ext.getCmp('strDiagnosticoDienteActividad002').clearValue();
        Ext.getCmp('strDiagnosticoDienteActividad002').clearInvalid();
        Ext.getCmp('strSuperficiesDienteActividad002').setReadOnly(true);
        Ext.getCmp('strSuperficiesDienteActividad002').allowBlank = true;
        Ext.getCmp('strSuperficiesDienteActividad002').setValue("N-N-N-N-N");
        Ext.getCmp('strSuperficiesDienteActividad002').clearInvalid();
    }
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos,
                Superficies: Ext.getCmp('strSuperficiesDienteActividad002').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}