/*
* @category    Formulario Adicionar Actividades Realizadas x Diente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddDienteActividadRealizadaUi = Ext.extend(Ext.Window, {
    title: '.:: Actividad Realizada ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddDienteActividadRealizadaUi',
    initComponent: function() {
        Ext.QuickTips.init();
        Ext.form.Field.prototype.msgTarget = 'side';
                
        Ext.apply(Ext.form.VTypes,{
            validacionSuperficies : function(value, field) {
            return /[OMDLPVomdlpv]/.test(value);
           },
           validacionSuperficiesText : 'La superficie no es valida',
           validacionSuperficiesMask : '/[O\-\M\-\D\-\L\-\P\-\V]/'
        });
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddDienteActividadRealizada',
                padding: 10,
                labelWidth: 200,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intPacienteDienteActividad',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASDienteActividad',
                                value: 0,
                                allowBlank: true
                            },
                            /*{
                                xtype: 'hidden',
                                id: 'intProfesionalDienteActividad',
                                value: 0,
                                allowBlank: true
                            },*/
                            {
                                xtype: 'compositefield',
                                anchor: '95%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 50,
                                        minValue: 11,
                                        maxValue: 85,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        fieldLabel: 'Nro. Diente',
                                        name: 'Nro. Diente',
                                        id: 'intNroDienteDienteActividad'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysSuperficie',
                                        value: 'Superficie: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 120,
                                        name: 'strSuperficies',
                                        allowBlank: false,
                                        value: 'N-N-N-N-N',
                                        plugins: [
                                            new Ext.ux.InputTextMask({
                                                mask:'X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X-X[OMDLPVNomdlpvn]X',
                                                clearInvalid: false
                                            })
                                        ],
                                        id: 'sysSuperficieDienteActividad'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Procedimiento / Actividad',
                                anchor: '95%',
                                name: 'Procedimiento / Actividad',
                                allowBlank: false,
                                store: 'StoreConceptosxServicioOdo',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                submitValue: true,
                                id: 'intIdProcedDienteActividad'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Notas Evolucion',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memNotasDienteActividad'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddActDienteOdontograma',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Guardar Historial',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                fnGuardarRegItemDienteActividad("GUARDAR_DIENTE_ACTIVIDAD","SI","winAddDienteActividadRealizadaUi","frmAddDienteActividadRealizada","../../controlador/asistencial/controlador_odontologia.php","gridDientesActividadesRealizadas");
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddDienteActividadRealizadaUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemDienteActividad(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    if(Ext.getCmp('sysSuperficieDienteActividad').getValue() != 'N-N-N-N-N'){
        Ext.getCmp('intNroDienteDienteActividad').allowBlank = false;
    }else{
        Ext.getCmp('intNroDienteDienteActividad').allowBlank = true;
    }
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
