/*
* @category    Fieldset Necesidades de Atencion - Tratamiento
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsNecesidadesAtencionTratamientoUi = Ext.extend(Ext.form.FieldSet, {
    //anchor: '100%',
    width: 938,
    autoHeight: true,
    layout: 'form',
    /*collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,*/
    padding: 0,
    id: 'fsNecesidadesAtencionTratamiento',
    initComponent: function() {
        
        var stNecesidadesAtencionTratamiento = new StoreGridNecesidadesAtencionTratamiento();
        
        this.items = [
            {
                xtype: 'hidden',
                id: 'IdConsecutivoNecesidad',
                value: 1
            },
            {
                xtype: 'hidden',
                id: 'IdOdontogramaUltimo'
            },
            {
                xtype: 'grid',
                layout: 'fit',
                id: 'gridNecesidadesAtencionTratamiento',
                store: stNecesidadesAtencionTratamiento,
                anchor: '100%',
                height: 400,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdConsecutivoDientesActividad',
                        id: 'IdConsecutivoDientesActividad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Diente',
                        sortable: true,
                        width: 60,
                        dataIndex: 'Diente'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Superficie',
                        sortable: true,
                        width: 60,
                        dataIndex: 'Superficie'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Procedimiento/Actividad',
                        sortable: true,
                        width: 450,
                        dataIndex: 'DesProced'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'VlrActividad',
                        sortable: true,
                        width: 110,
                        dataIndex: 'VlrActividad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'VlrCopago',
                        sortable: true,
                        width: 110,
                        dataIndex: 'VlrCopago'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'VlrNeto',
                        sortable: true,
                        width: 110,
                        dataIndex: 'VlrNeto'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                viewConfig: {
                    getRowClass: function(record, index) {
                        //S = Solicitado, A = Aprobado, P = Programado, Q = Pagado, R = Realizado, X = Inactivo
                        switch (record.get('Estado')){
                            case "S":
                                return 'EstadoTtoS';
                                break;
                            case "A":
                                return 'EstadoTtoA';
                                break;
                            case "P":
                                return 'EstadoTtoP';
                                break;
                            case "Q":
                                return 'NeceAtenQ';
                                break;
                            case "R":
                                return 'NeceAtenR';
                                break;
                            case "X":
                                return;
                                break;
                            default:
                                return;
                                break;
                        }
                    }
                },
                //view: new Ext.grid.GroupingView(),
                bbar:
                {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Programar',
                            iconCls: 'btnAddRow',
                            id: 'btnProgramarActividadDienteTto',
                            listeners: {
                                click : function() {
                                    
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Realizar',
                            iconCls: 'btnAddRow',
                            id: 'btnRealizarActividadDienteTto',
                            listeners: {
                                click : function() {
                                    
                                }
                            }
                        }
                    ]
                },
                tbar:
                {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Adicionar',
                            iconCls: 'btnAddRow',
                            id: 'btnAddActividadDienteTto',
                            listeners: {
                                click : function() {
                                    //if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                        var winAddTratamiento001 = new winAddTratamiento001Ui();
                                        Ext.getCmp('intPacienteDienteActividadNecesidad').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                        Ext.getCmp('intCASDienteActividadNecesidad').setValue(Ext.getCmp('sysCASHC').getValue());
                                        Ext.getCmp('sysTipoAfiliadoDienteNecesidad').setValue("C");
                                        Ext.getCmp('sysPorCopagoDienteNecesidad').setValue(0);
                                        Ext.getCmp('intNroDienteDienteActividadNecesidad').store.load({
                                            params: {
                                                pTipo: "MIXTA"
                                            }
                                        });
                                        //Ext.getCmp('intProfesionalDienteActividad').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                        Ext.getCmp('intIdProcedDienteNecesidad').store.load({
                                            params: {
                                                pServicio: "%ODONTOLO%",
                                                pCAS: myCAS
                                            }
                                        });
                                        Ext.getCmp('strAmbitoDienteActividadNecesidad').setVisible(false);
                                        Ext.getCmp('strFinalidadDienteActividadNecesidad').setVisible(false);
                                        Ext.getCmp('memNotasDienteActividadNecesidad').setVisible(false);
                                        winAddTratamiento001.show();
                                    /*}else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Historia',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }*/
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Eliminar',
                            iconCls: 'btnDelRow',
                            id: 'btnDelActividadDienteTTo',
                            listeners: {
                                click : function() {
                                    /*if(parseInt(Ext.getCmp('gridDientesActividadesRealizadas').selModel.getCount()) === 1){
                                        var selections = Ext.getCmp('gridDientesActividadesRealizadas').selModel.getSelections();
                                        if(selections[0].json.CAS === Ext.getCmp('sysCASHC').getValue()){
                                            Ext.Msg.show({
                                                title: 'Actividades Realizadas en el Diente: ' + selections[0].json.Diente,
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DesProced + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn)
                                                {
                                                    if(btn === "yes")
                                                    {
                                                        fnEliminarRegistrosOdo("../../controlador/asistencial/controlador_odontologia.php",{task: "ELIMINAR_DIENTE_ACTIVIDAD", pIdRegistroActividadDiente: selections[0].json.IdConsecutivoDientesActividad}, 'gridDientesActividadesRealizadas');
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Este Registro No Fue Creado por Usted y No Se Puede Eliminar',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }*/
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Autorizar',
                            iconCls: 'btnAceptar',
                            id: 'btnDelActividadDienteTto',
                            listeners: {
                                click : function() {
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Odontograma',
                            iconCls: 'btnDiente',
                            listeners:{
                                click : function(){
                                    var RecordOdontogramaIni = Ext.getCmp('gridOdontogramasxPaciente').store.getAt(0); 
                                    Ext.getCmp('IdOdontogramaUltimo').setValue(RecordOdontogramaIni.get('IdConsecutivoOdontograma'));
                                    Ext.getCmp('IdOdontogramaViewOdontogramas').setValue(RecordOdontogramaIni.get('IdConsecutivoOdontograma'));
                                    Ext.getCmp('winViewOdontogramas').show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Convenciones',
                            iconCls: 'btnDiente',
                            listeners:{
                                click : function(){
                                    Ext.getCmp('winConvencionesOdontograma').show();
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                }
            }
        ];
        fsNecesidadesAtencionTratamientoUi.superclass.initComponent.call(this);
    }
});
