/*
* @category    Formulario Vista Odontogramas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winViewOdontogramasUi = Ext.extend(Ext.Window, {
    title: '.:: Odontogramas por Paciente ::.',
    width: 1010,
    height: 580,
    modal: false,
    closable: true,
    id: 'winViewOdontogramas',
    layout: 'form',
    border: true,
    closeAction: 'hide',
    initComponent: function() {
        Ext.QuickTips.init();
        var YaCargoInicial = 0;
        
        var viewOdontogramaInical = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma002.php?pPaciente=0&pCAS=' + wCAS + '&pOdontograma=0',
                scripts:true,
                scope:this
            },
            id:'viewOdontogramaInical',
            height: 550,
            autoScroll:true,
            closable:false
        });
        var viewOdontogramaControl = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/frm/odontograma/odontograma002control.php?pPaciente=' + myPaciente + '&pCAS=' + wCAS + '&pOdontograma=0',
                scripts:true,
                scope:this
            },
            id:'viewOdontogramaControl',
            height: 550,
            autoScroll:true,
            closable:false
        });
        this.bbar = [
            '->',
            {
                text: 'Actualizar',
                iconCls: 'btnActualizarGrid',
                listeners: {
                    click : function() {
                        var updaterInicial = Ext.getCmp('viewOdontogramaInical').getUpdater();
                        updaterInicial.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=0&pCAS=' + wCAS + '&pOdontograma=' + Ext.getCmp('IdOdontogramaViewOdontogramas').getValue());
                        updaterInicial.refresh();

                        var updaterControl = Ext.getCmp('viewOdontogramaControl').getUpdater(); 
                        updaterControl.setDefaultUrl('../../../app/frm/odontograma/odontograma002control.php?pPaciente=' + myPaciente + '&pCAS=' + wCAS + '&pOdontograma=0');
                        updaterControl.refresh();
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                autoHeight: true,
                border: false,
                autoScroll: true,
                labelWidth: 1,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        id: 'IdOdontogramaViewOdontogramas'
                    },
                    {
                        xtype: 'panel',
                        title: 'Odontograma Inicial',
                        anchor: '100%',
                        autoHeight: true,
                        border: true,
                        frame: true,
                        collapsible: true, 
                        collapsed: true, 
                        titleCollapse: true, 
                        id: 'Odontogramas_Inicial',
                        items:[
                            viewOdontogramaInical
                        ],
                        listeners: {
                            expand: function(p){
                                if(YaCargoInicial === 0){
                                    var updaterInicial = Ext.getCmp('viewOdontogramaInical').getUpdater();
                                    updaterInicial.setDefaultUrl('../../../app/frm/odontograma/odontograma002.php?pPaciente=0&pCAS=' + wCAS + '&pOdontograma=' + Ext.getCmp('IdOdontogramaViewOdontogramas').getValue());
                                    updaterInicial.refresh();
                                    YaCargoInicial = 1;
                                }
                            }
                        }
                    },
                    {
                        xtype: 'panel',
                        title: 'Odontograma Control',
                        anchor: '100%',
                        autoHeight: true,
                        border: true,
                        frame: true,
                        collapsible: true, 
                        titleCollapse: true, 
                        id: 'Odontogramas_Control',
                        items:[
                            viewOdontogramaControl
                        ]
                    }
                    
                ]
            }
        ];
        winViewOdontogramasUi.superclass.initComponent.call(this);
    }
});