/*
* @category    Formulario Dx Diente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winOdontogramaDienteUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Diente ::.',
    width: 900,
    height: 250,
    modal: true,
    closable: false,
    autoScroll: true,
    x: ((screen.width - 1004)/2) + 50,
    y: 10,
    id: 'winOdontogramaDiente',
    layout: 'form',
    labelWidth: 210,
    initComponent: function() {
        Ext.QuickTips.init();
        this.tbar = [
            {
                xtype: 'button',
                text: 'Guardar',
                iconCls: 'btnGuardar',
                id: 'btnGuardarDienteOdontograma',
                listeners:{
                    click : function(){
                        fnGuardarDienteOdontograma();
                    }
                }
            }
        ];
        this.bbar = [
            '->',
            {
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners: {
                    click : function() {
                        Ext.Msg.show({
                            title: 'eOfiClinic',
                            msg: 'Esta seguro que desea cerrar la ventana?',
                            buttons: Ext.Msg.YESNO,
                            icon: Ext.Msg.QUESTION,
                            fn: function(btn)
                            {
                                if(btn=="yes")
                                {
                                    Ext.getCmp('winOdontogramaDiente').close();
                                }
                            }
                        });
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'CAS',
                id: 'intCASOdontograma'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'CAS',
                id: 'intPacienteOdontograma'
            },
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'CAS',
                id: 'intIdOdontograma'
            },
            {
                xtype: 'hidden',
                width: 100,
                allowBlank: true,
                readOnly: true,
                fieldLabel: 'Diente',
                id: 'intDienteOdontograma'
            },
            {
                xtype: 'combo',
                width: 80,
                fieldLabel: 'El Diagnostico Afecta Todo el Diente',
                labelStyle: 'color:red;',
                name: 'El Diagnostico Afecta Todo el Diente',
                allowBlank: false,
                store: 'StoreSiNo',
                valueField: 'Descripcion',
                displayField: 'Descripcion',
                mode: 'local',
                forceSelection: true,
                typeAhead: true,
                typeAheadDelay: 10,
                triggerAction: 'all',
                id: 'strDxAfectaTodoDienteOdontograma',
                listeners:{
                    select : function(cmb, rec, idx){
                        var frm = Ext.getCmp('frmOdontogramaDiente').getForm();
                        frm.reset();
                        frm.clearInvalid();
                        if(cmb.getValue() == "SI"){
                            Ext.getCmp('winOdontogramaDiente').setHeight(250);
                            Ext.getCmp('strDxGeneralDienteOdontograma').setVisible(true);
                            Ext.getCmp('pnDxDienteOdontrograma').setVisible(false);
                            Ext.getCmp('pnDxSuperficieOdontrograma').setVisible(false);
                            Ext.getCmp('strDxGeneralDienteOdontograma').setValue("DX_DIENTE_SANO");

                        }else{
                            Ext.getCmp('winOdontogramaDiente').setHeight(640);
                            Ext.getCmp('strDxGeneralDienteOdontograma').setVisible(false);
                            Ext.getCmp('pnDxDienteOdontrograma').setVisible(true);
                            Ext.getCmp('pnDxSuperficieOdontrograma').setVisible(true);
                        }
                    }
                }
            },
            {
                xtype: 'form',
                frame: true,
                anchor: '98%',
                id: 'frmOdontogramaDiente',
                border: false,
                aautoScroll: true,
                labelWidth: 210,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        fieldLabel: 'Diagnostico General del Diente',
                        name: 'Diagnostico General del Diente',
                        allowBlank: true,
                        store: 'StoreDxDienteOdontograma',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strDxGeneralDienteOdontograma'
                    },
                    {
                        xtype: 'panel',
                        id: 'pnDxDienteOdontrograma',
                        title: 'DIAGNOSTICOS DEL DIENTE',
                        anchor: '99%',
                        collapsible: true,
                        autoHeight: true,
                        layout: 'table',
                        layoutConfig: {
                            columns: 2
                        },
                        labelWidth: 250,
                        items:[
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: '390',
                                height: 165,
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Núcleo',
                                        name: 'DX_DIENTE_NUCLEO',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_NUCLEO'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Implante',
                                        name: 'DX_DIENTE_IMPLANTE',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_IMPLANTE'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Endodoncia Buena',
                                        name: 'DX_DIENTE_ENDOBUENA',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_ENDOBUENA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Endodoncia Indicada o por Repetir',
                                        name: 'DX_DIENTE_ENDOINDICADA',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_ENDOINDICADA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Sellante en Boca',
                                        name: 'DX_DIENTE_SELLANTEBOCA',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_SELLANTEBOCA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Sellante Indicado',
                                        name: 'DX_DIENTE_SELLANTEINDICADO',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_SELLANTEINDICADO'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width: '390',
                                height: 165,
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Diente Provisional',
                                        name: 'DX_DIENTE_PROVICIONAL',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_PROVICIONAL'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Obturacion Metalica Colada o de Acero',
                                        name: 'DX_DIENTE_OBTURAMETALICA',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_OBTURAMETALICA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Obturacion Colada en Porcelana',
                                        name: 'DX_DIENTE_OBTURAPORCELANA',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_OBTURAPORCELANA'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Diente con Abrasión o Abfracción',
                                        name: 'DX_DIENTE_ABRASION',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_ABRASION'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        allowBlank: true,
                                        fieldLabel: 'Rotaciones y Migraciones',
                                        name: 'DX_DIENTE_ROTACIONES',
                                        labelStyle: 'color: #000000;',
                                        id: 'bolDX_DIENTE_ROTACIONES'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        id: 'pnDxSuperficieOdontrograma',
                        title: 'DX SUPERFICIES',
                        anchor: '99%',
                        collapsible: true,
                        autoHeight: true,
                        layout: 'form',
                        labelWidth: 250,
                        labelSeparator: '',
                        items:[
                            {
                                xtype: 'compositefield',
                                fieldLabel: ' ',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: 'M',
                                                width: 70,
                                                height: 30,
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        anchor: '100%',
                                                        id: 'syspn1'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'O',
                                                width: 70,
                                                height: 30,
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        anchor: '100%',
                                                        id: 'syspn2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'D',
                                                width: 70,
                                                height: 30,
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        anchor: '100%',
                                                        id: 'syspn3'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'V',
                                                width: 70,
                                                height: 30,
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        anchor: '100%',
                                                        id: 'syspn4'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'L/P',
                                                width: 70,
                                                height: 30,
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        anchor: '100%',
                                                        id: 'syspn5'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Caries',
                                style: 'background:transparent;',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 3,
                                                        maxValue: 6,
                                                        allowBlank: true,
                                                        name: 'Caries Mesial',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;',
                                                        //id: 'bolCaries_M'
                                                        id: 'intCaries_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 3,
                                                        maxValue: 6,
                                                        allowBlank: true,
                                                        name: 'Caries Oclusal',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;',
                                                        //id: 'bolCaries_O'
                                                        id: 'intCaries_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 3,
                                                        maxValue: 6,
                                                        allowBlank: true,
                                                        name: 'Caries Distal',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;',
                                                        //id: 'bolCaries_D'
                                                        id: 'intCaries_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 3,
                                                        maxValue: 6,
                                                        allowBlank: true,
                                                        name: 'Caries Vestibular',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolCaries_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 3,
                                                        maxValue: 6,
                                                        allowBlank: true,
                                                        style: 'text-align:center;',
                                                        name: 'Caries Lingual Palatina',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolCaries_LP'
                                                    }
                                                ]
                                            }

                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Caries Incipiente',
                                style: 'background:transparent;',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 1,
                                                        maxValue: 2,
                                                        id: 'intCariesIncipiente_M',
                                                        allowBlank: true,
                                                        name: 'Caries Incipiente Mesial',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;'
                                                        //id: 'bolCariesIncipiente_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        allowBlank: true,
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 1,
                                                        maxValue: 2,
                                                        id: 'intCariesIncipiente_O',
                                                        name: 'Caries Incipiente Oclusal',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;'
                                                        //id: 'bolCariesIncipiente_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 1,
                                                        maxValue: 2,
                                                        id: 'intCariesIncipiente_D',
                                                        allowBlank: true,
                                                        name: 'Caries Incipiente Distal',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;'
                                                        //id: 'bolCariesIncipiente_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 1,
                                                        maxValue: 2,
                                                        id: 'intCariesIncipiente_V',
                                                        allowBlank: true,
                                                        name: 'Caries Incipiente Vestibular',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;'
                                                        //id: 'bolCariesIncipiente_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 1,
                                                items: [
                                                    {
                                                        //xtype: 'checkbox',
                                                        xtype: 'numberfield',
                                                        width: 60,
                                                        minValue: 1,
                                                        maxValue: 2,
                                                        id: 'intCariesIncipiente_LP',
                                                        allowBlank: true,
                                                        name: 'Caries Incipiente Lingual Palatina',
                                                        style: 'text-align:center;',
                                                        labelStyle: 'color: #000000;'
                                                        //id: 'bolCariesIncipiente_LP'
                                                    }
                                                ]
                                            }

                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Cavidad Vacía Sin Caries',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Cavidad vacía sin caries Incipiente Mesial',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolCavidadVacia_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Cavidad vacía sin caries Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolCavidadVacia_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Cavidad vacía sin caries Distal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolCavidadVacia_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Cavidad vacía sin caries Vestibular',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolCavidadVacia_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Cavidad vacía sin caries Lingual Palatina',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolCavidadVacia_LP'
                                                    }
                                                ]
                                            }

                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Ionómero o Resina',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Mesial',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResina_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResina_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Distal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResina_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Vestibular',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResina_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Lingual Palatina',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResina_LP'
                                                    }
                                                ]
                                            }

                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Ionómero o Resina con Defecto',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina con Defecto Mesial',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaDefecto_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina con Defecto Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaDefecto_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina con Defecto Distal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaDefecto_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina con Defecto Vestibular',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaDefecto_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina con Defecto Lingual Palatina',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaDefecto_LP'
                                                    }
                                                ]
                                            }

                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Ionómero o Resina Caries Secundaria',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Caries Secundaria Mesial',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaCariesSec_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Caries Secundaria Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaCariesSec_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Caries Secundaria Distal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaCariesSec_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Caries Secundaria Vestibular',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaCariesSec_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Ionómero o Resina Caries Secundaria Lingual Palatina',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolIonomeroResinaCariesSec_LP'
                                                    }
                                                ]
                                            }

                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Amalgama',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Mesial',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgama_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgama_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Distal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgama_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Vestibular',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgama_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Lingual Palatina',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgama_LP'
                                                    }
                                                ]
                                            }

                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Amalgama con Defecto',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama con Defecto Mesial',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaDefecto_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama con Defecto Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaDefecto_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama con Defecto Distal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaDefecto_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama con Defecto Vestibular',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaDefecto_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama con Defecto Lingual Palatina',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaDefecto_LP'
                                                    }
                                                ]
                                            }

                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Amalgama Caries Secundaria',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Caries Secundaria Mesial',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaCariesSec_M'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Caries Secundaria Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaCariesSec_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Caries Secundaria Distal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaCariesSec_D'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Caries Secundaria Vestibular',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaCariesSec_V'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Amalgama Caries Secundaria Lingual Palatina',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolAmalgamaCariesSec_LP'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Sellante Caries Secundaria',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: []
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Sellante Caries Secundaria Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolSellanteCariesSec_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: []
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: []
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: []
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                fieldLabel: 'Sellante Defectuoso',
                                anchor: '100%',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        height: 30,
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: []
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: [
                                                    {
                                                        xtype: 'checkbox',
                                                        allowBlank: true,
                                                        name: 'Sellante Defectuoso Oclusal',
                                                        labelStyle: 'color: #000000;',
                                                        id: 'bolSellanteDefecto_O'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: []
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: []
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 70,
                                                height: 30,
                                                labelWidth: 30,
                                                items: []
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        id: 'pnObservaDienteOdontrograma',
                        title: 'OBSERVACIONES',
                        anchor: '99%',
                        collapsible: true,
                        autoHeight: true,
                        layout: 'table',
                        items: [
                            {
                                xtype: 'textarea',
                                width: 845,
                                allowBlank: true,
                                name: 'Observaciones Diente',
                                id: 'memObservaDienteOdontograma'
                            }
                        ]
                    }
                ]
            }
        ];
        winOdontogramaDienteUi.superclass.initComponent.call(this);
    }
});


function fnGuardarDienteOdontograma(){
    if(Ext.getCmp('strDxAfectaTodoDienteOdontograma').getValue() != "" && Ext.getCmp('strDxAfectaTodoDienteOdontograma').getValue() != null){
        var frm = Ext.getCmp('frmOdontogramaDiente').getForm();
        if (frm.isValid()){
            var listacampos = ExtraerCamposFrmHC(frm);
            frm.submit({
                url: '../../controlador/odontograma/controlador_odontograma.php',
                params:{
                    task: 'update_diente',
                    CAMPOS: listacampos,
                    pDiente: Ext.getCmp('intDienteOdontograma').getValue(),
                    pDxAfectaTodoDiente: Ext.getCmp('strDxAfectaTodoDienteOdontograma').getValue(),
                    pCAS: Ext.getCmp('intCASOdontograma').getValue(),
                    pPaciente: Ext.getCmp('intPacienteOdontograma').getValue()
                },
                success: function(res,req)
                {
                    switch(req.result.requestedId){
                        case "1":
                            var updater = Ext.getCmp('OdontogramaInical').getUpdater();
                            updater.refresh();
                            Ext.getCmp('winOdontogramaDiente').close();
                            break;

                        default:
                            Ext.MessageBox.show({
                                title: 'Guardar',
                                msg: 'Ocurrio un error al guardar, la estructura no es valida o el registro no se encuentra.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                            break;
                    }
                },
                failure: function(response,options)
                {
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Guardar',
                msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
