/*
* @category    Formulario Modelo Evolucion Historia Clinica Medicina General 001
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCMedicinaGeneral001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Medicina General ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'MOTIVO DE CONSULTA',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'MOTIVO DE CONSULTA',
                                                name: 'MOTIVO DE CONSULTA',
                                                height: 100,            
                                                allowBlank: false,
                                                id: 'memMotivoConsulta'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'ENFERMEDAD ACTUAL',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'ENFERMEDAD ACTUAL',
                                                name: 'ENFERMEDAD ACTUAL',
                                                height: 100,            
                                                allowBlank: false,
                                                id: 'memEnfermedadActual'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'ASPECTO GENERAL',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'ASPECTO GENERAL',
                                                name: 'ASPECTO GENERAL',
                                                height: 100,            
                                                allowBlank: false,
                                                id: 'memAspectoGeneral'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'REVISION POR SISTEMAS',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'REVISION POR SISTEMAS',
                                                name: 'REVISION POR SISTEMAS',
                                                height: 100,            
                                                allowBlank: false,
                                                id: 'memRevisionxSistemas'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        style: 'background:transparent;',
                                        fieldLabel: 'Signos Registrados?',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                readOnly: true,
                                                width: 20,
                                                style: 'background:transparent;',
                                                id: 'sysTomaSignos',
                                                border: false,
                                                allowBlank: true
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'systxt1',
                                                value: '  -  '
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnSignos',
                                                tooltip: 'Registrar Toma de Signos',
                                                text: 'Registro Toma de Signos',
                                                id: 'btnRegistroSignos',
                                                listeners:{
                                                    click : function(){
                                                        alert("Tomar Signos");
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        html:'</br>',border: false
                                    },
                                    
                                    {
                                        xtype: 'checkbox',
                                        name: 'HACE EJERCICIO',
                                        fieldLabel: 'HACE EJERCICIO',
                                        labelStyle: 'color: Brown;',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolPOS'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'RIESGO VASCULAR',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'RIESGO VASCULAR',
                                                name: 'RIESGO VASCULAR',
                                                allowBlank: false,
                                                id: 'strRiesgoVascular'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'ANTECEDENTES FAMILIARES',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'ANTECEDENTES FAMILIARES',
                                                name: 'ANTECEDENTES FAMILIARES',
                                                height: 100,            
                                                allowBlank: false,
                                                id: 'memAntecedentesFamiliares'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'ANTECEDENTES PERSONALES',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'ANTECEDENTES PERSONALES',
                                                name: 'ANTECEDENTES PERSONALES',
                                                height: 100,            
                                                allowBlank: false,
                                                id: 'memAntecedentesPersonales'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'EXAMEN FISICO',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        id: 'fsExamenFisico',layoutConfig: {
                                            columns: 2
                                        },
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'EXAMEN FISICO',
                                                id: 'strEXAMENFISICO',
                                                name: 'bTBEXAMEN FISICO'
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'NEUROLOGICO',
                                                        name: 'NEUROLOGICO',
                                                        allowBlank: false,
                                                        id: 'memNeurologico',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memNeurologico').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'CABEZA',
                                                        name: 'CABEZA',
                                                        allowBlank: false,
                                                        id: 'memCabeza',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memCabeza').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'ORL',
                                                        name: 'ORL',
                                                        allowBlank: false,
                                                        id: 'memORL',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memORL').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'CUELLO',
                                                        name: 'CUELLO',
                                                        allowBlank: false,
                                                        id: 'memCuello',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memCuello').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'CARDIO PULMONAR',
                                                        name: 'CARDIO PULMONAR',
                                                        allowBlank: false,
                                                        id: 'memCardioPulmonar',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memCardioPulmonar').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'TORAX',
                                                        name: 'TORAX',
                                                        allowBlank: false,
                                                        id: 'memTorax',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memTorax').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'ABDOMEN',
                                                        name: 'ABDOMEN',
                                                        allowBlank: false,
                                                        id: 'memAbdomen',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memAbdomen').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'HABITO INTESTINAL',
                                                        name: 'HABITO INTESTINAL',
                                                        allowBlank: false,
                                                        id: 'memHabitoIntestinal',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memHabitoIntestinal').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'GENITO-URINARIO',
                                                        name: 'GENITO-URINARIO',
                                                        allowBlank: false,
                                                        id: 'memGenitoUrinario',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memGenitoUrinario').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'EXTREMIDADES',
                                                        name: 'EXTREMIDADES',
                                                        allowBlank: false,
                                                        id: 'memExtremidades',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memExtremidades').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 450,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'PIEL',
                                                        name: 'PIEL',
                                                        allowBlank: false,
                                                        id: 'memPiel',
                                                        listeners: { 
                                                            render: function( p ) {
                                                             p.getEl().on('dblclick', function (){
                                                                 Ext.getCmp('memPiel').setValue("NORMAL");
                                                             });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                anchor: '100%',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'EXAMEN FISICO',
                                                id: 'strEXAMENFISICO1',
                                                name: 'eTBEXAMEN FISICO'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'CONDUCTA',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                anchor: '100%',
                                                width: 880,
                                                fieldLabel: 'CONDUCTA',
                                                name: 'CONDUCTA',
                                                height: 100,            
                                                allowBlank: false,
                                                id: 'memConducta'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'INCAPACIDAD',
                                        layout: 'form',
                                        collapsible: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                fieldLabel: 'Dias',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        width: 50,
                                                        name: 'INCAPACIDAD DIAS',
                                                        minValue: 0,
                                                        allowBlank: true,
                                                        style: 'text-align:center;',
                                                        id: 'intDiasIncapacidad',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                //new Date(año,mes,dia) 01/05/2010
                                                                if(Ext.getCmp('fecDesdeIncapacidad').getValue() == null || Ext.getCmp('fecDesdeIncapacidad').getValue() == ""){
                                                                    Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                }
                                                                var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                var xMes = xFecha.substr(3,2);
                                                                var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                if(pNew > 0)
                                                                    DiasIncapacidad = pNew - 1;
                                                                else
                                                                    DiasIncapacidad = pNew;
                                                                NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysIncDsd',
                                                        value: 'Desde:'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 120,
                                                        name: 'INCAPACIDAD DESDE',
                                                        allowBlank: true,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecDesdeIncapacidad',
                                                        listeners:{
                                                            change : function(f,pNew, pOld){
                                                                Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                var xFecha = pNew.format('d/m/Y')
                                                                var xMes = xFecha.substr(3,2);
                                                                var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                    DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                }else{
                                                                    DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                }
                                                                NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysIncHst',
                                                        value: 'Hasta:'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 120,
                                                        name: 'INCAPACIDAD HASTA',
                                                        allowBlank: true,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        id: 'fecHastaIncapacidad'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                fieldLabel: 'Observaciones',
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 615,
                                                        name: 'INCAPACIDAD OBSERVACIONES',
                                                        height: 50,
                                                        allowBlank: true,
                                                        id: 'memIncapacidadObserva'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnImprimir',
                                                        text: 'Imprimir Incapacidad',
                                                        tooltip: 'Imprimir Incapacidad',
                                                        id: 'btnPrintIncapacidadHC',
                                                        listeners:{
                                                            click : function(){
                                                                if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                    window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                else{
                                                                    Ext.Msg.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'Usted No ha Guardado la Evolución',
                                                                        buttons: Ext.Msg.OK,
                                                                        icon: Ext.Msg.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'RIPS',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        id: 'fsRips',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: false,
                                                        fieldLabel: 'Diagnostico Principal',
                                                        id: 'sysDiagPpalHC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request({
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagPpalHCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Principal',
                                                        id: 'btnSearchDiagPpalHC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                        id: 'sysDiagRel1HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel1HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado1',
                                                        id: 'btnSearchDiagRel1HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                        id: 'sysDiagRel2HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel2HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado2',
                                                        id: 'btnSearchDiagRel2HC1',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                        id: 'sysDiagRel3HC',
                                                        listeners:{
                                                            specialkey: function(f,e){
                                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                {
                                                                    if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                        Ext.Ajax.request(
                                                                        {
                                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                                            params:{
                                                                                task: 'BUSCAR',
                                                                                pCodigo: f.getValue().toUpperCase()
                                                                            },
                                                                            success: function(response,options)
                                                                            {
                                                                                var el = Ext.get('response'); // get the LOG
                                                                                var Respuesta = response.responseText;
                                                                                var Contenido = Respuesta.split('^');
                                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                    Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                } else {
                                                                                    Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                }
                                                                            },
                                                                            failure: function(response,options){
                                                                                var el = Ext.get('response');
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            },
                                                                            scope:this //bind the callbacks
                                                                        });
                                                                    }else{
                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 625,
                                                        height: 22,
                                                        id: 'sysDiagRel3HCNom'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado3',
                                                        id: 'btnSearchDiagRel3HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo de Diagnostico',
                                                width:750,
                                                name: 'Tipo de Diagnostico',
                                                allowBlank: false,
                                                store: 'StoreTipoDiagnostico',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'sysTipoDiagosticoHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Finalidad Consulta',
                                                width:750,
                                                name: 'Finalidad Consulta',
                                                allowBlank: false,
                                                store: 'StoreFinalidadConsulta',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 10,
                                                id: 'sysFinalidadConsultaHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Causa Externa',
                                                width:750,
                                                name: 'Causa Externa',
                                                allowBlank: false,
                                                store: 'StoreCausaExterna',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                value: 13,
                                                id: 'sysCausaExternaHC'
                                            }                            
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Resumen Toma de Signos',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaSignos',
                                layout: 'form',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Incapacidad',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIncapacidad',
                                items: [
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea guardar la evolución, si hace esto ya no podra realizar ningun cambio?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'La evolución ya se guardo y no podra ser modificada nuevamente',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCMedicinaGeneral001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
