/*
* @category    Formulario Modelo Evolucion CRI Rehabilitacion Cardiaca Primera Vez
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCRehabilitaCRI001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Rehabilitacion Cardiaca Primera Vez ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        var dataCRIIntensidad = [
            ['LEVE'],
            ['MODERADA'],
            ['VIGIROSA']
        ];
        var stCRIIntensidad = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIIntensidad.loadData(dataCRIIntensidad);
        
        var dataCRIDuracion = [
            ['< 15 MIN'],
            ['15 - 30 MIN'],
            ['30 - 45 MIN'],
            ['45 - 60 MIN'],
            ['> 60 MIN']
        ];
        var stCRIDuracion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIDuracion.loadData(dataCRIDuracion);
        
        var dataCRIAHAACSM = [
            ['A1'],
            ['A2'],
            ['A3'],
            ['B'],
            ['C'],
            ['D']
        ];
        var stCRIAHAACSM = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIAHAACSM.loadData(dataCRIAHAACSM);
        
        var dataCRIRiesgoEventos = [
            ['BAJO'],
            ['MODERADO'],
            ['ALTO']
        ];
        var stCRIRiesgoEventos = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIRiesgoEventos.loadData(dataCRIRiesgoEventos);
        
        var dataCRIEntrenamiento = [
            ['60%'],
            ['65%'],
            ['70%'],
            ['80%']
        ];
        var stCRIEntrenamiento = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stCRIEntrenamiento.loadData(dataCRIEntrenamiento);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                anchor: '100%',
                                                fieldLabel: 'Medico Remitente',
                                                name: 'Medico Remitente',
                                                allowBlank: true,
                                                id: 'strMedicoRemitente'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                fieldLabel: 'Iterconsulta',
                                                name: 'Iterconsulta',
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "NO",
                                                id: 'strInterconsulta'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 550,
                                                        fieldLabel: 'En Caso de Emergencia Avisar',
                                                        name: 'En Caso de Emergencia Avisar',
                                                        allowBlank: true,
                                                        id: 'strEnCasoEmergenciaAvisar'
                                                    },
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCRI001',
                                                        value: 'Telefono: '
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        width: 150,
                                                        name: 'Telefono',
                                                        allowBlank: true,
                                                        id: 'strEnCasoEmergenciaAvisarTel'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'numberfield',
                                                minValue: 1,
                                                fieldLabel: 'Nro Sesiones',
                                                name: 'No Sesiones Programadas',
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                id: 'intNroSesionesProgramadas'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE INGRESO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        name: 'Motivo Consulta',
                                                        width: 600,
                                                        allowBlank: true,
                                                        disabled: true,
                                                        id: 'strMotivoConsulta'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Diagnostico Cardiologico',
                                                        name: 'Diagnostico Cardiologico',
                                                        allowBlank: true,
                                                        id: 'strDiagnoCardiologico'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 120,
                                                                fieldLabel: 'Incapacidad',
                                                                name: 'Incapacidad',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strIncapacidadIngreso'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCRI002',
                                                                value: 'Fecha: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Fecha',
                                                                width: 450,
                                                                allowBlank: true,
                                                                id: 'strIncapacidadIngresoFec'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 120,
                                                                fieldLabel: 'Tto Psicologico Previo',
                                                                name: 'Tto Psicologico Previo',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strTtoPsicologicoPrevio'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCRI002',
                                                                value: 'Fecha: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Fecha',
                                                                width: 450,
                                                                allowBlank: true,
                                                                id: 'strTtoPsicologicoPrevioFec'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 120,
                                                                fieldLabel: 'Rehab. Cardiaca Previa',
                                                                name: 'Rehab. Cardiaca Previa',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strRehabilitaCardicaPrevio'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysCRI002',
                                                                value: 'Fecha: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Fecha',
                                                                width: 450,
                                                                allowBlank: true,
                                                                id: 'strRehabilitaCardicaPrevioFec'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES CARDIOVASCULARES',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                labelWidth: 150,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Sincope Vasopresor',
                                                                name: 'Sincope Vasopresor',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_SincopeVasopresor',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_SincopeVasopresorH').allowBlank = true;
                                                                            Ext.getCmp('strAC_SincopeVasopresorH').setValue(null);
                                                                            Ext.getCmp('strAC_SincopeVasopresorH').disable();
                                                                            Ext.getCmp('strAC_SincopeVasopresorH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_SincopeVasopresorH').enable();
                                                                            Ext.getCmp('strAC_SincopeVasopresorH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_SincopeVasopresorH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Sincope Cardioinhibitorio',
                                                                name: 'Sincope Cardioinhibitorio',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_SincopeCardioinhibitorio',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_SincopeCardioinhibitorioH').allowBlank = true;
                                                                            Ext.getCmp('strAC_SincopeCardioinhibitorioH').setValue(null);
                                                                            Ext.getCmp('strAC_SincopeCardioinhibitorioH').disable();
                                                                            Ext.getCmp('strAC_SincopeCardioinhibitorioH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_SincopeCardioinhibitorioH').enable();
                                                                            Ext.getCmp('strAC_SincopeCardioinhibitorioH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_SincopeCardioinhibitorioH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Sincope Mixto',
                                                                name: 'Sincope Mixto',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_SincopeMixto',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_SincopeMixtoH').allowBlank = true;
                                                                            Ext.getCmp('strAC_SincopeMixtoH').setValue(null);
                                                                            Ext.getCmp('strAC_SincopeMixtoH').disable();
                                                                            Ext.getCmp('strAC_SincopeMixtoH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_SincopeMixtoH').enable();
                                                                            Ext.getCmp('strAC_SincopeMixtoH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_SincopeMixtoH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'IAM',
                                                                name: 'IAM',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_IAM',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_IAMH').allowBlank = true;
                                                                            Ext.getCmp('strAC_IAMH').setValue(null);
                                                                            Ext.getCmp('strAC_IAMH').disable();
                                                                            Ext.getCmp('strAC_IAMH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_IAMH').enable();
                                                                            Ext.getCmp('strAC_IAMH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_IAMH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Angioplastia',
                                                                name: 'Angioplastia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Angioplastia',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_AngioplastiaH').allowBlank = true;
                                                                            Ext.getCmp('strAC_AngioplastiaH').setValue(null);
                                                                            Ext.getCmp('strAC_AngioplastiaH').disable();
                                                                            Ext.getCmp('strAC_AngioplastiaH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_AngioplastiaH').enable();
                                                                            Ext.getCmp('strAC_AngioplastiaH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_AngioplastiaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Stent',
                                                                name: 'Stent',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Stent',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_StentH').allowBlank = true;
                                                                            Ext.getCmp('strAC_StentH').setValue(null);
                                                                            Ext.getCmp('strAC_StentH').disable();
                                                                            Ext.getCmp('strAC_StentH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_StentH').enable();
                                                                            Ext.getCmp('strAC_StentH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_StentH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Arritmia',
                                                                name: 'Arritmia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Arritmia',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_ArritmiaH').allowBlank = true;
                                                                            Ext.getCmp('strAC_ArritmiaH').setValue(null);
                                                                            Ext.getCmp('strAC_ArritmiaH').disable();
                                                                            Ext.getCmp('strAC_ArritmiaH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_ArritmiaH').enable();
                                                                            Ext.getCmp('strAC_ArritmiaH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_ArritmiaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'R.V.M',
                                                                name: 'R.V.M',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_RVM',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_RVMH').allowBlank = true;
                                                                            Ext.getCmp('strAC_RVMH').setValue(null);
                                                                            Ext.getCmp('strAC_RVMH').disable();
                                                                            Ext.getCmp('strAC_RVMH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_RVMH').enable();
                                                                            Ext.getCmp('strAC_RVMH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_RVMH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'I.C.C',
                                                                name: 'I.C.C',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_ICC',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_ICCH').allowBlank = true;
                                                                            Ext.getCmp('strAC_ICCH').setValue(null);
                                                                            Ext.getCmp('strAC_ICCH').disable();
                                                                            Ext.getCmp('strAC_ICCH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_ICCH').enable();
                                                                            Ext.getCmp('strAC_ICCH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_ICCH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Marcapaso',
                                                                name: 'Marcapaso',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Marcapaso',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_MarcapasoH').allowBlank = true;
                                                                            Ext.getCmp('strAC_MarcapasoH').setValue(null);
                                                                            Ext.getCmp('strAC_MarcapasoH').disable();
                                                                            Ext.getCmp('strAC_MarcapasoH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_MarcapasoH').enable();
                                                                            Ext.getCmp('strAC_MarcapasoH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_MarcapasoH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Cardiodesfibrilador',
                                                                name: 'Cardiodesfibrilador',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Cardiodesfibrilador',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_CardiodesfibriladorH').allowBlank = true;
                                                                            Ext.getCmp('strAC_CardiodesfibriladorH').setValue(null);
                                                                            Ext.getCmp('strAC_CardiodesfibriladorH').disable();
                                                                            Ext.getCmp('strAC_CardiodesfibriladorH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_CardiodesfibriladorH').enable();
                                                                            Ext.getCmp('strAC_CardiodesfibriladorH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_CardiodesfibriladorH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Muerte Subita',
                                                                name: 'Muerte Subita',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_MuerteSubita',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_MuerteSubitaH').allowBlank = true;
                                                                            Ext.getCmp('strAC_MuerteSubitaH').setValue(null);
                                                                            Ext.getCmp('strAC_MuerteSubitaH').disable();
                                                                            Ext.getCmp('strAC_MuerteSubitaH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_MuerteSubitaH').enable();
                                                                            Ext.getCmp('strAC_MuerteSubitaH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_MuerteSubitaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Arresto Cardiaco',
                                                                name: 'Arresto Cardiaco',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_ArrestoCardiaco',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_ArrestoCardiacoH').allowBlank = true;
                                                                            Ext.getCmp('strAC_ArrestoCardiacoH').setValue(null);
                                                                            Ext.getCmp('strAC_ArrestoCardiacoH').disable();
                                                                            Ext.getCmp('strAC_ArrestoCardiacoH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_ArrestoCardiacoH').enable();
                                                                            Ext.getCmp('strAC_ArrestoCardiacoH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_ArrestoCardiacoH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Diseccion',
                                                                name: 'Diseccion',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Diseccion',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_DiseccionH').allowBlank = true;
                                                                            Ext.getCmp('strAC_DiseccionH').setValue(null);
                                                                            Ext.getCmp('strAC_DiseccionH').disable();
                                                                            Ext.getCmp('strAC_DiseccionH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_DiseccionH').enable();
                                                                            Ext.getCmp('strAC_DiseccionH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_DiseccionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Aneurisma',
                                                                name: 'Aneurisma',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Aneurisma',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_AneurismaH').allowBlank = true;
                                                                            Ext.getCmp('strAC_AneurismaH').setValue(null);
                                                                            Ext.getCmp('strAC_AneurismaH').disable();
                                                                            Ext.getCmp('strAC_AneurismaH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_AneurismaH').enable();
                                                                            Ext.getCmp('strAC_AneurismaH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_AneurismaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Coartacion',
                                                                name: 'Coartacion',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Coartacion',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_CoartacionH').allowBlank = true;
                                                                            Ext.getCmp('strAC_CoartacionH').setValue(null);
                                                                            Ext.getCmp('strAC_CoartacionH').disable();
                                                                            Ext.getCmp('strAC_CoartacionH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_CoartacionH').enable();
                                                                            Ext.getCmp('strAC_CoartacionH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_CoartacionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'E.A.P',
                                                                name: 'E.A.P',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_EAP',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_EAPH').allowBlank = true;
                                                                            Ext.getCmp('strAC_EAPH').setValue(null);
                                                                            Ext.getCmp('strAC_EAPH').disable();
                                                                            Ext.getCmp('strAC_EAPH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_EAPH').enable();
                                                                            Ext.getCmp('strAC_EAPH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_EAPH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'R.V Periferica',
                                                                name: 'R.V Periferica',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_RVPeriferica',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_RVPerifericaH').allowBlank = true;
                                                                            Ext.getCmp('strAC_RVPerifericaH').setValue(null);
                                                                            Ext.getCmp('strAC_RVPerifericaH').disable();
                                                                            Ext.getCmp('strAC_RVPerifericaH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_RVPerifericaH').enable();
                                                                            Ext.getCmp('strAC_RVPerifericaH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_RVPerifericaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'A.C.V',
                                                                name: 'A.C.V',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_ACV',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_ACVH').allowBlank = true;
                                                                            Ext.getCmp('strAC_ACVH').setValue(null);
                                                                            Ext.getCmp('strAC_ACVH').disable();
                                                                            Ext.getCmp('strAC_ACVH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_ACVH').enable();
                                                                            Ext.getCmp('strAC_ACVH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_ACVH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Cambio Valvular',
                                                                name: 'Cambio Valvular',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_CambioValvular',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_CambioValvularH').allowBlank = true;
                                                                            Ext.getCmp('strAC_CambioValvularH').setValue(null);
                                                                            Ext.getCmp('strAC_CambioValvularH').disable();
                                                                            Ext.getCmp('strAC_CambioValvularH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_CambioValvularH').enable();
                                                                            Ext.getCmp('strAC_CambioValvularH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_CambioValvularH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Cardiomiopatia',
                                                                name: 'Cardiomiopatia',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strAC_Cardiomiopatia',
                                                                listeners:{
                                                                    select : function(cmb, rec, idx){
                                                                        if(cmb.getValue() == "NO"){
                                                                            Ext.getCmp('strAC_CardiomiopatiaH').allowBlank = true;
                                                                            Ext.getCmp('strAC_CardiomiopatiaH').setValue(null);
                                                                            Ext.getCmp('strAC_CardiomiopatiaH').disable();
                                                                            Ext.getCmp('strAC_CardiomiopatiaH').clearInvalid();
                                                                        }else{
                                                                            Ext.getCmp('strAC_CardiomiopatiaH').enable();
                                                                            Ext.getCmp('strAC_CardiomiopatiaH').allowBlank = false;
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Observaciones',
                                                                width: 600,
                                                                allowBlank: true,
                                                                disabled: true,
                                                                emptyText: 'HALLAZGOS',
                                                                id: 'strAC_CardiomiopatiaH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Otros Antecedentes Clinicos',
                                                        name: 'Otros Antecedentes Clinicos',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strAC_OtrosAntecedentes'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FACTORES DE RIESGO',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                labelWidth: 150,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 885,
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {           
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                autoHeight: true,
                                                                width: 440,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Dislipidemia',
                                                                        name: 'Dislipidemia',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_Dislipidemia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'HTA',
                                                                        name: 'HTA',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_HTA'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'DM Tipo 1',
                                                                        name: 'DM Tipo 1',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_DMT1'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'DM Tipo 2',
                                                                        name: 'DM Tipo 2',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_DMT2'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                autoHeight: true,
                                                                width: 440,
                                                                items:[
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Hipotiroidismo',
                                                                        name: 'Hipotiroidismo',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_Hipotiroidismo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Post-Menopausia',
                                                                        name: 'Post-Menopausia',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_PostMenopausia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Sobrepeso',
                                                                        name: 'Sobrepeso',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_Sobrepeso'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 70,
                                                                        fieldLabel: 'Obesidad',
                                                                        name: 'Obesidad',
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strFR_Obesidad'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Fuma Actualente',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strFR_FuamaActualmente'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_o',
                                                                value: 'Nro Cigarrillos Dia:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                id: 'strFR_NroCigarrillosActual'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_p',
                                                                value: 'Tiempo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                emptyText: "Años",
                                                                id: 'strFR_FumaActualmenteTiempo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Fumó Anteriormente',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strFR_FuamoAnteriormente'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_q',
                                                                value: 'Nro Cigarrillos Dia:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                id: 'strFR_NroCigarrillosAnterior'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_r',
                                                                value: 'Tiempo:'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                allowBlank: true,
                                                                width: 140,
                                                                emptyText: "Años",
                                                                id: 'strFR_FumaAnteriormenteTiempo'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 70,
                                                                fieldLabel: 'Consumo de Alcohol',
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NO",
                                                                id: 'strFR_ConsumoAlcohol'
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sys2_s',
                                                                value: 'Freciencia:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                width: 130,
                                                                allowBlank: false,
                                                                store: 'StoreFrecuenciaConsumo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                value: "NUNCA",
                                                                id: 'strFR_ConsumoAlcoholFrecuencia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Tipo Alcohol',
                                                        name: 'Tipo Alcohol',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strFR_ConsumoAlcoholTipo'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Consumo Drogas Alucinogenas',
                                                        name: 'Consumo Drogas Alucinogenas',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strFR_ConsumoDrogasAlucinogenas'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ANTECEDENTES FAMILIARES (Fallecimiento)',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        titleCollapse: false,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        labelWidth: 100,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 885,
                                                                layout: {
                                                                    columns: 2,
                                                                    type: 'table'
                                                                },
                                                                items: [
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 400,
                                                                        items:[
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Padre',
                                                                                name: 'Padre',
                                                                                anchor: '98%',
                                                                                allowBlank: true,
                                                                                id: 'strFR_AF_FallecePadre'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Madre',
                                                                                name: 'Madre',
                                                                                anchor: '98%',
                                                                                allowBlank: true,
                                                                                id: 'strFR_AF_FalleceMadre'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 400,
                                                                        items:[
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Hermano',
                                                                                name: 'Hermano',
                                                                                anchor: '98%',
                                                                                allowBlank: true,
                                                                                id: 'strFR_AF_FalleceHermano'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Hermana',
                                                                                name: 'Hermana',
                                                                                anchor: '98%',
                                                                                allowBlank: true,
                                                                                id: 'strFR_AF_FalleceHermana'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'ACTIVIDAD FISICA',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        titleCollapse: false,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        labelWidth: 100,
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {   
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Caminata',
                                                                        name: 'Caminata',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'strFR_ActF_Caminata'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica1',
                                                                        value: 'Intensidad: '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        store: stCRIIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFR_ActF_CaminataIntensidad'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica2',
                                                                        value: 'Duracion: '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        store: stCRIDuracion,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFR_ActF_CaminataDuracion'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica3',
                                                                        value: 'Pulso: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Pulso',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_CaminataPulso'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica4',
                                                                        value: 'Frecuencia Sem: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Frecuencia',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_CaminataFrecuencia'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {   
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Trote',
                                                                        name: 'Trote',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'strFR_ActF_Trote'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica5',
                                                                        value: 'Intensidad: '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        store: stCRIIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFR_ActF_TroteIntensidad'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica6',
                                                                        value: 'Duracion: '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        store: stCRIDuracion,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFR_ActF_TroteDuracion'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica7',
                                                                        value: 'Pulso: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Pulso',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_TrotePulso'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica8',
                                                                        value: 'Frecuencia Sem: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Frecuencia',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_TroteFrecuencia'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {   
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Bicicleta',
                                                                        name: 'Bicicleta',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'strFR_ActF_Bicicleta'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica9',
                                                                        value: 'Intensidad: '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        store: stCRIIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFR_ActF_BicicletaIntensidad'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica10',
                                                                        value: 'Duracion: '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        store: stCRIDuracion,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFR_ActF_BicicletaDuracion'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica11',
                                                                        value: 'Pulso: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Pulso',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_BicicletaPulso'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica12',
                                                                        value: 'Frecuencia Sem: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Frecuencia',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_BicicletaFrecuencia'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {   
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Natacion',
                                                                        name: 'Natacion',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'strFR_ActF_Natacion'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica13',
                                                                        value: 'Intensidad: '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        store: stCRIIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFR_ActF_NatacionIntensidad'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica14',
                                                                        value: 'Duracion: '
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        width: 120,
                                                                        allowBlank: true,
                                                                        store: stCRIDuracion,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFR_ActF_NatacionDuracion'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica15',
                                                                        value: 'Pulso: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Pulso',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_NatacionPulso'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica16',
                                                                        value: 'Frecuencia Sem: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Frecuencia',
                                                                        width: 80,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_NatacionFrecuencia'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                anchor: '100%',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Otro',
                                                                        name: 'Otro',
                                                                        width: 310,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_Otro'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysAFisica17',
                                                                        value: 'Fraccionada: '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'Fraccionada',
                                                                        width: 310,
                                                                        allowBlank: true,
                                                                        id: 'strFR_ActF_Fraccionada'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 805,
                                                                layout: {
                                                                    columns: 3,
                                                                    type: 'table'
                                                                },
                                                                items: [
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 267,
                                                                        items:[
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: 'Sedentarismo',
                                                                                name: 'Sedentarismo',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "SI",
                                                                                id: 'strFR_ActF_Sedentarismo'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: 'Poco Activo',
                                                                                name: 'Poco Activo',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strFR_ActF_PocoActivo'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 267,
                                                                        items:[
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: 'Activo',
                                                                                name: 'Activo',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strFR_ActF_Activo'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: 'Muy Activo',
                                                                                name: 'Muy Activo',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strFR_ActF_MuyActivo'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 266,
                                                                        items:[
                                                                            {
                                                                                xtype: 'combo',
                                                                                width: 70,
                                                                                fieldLabel: 'Entrenamiento',
                                                                                name: 'Entrenamiento',
                                                                                allowBlank: false,
                                                                                store: 'StoreSiNo',
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                value: "NO",
                                                                                id: 'strFR_ActF_Entrenamiento'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'LABORATORIOS',
                                                        layout: 'form',
                                                        collapsible: false,
                                                        titleCollapse: false,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        labelWidth: 100,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                labelWidth: 100,
                                                                width: 805,
                                                                layout: {
                                                                    columns: 3,
                                                                    type: 'table'
                                                                },
                                                                items: [
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 400,
                                                                        items:[
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Colesterol',
                                                                                        name: 'Colesterol',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_Colesterol'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_ColesterolF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'HDL',
                                                                                        name: 'HDL',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_HDL'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_HDLF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'LDL',
                                                                                        name: 'LDL',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_LDL'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_LDLF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Trigliceridos',
                                                                                        name: 'Trigliceridos',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_Trigliceridos'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        emptyText: 'Fecha',
                                                                                        name: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_TrigliceridosF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Glicemia',
                                                                                        name: 'Glicemia',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_Glicemia'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_GlicemiaF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'BUN',
                                                                                        name: 'BUN',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_BUN'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_BUNF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Creatinina',
                                                                                        name: 'Creatinina',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_Creatinina'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_CreatininaF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Ac Urico',
                                                                                        name: 'Ac Urico',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_AcidoUrico'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_AcidoUricoF'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    },
                                                                    {           
                                                                        xtype: 'panel',
                                                                        layout: 'form',
                                                                        autoHeight: true,
                                                                        width: 400,
                                                                        items:[
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Hb',
                                                                                        name: 'Hb',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_Hb'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_HbF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Hcto',
                                                                                        name: 'Hcto',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_Hcto'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_HctoF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'INR',
                                                                                        name: 'INR',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_INR'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_INRF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'K',
                                                                                        name: 'K',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_K'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_KF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Na',
                                                                                        name: 'Na',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_Na'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_NaF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'TSH',
                                                                                        name: 'TSH',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_TSH'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_TSHF'
                                                                                    }
                                                                                ]
                                                                            },
                                                                            {
                                                                                xtype: 'compositefield',
                                                                                style: 'background:transparent;',
                                                                                anchor: '100%',
                                                                                items: [
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        fieldLabel: 'Otros',
                                                                                        name: 'Otros',
                                                                                        width: 150,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_Otros'
                                                                                    },
                                                                                    {
                                                                                        xtype: 'textfield',
                                                                                        name: 'Fecha',
                                                                                        emptyText: 'Fecha',
                                                                                        width: 100,
                                                                                        allowBlank: true,
                                                                                        id: 'strFR_LAB_OtrosF'
                                                                                    }
                                                                                ]
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMENES PARACLINICOS',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 100,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo', 
                                                                fieldLabel: 'Tilt Table Test',
                                                                name: 'Tilt Table Test',
                                                                width: 120,
                                                                allowBlank: false,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NEGATIVO (-)',
                                                                id: 'strExaPara_TableTest'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                emtyText: 'OBSERVACIONES',
                                                                name: 'Otros',
                                                                width: 620,
                                                                allowBlank: true,
                                                                id: 'strExaPara_TableTestH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                              html: 'FE: '  
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Ecocardiograma',
                                                                name: 'Ecocardiograma',
                                                                width: 270,
                                                                allowBlank: true,
                                                                id: 'strExaPara_EcocardiogramaFE'
                                                            },
                                                            {
                                                              html: 'Valvulas: '  
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Valvulas',
                                                                width: 150,
                                                                allowBlank: true,
                                                                id: 'strExaPara_EcocardiogramaValvulas'
                                                            },
                                                            {
                                                              html: 'Contractibilidad: '  
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'Valvulas',
                                                                width: 150,
                                                                allowBlank: true,
                                                                id: 'strExaPara_EcocardiogramaContractibilidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Prueba Esfuerzo',
                                                        name: 'Prueba Esfuerzo',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strExaPara_PruebaEsfuerzoH'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        anchor: '100%',
                                                        items: [
                                                            {
                                                                xtype: 'combo', 
                                                                fieldLabel: 'Isonitrilos',
                                                                name: 'Isonitrilos',
                                                                width: 70,
                                                                allowBlank: false,
                                                                store: 'StoreSiNo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                value: 'NO',
                                                                id: 'strExaPara_Isonitrilos'
                                                            },
                                                            {
                                                                xtype: 'combo', 
                                                                width: 120,
                                                                allowBlank: true,
                                                                store: 'StorePositivoNegativo',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione....',
                                                                id: 'strExaPara_IsonitrilosPositNegat'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                emtyText: 'OBSERVACIONES',
                                                                width: 550,
                                                                allowBlank: true,
                                                                id: 'strExaPara_IsonitrilosH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Holter',
                                                        name: 'Holter',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strExaPara_HolterH'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Ultimo EKG',
                                                        name: 'Ultimo EKG',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strExaPara_UltimoEKGH'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Dopler',
                                                        name: 'Dopler',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strExaPara_DoplerH'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        anchor: '100%',
                                                        allowBlank: true,
                                                        id: 'strExaPara_DoplerH'
                                                    }
                                                ]
                                            },
                                            /*
                                            {
                                                xtype: 'fieldset',
                                                title: 'TEST DE CAMINATA 6 MINUTOS',
                                                autoHeight: true,
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                id: 'fichaTestCaminata',
                                                items: [
                                                ]
                                            },*/
                                            {
                                                xtype: 'fieldset',
                                                title: 'FARMACOLOGICO',
                                                layout: 'form',
                                                collapsible: false,
                                                titleCollapse: false,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelWidth: 150,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 905,
                                                        labelWidth: 150,
                                                        layout: {
                                                            columns: 4,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                title: '<center>TIPO DE FARMACO</center>',
                                                                width: 220,
                                                                labelWidth: 150,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'ASA',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_ASA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'ANTIADRENERGICOS',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_ANTIADRENERGICOS'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'ANTIGREGANTE',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_ANTIGREGANTE'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'ANTIARRITMICO',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_ANTIARRITMICO'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'ANTICOAGULANTE',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_ANTICOAGULANTE'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'BLOQUEADOR DE CALCIO',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_BLOQUEADORCALCIO'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'B BLOQUEADOR',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_BBLOQUEADOR'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'IECA',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_IECA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'ARA II',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_ARAII'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'DIGITAL',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_DIGITAL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'DIURETICO',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_DIURETICO'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'NITRATOS',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_NITRATOS'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'REMPLAZO HORMONAL',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_REMPLAZOHORMONAL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'HIPOGLICEMIANTE ORAL',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_HIPOGLICEMIANTEORAL'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'INSULINA',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_INSULINA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'HIPOLIPEMIANTE',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_HIPOLIPEMIANTE'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'BRONCODILATADORES',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_BRONCODILATADORES'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'ANALGESICO',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_ANALGESICO'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 1,
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        fieldLabel: 'OTROS',
                                                                        border: 0,
                                                                        style: 'background:transparent;border:none;',
                                                                        id: 'sysFARMACO_OTROS'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                title: '<center>MEDICAMENTO ACTUAL</center>',
                                                                width: 400,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ASA MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ASA_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIADRENERGICOS MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIADRENERGICOS_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIGREGANTE MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIGREGANTE_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIARRITMICO MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIARRITMICO_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTICOAGULANTE MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTICOAGULANTE_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'BLOQUEADOR DE CALCIO MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BLOQUEADORCALCIO_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'B BLOQUEADOR MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BBLOQUEADOR_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'IECA MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_IECA_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ARA II MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ARAII_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'DIGITAL MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_DIGITAL_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'DIURETICO MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_DIURETICO_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'NITRATOS MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_NITRATOS_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'REMPLAZO HORMONAL MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_REMPLAZOHORMONAL_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HIPOGLICEMIANTE ORAL MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_HIPOGLICEMIANTEORAL_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'INSULINA MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_INSULINA_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HIPOLIPEMIANTE MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_HIPOLIPEMIANTE_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'BRONCODILATADORES MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BRONCODILATADORES_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANALGESICO MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANALGESICO_Actual'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'OTROS MEDICAMNETO ACTUAL',
                                                                        width: 390,
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_OTROS_Actual'
                                                                    },
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                labelWidth: 1,
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                title: '<center>DOSIS</center>',
                                                                width: 100,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ASA DOSIS',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ASA_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIADRENERGICOS DOSIS',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIADRENERGICOS_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIGREGANTE DOSIS',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIGREGANTE_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIARRITMICO DOSIS',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIARRITMICO_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTICOAGULANTE DOSIS',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTICOAGULANTE_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'BLOQUEADOR DE CALCIO DOSIS',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BLOQUEADORCALCIO_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'B BLOQUEADOR',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BBLOQUEADOR_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'IECA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_IECA_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ARA II',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ARAII_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'DIGITAL',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_DIGITAL_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'DIURETICO',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_DIURETICO_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'NITRATOS',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_NITRATOS_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'REMPLAZO HORMONAL',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_REMPLAZOHORMONAL_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HIPOGLICEMIANTE ORAL',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_HIPOGLICEMIANTEORAL_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'INSULINA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_INSULINA_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HIPOLIPEMIANTE',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_HIPOLIPEMIANTE_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'BRONCODILATADORES',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BRONCODILATADORES_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANALGESICO',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANALGESICO_Dosis'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'OTROS',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_OTROS_Dosis'
                                                                    }
                                                                ]
                                                            },
                                                            {           
                                                                xtype: 'panel',
                                                                labelWidth: 1,
                                                                layout: {
                                                                    //columns: 1,
                                                                    type: 'form'
                                                                },
                                                                autoHeight: true,
                                                                title: '<center>VECES x DIA</center>',
                                                                width: 100,
                                                                items:[
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ASA VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ASA_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIADRENERGICOS VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIADRENERGICOS_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIGREGANTE VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIGREGANTE_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTIARRITMICO VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTIARRITMICO_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANTICOAGULANTE VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANTICOAGULANTE_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'BLOQUEADOR DE CALCIO VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BLOQUEADORCALCIO_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'B BLOQUEADOR VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BBLOQUEADOR_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'IECA VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_IECA_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ARA II VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ARAII_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'DIGITAL VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_DIGITAL_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'DIURETICO VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_DIURETICO_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'NITRATOS VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_NITRATOS_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'REMPLAZO HORMONAL VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_REMPLAZOHORMONAL_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HIPOGLICEMIANTE ORAL VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_HIPOGLICEMIANTEORAL_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'INSULINA VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_INSULINA_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'HIPOLIPEMIANTE VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_HIPOLIPEMIANTE_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'BRONCODILATADORES VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_BRONCODILATADORES_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'ANALGESICO VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_ANALGESICO_VecesDia'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'OTROS VECES x DIA',
                                                                        anchor: '99%',
                                                                        allowBlank: true,
                                                                        id: 'strFARMACO_OTROS_VecesDia'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN FISICO',
                                                labelWidth: '150',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 120,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 0,
                                                                fieldLabel: 'FC (Lpm)',
                                                                name:"FC (Lpm)",
                                                                emptyText: '(Lpm)',
                                                                id: 'intEF_FC'
                                                            },
                                                            {
                                                                html: 'FR: (Rpm)'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 120,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 0,
                                                                allowBlank: false,
                                                                name: "FR: (Rpm)",
                                                                emptyText: 'Rpm',
                                                                id: 'intEF_FR'
                                                            },
                                                            {
                                                                html: 'SPO2: (%)'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 120,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 0,
                                                                allowBlank: true,
                                                                name: "SPO2 (%)",
                                                                emptyText: '%',
                                                                id: 'intEF_SPO2'
                                                            },
                                                            {
                                                                html: 'TAS/TAD: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 120,
                                                                allowBlank: true,
                                                                name: "TAS/TAD",
                                                                id: 'strEF_TA'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                fieldLabel: 'Talla (cm)',
                                                                name: "Talla (cm)",
                                                                emptyText: '(cm)',
                                                                id: 'intEF_Talla',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Talla').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'Peso (kg)'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(Kg)',
                                                                name:"PESO ACTUAL (Kg)",
                                                                id: 'intEF_Peso',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        if(pNew == null || pNew == 0){
                                                                            Ext.getCmp('intEF_Peso').setValue(null);
                                                                            Ext.getCmp('intEF_IMC').setValue(0);
                                                                        }else{
                                                                            //peso [kg]/ estatura [m2]
                                                                            if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100; 
                                                                                Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                            }else{
                                                                                Ext.getCmp('intEF_IMC').setValue(0);
                                                                            }
                                                                        }
                                                                        if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                           Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                        }else{
                                                                            if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                               Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                            }else{
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                   Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                }else{
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                }

                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                html: 'IMC: '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                value: 0,
                                                                name: "IMC",
                                                                id: 'intEF_IMC'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 100,
                                                                allowBlank: true,
                                                                readOnly: true,
                                                                name: "IMC - CLASIFICACION",
                                                                id: 'strEF_IMCClasificacon'
                                                            },
                                                            {
                                                                html: 'Cintura (cm): '
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 100,
                                                                minValue: 0,
                                                                maxValue: 250,
                                                                decimalPrecision: 2,
                                                                allowBlank: true,
                                                                emptyText: '(cm)',
                                                                name:"CINTURA (cm)",
                                                                id: 'intEF_Cintura'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Disnea',
                                                                width: 210,
                                                                allowBlank: true,
                                                                name: "Disnea",
                                                                id: 'strEF_Disnea'
                                                            },
                                                            {
                                                                html: 'Fatiga: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 210,
                                                                allowBlank: true,
                                                                name: "Disnea",
                                                                id: 'strEF_Fatiga'
                                                            },
                                                            {
                                                                html: 'Angina: '
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                width: 210,
                                                                allowBlank: true,
                                                                name: "Angina",
                                                                id: 'strEF_Angina'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CLASIFICACION',
                                                labelWidth: 250,
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo', 
                                                        width: 120,
                                                        fieldLabel: 'AHA-ACSM',
                                                        name: 'AHA-ACSM',
                                                        allowBlank: true,
                                                        store: stCRIAHAACSM,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        id: 'strClasificacionAHAACSM'
                                                    },
                                                    {
                                                        xtype: 'combo', 
                                                        width: 120,
                                                        fieldLabel: 'Riesgo Eventos',
                                                        name: 'Riesgo Eventos',
                                                        allowBlank: true,
                                                        store: stCRIRiesgoEventos,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        id: 'strClasificacionRiesgoEventos'
                                                    },
                                                    {
                                                        xtype: 'combo', 
                                                        width: 120,
                                                        fieldLabel: 'Riesgo Progresion Enfermedad AACVPR',
                                                        name: 'Riesgo Progresion Enfermedad AACVPR',
                                                        allowBlank: true,
                                                        store: stCRIRiesgoEventos,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        id: 'strClasificacionRiesgoProgresionEnfAACVPR'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENTRENAMIENTO',
                                                labelWidth: 250,
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'combo', 
                                                        width: 120,
                                                        fieldLabel: 'Inicial al',
                                                        name: 'Inicial al',
                                                        allowBlank: true,
                                                        store: stCRIEntrenamiento,
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        id: 'strEntrenamientoInicial'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'TRATAMIENTO A SEGUIR',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'Tratamiento a Seguir',
                                                        name: 'Tratamiento a Seguir',
                                                        allowBlank: true,
                                                        value: 'Usuario que asiste al Servicio deambulando por sus propios medios, con acompañante. En el momento no presenta fatiga ni disnea con una calificación de 0/10 según la Escala de Borg. A la Auscultación Cardíaca: Ruídos cardíacos rítmicos y a la Auscultación Pulmonar: Murmullo Vesicular conservado sin sobregragados. En la valoración realizada por la especialidad de Rehabilitación Cardíaca, se define como objetivo principal de tratamiento el Mejoramiento de la Capacidad Funcional y el Acondicionamiento del Sistema Cardiovascular con el fin de obtener mejor respuesta ante el ejercicio, favoreciendo la realización de las Actividades Básicas Cotidianas bajo condiciones de seguridad teniendo en cuenta una adecuada respuesta presora y cronotrópica que conduzca a mejorar la Calidad de Vida. Posteriormente se explican los riesgos inherentes a la atención y se procede a firmar el consentimiento informado. Finalmente se dan las recomendaciones a seguir durante el tratamiento y se estimula la adopción de estilos de vida saludables. Queda en condiciones estables y tolera la valoración.',
                                                        id: 'memTratamientoSeguir'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RECOMENDACIONES INICIALES',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'Recomendaciones Iniciales',
                                                        name: 'Recomendaciones Iniciales',
                                                        allowBlank: true,
                                                        id: 'memRecomendacionesIniciales'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea guardar la evolución, si hace esto ya no podra realizar ningun cambio?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'La evolución ya se guardo y no podra ser modificada nuevamente',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCRehabilitaCRI001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
