/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCMedicinaBasica001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Integral P&P ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        var fsExamenFisico = new fsExamenFisicoUi();
        var pnAtencionInfantil = new pnAtencionInfantil001Ui();
        var pnJoven = new pnJoven001Ui();
        var pnAdultoJoven = new pnAdultoJoven001Ui();
        var pnAdultoMaduro = new pnAdultoMaduro001Ui();
        var pnAnciano = new pnAnciano001Ui();
        var pnMaternoPerinatal = new pnMaternoPerinatal001Ui;
        var pnPlanificacionFamiliar = new pnPlanificacionFamiliar001Ui;
        var stSuministrosSaludPyP = new StoreGridSuministrosPyP();
        stSuministrosSaludPyP.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }


        var dataPresentacion = [
            ['CEFALICA'],
            ['PELVICA'],
            ['TRANSVERSA']
        ];
        var stPresentacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPresentacion.loadData(dataPresentacion);
        
        
        var dataAcompanante = [
            ['PAREJA'],
            ['FAMILIAR'],
            ['OTRO'],
            ['NINGUNO']
        ];
        var stAcompanante = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAcompanante.loadData(dataAcompanante);
        
        
        var dataNacimiento = [
            ['VIVO'],
            ['MUERTO ANTEPARTO'],
            ['MUERTO PARTO'],
            ['MUERTO IGNORA MOMENTO']
        ];
        var stNacimiento = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stNacimiento.loadData(dataNacimiento);
        
        
        var dataFetos = [
            ['UNICO'],
            ['MULTIPLE']
        ];
        var stFetos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stFetos.loadData(dataFetos);


        var dataPlacenta = [
            ['COMPLETA RETENIDA'],
            ['COMPLETA NO RETENIDA'],
            ['INCOMPLETA RETENIDA'],
            ['INCOMPLETA NO RETENIDA']
        ];
        var stPlacenta = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPlacenta.loadData(dataPlacenta);
        
        
        var dataLigaduraCordon = [
            ['<30s'],
            ['30s 1m'],
            ['>1m']
        ];
        var stLigaduraCordon = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stLigaduraCordon.loadData(dataLigaduraCordon);


        var dataEdadMujer = [
            [2,'17 anos'],
            [0,'18 a 34 anos'],
            [1,'35 anos o mas']
        ];
        var stEdadMujer = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stEdadMujer.loadData(dataEdadMujer);
        
        
        var dataLoquios = [
            ['NO APLICA'],
            ['NORMAL'],
            ['ANORMAL']
        ];
        var stLoquios = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stLoquios.loadData(dataLoquios);
        
        
        var dataParidad = [
            [0,'Nulipara'],
            [1,'1 a 3 Partos'],
            [4,'4 Partos o mas']
        ];
        var stParidad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stParidad.loadData(dataParidad);


        var dataSocioEconomico = [
            [2,'SISBEN 1y2 con factor de riesgo'],
            [2.01,'Grado Escolar Hasta 5 años o menos'],
            [2.02,'Dependencia Economica'],
            [0,'No Aplica']
        ];
        var stSocioEconomico = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stSocioEconomico.loadData(dataSocioEconomico);


        var dataIntervaloEmbarazos = [
            [4,'Menor de 12 Meses'],
            [1,'1 a 2 anos'],
            [0,'Mas de 2 anos']
        ];
        var stIntervaloEmbarazos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stIntervaloEmbarazos.loadData(dataIntervaloEmbarazos);


        var dataAbortos = [
            [2,'1 o 2'],
            [4,'3 o mas'],
            [0,'No Aplica']
        ];
        var stAbortos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stAbortos.loadData(dataAbortos);


        var dataCesarea = [
            [1,'1'],
            [2,'2 o mas'],
            [0,'No Aplica']
        ];
        var stCesarea = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stCesarea.loadData(dataCesarea);


        var dataMortinato = [
            [4,'1 o 2'],
            [0,'No Aplica']
        ];
        var stMortinato = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stMortinato.loadData(dataMortinato);


        var dataPrematuros = [
            [2,'1'],
            [4,'2 o mas'],
            [0,'No Aplica']
        ];
        var stPrematuros = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stPrematuros.loadData(dataPrematuros);


        var dataHipertension = [
            [4,'Si'],
            [0,'No Aplica']
        ];
        var stHipertension = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stHipertension.loadData(dataHipertension);


        var dataPreclampsia = [
            [2,'Si'],
            [0,'No Aplica']
        ];
        var stPreclampsia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stPreclampsia.loadData(dataPreclampsia);
        
        
        var dataCardiopatia = [
            [2,'Si'],
            [0,'No Aplica']
        ];
        var stCardiopatia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stCardiopatia.loadData(dataCardiopatia);


        var dataOtraPatologia = [
            [2,'Si'],
            [0,'No Aplica']
        ];
        var stOtraPatologia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stOtraPatologia.loadData(dataOtraPatologia);


        var dataReanimacion = [
            ['FLUJO LIBRE O2'],
            ['VENTILACION'],
            ['INTUBACION OT'],
            ['MASAJE CARDIACO'],
            ['ADRENALINA']

        ];
        var stReanimacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stReanimacion.loadData(dataReanimacion);


        var dataCongenitos = [
            ['NO'],
            ['MENOR'],
            ['MAYOR']

        ];
        var stCongenitos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCongenitos.loadData(dataCongenitos);


        var dataHemoclasificacion = [
            ['O+'],
            ['O-'],
            ['A+'],
            ['A-'],
            ['B+'],
            ['B-'],
            ['AB+'],
            ['AB-']
        ];
        var stHemoclasificacion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHemoclasificacion.loadData(dataHemoclasificacion);


        var dataDependenciaEconomica = [
            ['PADRE'],
            ['MADRE'],
            ['EL MISMO'],
            ['OTROS']
        ];
        var stDependenciaEconomica = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stDependenciaEconomica.loadData(dataDependenciaEconomica);


        var dataRelaciones = [
            ['BUENA'],
            ['REGULAR'],
            ['MALA']
        ];
        var stRelaciones = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRelaciones.loadData(dataRelaciones);





        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'INFORMACION',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaIdentifica',
                                layout: 'form',
                                items:[
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysIdCodPlantillaHC'
                                    },
                                     {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        value: 1,
                                        id: 'sysUsaGridSalida'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        value: 0,
                                        id: 'sysYaGuardoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysPlantillaHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptMx'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptExa'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRutaRptRem'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Actividad',
                                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                        id: 'sysActividadHC',
                                        name: 'PLANTILLA'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Empresa',
                                        id: 'sysEmpresaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'IPS',
                                        id: 'sysIPSHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Usuario',
                                        id: 'sysUsuarioHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        id: 'sysIdPacienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Apertura',
                                        id: 'sysAperturaHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Cliente',
                                        id: 'sysClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdClienteHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdSubPlanHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Plantilla',
                                        id: 'sysIdContratoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Edad',
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Profesional',
                                        id: 'sysProfesionalAgendaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'ConsecutivoDetalle',
                                        id: 'sysConsecutivoDetalleHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'CAS',
                                                id: 'sysCASHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysFechaHC',
                                                value: 'Fecha: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysHoraHC',
                                                value: 'Hora: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysHoraHC'
                                            },
                                            {
                                                xtype: 'displayfield',
                                                id: 'sysLegalizacionHC',
                                                value: 'Legalización: '
                                            },
                                            {
                                                xtype: 'textfield',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysLegalizaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteHC'
                                    },
                                    {
                                        //xtype: 'textfield',
                                        xtype: 'hidden',
                                        width: 120,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroPacHC'
                                    },
                                    {
                                        //xtype: 'datefield',
                                        xtype: 'hidden',
                                        width: 120,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysFecNacPacHC'
                                    },
                                    {
                                        //xtype: 'textfield',
                                        xtype: 'hidden',
                                        width: 250,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEdadPacHC'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                fieldLabel: 'Genero',
                                                id: 'sysGeneroHC'
                                            },
                                            {
                                                html: 'Fecha Nac:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 100,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysFechaNac'
                                            },
                                            {
                                                html: 'Edad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysEdadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Ocupación',
                                        id: 'sysOcupacionHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysDiscapacidadHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Estado Civil',
                                        id: 'sysEstadoCivilHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 380,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEscolaridadHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 370,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Dirección',
                                        id: 'sysDireccionHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 390,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysTelefonoHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 380,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Etnia',
                                        id: 'sysEtniaHC'
                                    },
                                    {
                                        xtype: 'hidden',
                                        width: 390,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEstratoHC'
                                    },
                                    {
                                        html: '<hr>',
                                        style: 'background:transparent;',
                                        border: false
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompañante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IDENTIFICACION DE LA ATENCION',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC_1'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC_1'
                                                    }
                                                ]
                                            },
                                            fsRevisionxSistemas,
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            fsExamenFisico,
                                            {
                                                xtype: 'fieldset',
                                                title: 'PARACLINICOS',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'PARACLINICOS',
                                                        name: 'PARACLINICOS',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memParaclinicosHC'
                                                    }
                                                ]
                                            },
                                            pnAtencionInfantil,
                                            pnJoven,
                                            pnAdultoJoven,
                                            pnAdultoMaduro,
                                            pnAnciano,
                                            pnMaternoPerinatal,
                                            pnPlanificacionFamiliar,
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                        {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANALISIS',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ANALISIS',
                                                        name: 'ANALISIS',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memAnalisis'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() == null || Ext.getCmp('fecDesdeIncapacidad').getValue() == ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'))
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y')
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Suministros',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaSuministros',
                                layout: 'form',
                                items: [
                                     {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridSuministrosSaludPyP',
                                        store: stSuministrosSaludPyP,
                                        anchor: "100%",
                                        height: 320,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'idConsecutivo',
                                                id: 'idConsecutivo'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: false,
                                                width: 120,
                                                dataIndex: 'Fecha',
                                                id: 'Fecha'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Descripcion',
                                                sortable: false,
                                                width: 750,
                                                dataIndex: 'Descripcion',
                                                id: 'Descripcion'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar Registro',
                                                        iconCls: 'btnAddRow',
                                                        listeners: {
                                                            click : function() {
                                                                var wAddSuministros = new winAddSuministrosUi();
                                                                Ext.getCmp('intPacienteSuministros').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                                Ext.getCmp('intCASSuministros').setValue(wCAS);
                                                                Ext.getCmp('intUsuariosSuministros').setValue(ID_USUARIO);
                                                                wAddSuministros.show();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar Registro',
                                                        iconCls: 'btnDelRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridSuministrosSaludPyP').selModel.getCount() == 1)
                                                                {
                                                                    var selections = Ext.getCmp('gridSuministrosSaludPyP').selModel.getSelections();
                                                                    if(parseInt(selections[0].json.CAS) === parseInt(wCAS)){
                                                                        Ext.Msg.show({
                                                                            title: 'Suministros',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.Descripcion + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn)
                                                                            {
                                                                                if(btn=="yes")
                                                                                {
                                                                                    fnEliminarRegistrosSuministros01("../../controlador/asistencial/saludpyp.php",{task: "ELIMINAR_SUMINISTROS", pIdConsecutivo: selections[0].json.idConsecutivo}, 'gridSuministrosSaludPyP')
                                                                                }
                                                                            }
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    }
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos

                    if(Ext.getCmp('sysFechaHC').getValue() != null || Ext.getCmp('sysFechaHC').getValue() != 0){
                       guiaAtencionEtarea();
                    }
                    
                    var valFechaA = 0;
                    var pFec2AnioB = 0;
                    var pFec2MesB = 0;
                    var pFec2DiaB = 0;
                    var valFechaB = 0;
                    var EdadMesesCumplidos = 0;
                    var MesesCumplidos = 0;
                    
                    valFechaA = Ext.getCmp('sysFechaHC').getValue();
                    pFec2AnioB = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
                    pFec2MesB = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
                    pFec2DiaB = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
                    valFechaB =  pFec2AnioB + "/" + pFec2MesB + "/" + pFec2DiaB;
                    var newValFechaA = valFechaA.replace(/-/g,"/"); 

                    EdadMesesCumplidos = MostrarEdadMeses(newValFechaA, valFechaB);
                    MesesCumplidos = MostrarEdadMeses(newValFechaA, valFechaB);
                    
                    //EVALUA ANTECEDENTES GINOECO-OBSTETrICOS
                    if(Ext.getCmp('sysGeneroHC').getValue()=="MASCULINO" || EdadMesesCumplidos <= 96){
                        Ext.getCmp('fsANTGINECO').setVisible(false);
                        Ext.getCmp('intANTGINECOG').allowBlank = true;
                        Ext.getCmp('intANTGINECOP').allowBlank = true;
                        Ext.getCmp('intANTGINECOPV').allowBlank = true;
                        Ext.getCmp('intANTGINECOPC').allowBlank = true;
                        Ext.getCmp('intANTGINECOA').allowBlank = true;
                        Ext.getCmp('intANTGINECOVivos').allowBlank = true;
                        Ext.getCmp('intANTGINECOMuertos').allowBlank = true;
                        Ext.getCmp('bolANTGINECOMola').allowBlank = true;
                        Ext.getCmp('bolANTGINECOEmbEctopico').allowBlank = true;
                        Ext.getCmp('strANTGINECOLactanciaHoy').allowBlank = true;
                        Ext.getCmp('strANTGINECOLactanciaPasado').allowBlank = true;
                        Ext.getCmp('strANTGONECOTiempoLactancia').allowBlank = true;
                        Ext.getCmp('strANTGINECOMenarquia').allowBlank = true;
                        Ext.getCmp('strANTGINECOMenopausia').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFup').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
                        Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
                        Ext.getCmp('strANTGINECOMetodoPlanifica').allowBlank = true;
                        Ext.getCmp('strANTGINECOCiclosMestruales').allowBlank = true;
                        Ext.getCmp('strANTGINECOActividadSexual').allowBlank = true;
                        Ext.getCmp('strANTGINECOPatologiaEmbarazo').allowBlank = true;
                        Ext.getCmp('fsEXAMFISValMamaria').setVisible(false);
                        Ext.getCmp('strEXAFISMamaAspecto').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaGanglios').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaMalestar').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaDolor').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaDescargas').allowBlank = true;
                        Ext.getCmp('strEXAFISMamaMasas').allowBlank = true;
                    }else{
                        Ext.getCmp('fsANTGINECO').setVisible(true);
                        Ext.getCmp('intANTGINECOG').allowBlank = false;
                        Ext.getCmp('intANTGINECOP').allowBlank = false;
                        Ext.getCmp('intANTGINECOPV').allowBlank = false;
                        Ext.getCmp('intANTGINECOPC').allowBlank = false;
                        Ext.getCmp('intANTGINECOA').allowBlank = false;
                        Ext.getCmp('intANTGINECOVivos').allowBlank = false;
                        Ext.getCmp('intANTGINECOMuertos').allowBlank = false;
                        Ext.getCmp('bolANTGINECOMola').allowBlank = false;
                        Ext.getCmp('bolANTGINECOEmbEctopico').allowBlank = false;
                        Ext.getCmp('strANTGINECOLactanciaHoy').allowBlank = true;
                        Ext.getCmp('strANTGINECOLactanciaPasado').allowBlank = true;
                        Ext.getCmp('strANTGONECOTiempoLactancia').allowBlank = true;
                        Ext.getCmp('strANTGINECOMenarquia').allowBlank = true;
                        Ext.getCmp('strANTGINECOMenopausia').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFup').allowBlank = true;
                        Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
                        Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
                        Ext.getCmp('strANTGINECOMetodoPlanifica').allowBlank = false;
                        Ext.getCmp('strANTGINECOCiclosMestruales').allowBlank = false;
                        Ext.getCmp('strANTGINECOActividadSexual').allowBlank = false;
                        Ext.getCmp('strANTGINECOPatologiaEmbarazo').allowBlank = false;
                        Ext.getCmp('fsEXAMFISValMamaria').setVisible(true);
                        Ext.getCmp('strEXAFISMamaAspecto').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaGanglios').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaMalestar').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaDolor').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaDescargas').allowBlank = false;
                        Ext.getCmp('strEXAFISMamaMasas').allowBlank = false;
                    }
                    //CARGAR ANTECEDENTES
                    if(paramOpcion === "Nuevo"){ 
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/evolucionhc.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesFamiliares'
                            },
                            success: function(result, request)
                            {
                                var jsonAntFamiliares = Ext.util.JSON.decode(result.responseText);
                                CargarDataHCAntecedentes(jsonAntFamiliares.data.sysEvolucion);
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            },
                            scope:this
                        });
                    }
                    //IDENTIFICACION DEL RIESGO FILTROS
                    if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO" && MesesCumplidos >= 121){
                        Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoGestacion').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoGestacion').disable();
                    }
                    if(Ext.getCmp('sysGeneroHC').getValue() === "FEMENINO" || MesesCumplidos <= 216){
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').disable();
                    }
                    if(MesesCumplidos <= 36){
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').disable();
                    }
                }
            }
        });
        winHCMedicinaBasica001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoRiesgoReproductivoMaternidad(){
    
    var TotatRiegoReproductivoMaternidad = 0;
    var valEdadMujerMaternidad = 0;
    var valParidadMaternidad = 0;
    var valSocioEconomicoMaternidad = 0;
    var valIntervaloEmbarazosMaternidad = 0;
    var valAbortosMaternidad = 0;
    var valCesareaMaternidad = 0;
    var valMortinatoMaternidad = 0;
    var valPrematurosMaternidad = 0;
    var valHipertensionMaternidad = 0;
    var valPreclampsiaMaternidad = 0;
    var valCardiopatiaMaternidad = 0;
    var valOtraPatologiaMaternidad = 0;


    valEdadMujerMaternidad = Ext.getCmp('strPOSTPAREdadMujer').getValue();
    valParidadMaternidad = Ext.getCmp('strPOSTPARParidad').getValue();
    valSocioEconomicoMaternidad = Ext.getCmp('strPOSTPARSocioEconomico').getValue();
    valIntervaloEmbarazosMaternidad = Ext.getCmp('strPOSTPARIntervaloEmbarazos').getValue();
    valAbortosMaternidad = Ext.getCmp('strPOSTPARAbortos').getValue();
    valCesareaMaternidad = Ext.getCmp('strPOSTPARCesarea').getValue();
    valMortinatoMaternidad = Ext.getCmp('strPOSTPARMortinato').getValue();
    valPrematurosMaternidad = Ext.getCmp('strPOSTPARPrematuros').getValue();
    valHipertensionMaternidad = Ext.getCmp('strPOSTPARHipertension').getValue();
    valPreclampsiaMaternidad = Ext.getCmp('strPOSTPARPreclampsia').getValue();
    valCardiopatiaMaternidad = Ext.getCmp('strPOSTPARCardiopatia').getValue();
    valOtraPatologiaMaternidad = Ext.getCmp('strPOSTPAROtraPatologia').getValue();

    TotatRiegoReproductivoMaternidad = valEdadMujerMaternidad + valParidadMaternidad + valSocioEconomicoMaternidad + valIntervaloEmbarazosMaternidad + valAbortosMaternidad + valCesareaMaternidad + valMortinatoMaternidad + valPrematurosMaternidad + valHipertensionMaternidad + valPreclampsiaMaternidad + valCardiopatiaMaternidad + valOtraPatologiaMaternidad;
    
    if(TotatRiegoReproductivoMaternidad<5){
        Ext.getCmp('strPOSTPARRiesgoTotal').setValue(TotatRiegoReproductivoMaternidad + " - RIESGO BAJO");
    }else{
        if(TotatRiegoReproductivoMaternidad<10){
            Ext.getCmp('strPOSTPARRiesgoTotal').setValue(TotatRiegoReproductivoMaternidad + " - RIESGO MEDIO");
        }else{
            Ext.getCmp('strPOSTPARRiesgoTotal').setValue(TotatRiegoReproductivoMaternidad + " - RIESGO ALTO");
        }
    }
}
function calculoRiesgoReproductivo(){
    
    var TotatRiegoReproductivoPlanificacion = 0;
    var valEdadMujerPlanificacion = 0;
    var valParidadPlanificacion = 0;
    var valSocioEconomicoPlanificacion = 0;
    var valIntervaloEmbarazosPlanificacion = 0;
    var valAbortosPlanificacion = 0;
    var valCesareaPlanificacion = 0;
    var valMortinatoPlanificacion = 0;
    var valPrematurosPlanificacion = 0;
    var valHipertensionPlanificacion = 0;
    var valPreclampsiaPlanificacion = 0;
    var valCardiopatiaPlanificacion = 0;
    var valOtraPatologiaPlanificacion = 0;
    

    valEdadMujerPlanificacion = Ext.getCmp('strPlanificacionFamiliarEdadMujer').getValue();
    valParidadPlanificacion = Ext.getCmp('strPlanificacionFamiliarParidad').getValue();
    valSocioEconomicoPlanificacion = Ext.getCmp('strPlanificacionFamiliarSocioEconomico').getValue();
    valIntervaloEmbarazosPlanificacion = Ext.getCmp('strPlanificacionFamiliarIntervaloEmbarazos').getValue();
    valAbortosPlanificacion = Ext.getCmp('strPlanificacionFamiliarAbortos').getValue();
    valCesareaPlanificacion = Ext.getCmp('strPlanificacionFamiliarCesarea').getValue();
    valMortinatoPlanificacion = Ext.getCmp('strPlanificacionFamiliarMortinato').getValue();
    valPrematurosPlanificacion = Ext.getCmp('strPlanificacionFamiliarPrematuros').getValue();
    valHipertensionPlanificacion = Ext.getCmp('strPlanificacionFamiliarHipertension').getValue();
    valPreclampsiaPlanificacion = Ext.getCmp('strPlanificacionFamiliarPreclampsia').getValue();
    valCardiopatiaPlanificacion = Ext.getCmp('strPlanificacionFamiliarCardiopatia').getValue();
    valOtraPatologiaPlanificacion = Ext.getCmp('strPlanificacionFamiliarOtraPatologia').getValue();
    
    TotatRiegoReproductivoPlanificacion = valEdadMujerPlanificacion + valParidadPlanificacion + valSocioEconomicoPlanificacion + valIntervaloEmbarazosPlanificacion + valAbortosPlanificacion + valCesareaPlanificacion + valMortinatoPlanificacion + valPrematurosPlanificacion + valHipertensionPlanificacion + valPreclampsiaPlanificacion + valCardiopatiaPlanificacion + valOtraPatologiaPlanificacion;

    
    if(TotatRiegoReproductivoPlanificacion<5){
            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').setValue(TotatRiegoReproductivoPlanificacion + " - RIESGO BAJO");
    }else{
        if(TotatRiegoReproductivoPlanificacion<10){
            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').setValue(TotatRiegoReproductivoPlanificacion + " - RIESGO MEDIO");
        }else{
            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').setValue(TotatRiegoReproductivoPlanificacion + " - RIESGO ALTO");
        }
    }
}
function guiaAtencionEtarea(){
    var valFechaA = 0;
    var pFec2AnioB = 0;
    var pFec2MesB = 0;
    var pFec2DiaB = 0;
    var valFechaB = 0;
    var EdadMesesCumplidos = 0;
    var Guia10_1 = "";
    var Guia10_2 = "";
    var Guia10_3 = "";
    var Guia10_4 = "";
    var Guia10_5 = "";
    var Guia10_6 = "";
    var Guia10_7 = "";
    var Guia24_1 = "";
    var Guia24_2 = "";
    var Guia24_3 = "";
    var Guia24_4 = "";
    var Guia24_5 = "";
    var Guia24_6 = "";
    var Guia24_7 = "";
    var Guia44_1 = "";
    var Guia44_2 = "";
    var Guia44_3 = "";
    var Guia44_4 = "";
    var Guia44_5 = "";
    var Guia44_6 = "";
    var Guia64_1 = "";
    var Guia64_2 = "";
    var Guia64_3 = "";
    var Guia64_4 = "";
    var Guia64_5 = "";
    var Guia64_6 = "";
    var Guia64_7 = "";
    var Guia64_8 = "";
    var Guia64_9 = "";
    var Guia64_10 = "";
    var Guia65_1 = "";
    var Guia65_2 = "";
    var Guia65_3 = "";
    var Guia65_4 = "";
    var Guia65_5 = "";
    var Guia65_6 = "";
    var Guia65_7 = "";
    var Guia65_8 = "";
    
    valFechaA = Ext.getCmp('sysFechaHC').getValue();
    pFec2AnioB = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2MesB = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2DiaB = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    valFechaB =  pFec2AnioB + "/" + pFec2MesB + "/" + pFec2DiaB;
    var newValFechaA = valFechaA.replace(/-/g,"/"); 
    
    EdadMesesCumplidos = MostrarEdadMeses(newValFechaA, valFechaB);
    /*    
    //Menor 10 anios
    if(EdadMesesCumplidos <= 131){
       Guia10_1 = "\n\ - CONSULTA PEDIATRIA\n\    Menores a 5 años: 1mes, 3 meses, 6 meses, 9 meses, 12 meses, 16meses, 20 meses, 24 meses, 30 meses, 36 meses, 42 meses, 48 meses, 60 meses\n\    entre 5 y 9 años:  Un control cada año.";
    }
    
    if(EdadMesesCumplidos <= 131){
       Guia10_2 = "\n\ - CONSULTA SALUD ORAL: Semestral\n\ - ACTIVIDAD LÚDICO-EDUCATIVA : Semestral";
    }
    
    if(EdadMesesCumplidos >= 48 && EdadMesesCumplidos <= 59){
       Guia10_3 = "\n\ - AUDIOMETRIA: 4 años\n\ - OPTOMETRIA: 4 años";
    }
    
    if(EdadMesesCumplidos >= 84 && EdadMesesCumplidos <= 95){
       Guia10_4 = "\n\ - HEMOGLOBINA Y HEMATOCRITO: 7 años";
    }
    
    if(EdadMesesCumplidos >= 6 && EdadMesesCumplidos <= 59){
       Guia10_5 = "\n\ - SUMINISTRO DE HIERRO: desde 6 meses hasta 5 años";
    }
        
    if(EdadMesesCumplidos >= 24 && EdadMesesCumplidos <= 119){
       Guia10_6 = "\n\ - SUMINISTRO DE ANTIPARASITARIO: apartir de los 2 años";
    }
        
    if(EdadMesesCumplidos <= 131){
       Guia10_7 = "\n\ - CONSULTA NUTRICION: Anual\n\ - CONSULTA PSICOLOGIA: Anual\n\ - CONSULTA TRABAJO SOCIAL: Anual\n\ - CONSULTA ENFERMERIA: Anual";
    }
    
    //10 anios a 24 anios
    
    if(EdadMesesCumplidos <= 179){
       Guia24_1 = "\n\ - CONSULTA PEDIATRIA: Anual";
    }
    
    if(EdadMesesCumplidos <= 299){
       Guia24_2 = "\n\ - CONSULTA SALUD ORAL: Semestral\n\ - ACTIVIDAD LÚDICO-EDUCATIVA : Semestral";
    }
    
    if(EdadMesesCumplidos >= 132 && EdadMesesCumplidos <= 143){
       Guia24_3 = "\n\ - CONSULTA OPTOMETRIA: 11 y 16 años";
    }
    
    if(EdadMesesCumplidos >= 192 && EdadMesesCumplidos <= 203){
       Guia24_3 = "\n\ - CONSULTA OPTOMETRIA: 11 y 16 años";
    }
    
    if(EdadMesesCumplidos >= 144 && EdadMesesCumplidos <= 155 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia24_4 = "\n\ - HEMOGLOBINA Y HEMATOCRITO: 12 años (Mujeres)";
    }
    
    if(EdadMesesCumplidos >= 180 && EdadMesesCumplidos <= 191 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia24_4 = "\n\ - CITOLOGIA VAGINAL: apartir de los 15 años (Vida Sexual Activa)";
    }
    
    if(EdadMesesCumplidos >= 240 && EdadMesesCumplidos <= 251){
       Guia24_5 = "\n\ - GLICEMIA: 20 años\n\ - COLESTEROL TOTAL: 20 años\n\ - COLESTEROL HDL: 20 años\n\ - TRIGLICERIDOS: 20 años";
    }
    
    if(EdadMesesCumplidos >= 180 && EdadMesesCumplidos <= 191){
       Guia24_6 = "\n\ - VDRL: Anual (Vida Sexual Activa)";
    }
            
    if(EdadMesesCumplidos >= 132 && EdadMesesCumplidos <= 299){
       Guia24_7 = "\n\ - CONSULTA NUTRICION: Anual\n\ - CONSULTA PSICOLOGIA: Anual\n\ - CONSULTA TRABAJO SOCIAL: Anual\n\ - CONSULTA ENFERMERIA: Anual (PF-ITS-AUTOEXAMEN SENO O TESTICULO)";
    }
    
    //25 anios a 44 anios
    
    if(EdadMesesCumplidos >= 300 && EdadMesesCumplidos <= 539){
       Guia44_1 = "\n\ - CONSULTA SALUD ORAL: Semestral\n\ - ACTIVIDAD LÚDICO-EDUCATIVA : Semestral";
    }
    
    if(EdadMesesCumplidos >= 300 && EdadMesesCumplidos <= 539 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia44_2 = "\n\ - CITOLOGIA VAGINAL: Anual";
    }
    
    if(EdadMesesCumplidos >= 300 && EdadMesesCumplidos <= 311){
       Guia44_3 = "\n\ - GLICEMIA: a los 25, 30, 35, y 40 años\n\ - COLESTEROL TOTAL: a los 25, 30, 35, y 40 años\n\ - COLESTEROL HDL: a los 25, 30, 35, y 40 años\n\ - TRIGLICERIDOS: a los 25, 30, 35, y 40 años";
    }
    
    if(EdadMesesCumplidos >= 360 && EdadMesesCumplidos <= 371){
       Guia44_3 = "\n\ - GLICEMIA: a los 25, 30, 35, y 40 años\n\ - COLESTEROL TOTAL: a los 25, 30, 35, y 40 años\n\ - COLESTEROL HDL: a los 25, 30, 35, y 40 años\n\ - TRIGLICERIDOS: a los 25, 30, 35, y 40 años";
    }

    if(EdadMesesCumplidos >= 420 && EdadMesesCumplidos <= 431){
       Guia44_3 = "\n\ - GLICEMIA: a los 25, 30, 35, y 40 años\n\ - COLESTEROL TOTAL: a los 25, 30, 35, y 40 años\n\ - COLESTEROL HDL: a los 25, 30, 35, y 40 años\n\ - TRIGLICERIDOS: a los 25, 30, 35, y 40 años";
    }

    if(EdadMesesCumplidos >= 480 && EdadMesesCumplidos <= 491){
       Guia44_3 = "\n\ - GLICEMIA: a los 25, 30, 35, y 40 años\n\ - COLESTEROL TOTAL: a los 25, 30, 35, y 40 años\n\ - COLESTEROL HDL: a los 25, 30, 35, y 40 años\n\ - TRIGLICERIDOS: a los 25, 30, 35, y 40 años";
    }
     
    if(EdadMesesCumplidos >= 300 && EdadMesesCumplidos <= 539){
       Guia44_4 = "\n\ - VDRL: Anual (Vida Sexual Activa)";
    }
     
    if(EdadMesesCumplidos >= 300 && EdadMesesCumplidos <= 539){
       Guia44_5 = "\n\ - SANGRE OCULTA EN HECES: Anual (Paciente con Riesgo CA Colon)";
    }
          
    if(EdadMesesCumplidos >= 300 && EdadMesesCumplidos <= 539){
       Guia44_6 = "\n\ - CONSULTA NUTRICION: Anual\n\ - CONSULTA PSICOLOGIA: Anual\n\ - CONSULTA TRABAJO SOCIAL: Anual\n\ - CONSULTA ENFERMERIA: Anual (PF-ITS-AUTOEXAMEN SENO O TESTICULO)";
    }
    
     //45 anios a 64 anios
    
    if(EdadMesesCumplidos >= 540 && EdadMesesCumplidos <= 779){
       Guia64_1 = "\n\ - CONSULTA SALUD ORAL: Semestral\n\ - ACTIVIDAD LÚDICO-EDUCATIVA : Semestral";
    }
    
    if(EdadMesesCumplidos >= 540 && EdadMesesCumplidos <= 551){
       Guia64_2 = "\n\ - CONSULTA OPTOMETRIA: 45 y 50 años";
    }
    
    if(EdadMesesCumplidos >= 600 && EdadMesesCumplidos <= 611){
       Guia64_2 = "\n\ - CONSULTA OPTOMETRIA: 45 y 50 años";
    }
    
    if(EdadMesesCumplidos >= 660 && EdadMesesCumplidos <= 671){
       Guia64_3 = "\n\ - CONSULTA OFTALMOLOGICA: 55 y 60 años";
    }
    
    if(EdadMesesCumplidos >= 720 && EdadMesesCumplidos <= 731){
       Guia64_3 = "\n\ - CONSULTA OFTALMOLOGICA: 55 y 60 años";
    }
    
    if(EdadMesesCumplidos >= 540 && EdadMesesCumplidos <= 551){
       Guia64_4 = "\n\ - GLICEMIA: a los 45, 50, 55 y 60 años\n\ - COLESTEROL TOTAL: a los 45, 50, 55 y 60 años\n\ - COLESTEROL HDL: a los 45, 50, 55 y 60 años\n\ - TRIGLICERIDOS: a los 45, 50, 55 y 60 años\n\ - EXAMEN ORINA: a los 45, 50, 55 y 60 años\n\ - CREATININA: a los 45, 50, 55 y 60 años";
    }
    
    if(EdadMesesCumplidos >= 600 && EdadMesesCumplidos <= 611){
       Guia64_4 = "\n\ - GLICEMIA: a los 45, 50, 55 y 60 años\n\ - COLESTEROL TOTAL: a los 45, 50, 55 y 60 años\n\ - COLESTEROL HDL: a los 45, 50, 55 y 60 años\n\ - TRIGLICERIDOS: a los 45, 50, 55 y 60 años\n\ - EXAMEN ORINA: a los 45, 50, 55 y 60 años\n\ - CREATININA: a los 45, 50, 55 y 60 años";
    }
    
    if(EdadMesesCumplidos >= 660 && EdadMesesCumplidos <= 671){
       Guia64_4 = "\n\ - GLICEMIA: a los 45, 50, 55 y 60 años\n\ - COLESTEROL TOTAL: a los 45, 50, 55 y 60 años\n\ - COLESTEROL HDL: a los 45, 50, 55 y 60 años\n\ - TRIGLICERIDOS: a los 45, 50, 55 y 60 años\n\ - EXAMEN ORINA: a los 45, 50, 55 y 60 años\n\ - CREATININA: a los 45, 50, 55 y 60 años";
    }
    
    if(EdadMesesCumplidos >= 720 && EdadMesesCumplidos <= 731){
       Guia64_4 = "\n\ - GLICEMIA: a los 45, 50, 55 y 60 años\n\ - COLESTEROL TOTAL: a los 45, 50, 55 y 60 años\n\ - COLESTEROL HDL: a los 45, 50, 55 y 60 años\n\ - TRIGLICERIDOS: a los 45, 50, 55 y 60 años\n\ - EXAMEN ORINA: a los 45, 50, 55 y 60 años\n\ - CREATININA: a los 45, 50, 55 y 60 años";
    }
    
    if(EdadMesesCumplidos >= 600 && EdadMesesCumplidos <= 779){
       Guia64_5 = "\n\ - SANGRE OCULTA EN HECES: Anual desde los 50 años";
    }
    
    if(EdadMesesCumplidos >= 600 && EdadMesesCumplidos <= 779 && Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
       Guia64_6 = "\n\ - ANTIGENO PROSTATICO: Anual desde los 50 años (Hombres)";
    }
    
    if(EdadMesesCumplidos >= 540 && EdadMesesCumplidos <= 551 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 600 && EdadMesesCumplidos <= 611 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 624 && EdadMesesCumplidos <= 635 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 648 && EdadMesesCumplidos <= 659 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 672 && EdadMesesCumplidos <= 683 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 696 && EdadMesesCumplidos <= 707 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 720 && EdadMesesCumplidos <= 731 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 744 && EdadMesesCumplidos <= 755 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 768 && EdadMesesCumplidos <= 779 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_7 = "\n\ - MAMOGRAFIA: a los  45, 50, 52, 54, 56, 58, 60, 62 Y 64";
    }
    
    if(EdadMesesCumplidos >= 540 && EdadMesesCumplidos <= 779 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia64_8 = "\n\ - CITOLOGIA VAGINAL: Anual";
    }
    
    if(EdadMesesCumplidos >= 540 && EdadMesesCumplidos <= 779){
       Guia64_9 = "\n\ - VDRL: Anual (Vida Sexual Activa)";
    }
           
    if(EdadMesesCumplidos >= 300 && EdadMesesCumplidos <= 539){
       Guia64_10 = "\n\ - CONSULTA NUTRICION: Anual\n\ - CONSULTA PSICOLOGIA: Anual\n\ - CONSULTA TRABAJO SOCIAL: Anual\n\ - CONSULTA ENFERMERIA: Anual (PF-ITS-AUTOEXAMEN SENO O TESTICULO)";
    }
    
     //mayor a 65 anios
    
    if(EdadMesesCumplidos >= 780){
       Guia65_1 = "\n\ - CONSULTA SALUD ORAL: Semestral\n\ - ACTIVIDAD LÚDICO-EDUCATIVA : Semestral";
    }
    
    if(EdadMesesCumplidos >= 780 && EdadMesesCumplidos <= 791){
       Guia65_2 = "\n\ - CONSULTA OFTALMOLOGICA: 65 y 70 años\n\ - GLICEMIA: 65 y 70 años\n\ - COLESTEROL TOTAL: 65 y 70 años\n\ - COLESTEROL HDL: 65 y 70 años\n\ - TRIGLICERIDOS: 65 y 70 años\n\ - EXAMEN ORINA: 65 y 70 años\n\ - CREATININA: 65 y 70 años";
    }
    
    if(EdadMesesCumplidos >= 840 && EdadMesesCumplidos <= 851){
       Guia65_2 = "\n\ - CONSULTA OFTALMOLOGICA: 65 y 70 años\n\ - GLICEMIA: 65 y 70 años\n\ - COLESTEROL TOTAL: 65 y 70 años\n\ - COLESTEROL HDL: 65 y 70 años\n\ - TRIGLICERIDOS: 65 y 70 años\n\ - EXAMEN ORINA: 65 y 70 años\n\ - CREATININA: 65 y 70 años";
    }
    
    if(EdadMesesCumplidos <= 839){
       Guia65_3 = "\n\ - SANGRE OCULTA EN HECES: Anual hasta los 70 años";
    }
    
    if(EdadMesesCumplidos >= 780 && Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
       Guia65_4 = "\n\ - ANTIGENO PROSTATICO: Anual (Hombres)";
    }
    
    if(EdadMesesCumplidos >= 792 && EdadMesesCumplidos <= 803 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia65_5 = "\n\ - MAMOGRAFIA: a los  66, 68 Y 70";
    }
    
    if(EdadMesesCumplidos >= 816 && EdadMesesCumplidos <= 827 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia65_5 = "\n\ - MAMOGRAFIA: a los  66, 68 Y 70";
    }
    
    if(EdadMesesCumplidos >= 840 && EdadMesesCumplidos <= 851 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia65_5 = "\n\ - MAMOGRAFIA: a los  66, 68 Y 70";
    }
    
    if(EdadMesesCumplidos <= 839 && Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
       Guia65_6 = "\n\ - CITOLOGIA VAGINAL: Anual hasta los 70 años";
    }
    
    if(EdadMesesCumplidos >= 780){
       Guia65_7 = "\n\ - VDRL: Anual (Vida Sexual Activa)";
    }
           
    if(EdadMesesCumplidos >= 780){
       Guia65_8 = "\n\ - CONSULTA NUTRICION: Anual\n\ - CONSULTA PSICOLOGIA: Anual\n\ - CONSULTA TRABAJO SOCIAL: Anual\n\ - CONSULTA ENFERMERIA: Anual (PF-ITS-AUTOEXAMEN SENO O TESTICULO)";
    }
    */
        
    //MENSAJE INGRESO HC
    
    if(EdadMesesCumplidos <= 131){
        //alert("GUIA DE ATENCION ETAREA\n\ATENCION INFANTIL MENORES 10 AÑOS:\n\ " + Guia10_1 + Guia10_2 + Guia10_3 + Guia10_4 + Guia10_5 + Guia10_6 + Guia10_7)
        Ext.getCmp('fsAteInfanitl').setVisible(true)
        Ext.getCmp('strRegistrarAtencionInfantil').setValue("SI")
        Ext.getCmp('fsMaternoPerinatal').setVisible(false)
        Ext.getCmp('strRegistrarMaternoPerinatal').setValue("NO")
        Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
        Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
        Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(false)
        Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("NO")
        Ext.getCmp('fsJoven').setVisible(false)
        Ext.getCmp('strRegistrarJoven').setValue("NO")
        Ext.getCmp('fsAdultoJoven').setVisible(false)
        Ext.getCmp('strRegistrarAdultoJoven').setValue("NO")
        Ext.getCmp('fsAdultoMaduro').setVisible(false)
        Ext.getCmp('strRegistrarAdultoMaduro').setValue("NO")
        Ext.getCmp('fsAnciano').setVisible(false)
        Ext.getCmp('strRegistrarAnciano').setValue("NO")
    }else{
       if(EdadMesesCumplidos >= 132 && EdadMesesCumplidos <= 299){
            //alert("GUIA DE ATENCION ETAREA\n\JOVEN 10 AÑOS A 24 AÑOS:\n\ " + Guia24_1 + Guia24_2 + Guia24_3 + Guia24_4 + Guia24_5 + Guia24_6 + Guia24_7)
            Ext.getCmp('fsAteInfanitl').setVisible(false)
            Ext.getCmp('strRegistrarAtencionInfantil').setValue("NO")
            Ext.getCmp('fsJoven').setVisible(true)
            Ext.getCmp('strRegistrarJoven').setValue("SI")
            Ext.getCmp('fsAdultoJoven').setVisible(false)
            Ext.getCmp('strRegistrarAdultoJoven').setValue("NO")
            Ext.getCmp('fsAdultoMaduro').setVisible(false)
            Ext.getCmp('strRegistrarAdultoMaduro').setValue("NO")
            Ext.getCmp('fsAnciano').setVisible(false)
            Ext.getCmp('strRegistrarAnciano').setValue("NO")
            if(Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
                Ext.getCmp('fsMaternoPerinatal').setVisible(false)
                Ext.getCmp('strRegistrarMaternoPerinatal').setValue("NO")
            }else{
                if(Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
                    Ext.getCmp('fsMaternoPerinatal').setVisible(true)
                    Ext.getCmp('strRegistrarMaternoPerinatal').setValue("SI")
                }else{
                    Ext.getCmp('fsMaternoPerinatal').setVisible(false)
                    Ext.getCmp('strRegistrarMaternoPerinatal').setValue("NO")
                }
            }
            if(Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
                Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
                Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(true)
                Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(true)
                Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("SI")
            }else{
                if(Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
                    Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(true)
                    Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(true)
                    Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
                    Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("SI")
                }else{
                    Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
                    Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
                    Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(false)
                    Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("NO")
                }
            }
        
        }else{
            if(EdadMesesCumplidos >= 300 && EdadMesesCumplidos <= 539){
                //alert("GUIA DE ATENCION ETAREA\n\ADULTO JOVEN 25 AÑOS A 44 AÑOS:\n\ " + Guia44_1 + Guia44_2 + Guia44_3 + Guia44_4 + Guia44_5 + Guia44_6)
                Ext.getCmp('fsAteInfanitl').setVisible(false)
                Ext.getCmp('strRegistrarAtencionInfantil').setValue("NO")
                Ext.getCmp('fsJoven').setVisible(false)
                Ext.getCmp('strRegistrarJoven').setValue("NO")
                Ext.getCmp('fsAdultoJoven').setVisible(true)
                Ext.getCmp('strRegistrarAdultoJoven').setValue("SI")
                Ext.getCmp('fsAdultoMaduro').setVisible(false)
                Ext.getCmp('strRegistrarAdultoMaduro').setValue("NO")
                Ext.getCmp('fsAnciano').setVisible(false)
                Ext.getCmp('strRegistrarAnciano').setValue("NO")
                if(Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
                    Ext.getCmp('fsMaternoPerinatal').setVisible(false)
                    Ext.getCmp('strRegistrarMaternoPerinatal').setValue("NO")
                }else{
                    if(Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
                        Ext.getCmp('fsMaternoPerinatal').setVisible(true)
                        Ext.getCmp('strRegistrarMaternoPerinatal').setValue("SI")
                    }else{
                        Ext.getCmp('fsMaternoPerinatal').setVisible(false)
                        Ext.getCmp('strRegistrarMaternoPerinatal').setValue("NO")
                    }
                }
                if(Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
                    Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
                    Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(true)
                    Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(true)
                    Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("SI")
                }else{
                    if(Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
                        Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(true)
                        Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(true)
                        Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
                        Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("SI")
                    }else{
                        Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
                        Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
                        Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(false)
                        Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("NO")
                    }
                }
            }else{
                if(EdadMesesCumplidos >= 540 && EdadMesesCumplidos <= 779){
                    //alert("GUIA DE ATENCION ETAREA\n\ADULTO MADURO 45 AÑOS A 64 AÑOS:\n\ " + Guia64_1 + Guia64_2 + Guia64_3 + Guia64_4 + Guia64_5 + Guia64_6 + Guia64_7 + Guia64_8 + Guia64_9 + Guia64_10)
                    Ext.getCmp('fsAteInfanitl').setVisible(false)
                    Ext.getCmp('strRegistrarAtencionInfantil').setValue("NO")
                    Ext.getCmp('fsJoven').setVisible(false)
                    Ext.getCmp('strRegistrarJoven').setValue("NO")
                    Ext.getCmp('fsAdultoJoven').setVisible(false)
                    Ext.getCmp('strRegistrarAdultoJoven').setValue("NO")
                    Ext.getCmp('fsAdultoMaduro').setVisible(true)
                    Ext.getCmp('strRegistrarAdultoMaduro').setValue("SI")
                    Ext.getCmp('fsAnciano').setVisible(false)
                    Ext.getCmp('strRegistrarAnciano').setValue("NO")
                    if(Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
                        Ext.getCmp('fsMaternoPerinatal').setVisible(false)
                        Ext.getCmp('strRegistrarMaternoPerinatal').setValue("NO")
                    }else{
                        if(Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
                            Ext.getCmp('fsMaternoPerinatal').setVisible(true)
                            Ext.getCmp('strRegistrarMaternoPerinatal').setValue("SI")
                        }else{
                            Ext.getCmp('fsMaternoPerinatal').setVisible(false)
                            Ext.getCmp('strRegistrarMaternoPerinatal').setValue("NO")
                        }
                    }
                    if(Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
                        Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
                        Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(true)
                        Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(true)
                        Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("SI")
                    }else{
                        if(Ext.getCmp('sysGeneroHC').getValue() == "FEMENINO"){
                            Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(true)
                            Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(true)
                            Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
                            Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("SI")
                        }else{
                            Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
                            Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
                            Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(false)
                            Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("NO")
                        }
                    }
                }else{
                    if(EdadMesesCumplidos >= 780){
                        //alert("GUIA DE ATENCION ETAREA\n\ADULTO MADURO 45 AÑOS A 64 AÑOS:\n\ " + Guia65_1 + Guia65_2 + Guia65_3 + Guia65_4 + Guia65_5 + Guia65_6 + Guia65_7 + Guia65_8)
                        Ext.getCmp('fsAteInfanitl').setVisible(false)
                        Ext.getCmp('strRegistrarAtencionInfantil').setValue("NO")
                        Ext.getCmp('fsJoven').setVisible(false)
                        Ext.getCmp('strRegistrarJoven').setValue("NO")
                        Ext.getCmp('fsAdultoJoven').setVisible(false)
                        Ext.getCmp('strRegistrarAdultoJoven').setValue("NO")
                        Ext.getCmp('fsAdultoMaduro').setVisible(false)
                        Ext.getCmp('strRegistrarAdultoMaduro').setValue("NO")
                        Ext.getCmp('fsAnciano').setVisible(true)
                        Ext.getCmp('strRegistrarAnciano').setValue("SI")
                        Ext.getCmp('fsMaternoPerinatal').setVisible(false)
                        Ext.getCmp('strRegistrarMaternoPerinatal').setValue("NO")
                        Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
                        Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
                        Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(false)
                        Ext.getCmp('strRegistrarPlanificacionFamiliar').setValue("NO")
                    }
                }
            }
        }
    }
}

function fnEliminarRegistrosSuministros01(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}