/*
* @category    Panel Seguimiento Citologia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnSegCitologiaUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    title: '<center>SEGUIMIENTO CITOLOGIA</center> ',
    titleCollapse: false,
    labelWidth:180,
    border: false,
    padding: 5,
    id: 'pnSegCitologia',
    initComponent: function() {
        
        var dataCiclos=[
            ['CICLO 1'],
            ['CICLO 2'],
            ['CICLO 3'],
            ['CICLO 4']
        ];
        var stCiclos = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCiclos.loadData(dataCiclos);
        
        this.items = [
            {
                xtype: 'fieldset',
                layout: 'form',
                anchor: '100%',
                autoHeight: true,
                labelWidth:270,
                padding: 5,
                items:[
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width:100,
                                allowBlank: true,
                                fieldLabel: 'FECHA REGISTRO DE CITOLOGIA EN LA GUIA',
                                id: 'fecRegCitGuia',
                                name: 'FECHA REGISTRO DE CITOLOGIA EN LA GUIA'
                            },
                            {
                                html:'CICLO'
                            },
                            {
                                xtype: 'combo',
                                anchor: '100%',
                                store:stCiclos,
                                forceSelection: true,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                name: 'CICLO',
                                allowBlank: false,
                                emptyText: 'Seleccione...!',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                triggerAction: 'all',
                                mode: 'local',
                                id: 'strCiclo'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        layout: 'table',
                        anchor: '100%',
                        colspan:2,
                        labelWidth:180,
                        autoHeight: true,
                        padding: 5,
                        id: 'paSegCitologia',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width:610,
                                title:'<center>CITOLOGÍA</center>',
                                labelWidth:180,
                                autoHeight: true,
                                padding: 5,
                                id: 'paCitologia',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width:100,
                                        allowBlank: true,
                                        fieldLabel: 'FECHA TOMA DE CITOLOGIA',
                                        name: 'FECHA TOMA DE CITOLOGIA',
                                        id: 'fecCitTomCitologia'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width:400,
                                        allowBlank: true,
                                        fieldLabel: 'RESULTADO CITOLOGIA ',
                                        name: 'RESULTADO CITOLOGIA ',
                                        id: 'strCitResCitologia'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width:400,
                                        allowBlank: true,
                                        fieldLabel: 'CONDUCTA MEDICA',
                                        name: 'CONDUCTA MEDICA',
                                        id: 'strCitConMedica'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                width:610,
                                title:'<center>COLPOSCOPIA</center>',
                                labelWidth:200,
                                autoHeight: true,
                                padding: 5,
                                id: 'paColposcopia',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width:100,
                                        allowBlank: true,
                                        fieldLabel: 'FECHA REALIZACION DE  COLPOSCOPIA CON O SIN BIOPSIA',
                                        name: 'FECHA REALIZACION DE  COLPOSCOPIA CON O SIN BIOPSIA',
                                        id: 'fecColReaColBiopsia'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width:380,
                                        allowBlank: true,
                                        fieldLabel: ' RESULTADO DE LA COLPOSCOPIA  ',
                                        name: ' RESULTADO DE LA COLPOSCOPIA  ',
                                        id: 'strColResColposcopia'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width:380,
                                        allowBlank: true,
                                        fieldLabel: ' RESULTADO DE LA BIOPSIA',
                                        name: ' RESULTADO DE LA BIOPSIA ',
                                        id: 'strColResBiopsia'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width:380,
                                        allowBlank: true,
                                        fieldLabel: 'CONDUCTA',
                                        name: 'CONDUCTA',
                                        id: 'strColConducta'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth:150,
                        padding: 5,
                        items:[
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 100,
                                        allowBlank: true,
                                        fieldLabel: 'FECHA SEGUIMIENTO PYP',
                                        id: 'fecSegPYP',
                                        name: 'FECHA SEGUIMIENTO PYP'
                                    },
                                    {
                                        html:'FASE DE DETECCION'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '20%',
                                        allowBlank: true,
                                        id: 'strFasDeteccion',
                                        name: 'FASE DE DETECCION'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                anchor: '100%',
                autoHeight: true,
                labelWidth:176,
                padding: 5,
                items:[
                    {
                        xtype: 'datefield',
                        width: 100,
                        allowBlank: true,
                        fieldLabel: 'PROXIMA CITA ',
                        id: 'fecProCita',
                        name: 'PROXIMA CITA '
                    },
                    {
                        xtype: 'textfield',
                        anchor: '50%',
                        fieldLabel:'PERIODO DE REPORTE',
                        allowBlank: true,
                        id: 'strPerReporte',
                        name: 'PERIODO DE REPORTE'
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'OBSERVACIONES  REMISIONES ',
                        name: 'OBSERVACIONES  REMISIONES',
                        anchor:'90%',
                        id: 'memObsRemisiones'
                    }
                ]
            }
        ];
        pnSegCitologiaUi.superclass.initComponent.call(this);
    }
});
