/*
* @category    Panel Control PostParto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnPlanificacionFamiliar001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnPlanificacionFamiliar',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 280,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Planificacion Familiar?',
                        name: 'Registrar HC Planificacion Familiar?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarPlanificacionFamiliar',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false);
                                    Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false);
                                    Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(false);
                                }else{
                                    if(Ext.getCmp('sysGeneroHC').getValue() == "MASCULINO"){
                                        Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(false)
                                        Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(true)
                                        Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(true)
                                    }else{
                                        Ext.getCmp('fsPlanificacionFamiliarFinal').setVisible(true)
                                        Ext.getCmp('fsPlanificacionFamiliarMujer').setVisible(true)
                                        Ext.getCmp('fsPlanificacionFamiliarHombre').setVisible(false)
                                    }
                                }
                            }
                        }
                                    
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'EVALUACÓN INTEGRAL PLANIFICACION FAMILIAR HOMBRE',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsPlanificacionFamiliarHombre',
                items: [
                    {
                        xtype: 'panel',
                        title: '<center>DATOS BASICOS PROGRAMA</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnDatosBasicosPlanificacionFamiliaHombre',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Metodo Planificacion',
                                        fieldLabel: 'Metodo Planificacion',
                                        width: 250,
                                        allowBlank: true,
                                        store: stPlanificacionHombres,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarMetodoHombre'
                                    },
                                    {
                                        html: 'Tiempo de Uso'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Tiempo de Uso',
                                        width: 250,
                                        allowBlank: true,
                                        id: 'strPlanificacionFamiliarMetodoHombreTiempo'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>CAMBIO DE METODO</center>',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntPlaFamCambioMetodoHombre',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Cambio de Metodo',
                                        fieldLabel: 'Cambio de Metodo',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarCambioMetodoHombre',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strPlanificacionFamiliarNuevoMetodoHombre').allowBlank = true;
                                                    Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodoHombre').allowBlank = true;
                                                    Ext.getCmp('strPlanificacionFamiliarNuevoMetodoHombre').setValue(null);
                                                    Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodoHombre').setValue(null);
                                                    Ext.getCmp('strPlanificacionFamiliarNuevoMetodoHombre').disable();
                                                    Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodoHombre').disable();
                                                    Ext.getCmp('strPlanificacionFamiliarNuevoMetodoHombre').clearInvalid();
                                                    Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodoHombre').clearInvalid();
                                                    }else{
                                                    Ext.getCmp('strPlanificacionFamiliarNuevoMetodoHombre').enable();
                                                    Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodoHombre').enable();
                                                    Ext.getCmp('strPlanificacionFamiliarNuevoMetodoHombre').allowBlank = false;
                                                    Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodoHombre').allowBlank = false;
                                                    }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Nuevo Metodo:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Nuevo Metodo',
                                        width: 250,
                                        allowBlank: true,
                                        store: stPlanificacionHombres,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarNuevoMetodoHombre'
                                    },
                                    {
                                        html: 'Fecha Cambio:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        name: 'Fecha Cambio Metodo',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecPlanificacionFamiliarFecCambioMetodoHombre'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>EDUCACION</center>',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntPlaFamEducacionHombre',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 2
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Nutricion',
                                                fieldLabel:'Nutricion<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduNutricionHombre'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Ejercicio',
                                                fieldLabel:'Ejercicio<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduEjercicioHombre'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Sexualidad',
                                                fieldLabel:'Sexualidad<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduSexualidadHombre'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'ITS',
                                                fieldLabel:'ITS',
                                                id: 'strPlanificacionFamiliarEduITSHombre'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Testiculo',
                                                fieldLabel:'Autoexamen Testiculo',
                                                id: 'strPlanificacionFamiliarEduAutTesticuloHombre'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Salud Oral',
                                                fieldLabel:'Salud Oral<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduSalOralHombre'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'EVALUACÓN INTEGRAL PLANIFICACION FAMILIAR MUJER',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsPlanificacionFamiliarMujer',
                items: [
                    {
                        xtype: 'panel',
                        title: '<center>DATOS BASICOS PROGRAMA</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnDatosBasicosPlanificacionFamiliarMujer',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Metodo Planificacion',
                                        fieldLabel: 'Metodo Planificacion',
                                        width: 250,
                                        allowBlank: true,
                                        store: 'StoreMetodosPlanificacion',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarMetodoPlanifica'
                                    },
                                    {
                                        html: 'Tolera Metodo'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tolera Metodo',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarToleraMetodo'
                                    },
                                    {
                                        html: 'Transtornos Mestruales'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Transtornos Mestruales',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarTranstornosMestruales'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Cambios Comportamentales',
                                        fieldLabel: 'Cambios Comportamentales',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarCambiosComportamentales'
                                    },
                                    {
                                        html: 'Cefalea'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Cefalea',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarCefalea'
                                    },
                                    {
                                        html: 'Vision Borrosa'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Vision Borrosa',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarVisionBorrosa'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Caida del Cabello',
                                        fieldLabel: 'Caida del Cabello',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarCaidaCabello'
                                    },
                                    {
                                        html: 'Mareos'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Mareos',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarMareos'
                                    },
                                    {
                                        html: 'Manchas en Piel'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Manchas en Piel',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarManchasPiel'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Molestias en Senos',
                                        fieldLabel: 'Molestias en Senos',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarMolestiasSenos'
                                    },
                                    {
                                        html: 'Dolor en Miembros Inferiores'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Dolor en Miembros Inferiores',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarDolorMiembrosInferiores'
                                    },
                                    {
                                        html: 'Edemas'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Edemas',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarEdemas'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Varices',
                                        fieldLabel: 'Varices',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarVarices'
                                    },
                                    {
                                        html: 'Expulsion DIU'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Expulsion DIU',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarExpulsionDIU'
                                    },
                                    {
                                        html: 'Dolor Torax - Brazo'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Edemas',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarDolorToraxBrazo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        name: 'Dolor Bajo Vientre',
                                        fieldLabel: 'Dolor Bajo Vientre',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarDolorBajoVientre'
                                    },
                                    {
                                        html: 'Flujo Vaginal'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Flujo Vaginal',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarFlujoVaginal'
                                    },
                                    {
                                        html: 'Sintomas Urinarios'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Sintomas Urinarios',
                                        width: 60,
                                        allowBlank: true,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strPlanificacionFamiliarSintomasUrinarios'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        anchor: '100%',
                        autoHeight: true,
                        layout: 'form',
                        labelWidth: 260,
                        padding: 5,
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Registrar Indice de Riesgo Reproductivo?',
                                name: 'Registrar Indice de Riesgo Reproductivo?',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'sysRegistrarIndiceRiesgoReproductivo',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('fsPlanificacionFamiliarIndiceRiesgoReproductivo').setVisible(false);
                                            Ext.getCmp('strPlanificacionFamiliarEdadMujer').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarParidad').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarSocioEconomico').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarIntervaloEmbarazos').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarAbortos').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarCesarea').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarMortinato').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarPrematuros').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarHipertension').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarPreclampsia').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarCardiopatia').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarOtraPatologia').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').allowBlank = true;
                                            Ext.getCmp('strPlanificacionFamiliarEdadMujer').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarParidad').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarSocioEconomico').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarIntervaloEmbarazos').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarAbortos').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarCesarea').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarMortinato').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarPrematuros').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarHipertension').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarPreclampsia').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarCardiopatia').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarOtraPatologia').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').setValue(null);
                                            Ext.getCmp('strPlanificacionFamiliarEdadMujer').disable();
                                            Ext.getCmp('strPlanificacionFamiliarParidad').disable();
                                            Ext.getCmp('strPlanificacionFamiliarSocioEconomico').disable();
                                            Ext.getCmp('strPlanificacionFamiliarIntervaloEmbarazos').disable();
                                            Ext.getCmp('strPlanificacionFamiliarAbortos').disable();
                                            Ext.getCmp('strPlanificacionFamiliarCesarea').disable();
                                            Ext.getCmp('strPlanificacionFamiliarMortinato').disable();
                                            Ext.getCmp('strPlanificacionFamiliarPrematuros').disable();
                                            Ext.getCmp('strPlanificacionFamiliarHipertension').disable();
                                            Ext.getCmp('strPlanificacionFamiliarPreclampsia').disable();
                                            Ext.getCmp('strPlanificacionFamiliarCardiopatia').disable();
                                            Ext.getCmp('strPlanificacionFamiliarOtraPatologia').disable();
                                            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').disable();
                                            Ext.getCmp('strPlanificacionFamiliarEdadMujer').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarParidad').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarSocioEconomico').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarIntervaloEmbarazos').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarAbortos').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarCesarea').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarMortinato').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarPrematuros').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarHipertension').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarPreclampsia').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarCardiopatia').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarOtraPatologia').clearInvalid();
                                            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').clearInvalid();
                                        }else{
                                            Ext.getCmp('fsPlanificacionFamiliarIndiceRiesgoReproductivo').setVisible(true);
                                            Ext.getCmp('strPlanificacionFamiliarEdadMujer').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarParidad').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarSocioEconomico').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarIntervaloEmbarazos').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarAbortos').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarCesarea').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarMortinato').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarPrematuros').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarHipertension').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarPreclampsia').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarCardiopatia').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarOtraPatologia').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').allowBlank = false;
                                            Ext.getCmp('strPlanificacionFamiliarEdadMujer').enable();
                                            Ext.getCmp('strPlanificacionFamiliarParidad').enable();
                                            Ext.getCmp('strPlanificacionFamiliarSocioEconomico').enable();
                                            Ext.getCmp('strPlanificacionFamiliarIntervaloEmbarazos').enable();
                                            Ext.getCmp('strPlanificacionFamiliarAbortos').enable();
                                            Ext.getCmp('strPlanificacionFamiliarCesarea').enable();
                                            Ext.getCmp('strPlanificacionFamiliarMortinato').enable();
                                            Ext.getCmp('strPlanificacionFamiliarPrematuros').enable();
                                            Ext.getCmp('strPlanificacionFamiliarHipertension').enable();
                                            Ext.getCmp('strPlanificacionFamiliarPreclampsia').enable();
                                            Ext.getCmp('strPlanificacionFamiliarCardiopatia').enable();
                                            Ext.getCmp('strPlanificacionFamiliarOtraPatologia').enable();
                                            Ext.getCmp('strPlanificacionFamiliarRiesgoTotal').enable();
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Indice de Riesgo Reproductivo',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 5,
                        id: 'fsPlanificacionFamiliarIndiceRiesgoReproductivo',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 2
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 350,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name: 'Edad de la Mujer',
                                                fieldLabel: 'Edad de la Mujer',
                                                width: 200,
                                                allowBlank: true,
                                                store: stEdadMujer,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarEdadMujer',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Paridad',
                                                fieldLabel: 'Paridad',
                                                width: 200,
                                                allowBlank: true,
                                                store: stParidad,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarParidad',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Socio-Economico',
                                                fieldLabel: 'Socio-Economico',
                                                width: 200,
                                                allowBlank: true,
                                                store: stSocioEconomico,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarSocioEconomico',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Intervalo Emb',
                                                fieldLabel: 'Intervalo Emb',
                                                width: 200,
                                                allowBlank: true,
                                                store: stIntervaloEmbarazos,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarIntervaloEmbarazos',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Abortos',
                                                fieldLabel: 'Abortos',
                                                width: 200,
                                                allowBlank: true,
                                                store: stAbortos,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarAbortos',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Cesarea',
                                                fieldLabel: 'Cesarea',
                                                width: 200,
                                                allowBlank: true,
                                                store: stCesarea,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarCesarea',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 350,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name: 'Cesarea',
                                                fieldLabel: 'Cesarea',
                                                width: 200,
                                                allowBlank: true,
                                                store: stMortinato,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarMortinato',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Prematuros',
                                                fieldLabel: 'Prematuros',
                                                width: 200,
                                                allowBlank: true,
                                                store: stPrematuros,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarPrematuros',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Hipertension',
                                                fieldLabel: 'Hipertension',
                                                width: 200,
                                                allowBlank: true,
                                                store: stHipertension,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarHipertension',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Preclampsia',
                                                fieldLabel: 'Preclampsia',
                                                width: 200,
                                                allowBlank: true,
                                                store: stPreclampsia,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarPreclampsia',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Cardiopatia',
                                                fieldLabel: 'Cardiopatia',
                                                width: 200,
                                                allowBlank: true,
                                                store: stCardiopatia,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarCardiopatia',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Otra Patologia',
                                                fieldLabel: 'Otra Patologia',
                                                width: 200,
                                                allowBlank: true,
                                                store: stOtraPatologia,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarOtraPatologia',
                                                listeners:{
                                                    change : function(f,pNew, pOld){
                                                        calculoRiesgoReproductivo()
                                                    }
                                                }
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                html: '<br>'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Riesgo Total',
                                name: 'Riesgo Total',
                                width: 200,
                                readOnly: true,
                                id: 'strPlanificacionFamiliarRiesgoTotal'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>APOYO DIAGNOSTICO</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnApoyoDxPlanificacionFamiliar',
                        items: [
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Citologia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Citologia',
                                        id: 'strPlanificacionFamiliarExamenCitologia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strPlanificacionFamiliarExamenCitologiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenCitologiaFecha').allowBlank = true;
                                                    Ext.getCmp('strPlanificacionFamiliarExamenCitologiaDescripcion').disable();
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenCitologiaFecha').disable();
                                                    Ext.getCmp('strPlanificacionFamiliarExamenCitologiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenCitologiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strPlanificacionFamiliarExamenCitologiaDescripcion').enable();
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenCitologiaFecha').enable();
                                                    Ext.getCmp('strPlanificacionFamiliarExamenCitologiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenCitologiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Citologia Descripcion',
                                        id: 'strPlanificacionFamiliarExamenCitologiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Citologia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecPlanificacionFamiliarExamenCitologiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Prueba de Embarazo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Prueba de Embarazo',
                                        id: 'strPlanificacionFamiliarPruebaEmbarazo',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strPlanificacionFamiliarPruebaEmbarazoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecPlanificacionFamiliarPruebaEmbarazoFecha').allowBlank = true;
                                                    Ext.getCmp('strPlanificacionFamiliarPruebaEmbarazoDescripcion').disable();
                                                    Ext.getCmp('fecPlanificacionFamiliarPruebaEmbarazoFecha').disable();
                                                    Ext.getCmp('strPlanificacionFamiliarPruebaEmbarazoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecPlanificacionFamiliarPruebaEmbarazoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strPlanificacionFamiliarPruebaEmbarazoDescripcion').enable();
                                                    Ext.getCmp('fecPlanificacionFamiliarPruebaEmbarazoFecha').enable();
                                                    Ext.getCmp('strPlanificacionFamiliarPruebaEmbarazoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecPlanificacionFamiliarPruebaEmbarazoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Prueba de Embarazo Descripcion',
                                        id: 'strPlanificacionFamiliarPruebaEmbarazoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Prueba de Embarazo Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecPlanificacionFamiliarPruebaEmbarazoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Frotis Vaginal',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Frotis Vaginal',
                                        id: 'strPlanificacionFamiliarExamenFrotisVaginal',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strPlanificacionFamiliarExamenFrotisVaginalDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenFrotisVaginalFecha').allowBlank = true;
                                                    Ext.getCmp('strPlanificacionFamiliarExamenFrotisVaginalDescripcion').disable();
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenFrotisVaginalFecha').disable();
                                                    Ext.getCmp('strPlanificacionFamiliarExamenFrotisVaginalDescripcion').clearInvalid();
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenFrotisVaginalFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strPlanificacionFamiliarExamenFrotisVaginalDescripcion').enable();
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenFrotisVaginalFecha').enable();
                                                    Ext.getCmp('strPlanificacionFamiliarExamenFrotisVaginalDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecPlanificacionFamiliarExamenFrotisVaginalFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Frotis Vaginal Descripcion',
                                        id: 'strPlanificacionFamiliarExamenFrotisVaginalDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Frotis Vaginal Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecPlanificacionFamiliarExamenFrotisVaginalFecha'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>EDUCACION</center>',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntPlaFamEducacion',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 2
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Nutricion',
                                                fieldLabel:'Nutricion<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduNutricion'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Ejercicio',
                                                fieldLabel:'Ejercicio<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduEjercicio'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Inmunizacion',
                                                fieldLabel:'Inmunizacion<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduInmunizacion'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Sexualidad',
                                                fieldLabel:'Sexualidad<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduSexualidad'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'ITS',
                                                fieldLabel:'ITS',
                                                id: 'strPlanificacionFamiliarEduITS'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Seno',
                                                fieldLabel:'Autoexamen Seno',
                                                id: 'strPlanificacionFamiliarEduAutSeno'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'CA Cervix',
                                                fieldLabel:'CA Cervix',
                                                id: 'strPlanificacionFamiliarEduAutCACervix'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Salud Oral',
                                                fieldLabel:'Salud Oral<br>&nbsp;',
                                                id: 'strPlanificacionFamiliarEduSalOral'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>CAMBIO DE METODO</center>',
                                layout: 'form',
                                anchor: '100%',
                                autoHeight: true,
                                id: 'pnFicIntPlaFamCambioMetodo',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name: 'Cambio de Metodo',
                                                fieldLabel: 'Cambio de Metodo',
                                                width: 60,
                                                allowBlank: true,
                                                store: 'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarCambioMetodo',
                                                listeners:{
                                                    change : function( t, newValue, oldValue){
                                                        if(newValue == "NO"){
                                                            Ext.getCmp('strPlanificacionFamiliarNuevoMetodo').allowBlank = true;
                                                            Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodo').allowBlank = true;
                                                            Ext.getCmp('strPlanificacionFamiliarNuevoMetodo').setValue(null);
                                                            Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodo').setValue(null);
                                                            Ext.getCmp('strPlanificacionFamiliarNuevoMetodo').disable();
                                                            Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodo').disable();
                                                            Ext.getCmp('strPlanificacionFamiliarNuevoMetodo').clearInvalid();
                                                            Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodo').clearInvalid();
                                                            }else{
                                                            Ext.getCmp('strPlanificacionFamiliarNuevoMetodo').enable();
                                                            Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodo').enable();
                                                            Ext.getCmp('strPlanificacionFamiliarNuevoMetodo').allowBlank = false;
                                                            Ext.getCmp('fecPlanificacionFamiliarFecCambioMetodo').allowBlank = false;
                                                            }
                                                    }
                                                }
                                            },
                                            {
                                                html: 'Nuevo Metodo:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Nuevo Metodo',
                                                width: 190,
                                                allowBlank: true,
                                                store: 'StoreMetodosPlanificacion',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'strPlanificacionFamiliarNuevoMetodo'
                                            },
                                            {
                                                html: 'Fecha Cambio:'
                                            },
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                name: 'Fecha Cambio Metodo',
                                                allowBlank: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'fecPlanificacionFamiliarFecCambioMetodo'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'INFORMACION FINAL PLANIFICACION FAMILIAR',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsPlanificacionFamiliarFinal',
                items: [
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Probable Proxima Cita',
                                name: 'Fecha Probable Proxima Cita',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecPlanificacionFamiliarProximaCita'
                            },
                            {
                                html: 'Profesional que Atiende'
                            },
                            {
                                xtype: 'combo',
                                name: 'Profesional que Atiende',
                                width: 250,
                                allowBlank: true,
                                store: stProfesionalAtiende,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strPlanificacionFamiliarProximaCitaProfesionalAtiende'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memPlanificacionFamiliarPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysPlanificacionFamiliarDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysPlanificacionFamiliarDiag').setValue(null);
                                                            Ext.getCmp('sysPlanificacionFamiliarDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysPlanificacionFamiliarDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysPlanificacionFamiliarDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysPlanificacionFamiliarDiag').setValue(null);
                                                        Ext.getCmp('sysPlanificacionFamiliarDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysPlanificacionFamiliarDiag').setValue(null);
                                                Ext.getCmp('sysPlanificacionFamiliarDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysPlanificacionFamiliarDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysPlanificacionFamiliarDiag','sysPlanificacionFamiliarDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnPlanificacionFamiliar001Ui.superclass.initComponent.call(this);
    }
});