/*
* @category    Panel Gestantes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnGestantesUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    title: '<center>GESTANTES</center> ',
    labelWidth:175,
    border: true,
    padding: 5,
    id: 'pnGestantes',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'compositefield',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'datefield',
                        width:100,
                        allowBlank: true,
                        fieldLabel: 'FECHA CONTROLES MEDICOS ',
                        id: 'fecGesConMedicos',
                        name: 'FECHA CONTROLES MEDICOS '
                    },
                    {
                        html:'GUIA ANTICIPATORIA GESTANTE'
                    },
                    {
                        xtype: 'datefield',
                        width:100,
                        name: 'GUIA ANTICIPATORIA GESTANTE',
                        id: 'fecGesGuiAntGestantes'
                    }
                ]
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                anchor: '100%',
                title:'PRIMER CONTROL DE ENFERMERIA ',
                autoHeight: true,
                labelWidth:150,
                padding: 5,
                items:[
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width:100,
                                allowBlank: true,
                                fieldLabel: 'FECHA DE ATENCIÓN  ',
                                id: 'fecGesAtencion',
                                name: 'FECHA DE ATENCIÓN '
                            },
                            {
                                html:'EDAD GESTACIONAL '
                            },
                            {
                                xtype: 'textfield',
                                width:200,
                                name: 'EDAD GESTACIONAL ',
                                id: 'strGesEdaGestacional'
                            },
                            {
                                html:'TENSION ARTERIAL'
                            },
                            {
                                xtype: 'textfield',
                                width:100,
                                name: 'TENSION ARTERIAL',
                                id: 'strGesTesArterial'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        labelWidth:65,
                        border: false,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: true,
                                        fieldLabel: 'PESO (kg)',
                                        name:"PESO (kg)",
                                        emptyText: '(kg)',
                                        id: 'intGesPeso'
                                    },
                                    {
                                        html:'ALTURA UTERINA '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width:200,
                                        allowBlank: true,
                                        id: 'strGesAltUterina',
                                        name: 'ALTURA UTERINA '
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        anchor: '100%',
                                    // store:'StoreSiNo',
                                        fieldLabel:'EDUCACION',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        forceSelection: true,
                                        emptyText: 'Seleccione...!',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        name:'EDUCACION',
                                        id: 'strGesEducacion'
                                    },
                                    {
                                        html:'PRESENCIA SIGNOS DE ALARMA '
                                    },
                                    {
                                        xtype: 'combo',
                                        anchor: '100%',
                                        //store:'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        forceSelection: true,
                                        emptyText: 'Seleccione...!',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        name:'PRESENCIA SIGNOS DE ALARMA ',
                                        id: 'strGesPreSigAlarma'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                layout: 'form',
                anchor: '100%',
                autoHeight: true,
                labelWidth:100,
                padding: 5,
                items:[
                    {
                        xtype: 'fieldset',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        labelWidth:230,
                        padding: 5,
                        items:[
                            {
                                xtype: 'textfield',
                                width:400,
                                allowBlank: true,
                                fieldLabel: 'SEGUIMIENTO REALIZADO AL USUARIO Y RESULTADO  ',
                                name: 'SEGUIMIENTO REALIZADO AL USUARIO Y RESULTADO ',
                                id: 'strPSASegReaUsuResultado'
                            },
                            {
                                xtype: 'datefield',
                                width:100,
                                allowBlank: true,
                                fieldLabel: 'FECHA DEL PROXIMO CONTROL',
                                name: 'FECHA DEL PROXIMO CONTROL',
                                id: 'fecPSASegFecProControl'
                            },
                            {
                                xtype: 'datefield',
                                width:100,
                                allowBlank: true,
                                fieldLabel: 'FECHA SEGUIMIENTO PYP',
                                name: 'FECHA SEGUIMIENTO PYP',
                                id: 'fecPSASegFecSegPYP'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'OBSERVACIONES Y/O REMISIONES ',
                                name: 'OBSERVACIONES  REMISIONES',
                                anchor:'90%',
                                id: 'memPSAObsRemisiones'
                            }
                        ]
                    }
                ]
            }
        ];
        pnGestantesUi.superclass.initComponent.call(this);
    }
});
