/*
* @category    Formulario Materno Perinatal
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCMatParetanalUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Materno Perinatal ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        var dataTrimestre=[
            ['TRIMESTRE I'],
            ['TRIMESTRE II'],
            ['TRIMESTRE III']
        ];
        
        var stTrismestre = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            // AQUI EMPIEZAN CAMBIOS
                                            {
                                                xtype: 'fieldset',
                                                title: 'HISTORIA CLÍNICA MATERNO PERINATAL',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsHisCliMatPerinatal',
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'fsHisCliMatPerinatal1',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        fieldLabel: 'TALLA (cm)',
                                                                        name:"TALLA (cm)",
                                                                        emptyText: '(cm)',
                                                                        id: 'intEF_Talla',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null || pNew == 0){
                                                                                    Ext.getCmp('intEF_Talla').setValue(null);
                                                                                    Ext.getCmp('intEF_IMC').setValue(0);
                                                                                }else{
                                                                                    //peso [kg]/ estatura [m2]
                                                                                    if(Ext.getCmp('intEF_Peso').getValue() > 0){
                                                                                        var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                        Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                                    }else{
                                                                                        Ext.getCmp('intEF_IMC').setValue(0);
                                                                                    }
                                                                                }
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                                Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                                }else{
                                                                                    if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                        Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                        }else{
                                                                                            Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                        }

                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysEF02',
                                                                        value: 'PESO (Kg): '
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 100,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        emptyText: '(Kg)',
                                                                        name:"PESO (Kg)",
                                                                        id: 'intEF_Peso',
                                                                        listeners:{
                                                                            change : function(f,pNew, pOld){
                                                                                if(pNew == null || pNew == 0){
                                                                                    Ext.getCmp('intEF_Peso').setValue(null);
                                                                                    Ext.getCmp('intEF_IMC').setValue(0);
                                                                                }else{
                                                                                    //peso [kg]/ estatura [m2]
                                                                                    if(Ext.getCmp('intEF_Talla').getValue() > 0){
                                                                                        var pTalla = Ext.getCmp('intEF_Talla').getValue() / 100;
                                                                                        Ext.getCmp('intEF_IMC').setValue(Ext.getCmp('intEF_Peso').getValue()/(pTalla*pTalla));
                                                                                    }else{
                                                                                        Ext.getCmp('intEF_IMC').setValue(0);
                                                                                    }
                                                                                }
                                                                                if(Ext.getCmp('intEF_IMC').getValue()<1){
                                                                                Ext.getCmp('strEF_IMCClasificacon').setValue(null);
                                                                                }else{
                                                                                    if(Ext.getCmp('intEF_IMC').getValue()<24.9){
                                                                                    Ext.getCmp('strEF_IMCClasificacon').setValue("ACEPTABLE");
                                                                                    }else{
                                                                                        if(Ext.getCmp('intEF_IMC').getValue()<29.9){
                                                                                        Ext.getCmp('strEF_IMCClasificacon').setValue("SOBREPESO");
                                                                                        }else{
                                                                                            Ext.getCmp('strEF_IMCClasificacon').setValue("OBESIDAD");
                                                                                        }

                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'ESTADO CIVIL',
                                                                        fieldLabel:'ESTADO CIVIL',
                                                                        width: 100,
                                                                        height: 22,
                                                                        id: 'strHisCliMatPerEstCivil'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysHisCliMatPerOcupacion',
                                                                        value: 'OCUPACIÓN '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'OCUPACION',
                                                                        width: 100,
                                                                        height: 22,
                                                                        id: 'strHisCliMatPerOcupacion'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysHisCliMatPerNivEducativo',
                                                                        value: 'NIVEL EDUCATIVO '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'NIVEL EDUCATIVO',
                                                                        width: 100,
                                                                        height: 22,
                                                                        id: 'strisCliMatPerNivEducativo'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'PROCEDENCIA',
                                                                        fieldLabel:'PROCEDENCIA',
                                                                        width: 100,
                                                                        height: 22,
                                                                        id: 'strHisCliMatPerProcedencia'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysHisCliMatPerDireccion',
                                                                        value: 'DIRECCIÓN '
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'DIRECCION',
                                                                        width: 100,
                                                                        height: 22,
                                                                        id: 'strHisCliMatPerDireccion'
                                                                    }
                                                                ]
                                                            },
                                                            {   
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'FUM',
                                                                        fieldLabel:'FUM',
                                                                        width: 60,
                                                                        height: 22,
                                                                        id: 'strHisCliMatPerFUM'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysHisCliMatPerFPP',
                                                                        value: 'FPP'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'FPP',
                                                                        width: 100,
                                                                        height: 22,
                                                                        id: 'strHisCliMatPerFPP'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysHisCliMatPerFPP',
                                                                        value: 'FUM'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'FUM',
                                                                        width: 100,
                                                                        height: 22,
                                                                        id: 'strHisCliMatPerFUM'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        anchor: '100%',
                                                        forceSelection: true,
                                                        emptyText: 'Seleccione...!',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        listEmptyText: '',
                                                        triggerAction: 'all',
                                                        store:stTrismestre,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        fieldLabel: 'TRIMESTRE ACTUAL',
                                                        name:'TRIMESTRE ACTUAL',
                                                        id: 'strHisCliMatPerTriActual'
                                                    },
                                                    {   
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'ANTECEDENTES FAMILIARES',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'fsHisCliMatPerAntFamiliares',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'HTA CRONICA',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        name:'HTA CRONICA',
                                                                        id: 'strAntFamHTACronica'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'DIABETES',
                                                                        name:'DIABETES',
                                                                        id: 'strAntFamDiabetes'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'GEMELARES',
                                                                        name:'GEMELARES',
                                                                        id: 'strAntFamGemerales'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'CARDIOPATIA',
                                                                        name:'CARDIOPATIA',
                                                                        id: 'strAntFamCardiopatia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'TBC',
                                                                        name:'TBC',
                                                                        id: 'strAntFamTBC'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'OTROS',
                                                                        name:'OTROS',
                                                                        id: 'strAntFamOtros'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'ANTECEDENTES PERSONALES',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'fsHisCliMatPerAntPersonales',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'TBC',
                                                                        name:'TBC',
                                                                        id: 'strAntPerTBC'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'DIABETES',
                                                                        name:'DIABETES',
                                                                        id: 'strAntPerDiabetes'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'HTA CRONICA',
                                                                        name:'HTA CRONICA',
                                                                        id: 'strAntPerHTACronica'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'CX PERLVICO UTERINAS',
                                                                        name:'CX PERLVICO UTERINAS',
                                                                        id: 'strAntPerCXPerUterinas'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'SHAE',
                                                                        name:'SHAE',
                                                                        id: 'strAntPerSHAE'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'ALERGICOS',
                                                                        name:'ALERGICOS',
                                                                        id: 'strAntPerAlergicos'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'TABAQUISMO',
                                                                        name:'TABAQUISMO',
                                                                        id: 'strAntPerTabaquismo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'ANTITETANICA PREVIA',
                                                                        name:'ANTITETANICA PREVIA',
                                                                        id: 'strAntPerAntPrevia'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        anchor: '100%',
                                                                        store:'StoreSiNo',
                                                                        forceSelection: true,
                                                                        emptyText: 'Seleccione...!',
                                                                        mode: 'local',
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        listEmptyText: '',
                                                                        triggerAction: 'all',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        fieldLabel: 'OTROS',
                                                                        name:'OTROS',
                                                                        id: 'strAntPerOtros'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'AGO',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'fsHisCliMatPerAGO',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'G',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"G",
                                                                        id: 'intAGOG'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'P',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"P",
                                                                        id: 'intAGOP'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'C',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"C",
                                                                        id: 'intAGOC'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'A',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"A",
                                                                        id: 'intAGOA'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'E',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"R",
                                                                        id: 'intAGOE'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'V',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"V",
                                                                        id: 'intAGOV'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'M',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"M",
                                                                        id: 'intAGOM'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        maxValue: 250,
                                                                        fieldLabel: 'RPM',
                                                                        decimalPrecision: 2,
                                                                        allowBlank: true,
                                                                        name:"RPM",
                                                                        id: 'intAGORPM'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsHisCliMatPerAGO1',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'MENARQUIA',
                                                                                fieldLabel:'MENARQUIA',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1Menarquia'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'CICLOS REGULARES',
                                                                                fieldLabel:'CICLOS REGULARES',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1CilRegulares'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'PF',
                                                                                fieldLabel:'PF',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1PF'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'LEUCORREAS',
                                                                                fieldLabel:'LEUCORREAS',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1Leucorreas'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'ITS',
                                                                                fieldLabel:'ITS',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1ITS'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'CITOLOGIAS',
                                                                                fieldLabel:'CITOLOGIAS',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1Citologias'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'P.INTERGENESICO',
                                                                                fieldLabel:'P.INTERGENESICO',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1PIntergenesico'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'HC DE INFERTILIDAD',
                                                                                fieldLabel:'HC DE INFERTILIDAD',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1HCIngerfertilidad'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'AMENAZA DE ABORTO',
                                                                                fieldLabel:'AMENAZA DE ABORTO',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO1AmeAborto'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'AGO',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsHisCliMatPerAGO2',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'RCIU',
                                                                                fieldLabel:'RCIU',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO2RCIU'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'APP',
                                                                                fieldLabel:'APP',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO2APP'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'PARTO PREMATURO',
                                                                                fieldLabel:'PARTO PREMATURO',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGOParPrematuro'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'GEMELAR',
                                                                                fieldLabel:'GEMELAR',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO2Gemelar'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'MALFORMACIONES',
                                                                                fieldLabel:'MALFORMACIONES',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO2Malformaciones'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'POLIHIDRAMNIOS',
                                                                                fieldLabel:'POLIHIDRAMNIOS',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO2Polihidramnios'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'OLOGOHIDRAMNIOS',
                                                                                fieldLabel:'OLOGOHIDRAMNIOS',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO2Olohidramnios'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'EMB.PROLONGADO',
                                                                                fieldLabel:'EMB.PROLONGADO',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO2EMBProlongado'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'OTROS',
                                                                                fieldLabel:'OTROS',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strAGO2Otros'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        name:'OBSERVACIONES',
                                                        fielLabel:'OBSERVACIONES',
                                                        width: 625,
                                                        height: 22,
                                                        id: 'memHisCliMatPerObservaciones'
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'TAMIZAJE CLINICO Y DE LABORATORIO',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        id: 'fsHisCliMatPerTamCliLaboratorio',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'GRUPO Y RH',
                                                                        fieldLabel:'GRUPO Y RH',
                                                                        width: 60,
                                                                        height: 22,
                                                                        id: 'strTamCliLabGruRH'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysTamCliLabGlicemia',
                                                                        value: 'GLICEMIA'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'GLICEMIA',
                                                                        width: 60,
                                                                        height: 22,
                                                                        id: 'strTamCliLabGlicemia'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysTamCliLabTesSullivan',
                                                                        value: 'TEST DE O´SULLIVAN'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'TEST DE O´SULLIVAN',
                                                                        width: 60,
                                                                        height: 22,
                                                                        id: 'strTamCliLabTesSullivan'
                                                                    },
                                                                    {
                                                                        xtype: 'displayfield',
                                                                        id: 'sysTamCliLabCTG',
                                                                        value: 'CTG'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name:'CTG',
                                                                        width: 60,
                                                                        height: 22,
                                                                        id: 'strTamCliLabCTG'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsHisCliMatPerTamCliLaboratorio1',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'HB',
                                                                                fieldLabel:'HB',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab1HB'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'HCTO',
                                                                                fieldLabel:'HCTO',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab1HCTO'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'VDRL',
                                                                                fieldLabel:'VDRL',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab1VDRL'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'FROTIS VAGINAL',
                                                                                fieldLabel:'FROTIS VAGINAL',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab1FroVaginal'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'P.ORINA',
                                                                                fieldLabel:'P.ORINA',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab1POrina'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'ECO',
                                                                                fieldLabel:'ECO',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab1ECO'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsHisCliMatPerTamCliLaboratorio2',
                                                                        items: [
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'UROCULTIVO',
                                                                                fieldLabel:'UROCULTIVO',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab2Ugrocultivo'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'FTA - ABS',
                                                                                fieldLabel:'FTA - ABS',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab2FTAABS'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'TD',
                                                                                fieldLabel:'TD',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab2TD'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'HIV',
                                                                                fieldLabel:'HIV',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab2HIV'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                name:'OTROS',
                                                                                fieldLabel:'OTROS',
                                                                                width: 60,
                                                                                height: 22,
                                                                                id: 'strCliLab2Otros'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]                                                
                                            },
                                            // AQUI FINALIZAN CAMBIOS 
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCMatParetanalUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
