/*
* @category    Formulario Estados Del Desarrollo y Guias Anticipatorias 
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCEstDesaGuiAnticipatoriasUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC - Estados Del Desarrollo y Guias Anticipatorias ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: myPaciente,
                    pCAS: myCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 90,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                width: 100,
                                id: 'sysLegalizaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysAutorizacionHC',
                                value: 'Nro Autorización: '
                            },
                            {
                                xtype: 'textfield',
                                width: 210,
                                allowBlank: true,
                                style: 'color:brown;',
                                readOnly: true,
                                id: 'sysNroAutorizacionHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                html: 'Fecha Nacimiento'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFecNacPacHC'
                            },
                            {
                                html: 'Edad'
                            },
                            {
                                xtype: 'textfield',
                                width: 250,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadPacHC'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        width: 930,
                        autoHeight: true,
                        border: false,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            // AQUI EMPIEZAN CAMBIOS
                                            {
                                                xtype: 'panel',
                                                title: 'ESTADOS DEL DESARROLLO Y GUIAS ANTICIPATORIAS',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                colspan:2,
                                                autoHeight: true,
                                                id: 'paEstDesGuiAnticipatorias',
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: 'ESTADOS DEL DESARROLLO',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        colspan:2,
                                                        autoHeight: true,
                                                        id: 'paEstDesarrollo',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                colspan:2,
                                                                autoHeight: true,
                                                                id: 'paEstDes10',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'FISICO',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsFisico',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'ETAPAS DE TANNER 1 Y 2*.',
                                                                                fieldLabel: 'ETAPAS DE TANNER 1 Y 2*. ',
                                                                                allowBlank: true,
                                                                                id: 'bolFisEtaTanner'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'MENARCA Y EYACULACIÓN.',
                                                                                fieldLabel: 'MENARCA Y EYACULACIÓN. ',
                                                                                allowBlank: true,
                                                                                id: 'bolFisMenEyaculacion'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'INCREMENTO TAMAÑO CORPORAL, TORPEZA',
                                                                                fieldLabel: 'INCREMENTO TAMAÑO CORPORAL, TORPEZA',
                                                                                allowBlank: true,
                                                                                id: 'bolFisIncTamCorTorpeza'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PSICOSEXUAL:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPsicosexual',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'RELACIONES CON GRUPOS DE PARES (MISMO SEXO)',
                                                                                fieldLabel: 'RELACIONES CON GRUPOS DE PARES (MISMO SEXO)',
                                                                                allowBlank: true,
                                                                                id: 'bolPsiRelGruPares'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PSICOSOCIAL:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPsicosocial',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'APARICIÓN DE CONFLICTOS CON LOS PADRES.',
                                                                                fieldLabel: 'APARICIÓN DE CONFLICTOS CON LOS PADRES. ',
                                                                                allowBlank: true,
                                                                                id: 'bolSocApaConPadres'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CONFUSIÓN ACERCA DE SU ROL (ÉL O ELLA).',
                                                                                fieldLabel: 'CONFUSIÓN ACERCA DE SU ROL (ÉL O ELLA).',
                                                                                allowBlank: true,
                                                                                id: 'bolSocConAceRol'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'COGNITIVO.:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsCognitivo',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'PUEDEN COMENZAR EL PENSAMIENTO ABSTRACTO',
                                                                                fieldLabel: 'PUEDEN COMENZAR EL PENSAMIENTO ABSTRACTO ',
                                                                                allowBlank: true,
                                                                                id: 'bolCogComPenAbstracto'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                colspan:2,
                                                                autoHeight: true,
                                                                id: 'paEstDes14',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'FÍSICO:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsFisico14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'ETAPAS DE TANNER 3 Y 4*.',
                                                                                fieldLabel: 'ETAPAS DE TANNER 3 Y 4*. ',
                                                                                allowBlank: true,
                                                                                id: 'bolFisEtaTanner34'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PSICOSEXUAL:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPsicosexual14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'INTERÉS HETEROSESUAL',
                                                                                fieldLabel: 'INTERÉS HETEROSESUAL',
                                                                                allowBlank: true,
                                                                                id: 'bolPsiIntHeterosesual'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PSICOSOCIAL:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPsicosocial14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'REBELIÓN / ALEJAMIENTO DE LAS ACTIVIDADES FAMILIARES',
                                                                                fieldLabel: 'REBELIÓN / ALEJAMIENTO DE LAS ACTIVIDADES FAMILIARES ',
                                                                                allowBlank: true,
                                                                                id: 'bolSocRebAleActFamiliares'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CAMBIO CONTINUO EN LA IDENTIDAD INDIVIDUAL',
                                                                                fieldLabel: 'CAMBIO CONTINUO EN LA IDENTIDAD INDIVIDUAL',
                                                                                allowBlank: true,
                                                                                id: 'bolSocCamConIdeIndividual'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'VALORES REGLAS Y SEGURIDAD DENTRO DE SU  GRUPO DE PARES (ÉL O ELLA).',
                                                                                fieldLabel: 'VALORES REGLAS Y SEGURIDAD DENTRO DE SU  GRUPO DE PARES (ÉL O ELLA).',
                                                                                allowBlank: true,
                                                                                id: 'bolSocValRegSegDenGruPares'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'COGNITIVO.:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsCognitivo14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'PENSAMIENTO ABSTRACTO, RAZONAMIENTO COMPLEJO (CRÍTICA).',
                                                                                fieldLabel: 'PENSAMIENTO ABSTRACTO, RAZONAMIENTO COMPLEJO (CRÍTICA).',
                                                                                allowBlank: true,
                                                                                id: 'bolCogPenAbsRazComplejo'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                colspan:2,
                                                                autoHeight: true,
                                                                id: 'paEstDes16',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'FÍSICO:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsFisico16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'ETAPAS DE TANNER 5*.',
                                                                                fieldLabel: 'ETAPAS DE TANNER 5*. ',
                                                                                allowBlank: true,
                                                                                id: 'bolFisEtaTanner5'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PSICOSEXUAL:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPsicosexual16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'IMÁGEN CORPORAL / ROL DE GÉNERO ASEGURADO',
                                                                                fieldLabel: 'IMÁGEN CORPORAL / ROL DE GÉNERO ASEGURADO',
                                                                                allowBlank: true,
                                                                                id: 'bolPsiImaCorRolGenAsegurado'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'RELACIONES CERCANAS / AMOR.',
                                                                                fieldLabel: 'RELACIONES CERCANAS / AMOR.',
                                                                                allowBlank: true,
                                                                                id: 'bolPsiRelCerAmor'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PSICOSOCIAL:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPsicosocial16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'RELACIONES NO DEPENDIENTES CON MIEMBROS DE LA FAMILIA',
                                                                                fieldLabel: 'RELACIONES NO DEPENDIENTES CON MIEMBROS DE LA FAMILIA ',
                                                                                allowBlank: true,
                                                                                id: 'bolSocRelaDepMieFamilia'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'COGNITIVO.:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsCognitivo16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'RAZONAMIENTO COMPLEJO, FLEXIBILIDAD Y FORMACIÓN DE HIPÓTESIS.',
                                                                                fieldLabel: 'RAZONAMIENTO COMPLEJO, FLEXIBILIDAD Y FORMACIÓN DE HIPÓTESIS.',
                                                                                allowBlank: true,
                                                                                id: 'bolCogRazComFleForHipotesis'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'fieldset',
                                                                title: 'PSICOSOCIAL:',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                autoHeight: true,
                                                                id: 'fsPsicosocial21',
                                                                items: [
                                                                    {   
                                                                        xtype: 'checkbox',
                                                                        name: 'CONSOLIDACIÓN DEL ROL',
                                                                        fieldLabel: 'CONSOLIDACIÓN DEL ROL',
                                                                        allowBlank: true,
                                                                        id: 'bolSocConRol'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: 'GUIAS ANTIPATORIAS',
                                                        layout: 'form',
                                                        collapsible: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        colspan:2,
                                                        autoHeight: true,
                                                        id: 'paGuiAnticipatorias',
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                colspan:2,
                                                                autoHeight: true,
                                                                id: 'paGuiAnt10',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PACIENTE:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPaciente',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CONSEJERO DE CONFIANZA, COMPORTAMIENTO EN EL COLEGIO, RELACIONES FAMILIARES.',
                                                                                fieldLabel: 'CONSEJERO DE CONFIANZA, COMPORTAMIENTO EN EL COLEGIO, RELACIONES FAMILIARES.',
                                                                                allowBlank: true,
                                                                                id: 'bolPacConComColRelFamiliares'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'EDUCACIÓN SEXUAL:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsEduSexual',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CAMBIOS FÍSICOS, REPRODUCCIÓN.',
                                                                                fieldLabel: 'CAMBIOS FÍSICOS, REPRODUCCIÓN.',
                                                                                allowBlank: true,
                                                                                id: 'bolEduSexCamFisReproduccion'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'SUBSTANCIAS:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsSubstancias',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'USO Y ABUSO.',
                                                                                fieldLabel: 'USO Y ABUSO.',
                                                                                allowBlank: true,
                                                                                id: 'bolSubUsoAbuso'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'NUTRICIÓN:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsNutricion',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'LIMITAR GOLOSINAS, GRASAS, BUENA INGESTA DE HIERRO',
                                                                                fieldLabel: 'LIMITAR GOLOSINAS, GRASAS, BUENA INGESTA DE HIERRO',
                                                                                allowBlank: true,
                                                                                id: 'bolNutLimGolGraBueIngHierro'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PADRES:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPadre',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CONFIDENCIAL O CONFIANZA.',
                                                                                fieldLabel: 'CONFIDENCIAL O CONFIANZA.',
                                                                                allowBlank: true,
                                                                                id: 'bolPadConConfianza'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'EDUCACIÓN DEL DESARROLLO DEL ADOLESCENTE.',
                                                                                fieldLabel: 'EDUCACIÓN DEL DESARROLLO DEL ADOLESCENTE.',
                                                                                allowBlank: true,
                                                                                id: 'bolPadEduDesAdolescente'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'COLOCAR LÍMITES (REGLAS JUSTAS).',
                                                                                fieldLabel: 'COLOCAR LÍMITES (REGLAS JUSTAS).',
                                                                                allowBlank: true,
                                                                                id: 'bolPadColLimites'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                colspan:2,
                                                                autoHeight: true,
                                                                id: 'paGuiAnt14',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PACIENTE:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPaciente14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'PROGRAMA CITAS APARTE DE LOS PADRES, COMPORTA- MIENTO Y DESEMPEÑO EN EL COLEGIO; RELACIONES CON LA FAMILIA',
                                                                                fieldLabel: 'PROGRAMA CITAS APARTE DE LOS PADRES, COMPORTA- MIENTO Y DESEMPEÑO EN EL COLEGIO; RELACIONES CON LA FAMILIA',
                                                                                allowBlank: true,
                                                                                id: 'bolPacProCitApaPadres'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'EDUCACIÓN SEXUAL::',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsEduSexual14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CONTROL DE LA FERTILIDAD, E.T.S.',
                                                                                fieldLabel: 'CONTROL DE LA FERTILIDAD, E.T.S.',
                                                                                allowBlank: true,
                                                                                id: 'bolEduSexConFertilidadETS'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'AUTOEXÁMEN:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsAutExamen14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'MAMAS Y TESTÍCULOS',
                                                                                fieldLabel: 'MAMAS Y TESTÍCULOS',
                                                                                allowBlank: true,
                                                                                id: 'bolAutExaMamTesticulos'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'SUBSTANCIAS::',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsSubstancias14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'USO Y ABUSO; PRESIÓN BALANCEADA.',
                                                                                fieldLabel: 'USO Y ABUSO; PRESIÓN BALANCEADA.',
                                                                                allowBlank: true,
                                                                                id: 'bolSubUsoAbuPreBalanceada'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'NUTRICIÓN:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsNutricion14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'GRASAS, DIETA BIEN BALANCEADA',
                                                                                fieldLabel: 'GRASAS, DIETA BIEN BALANCEADA',
                                                                                allowBlank: true,
                                                                                id: 'bolNutGraDieBalanceada'
                                                                            }
                                                                        ]
                                                                    } ,
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PADRES:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPadre14',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'INCREMENTO EN LA INDEPENDENCIA, TEMERARIO, IMPRUDENTE',
                                                                                fieldLabel: 'INCREMENTO EN LA INDEPENDENCIA, TEMERARIO, IMPRUDENTE',
                                                                                allowBlank: true,
                                                                                id: 'bolPadIncIndTemImprudente'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'VARIACIONES EN ACTIVIDADES QUE LO  AFECTAN.',
                                                                                fieldLabel: 'VARIACIONES EN ACTIVIDADES QUE LO  AFECTAN.',
                                                                                allowBlank: true,
                                                                                id: 'bolPadVarActAfectan'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                colspan:2,
                                                                autoHeight: true,
                                                                id: 'paGuiAnt16',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PACIENTE:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPaciente16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'REVISIÓN DE PLANES Y ESCOGENCIA DE CARRERA.',
                                                                                fieldLabel: 'REVISIÓN DE PLANES Y ESCOGENCIA DE CARRERA.',
                                                                                allowBlank: true,
                                                                                id: 'bolPacRevPlaEscCarrera'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'RELACIONES EN GRUPOS DE PARTES.',
                                                                                fieldLabel: 'RELACIONES EN GRUPOS DE PARTES.',
                                                                                allowBlank: true,
                                                                                id: 'bolPacRelaGruPartes'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CITAS CON NOVIOS / NOVIAS.',
                                                                                fieldLabel: 'CITAS CON NOVIOS / NOVIAS.',
                                                                                allowBlank: true,
                                                                                id: 'bolPacCitNovNovias'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'EDUCACIÓN SEXUAL::',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsEduSexual16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CONTROL DE LA FERTILIDAD, E.T.S., EMBARAZO',
                                                                                fieldLabel: 'CONTROL DE LA FERTILIDAD, E.T.S., EMBARAZO',
                                                                                allowBlank: true,
                                                                                id: 'bolEduSexConFerETSEmbarazo'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'SUBSTANCIAS::',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsSubstancias16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'USO Y ABUSO',
                                                                                fieldLabel: 'USO Y ABUSO',
                                                                                allowBlank: true,
                                                                                id: 'bolSubUsoAbuso'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'NUTRICIÓN:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsNutricion16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'GRASAS, DIETA BIEN BALANCEADA.',
                                                                                fieldLabel: 'GRASAS, DIETA BIEN BALANCEADA.',
                                                                                allowBlank: true,
                                                                                id: 'bolNutGraDieBieBalanceada'
                                                                            }
                                                                        ]
                                                                    } ,
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'PADRES:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsPadre16',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'ACEPTACIÓN DE LA SEXUALIDAD.',
                                                                                fieldLabel: 'ACEPTACIÓN DE LA SEXUALIDAD.',
                                                                                allowBlank: true,
                                                                                id: 'bolPadAceSexualidad'
                                                                            },
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'SOPORTE DE LA INDIVIDUALIDAD.',
                                                                                fieldLabel: 'SOPORTE DE LA INDIVIDUALIDAD.',
                                                                                allowBlank: true,
                                                                                id: 'bolPadSopIndividual'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                collapsible: true,
                                                                titleCollapse: true,
                                                                anchor: '100%',
                                                                colspan:2,
                                                                autoHeight: true,
                                                                id: 'paGuiAnt21',
                                                                items: [
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'EDUCACIÓN SEXUAL::',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsEduSexual21',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'CONTROL DE LA FERTILIDAD, E.T.S., EMBARAZO',
                                                                                fieldLabel: 'CONTROL DE LA FERTILIDAD, E.T.S., EMBARAZO',
                                                                                allowBlank: true,
                                                                                id: 'bolEduSexConFerETSEmbarazo21'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'SUBSTANCIAS:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsSubstancias21',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'USO Y ABUSO',
                                                                                fieldLabel: 'USO Y ABUSO',
                                                                                allowBlank: true,
                                                                                id: 'bolSubUsoAbuso21'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'fieldset',
                                                                        title: 'NUTRICIÓN:',
                                                                        layout: 'form',
                                                                        collapsible: true,
                                                                        titleCollapse: true,
                                                                        anchor: '100%',
                                                                        autoHeight: true,
                                                                        id: 'fsNutricion21',
                                                                        items: [
                                                                            {   
                                                                                xtype: 'checkbox',
                                                                                name: 'GRASAS, DIETA BIEN BALANCEADA.',
                                                                                fieldLabel: 'GRASAS, DIETA BIEN BALANCEADA.',
                                                                                allowBlank: true,
                                                                                id: 'bolNutGraDieBieBalanceada21'
                                                                            }
                                                                        ]
                                                                    } 
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]                                                
                                            },
                                            // AQUI FINALIZAN CAMBIOS 
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0]);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 352,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            }
                            /*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud CTC',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaCTC',
                                items: [
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    if (Ext.getCmp('sysUsaGridSalida').getValue() == 1){
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                    }
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistros();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCEstDesaGuiAnticipatoriasUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
