/*
* @category    Panel Control PostParto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnJoven001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnJoven',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 280,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Joven (10 a 24 años)?',
                        name: 'Registrar HC Joven (10 a 24 años)?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarJoven',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsJoven').setVisible(false);
                                    Ext.getCmp('strJovenExamenOptometrico').allowBlank = true;
                                    Ext.getCmp('strJovenExamenHemoglobina').allowBlank = true;
                                    Ext.getCmp('strJovenExamenGlicemia').allowBlank = true;
                                    Ext.getCmp('strJovenExamenPerfilLipidico').allowBlank = true;
                                    Ext.getCmp('strJovenExamenSerologiaVDRL').allowBlank = true;
                                    Ext.getCmp('strJovenExamenCitologia').allowBlank = true;
                                    Ext.getCmp('strJovenEduNutricion').allowBlank = true;
                                    Ext.getCmp('strJovenEduEjercicio').allowBlank = true;
                                    Ext.getCmp('strJovenEduTieLib').allowBlank = true;
                                    Ext.getCmp('strJovenEduSexualidad').allowBlank = true;
                                    Ext.getCmp('strJovenEduEstadosDesarrollo').allowBlank = true;
                                    Ext.getCmp('strJovenEduAlcTabDro').allowBlank = true;
                                    Ext.getCmp('strJovenEduAutSeno').allowBlank = true;
                                    Ext.getCmp('strJovenEduAutTestÃ­culos').allowBlank = true;
                                    Ext.getCmp('strJovenEduSalOral').allowBlank = true;
                                    Ext.getCmp('strJovenEduInmunizacion').allowBlank = true;
                                    Ext.getCmp('fecJovenProximaCita').allowBlank = true;
                                    Ext.getCmp('strjovenProximaCitaProfesionalAtiende').allowBlank = true;
                                    Ext.getCmp('memJovenPlan').allowBlank = true;
                                    Ext.getCmp('strJovenExamenOptometrico').setValue(null);
                                    Ext.getCmp('strJovenExamenHemoglobina').setValue(null);
                                    Ext.getCmp('strJovenExamenGlicemia').setValue(null);
                                    Ext.getCmp('strJovenExamenPerfilLipidico').setValue(null);
                                    Ext.getCmp('strJovenExamenSerologiaVDRL').setValue(null);
                                    Ext.getCmp('strJovenExamenCitologia').setValue(null);
                                    Ext.getCmp('strJovenEduNutricion').setValue(null);
                                    Ext.getCmp('strJovenEduEjercicio').setValue(null);
                                    Ext.getCmp('strJovenEduTieLib').setValue(null);
                                    Ext.getCmp('strJovenEduSexualidad').setValue(null);
                                    Ext.getCmp('strJovenEduEstadosDesarrollo').setValue(null);
                                    Ext.getCmp('strJovenEduAlcTabDro').setValue(null);
                                    Ext.getCmp('strJovenEduAutSeno').setValue(null);
                                    Ext.getCmp('strJovenEduAutTestÃ­culos').setValue(null);
                                    Ext.getCmp('strJovenEduSalOral').setValue(null);
                                    Ext.getCmp('strJovenEduInmunizacion').setValue(null);
                                    Ext.getCmp('fecJovenProximaCita').setValue(null);
                                    Ext.getCmp('strjovenProximaCitaProfesionalAtiende').setValue(null);
                                    Ext.getCmp('memJovenPlan').setValue(null);
                                    Ext.getCmp('strJovenExamenOptometrico').disable();
                                    Ext.getCmp('strJovenExamenHemoglobina').disable();
                                    Ext.getCmp('strJovenExamenGlicemia').disable();
                                    Ext.getCmp('strJovenExamenPerfilLipidico').disable();
                                    Ext.getCmp('strJovenExamenSerologiaVDRL').disable();
                                    Ext.getCmp('strJovenExamenCitologia').disable();
                                    Ext.getCmp('strJovenEduNutricion').disable();
                                    Ext.getCmp('strJovenEduEjercicio').disable();
                                    Ext.getCmp('strJovenEduTieLib').disable();
                                    Ext.getCmp('strJovenEduSexualidad').disable();
                                    Ext.getCmp('strJovenEduEstadosDesarrollo').disable();
                                    Ext.getCmp('strJovenEduAlcTabDro').disable();
                                    Ext.getCmp('strJovenEduAutSeno').disable();
                                    Ext.getCmp('strJovenEduAutTestÃ­culos').disable();
                                    Ext.getCmp('strJovenEduSalOral').disable();
                                    Ext.getCmp('strJovenEduInmunizacion').disable();
                                    Ext.getCmp('fecJovenProximaCita').disable();
                                    Ext.getCmp('strjovenProximaCitaProfesionalAtiende').disable();
                                    Ext.getCmp('memJovenPlan').disable();
                                    Ext.getCmp('strJovenExamenOptometrico').clearInvalid();
                                    Ext.getCmp('strJovenExamenHemoglobina').clearInvalid();
                                    Ext.getCmp('strJovenExamenGlicemia').clearInvalid();
                                    Ext.getCmp('strJovenExamenPerfilLipidico').clearInvalid();
                                    Ext.getCmp('strJovenExamenSerologiaVDRL').clearInvalid();
                                    Ext.getCmp('strJovenExamenCitologia').clearInvalid();
                                    Ext.getCmp('strJovenEduNutricion').clearInvalid();
                                    Ext.getCmp('strJovenEduEjercicio').clearInvalid();
                                    Ext.getCmp('strJovenEduTieLib').clearInvalid();
                                    Ext.getCmp('strJovenEduSexualidad').clearInvalid();
                                    Ext.getCmp('strJovenEduEstadosDesarrollo').clearInvalid();
                                    Ext.getCmp('strJovenEduAlcTabDro').clearInvalid();
                                    Ext.getCmp('strJovenEduAutSeno').clearInvalid();
                                    Ext.getCmp('strJovenEduAutTestÃ­culos').clearInvalid();
                                    Ext.getCmp('strJovenEduSalOral').clearInvalid();
                                    Ext.getCmp('strJovenEduInmunizacion').clearInvalid();
                                    Ext.getCmp('fecJovenProximaCita').clearInvalid();
                                    Ext.getCmp('strjovenProximaCitaProfesionalAtiende').clearInvalid();
                                    Ext.getCmp('memJovenPlan').clearInvalid();
                                }else{
                                    Ext.getCmp('fsJoven').setVisible(true);
                                    Ext.getCmp('strJovenExamenOptometrico').allowBlank = false;
                                    Ext.getCmp('strJovenExamenHemoglobina').allowBlank = false;
                                    Ext.getCmp('strJovenExamenGlicemia').allowBlank = false;
                                    Ext.getCmp('strJovenExamenPerfilLipidico').allowBlank = false;
                                    Ext.getCmp('strJovenExamenSerologiaVDRL').allowBlank = false;
                                    Ext.getCmp('strJovenExamenCitologia').allowBlank = false;
                                    Ext.getCmp('strJovenEduNutricion').allowBlank = false;
                                    Ext.getCmp('strJovenEduEjercicio').allowBlank = false;
                                    Ext.getCmp('strJovenEduTieLib').allowBlank = false;
                                    Ext.getCmp('strJovenEduSexualidad').allowBlank = false;
                                    Ext.getCmp('strJovenEduEstadosDesarrollo').allowBlank = false;
                                    Ext.getCmp('strJovenEduAlcTabDro').allowBlank = false;
                                    Ext.getCmp('strJovenEduAutSeno').allowBlank = false;
                                    Ext.getCmp('strJovenEduAutTestÃ­culos').allowBlank = false;
                                    Ext.getCmp('strJovenEduSalOral').allowBlank = false;
                                    Ext.getCmp('strJovenEduInmunizacion').allowBlank = false;
                                    Ext.getCmp('fecJovenProximaCita').allowBlank = false;
                                    Ext.getCmp('strjovenProximaCitaProfesionalAtiende').allowBlank = false;
                                    Ext.getCmp('memJovenPlan').allowBlank = false;
                                    Ext.getCmp('strJovenExamenOptometrico').enable();
                                    Ext.getCmp('strJovenExamenHemoglobina').enable();
                                    Ext.getCmp('strJovenExamenGlicemia').enable();
                                    Ext.getCmp('strJovenExamenPerfilLipidico').enable();
                                    Ext.getCmp('strJovenExamenSerologiaVDRL').enable();
                                    Ext.getCmp('strJovenExamenCitologia').enable();
                                    Ext.getCmp('strJovenEduNutricion').enable();
                                    Ext.getCmp('strJovenEduEjercicio').enable();
                                    Ext.getCmp('strJovenEduTieLib').enable();
                                    Ext.getCmp('strJovenEduSexualidad').enable();
                                    Ext.getCmp('strJovenEduEstadosDesarrollo').enable();
                                    Ext.getCmp('strJovenEduAlcTabDro').enable();
                                    Ext.getCmp('strJovenEduAutSeno').enable();
                                    Ext.getCmp('strJovenEduAutTestÃ­culos').enable();
                                    Ext.getCmp('strJovenEduSalOral').enable();
                                    Ext.getCmp('strJovenEduInmunizacion').enable();
                                    Ext.getCmp('fecJovenProximaCita').enable();
                                    Ext.getCmp('strjovenProximaCitaProfesionalAtiende').enable();
                                    Ext.getCmp('memJovenPlan').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'EVALUACÓN INTEGRAL JOVEN (10 a 24 AÑOS)',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsJoven',
                items: [
                    {
                        xtype: 'panel',
                        title: '<center>DATOS BASICOS PROGRAMA</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnDatosBasicosJoven',
                        items: [
                            {
                                xtype: 'fieldset',
                                title: 'Factores de Riesgo',
                                layout: 'form',
                                collapseFirst: false,
                                collapsible: true,
                                animCollapse: true,
                                titleCollapse: true,
                                anchor: '100%',
                                autoHeight: true,
                                padding: 5,
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'checkbox',
                                                fieldLabel: 'Fumador',
                                                name: 'Fumador',
                                                value: 'false',
                                                id: 'bolJovenFumador'
                                            },
                                            {
                                                html: 'Alcohol:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Alcohol',
                                                value: 'false',
                                                id: 'bolJovenAlcohol'
                                            },
                                            {
                                                html: 'Sust. Psicoa.:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Sust. Psicoa.',
                                                value: 'false',
                                                id: 'bolJovenSustPsicoa'
                                            },
                                            {
                                                html: 'Dieta Saludable:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Dieta Saludable',
                                                value: 'false',
                                                id: 'bolJovenDietaSaludable'
                                            },
                                            {
                                                html: 'Act. Fisica:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Act. Fisica',
                                                value: 'false',
                                                id: 'bolJovenActFisica'
                                            },
                                            {
                                                html: 'Manejo Stress:'
                                            },
                                            {
                                                xtype: 'checkbox',
                                                name: 'Manejo Stress',
                                                value: 'false',
                                                id: 'bolJovenManejoStress'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>APOYO DIAGNOSTICO</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnApoyoDxJoven',
                        items: [
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Examen Optometrico',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Examen Optometrico',
                                        id: 'strJovenExamenOptometrico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strJovenExamenOptometricoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecJovenExamenOptometricoFecha').allowBlank = true;
                                                    Ext.getCmp('strJovenExamenOptometricoDescripcion').disable();
                                                    Ext.getCmp('fecJovenExamenOptometricoFecha').disable();
                                                    Ext.getCmp('strJovenExamenOptometricoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecJovenExamenOptometricoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strJovenExamenOptometricoDescripcion').enable();
                                                    Ext.getCmp('fecJovenExamenOptometricoFecha').enable();
                                                    Ext.getCmp('strJovenExamenOptometricoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecJovenExamenOptometricoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Examen Optometrico Descripcion',
                                        id: 'strJovenExamenOptometricoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Examen Optometrico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecJovenExamenOptometricoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Hemoglobina / HCT',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Hemoglobina/HCT',
                                        id: 'strJovenExamenHemoglobina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strJovenExamenHemoglobinaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecJovenExamenHemoglobinaFecha').allowBlank = true;
                                                    Ext.getCmp('strJovenExamenHemoglobinaDescripcion').disable();
                                                    Ext.getCmp('fecJovenExamenHemoglobinaFecha').disable();
                                                    Ext.getCmp('strJovenExamenHemoglobinaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecJovenExamenHemoglobinaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strJovenExamenHemoglobinaDescripcion').enable();
                                                    Ext.getCmp('fecJovenExamenHemoglobinaFecha').enable();
                                                    Ext.getCmp('strJovenExamenHemoglobinaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecJovenExamenHemoglobinaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Hemoglobina Descripcion',
                                        id: 'strJovenExamenHemoglobinaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Examen Hemoglobina Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecJovenExamenHemoglobinaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Glicemia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Glicemia',
                                        id: 'strJovenExamenGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strJovenExamenOftalmologicoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecJovenExamenOftalmologicoFecha').allowBlank = true;
                                                    Ext.getCmp('strJovenExamenOftalmologicoDescripcion').disable();
                                                    Ext.getCmp('fecJovenExamenOftalmologicoFecha').disable();
                                                    Ext.getCmp('strJovenExamenOftalmologicoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecJovenExamenOftalmologicoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strJovenExamenOftalmologicoDescripcion').enable();
                                                    Ext.getCmp('fecJovenExamenOftalmologicoFecha').enable();
                                                    Ext.getCmp('strJovenExamenOftalmologicoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecJovenExamenOftalmologicoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Glicemia Descripcion',
                                        id: 'strJovenExamenGlicemiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Glicemia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecJovenExamenGlicemiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Perfil Lipidico<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Perfil Lipidico',
                                        id: 'strJovenExamenPerfilLipidico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strJovenExamenPerfilLipidicoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecJovenExamenPerfilLipidicoFecha').allowBlank = true;
                                                    Ext.getCmp('strJovenExamenPerfilLipidicoDescripcion').disable();
                                                    Ext.getCmp('fecJovenExamenPerfilLipidicoFecha').disable();
                                                    Ext.getCmp('strJovenExamenPerfilLipidicoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecJovenExamenPerfilLipidicoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strJovenExamenPerfilLipidicoDescripcion').enable();
                                                    Ext.getCmp('fecJovenExamenPerfilLipidicoFecha').enable();
                                                    Ext.getCmp('strJovenExamenPerfilLipidicoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecJovenExamenPerfilLipidicoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textarea',
                                        anchor: '100%',
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Perfil Lipidico Descripcion',
                                        id: 'strJovenExamenPerfilLipidicoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Perfil Lipidico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecJovenExamenPerfilLipidicoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Serologia VDRL<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Serologia VDRL',
                                        id: 'strJovenExamenSerologiaVDRL',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strJovenExamenSerologiaVDRLDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecJovenExamenSerologiaVDRLFecha').allowBlank = true;
                                                    Ext.getCmp('strJovenExamenSerologiaVDRLDescripcion').disable();
                                                    Ext.getCmp('fecJovenExamenSerologiaVDRLFecha').disable();
                                                    Ext.getCmp('strJovenExamenSerologiaVDRLDescripcion').clearInvalid();
                                                    Ext.getCmp('fecJovenExamenSerologiaVDRLFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strJovenExamenSerologiaVDRLDescripcion').enable();
                                                    Ext.getCmp('fecJovenExamenSerologiaVDRLFecha').enable();
                                                    Ext.getCmp('strJovenExamenSerologiaVDRLDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecJovenExamenSerologiaVDRLFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Serologia VDRL Descripcion',
                                        id: 'strJovenExamenSerologiaVDRLDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Serologia VDRL Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecJovenExamenSerologiaVDRLFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Citologia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Citologia',
                                        id: 'strJovenExamenCitologia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strJovenExamenCitologiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecJovenExamenCitologiaFecha').allowBlank = true;
                                                    Ext.getCmp('strJovenExamenCitologiaDescripcion').disable();
                                                    Ext.getCmp('fecJovenExamenCitologiaFecha').disable();
                                                    Ext.getCmp('strJovenExamenCitologiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecJovenExamenCitologiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strJovenExamenCitologiaDescripcion').enable();
                                                    Ext.getCmp('fecJovenExamenCitologiaFecha').enable();
                                                    Ext.getCmp('strJovenExamenCitologiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecJovenExamenCitologiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Citologia Descripcion',
                                        id: 'strJovenExamenCitologiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Citologia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecJovenExamenCitologiaFecha'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>EDUCACION</center>',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntJovenEducacion',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 2
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Nutricion',
                                                fieldLabel:'Nutricion<br>&nbsp;',
                                                id: 'strJovenEduNutricion'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Ejercicio',
                                                fieldLabel:'Ejercicio<br>&nbsp;',
                                                id: 'strJovenEduEjercicio'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Tiempo Libre',
                                                fieldLabel:'Tiempo Libre<br>&nbsp;',
                                                id: 'strJovenEduTieLib'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Sexualidad',
                                                fieldLabel:'Sexualidad<br>&nbsp;',
                                                id: 'strJovenEduSexualidad'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Estados Desarrollo',
                                                fieldLabel:'Estados Desarrollo<br>&nbsp;',
                                                id: 'strJovenEduEstadosDesarrollo'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Alcohol, Tabaco y Drogas',
                                                fieldLabel:'Alcohol, Tabaco y Drogas',
                                                id: 'strJovenEduAlcTabDro'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Seno',
                                                fieldLabel:'Autoexamen Seno',
                                                id: 'strJovenEduAutSeno'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Testiculo',
                                                fieldLabel:'Autoexamen Testiculo',
                                                id: 'strJovenEduAutTestÃ­culos'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Salud Oral',
                                                fieldLabel:'Salud Oral<br>&nbsp;',
                                                id: 'strJovenEduSalOral'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Inmunizacion',
                                                fieldLabel:'Inmunizacion<br>&nbsp;',
                                                id: 'strJovenEduInmunizacion'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Probable Proxima Cita',
                                name: 'Fecha Probable Proxima Cita',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecJovenProximaCita'
                            },
                            {
                                html: 'Profesional que Atiende'
                            },
                            {
                                xtype: 'combo',
                                name: 'Profesional que Atiende',
                                width: 250,
                                allowBlank: true,
                                store: stProfesionalAtiende,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strjovenProximaCitaProfesionalAtiende'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memJovenPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysJovenDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysJovenDiag').setValue(null);
                                                            Ext.getCmp('sysJovenDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysJovenDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysJovenDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysJovenDiag').setValue(null);
                                                        Ext.getCmp('sysJovenDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysJovenDiag').setValue(null);
                                                Ext.getCmp('sysJovenDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysJovenDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysJovenDiag','sysJovenDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnJoven001Ui.superclass.initComponent.call(this);
    }
});