/*
* @category    Panel Aduto Maduro
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


pnAdultoMaduro001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    collapseFirst: false,
    collapsible: false,
    animCollapse: false,
    titleCollapse: false,
    border: false,
    padding: 0,
    id: 'pnAdultoMaduro',
    initComponent: function() {
        this.items = [
            {
                xtype: 'panel',
                anchor: '100%',
                autoHeight: true,
                layout: 'form',
                labelWidth: 280,
                padding: 5,
                items: [
                    {
                        xtype: 'combo',
                        labelStyle: 'background-color:#FF0; color:#F00; text-decoration:blink;',
                        fieldLabel: 'Registrar HC Adulto Maduro (45 a 64 años)?',
                        name: 'Registrar HC Adulto Maduro (45 a 64 años)?',
                        width: 60,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strRegistrarAdultoMaduro',
                        listeners:{
                            change : function( t, newValue, oldValue){
                                if(newValue == "NO"){
                                    Ext.getCmp('fsAdultoMaduro').setVisible(false);
                                    Ext.getCmp('strAdultoMaduroExamenOptometrico').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenOftalmologico').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenGlicemia').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidico').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenParcialOrina').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenCreatinina').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstatico').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenMamografia').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenCitologia').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHeces').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduAutocuidado').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduNutricion').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduEjercicio').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduTieLib').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduSexualidad').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduPlaFamiliar').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduAlcTabDro').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduAutSeno').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduAutTestÃ­culos').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroEduSalOral').allowBlank = true;
                                    Ext.getCmp('fecAdultoMaduroProximaCita').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroProximaCitaProfesionalAtiende').allowBlank = true;
                                    Ext.getCmp('memAdultoMaduroPlan').allowBlank = true;
                                    Ext.getCmp('strAdultoMaduroExamenOptometrico').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenOftalmologico').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenGlicemia').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidico').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenParcialOrina').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenCreatinina').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstatico').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenMamografia').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenCitologia').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHeces').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduAutocuidado').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduNutricion').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduEjercicio').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduTieLib').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduSexualidad').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduPlaFamiliar').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduAlcTabDro').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduAutSeno').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduAutTestÃ­culos').setValue(null);
                                    Ext.getCmp('strAdultoMaduroEduSalOral').setValue(null);
                                    Ext.getCmp('fecAdultoMaduroProximaCita').setValue(null);
                                    Ext.getCmp('strAdultoMaduroProximaCitaProfesionalAtiende').setValue(null);
                                    Ext.getCmp('memAdultoMaduroPlan').setValue(null);
                                    Ext.getCmp('strAdultoMaduroExamenOptometrico').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenOftalmologico').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenGlicemia').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidico').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenParcialOrina').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenCreatinina').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstatico').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenMamografia').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenCitologia').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHeces').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduAutocuidado').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduNutricion').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduEjercicio').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduTieLib').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduSexualidad').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduPlaFamiliar').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduAlcTabDro').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduAutSeno').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduAutTestÃ­culos').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroEduSalOral').clearInvalid();
                                    Ext.getCmp('fecAdultoMaduroProximaCita').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroProximaCitaProfesionalAtiende').clearInvalid();
                                    Ext.getCmp('memAdultoMaduroPlan').clearInvalid();
                                    Ext.getCmp('strAdultoMaduroExamenOptometrico').disable();
                                    Ext.getCmp('strAdultoMaduroExamenOftalmologico').disable();
                                    Ext.getCmp('strAdultoMaduroExamenGlicemia').disable();
                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidico').disable();
                                    Ext.getCmp('strAdultoMaduroExamenParcialOrina').disable();
                                    Ext.getCmp('strAdultoMaduroExamenCreatinina').disable();
                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstatico').disable();
                                    Ext.getCmp('strAdultoMaduroExamenMamografia').disable();
                                    Ext.getCmp('strAdultoMaduroExamenCitologia').disable();
                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHeces').disable();
                                    Ext.getCmp('strAdultoMaduroEduAutocuidado').disable();
                                    Ext.getCmp('strAdultoMaduroEduNutricion').disable();
                                    Ext.getCmp('strAdultoMaduroEduEjercicio').disable();
                                    Ext.getCmp('strAdultoMaduroEduTieLib').disable();
                                    Ext.getCmp('strAdultoMaduroEduSexualidad').disable();
                                    Ext.getCmp('strAdultoMaduroEduPlaFamiliar').disable();
                                    Ext.getCmp('strAdultoMaduroEduAlcTabDro').disable();
                                    Ext.getCmp('strAdultoMaduroEduAutSeno').disable();
                                    Ext.getCmp('strAdultoMaduroEduAutTestÃ­culos').disable();
                                    Ext.getCmp('strAdultoMaduroEduSalOral').disable();
                                    Ext.getCmp('fecAdultoMaduroProximaCita').disable();
                                    Ext.getCmp('strAdultoMaduroProximaCitaProfesionalAtiende').disable();
                                    Ext.getCmp('memAdultoMaduroPlan').disable();
                                }else{
                                    Ext.getCmp('fsAdultoMaduro').setVisible(true);
                                    Ext.getCmp('strAdultoMaduroExamenOptometrico').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenOftalmologico').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenGlicemia').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidico').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenParcialOrina').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenCreatinina').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstatico').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenMamografia').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenCitologia').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHeces').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduAutocuidado').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduNutricion').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduEjercicio').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduTieLib').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduSexualidad').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduPlaFamiliar').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduAlcTabDro').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduAutSeno').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduAutTestÃ­culos').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroEduSalOral').allowBlank = false;
                                    Ext.getCmp('fecAdultoMaduroProximaCita').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroProximaCitaProfesionalAtiende').allowBlank = false;
                                    Ext.getCmp('memAdultoMaduroPlan').allowBlank = false;
                                    Ext.getCmp('strAdultoMaduroExamenOptometrico').enable();
                                    Ext.getCmp('strAdultoMaduroExamenOftalmologico').enable();
                                    Ext.getCmp('strAdultoMaduroExamenGlicemia').enable();
                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidico').enable();
                                    Ext.getCmp('strAdultoMaduroExamenParcialOrina').enable();
                                    Ext.getCmp('strAdultoMaduroExamenCreatinina').enable();
                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstatico').enable();
                                    Ext.getCmp('strAdultoMaduroExamenMamografia').enable();
                                    Ext.getCmp('strAdultoMaduroExamenCitologia').enable();
                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHeces').enable();
                                    Ext.getCmp('strAdultoMaduroEduAutocuidado').enable();
                                    Ext.getCmp('strAdultoMaduroEduNutricion').enable();
                                    Ext.getCmp('strAdultoMaduroEduEjercicio').enable();
                                    Ext.getCmp('strAdultoMaduroEduTieLib').enable();
                                    Ext.getCmp('strAdultoMaduroEduSexualidad').enable();
                                    Ext.getCmp('strAdultoMaduroEduPlaFamiliar').enable();
                                    Ext.getCmp('strAdultoMaduroEduAlcTabDro').enable();
                                    Ext.getCmp('strAdultoMaduroEduAutSeno').enable();
                                    Ext.getCmp('strAdultoMaduroEduAutTestÃ­culos').enable();
                                    Ext.getCmp('strAdultoMaduroEduSalOral').enable();
                                    Ext.getCmp('fecAdultoMaduroProximaCita').enable();
                                    Ext.getCmp('strAdultoMaduroProximaCitaProfesionalAtiende').enable();
                                    Ext.getCmp('memAdultoMaduroPlan').enable();
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'EVALUACÓN INTEGRAL AL ADULTO MADURO(45 a 64 AÑOS)',
                layout: 'form',
                collapsible: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsAdultoMaduro',
                items: [
                    {
                        xtype: 'panel',
                        title: '<center>FACTORES DE RIESGO</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntAduMadFactoresRiesgo',
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        fieldLabel: 'Fumador',
                                        name: 'Fumador',
                                        value: 'false',
                                        id: 'bolAdultoMaduroFumador'
                                    },
                                    {
                                        html: 'Alcohol:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Alcohol',
                                        value: 'false',
                                        id: 'bolAdultoMaduroAlcohol'
                                    },
                                    {
                                        html: 'Sust. Psicoa.:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Sust. Psicoa.',
                                        value: 'false',
                                        id: 'bolAdultoMaduroSustPsicoa'
                                    },
                                    {
                                        html: 'Dieta Saludable:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Dieta Saludable',
                                        value: 'false',
                                        id: 'bolAdultoMaduroDietaSaludable'
                                    },
                                    {
                                        html: 'Act. Fisica:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Act. Fisica',
                                        value: 'false',
                                        id: 'bolAdultoMaduroActFisica'
                                    },
                                    {
                                        html: 'Manejo Stress:'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Manejo Stress',
                                        value: 'false',
                                        id: 'bolAdultoMaduroManejoStress'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>APOYO DIAGNOSTICO</center>',
                        layout: 'form',
                        labelSeparator: '',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntAduMadApoDiagnostico',
                        items: [
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        allowBlank: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Examen Optometrico',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Examen Optometrico',
                                        id: 'strAdultoMaduroExamenOptometrico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenOptometricoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenOptometricoFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenOptometricoDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenOptometricoFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenOptometricoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenOptometricoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenOptometricoDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenOptometricoFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenOptometricoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenOptometricoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Examen Optometrico Descripcion',
                                        id: 'strAdultoMaduroExamenOptometricoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Examen Optometrico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenOptometricoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Examen Oftalmologico',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Examen Oftalmologico',
                                        id: 'strAdultoMaduroExamenOftalmologico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenOftalmologicoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenOftalmologicoFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenOftalmologicoDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenOftalmologicoFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenOftalmologicoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenOftalmologicoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenOftalmologicoDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenOftalmologicoFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenOftalmologicoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenOftalmologicoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Examen Oftalmologico Descripcion',
                                        id: 'strAdultoMaduroExamenOftalmologicoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Examen Oftalmologico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenOftalmologicoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Glicemia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Glicemia',
                                        id: 'strAdultoMaduroExamenGlicemia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenGlicemiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenGlicemiaFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenGlicemiaDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenGlicemiaFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenGlicemiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenGlicemiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenGlicemiaDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenGlicemiaFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenGlicemiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenGlicemiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Glicemia Descripcion',
                                        id: 'strAdultoMaduroExamenGlicemiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Glicemia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenGlicemiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Perfil Lipidico<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Perfil Lipidico',
                                        id: 'strAdultoMaduroExamenPerfilLipidico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidicoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenPerfilLipidicoFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidicoDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenPerfilLipidicoFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidicoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenPerfilLipidicoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidicoDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenPerfilLipidicoFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenPerfilLipidicoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenPerfilLipidicoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textarea',
                                        anchor: '100%',
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Perfil Lipidico Descripcion',
                                        id: 'strAdultoMaduroExamenPerfilLipidicoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Perfil Lipidico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenPerfilLipidicoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Parcial Orina<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Parcial Orina',
                                        id: 'strAdultoMaduroExamenParcialOrina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenParcialOrinaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenParcialOrinaFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenParcialOrinaDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenParcialOrinaFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenParcialOrinaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenParcialOrinaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenParcialOrinaDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenParcialOrinaFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenParcialOrinaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenParcialOrinaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Parcial Orina Descripcion',
                                        id: 'strAdultoMaduroExamenParcialOrinaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Parcial Orina Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenParcialOrinaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Creatinina<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Creatinina',
                                        id: 'strAdultoMaduroExamenCreatinina',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenCreatininaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenCreatininaFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenCreatininaDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenCreatininaFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenCreatininaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenCreatininaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenCreatininaDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenCreatininaFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenCreatininaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenCreatininaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Creatinina Descripcion',
                                        id: 'strAdultoMaduroExamenCreatininaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Creatinina Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenCreatininaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Antigeno Prostatico',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Antigeno Prostatico',
                                        id: 'strAdultoMaduroExamenAntigenoProstatico',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstaticoDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenAntigenoProstaticoFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstaticoDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenAntigenoProstaticoFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstaticoDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenAntigenoProstaticoFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstaticoDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenAntigenoProstaticoFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenAntigenoProstaticoDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenAntigenoProstaticoFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Antigeno Prostatico Descripcion',
                                        id: 'strAdultoMaduroExamenAntigenoProstaticoDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Antigeno Prostatico Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenAntigenoProstaticoFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Mamografia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Mamografia',
                                        id: 'strAdultoMaduroExamenMamografia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenMamografiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenMamografiaFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenMamografiaDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenMamografiaFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenMamografiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenMamografiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenMamografiaDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenMamografiaFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenMamografiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenMamografiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Mamografia Descripcion',
                                        id: 'strAdultoMaduroExamenMamografiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Mamografia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenMamografiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Citologia<br>&nbsp;',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Citologia',
                                        id: 'strAdultoMaduroExamenCitologia',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenCitologiaDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenCitologiaFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenCitologiaDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenCitologiaFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenCitologiaDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenCitologiaFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenCitologiaDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenCitologiaFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenCitologiaDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenCitologiaFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Citologia Descripcion',
                                        id: 'strAdultoMaduroExamenCitologiaDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Citologia Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenCitologiaFecha'
                                    }
                                ]
                            },
                            {   
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        width: 60,
                                        forceSelection: true,
                                        emptyText: 'SI/NO',
                                        mode: 'local',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        listEmptyText: '',
                                        triggerAction: 'all',
                                        store:'StoreSiNo',
                                        fieldLabel:'Sandre Oculta en Heces',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        name:'Sandre Oculta en Heces',
                                        id: 'strAdultoMaduroExamenSandreOcultaHeces',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue == "NO"){
                                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHecesDescripcion').allowBlank = true;
                                                    Ext.getCmp('fecAdultoMaduroExamenSandreOcultaHecesFecha').allowBlank = true;
                                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHecesDescripcion').disable();
                                                    Ext.getCmp('fecAdultoMaduroExamenSandreOcultaHecesFecha').disable();
                                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHecesDescripcion').clearInvalid();
                                                    Ext.getCmp('fecAdultoMaduroExamenSandreOcultaHecesFecha').clearInvalid();
                                                }else{
                                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHecesDescripcion').enable();
                                                    Ext.getCmp('fecAdultoMaduroExamenSandreOcultaHecesFecha').enable();
                                                    Ext.getCmp('strAdultoMaduroExamenSandreOcultaHecesDescripcion').allowBlank = false;
                                                    Ext.getCmp('fecAdultoMaduroExamenSandreOcultaHecesFecha').allowBlank = false;
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        allowBlank: true,
                                        disabled: true,
                                        name: 'Sandre Oculta en Heces Descripcion',
                                        id: 'strAdultoMaduroExamenSandreOcultaHecesDescripcion'
                                    },
                                    {
                                        html: ' - '
                                    },
                                    {
                                        xtype: 'datefield',
                                        name: 'Sandre Oculta en Heces Fecha',
                                        emptyText: '(dia/mes/año)',
                                        width: 120,
                                        allowBlank: true,
                                        disabled: true,
                                        id: 'fecAdultoMaduroExamenSandreOcultaHecesFecha'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>EDUCACION</center>',
                        layout: 'form',
                        anchor: '100%',
                        autoHeight: true,
                        id: 'pnFicIntAduMAdEducacion',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'table',
                                anchor: '100%',
                                padding: 0,
                                layoutConfig: {
                                    columns: 2
                                },
                                autoHeight: true,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autocuidado',
                                                fieldLabel:'Autocuidado<br>&nbsp;',
                                                id: 'strAdultoMaduroEduAutocuidado'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Nutricion',
                                                fieldLabel:'Nutricion<br>&nbsp;',
                                                id: 'strAdultoMaduroEduNutricion'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Ejercicio',
                                                fieldLabel:'Ejercicio<br>&nbsp;',
                                                id: 'strAdultoMaduroEduEjercicio'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Tiempo Libre',
                                                fieldLabel:'Tiempo Libre<br>&nbsp;',
                                                id: 'strAdultoMaduroEduTieLib'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Sexualidad',
                                                fieldLabel:'Sexualidad<br>&nbsp;',
                                                id: 'strAdultoMaduroEduSexualidad'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 400,
                                        autoHeight: true,
                                        labelSeparator: '',
                                        labelStyle: 'color:blue;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Planificacion Familiar',
                                                fieldLabel:'Planificacion Familiar',
                                                id: 'strAdultoMaduroEduPlaFamiliar'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Alcohol, Tabaco y Drogas',
                                                fieldLabel:'Alcohol, Tabaco y Drogas',
                                                id: 'strAdultoMaduroEduAlcTabDro'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Seno',
                                                fieldLabel:'Autoexamen Seno',
                                                id: 'strAdultoMaduroEduAutSeno'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Autoexamen Testiculo',
                                                fieldLabel:'Autoexamen Testiculo',
                                                id: 'strAdultoMaduroEduAutTestÃ­culos'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 60,
                                                forceSelection: true,
                                                emptyText: 'SI/NO',
                                                mode: 'local',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                store:'StoreSiNo',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                name:'Salud Oral',
                                                fieldLabel:'Salud Oral<br>&nbsp;',
                                                id: 'strAdultoMaduroEduSalOral'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Probable Proxima Cita',
                                name: 'Fecha Probable Proxima Cita',
                                allowBlank: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecAdultoMaduroProximaCita'
                            },
                            {
                                html: 'Profesional que Atiende'
                            },
                            {
                                xtype: 'combo',
                                name: 'Profesional que Atiende',
                                width: 250,
                                allowBlank: true,
                                store: stProfesionalAtiende,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strAdultoMaduroProximaCitaProfesionalAtiende'
                            }
                        ]
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        width: 880,
                        fieldLabel: 'PLAN',
                        name: 'PLAN',
                        height: 100,
                        allowBlank: true,
                        id: 'memAdultoMaduroPlan'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 96,
                                allowBlank: true,
                                fieldLabel: 'Diagnostico',
                                id: 'sysAdultoMaduroDiag',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                        {
                                            if (f.getValue() != "" && f.getValue() != null){
                                                Ext.Ajax.request({
                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                    params:{
                                                        task: 'BUSCAR',
                                                        pCodigo: f.getValue().toUpperCase()
                                                    },
                                                    success: function(response,options)
                                                    {
                                                        var el = Ext.get('response'); // get the LOG
                                                        var Respuesta = response.responseText;
                                                        var Contenido = Respuesta.split('^');
                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                            Ext.getCmp('sysAdultoMaduroDiag').setValue(null);
                                                            Ext.getCmp('sysAdultoMaduroDiagNom').setValue(null);
                                                        } else {
                                                            Ext.getCmp('sysAdultoMaduroDiag').setValue(Contenido[0]);
                                                            Ext.getCmp('sysAdultoMaduroDiagNom').setValue(Contenido[1]);
                                                        }
                                                    },
                                                    failure: function(response,options){
                                                        var el = Ext.get('response');
                                                        Ext.getCmp('sysAdultoMaduroDiag').setValue(null);
                                                        Ext.getCmp('sysAdultoMaduroDiagNom').setValue(null);
                                                    },
                                                    scope:this //bind the callbacks
                                                });
                                            }else{
                                                Ext.getCmp('sysAdultoMaduroDiag').setValue(null);
                                                Ext.getCmp('sysAdultoMaduroDiagNom').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'textarea',
                                readOnly: true,
                                width: 625,
                                height: 22,
                                id: 'sysAdultoMaduroDiagNom'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Diagnostico Principal',
                                listeners:{
                                    click : function(){
                                        buscarcie10('sysAdultoMaduroDiag','sysAdultoMaduroDiagNom');
                                    }
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        pnAdultoMaduro001Ui.superclass.initComponent.call(this);
    }
});