/*
* @category    Formulario Triage - Urgencias
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCTRIAGEUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Triage ::.',
    width: 880,
    autoHeight: true,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        //Store Locales
        var dataClasificaTriage = [
            ['V','ATENCION NORMAL - TRIAGE 4'],
            ['A','ATENCION PRIORITARIA - TRIAGE 3'],
            ['N','ATENCION URGENTE - TRIAGE 2'],
            ['R','ATENCION INMEDIATA - TRIAGE 1']
            
        ];
        var stClasificaTriage = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stClasificaTriage.loadData(dataClasificaTriage);
        
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners:{
                    click : function(){
                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1) 
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea cerrar la ventana?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn){
                                    if(btn === "yes"){
                                        Ext.getCmp('gridFormulario').store.reload();
                                        Ext.getCmp('winHC').close();
                                    }
                                }
                            });
                        else{
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'No se puede salir hasta que se guarde el triage ',
                                buttons: Ext.Msg.OK,
                                icon: Ext.Msg.ERROR
                            });
                        }
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmHCTriage',
                padding: 0,
                border: false,
                autoHeight: true,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                     {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                html: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                html: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                html: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        html: '<hr>'
                    },
                    {
                        xtype: 'fieldset',
                        title: 'EXAMEN FISICO',
                        labelWidth: '150',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '98%',
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'T.A. (Sentado)',
                                        name: 'T.A. (Sentado) Sistolica',
                                        width: 70,
                                        minValue: 0,
                                        maxValue: 300,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intEXAFISTASentadoSistolica'
                                    },
                                    {
                                        html: '/'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'T.A. (Sentado) Diastolica',
                                        width: 70,
                                        minValue: 0,
                                        maxValue: 300,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'intEXAFISTASentadoDiastolica'
                                    },
                                    {
                                        html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                                    },
                                    {
                                        html: 'T.A. (de Pie):'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'T.A. (de Pie) Sistolica',
                                        width: 70,
                                        minValue: 0,
                                        maxValue: 300,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intEXAFISTAdePieSistolica'
                                    },
                                    {
                                        html: '/'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'T.A. (de Pie) Diastolica',
                                        width: 70,
                                        minValue: 0,
                                        maxValue: 300,
                                        decimalPrecision: 0,
                                        allowBlank: true,
                                        id: 'intEXAFISTAdePieDiastolica'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        fieldLabel: 'TALLA (cm)',
                                        name:"TALLA (cm)",
                                        emptyText: '(cm)',
                                        id: 'intEXAFISTalla',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew === null || pNew === 0){
                                                    Ext.getCmp('intEXAFISTalla').setValue(null);
                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                }else{
                                                    if(Ext.getCmp('intEXAFISPeso').getValue() > 0){
                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                    }else{
                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                    }
                                                }
                                               if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                }else{
                                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                    }else{
                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                        }else{
                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                            }else{
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                }else{
                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                    }else{
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysEXAFISPeso',
                                        value: 'PESO (Kg) '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        maxValue: 250,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        emptyText: '(Kg)',
                                        name:"PESO (Kg)",
                                        id: 'intEXAFISPeso',
                                        listeners:{
                                            change : function(f,pNew, pOld){
                                                if(pNew === null || pNew === 0){
                                                    Ext.getCmp('intEXAFISPeso').setValue(null);
                                                    Ext.getCmp('intEXAFISIMC').setValue(0);
                                                }else{
                                                    //peso [kg]/ estatura [m2]
                                                    if(Ext.getCmp('intEXAFISTalla').getValue() > 0){
                                                        var pTalla = Ext.getCmp('intEXAFISTalla').getValue() / 100;
                                                        Ext.getCmp('intEXAFISIMC').setValue(Ext.getCmp('intEXAFISPeso').getValue()/(pTalla*pTalla));
                                                    }else{
                                                        Ext.getCmp('intEXAFISIMC').setValue(0);
                                                    }
                                                }
                                                if(Ext.getCmp('intEXAFISIMC').getValue()<1){
                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue(null);
                                                }else{
                                                    if(Ext.getCmp('intEXAFISIMC').getValue() < 16.00){
                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ SEVERA");
                                                    }else{
                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=16.90 && Ext.getCmp('intEXAFISIMC').getValue()>=16.00){
                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ MODERADA");
                                                        }else{
                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=18.49 && Ext.getCmp('intEXAFISIMC').getValue()>=17.00){
                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("DELGADEZ ACEPTABLE");
                                                            }else{
                                                                if(Ext.getCmp('intEXAFISIMC').getValue()<=24.99 && Ext.getCmp('intEXAFISIMC').getValue()>=18.50){
                                                                   Ext.getCmp('strEXAFISIMCClasificacon').setValue("NORMAL");
                                                                }else{
                                                                    if(Ext.getCmp('intEXAFISIMC').getValue()<=29.99 && Ext.getCmp('intEXAFISIMC').getValue()>=25.00){
                                                                       Ext.getCmp('strEXAFISIMCClasificacon').setValue("PREOBESO");
                                                                    }else{
                                                                        if(Ext.getCmp('intEXAFISIMC').getValue()<=34.99 && Ext.getCmp('intEXAFISIMC').getValue()>=30.00){
                                                                           Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO I");
                                                                        }else{
                                                                            if(Ext.getCmp('intEXAFISIMC').getValue()<=39.99 && Ext.getCmp('intEXAFISIMC').getValue()>=35.00){
                                                                               Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO II");
                                                                            }else{
                                                                                if(Ext.getCmp('intEXAFISIMC').getValue()>=40.00){
                                                                                Ext.getCmp('strEXAFISIMCClasificacon').setValue("OBESO TIPO III");
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysEXAFISIMC',
                                        value: 'IMC '
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        readOnly: true,
                                        name: "IMC",
                                        id: 'intEXAFISIMC'
                                    },
                                    {
                                        xtype: 'textfield',
                                        anchor: '100%',
                                        allowBlank: false,
                                        readOnly: true,
                                        name: "IMC - CLASIFICACION",
                                        id: 'strEXAFISIMCClasificacon'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'Temp',
                                        width: 60,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        name: 'Temperatura',
                                        allowBlank: false,
                                        id: 'intEXAFISTemp'
                                    },
                                    {
                                        html: 'F.C.'
                                    },                                                            
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        name: 'FC',
                                        allowBlank: false,
                                        id: 'intEXAFISFC'
                                    },
                                    {
                                        html: 'F.R.'
                                    },                                                            
                                    {
                                        xtype: 'numberfield',
                                        width: 60,
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        name: 'FR',
                                        allowBlank: false,
                                        id: 'intEXAFISFR'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'TRIAGE',
                        layout: 'table',
                        collapsible: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        padding: 7,
                        items: [
                            {
                                xtype: 'textarea',
                                width: 800,
                                fieldLabel: 'TRIAGE',
                                name: 'TRIAGE',
                                height: 30,
                                grow: true,
                                minGrow: 30,
                                allowBlank: false,
                                id: 'sysTriage'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Clasificacion',
                        anchor: '100%',
                        name: 'Clasificacion',
                        allowBlank: false,
                        store: stClasificaTriage,
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione....',
                        submitValue: true,
                        id: 'sysClasificacionTriage'
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarTriage',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'Esta seguro que desea gurdar el triage?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn === "yes"){
                                                if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0){
                                                    fnGuardarRegistrosTriage("Nuevo");
                                                }else{
                                                    fnGuardarRegistrosTriage("Modificar");
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCTRIAGEUi.superclass.initComponent.call(this);
    }
});


function fnGuardarRegistrosTriage(wOpcion){
    var frm = Ext.getCmp('frmHCTriage').getForm();
    var TASK = "";
    if(wOpcion === "Nuevo"){
        TASK = "GUARDAR_TRIAGE";
    }else{
        TASK = "MODIFICAR_TRIAGE";
    }
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/controlador_urgencias.php',
            params:{
                task: TASK,
                CAMPOS: listacampos,
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pConsecutivoHC: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pTriageHC: Ext.getCmp('sysTriage').getValue(),
                pClasificaTriageHC: Ext.getCmp('sysClasificacionTriage').getValue(),
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pTriage: Ext.getCmp('sysTriage').getValue(),
                pClasificaTriage: Ext.getCmp('sysClasificacionTriage').getValue(),
                pAperturaTriage: Ext.getCmp('sysAperturaHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        Ext.getCmp('gridFormulario').store.reload();
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
