/*
* @category    Formulario Modelo Historia Clinica Endodoncia
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winHCOdontologia004Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Historia Clinica Endodoncia ::.',
    width: 1010,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCOdontologia004',
    initComponent: function() {
        
        var dataTipoPaciente = [
            ['PACIENTE INICIO TRATAMIENTO'],
            ['PACIENTE INICIO TRATAMIENTO Y CONTROLADO']
        ];
        var stTipoPaciente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoPaciente.loadData(dataTipoPaciente);        
        
        var dataSintomatologiaIntensidad = [
            ['LEVE'],
            ['MODERADO'],
            ['SEVERO']
        ];
        var stSintomatologiaIntensidad = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaIntensidad.loadData(dataSintomatologiaIntensidad);
                
        var dataSintomatologiaDuracion = [
            ['CORTO'],
            ['MEDIANO'],
            ['LARGO']
        ];
        var stSintomatologiaDuracion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaDuracion.loadData(dataSintomatologiaDuracion);
        
        var dataSintomatologiaLocalizacion = [
            ['LOCALIZADO'],
            ['IRRADIADO']
        ];
        var stSintomatologiaLocalizacion = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaLocalizacion.loadData(dataSintomatologiaLocalizacion);
        
        var dataSintomatologiaEstimulo = [
            ['PROVOCADO'],
            ['ESPONTANEO']
        ];
        var stSintomatologiaEstimulo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaEstimulo.loadData(dataSintomatologiaEstimulo);
        
        var dataSintomatologiaTipoEstimulo = [
            ['CALOR (+ / -)'],
            ['FRIO (+ / -)']
        ];
        var stSintomatologiaTipoEstimulo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaTipoEstimulo.loadData(dataSintomatologiaTipoEstimulo);
        
        var dataSintomatologiaPositivoNegativo = [
            ['POSITIVO'],
            ['NEGATIVO']
        ];
        var stSintomatologiaPositivoNegativo = new Ext.data.ArrayStore({
            fields: [
               {name: 'Descripcion'}
            ]
        });
        stSintomatologiaPositivoNegativo.loadData(dataSintomatologiaPositivoNegativo);
        
        //NUEVO 2014
        //Consentimientos Informados
        var xConsentimientosInformados = new GridConsentimientosInformadosUi();
        //Consentimientos Informados
        var xEventosAdversos = new GridEventosAdversosUi();
        //KardexProgramas
        var xKardexProgramas = new GridKardexxPacUi();
        // Carta dental
        var xCartaDental = new CartaDental001Ui();
        // Diagrama Control de Placa
        var xControlPlaca = new ControlPlaca001Ui();
        // Actividades Realizdas
        var xActividadesRealizdas = new ActividadesRealizdas201401Ui();
        //Guias Atencion
        var xGuiasAtencion = new GridGuiasAtencionUi();
        //Reporte Paraclinicos
        var stReporteParaclinicos = new StoreGridReporteParaclinicos();
        stReporteParaclinicos.load({
            params: {
                pPaciente: wPaciente
            }
        });
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: wPaciente,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridAlertasPacientes').store.load({
            params: {
                pPaciente: wPaciente
            }
        });
        function renderClasificacionReporte(val, x, store){
            switch(val){
                case "A":
                    return '<span style="color:#F00">Anormal</span>';
                    break;
                case "N":
                    return '<span style="color:#090">Normal</span>';
                    break;
                default:
                    break;
            }
        }
        function renderValorReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            if(record.get('ReporteVal') !== "" && record.get('ReporteVal') !== null){
                return value + "<br><hr>Valor: " + record.get('ReporteVal');  
            }else{
                return value;  
            }
        }
        function renderObservaReporte(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;
        
        Ext.util.Format.Currency = function(v){
            return FormatoMoneda(v);
        };
        
        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }    
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        
        var stGridOdontogramasxPaciente = new StoreGridOdontogramasxPaciente();
        stGridOdontogramasxPaciente.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        function VerInfoOdontograma(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value + '</br>' + record.get('Profesional') + '</br>Tipo Odontograma:' + record.get('TipoOdontograma') + '</br>Tipo Denticion:' + record.get('TipoDenticion');
        }
        
        function VerInfoProxCita(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return 'CAS: ' + record.get('CAS') + '</br>' + record.get('Profesional') + '</br>Fecha:' + record.get('FechaAtencion');
        }
        
        //Store Locales
        var dataTipoDenticion = [
            ['TEMPORAL'],
            ['PERMANENTE'],
            ['MIXTA']
        ];
        var stTipoDenticion = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoDenticion.loadData(dataTipoDenticion);
        
        var dataHigiene = [
            ['BUENO'],
            ['REGULAR'],
            ['MALO']
        ];
        var stHigiene = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stHigiene.loadData(dataHigiene);
        
        var dataRiesgo = [
            ['ALTO'],
            ['MEDIO'],
            ['BAJO']
        ];
        var stRiesgo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRiesgo.loadData(dataRiesgo);  
        
        
        var dataTipoPaciente = [
            ['PACIENTE INICIO TRATAMIENTO'],
            ['PACIENTE INICIO TRATAMIENTO Y CONTROLADO']
        ];
        var stTipoPaciente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoPaciente.loadData(dataTipoPaciente);        
        
        var dataTipoAtencionOdo = [
            ['PRIMERA VEZ'],
            ['CONTROL'],
            ['URGENCIAS']
        ];
        var stTipoAtencionOdo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoAtencionOdo.loadData(dataTipoAtencionOdo);
        
        var dataTipoAfiliadoOdo = [
            ['COTIZANTE'],
            ['BENEFICIARIO']
        ];
        var stTipoAfiliadoOdo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoAfiliadoOdo.loadData(dataTipoAfiliadoOdo);
        
        var ConvencionesOdontograma = new winConvencionesOdontogramaUi();
        var ViewOdontogramas = new winViewOdontogramasUi();
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                width: 1000,
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'panel',
                        title: 'Datos Basicos',
                        autoHeight: true,
                        autoScroll: true,
                        width: 921,
                        frame: true,
                        border: false,
                        id: 'fichaIdentifica',
                        layout: 'form',
                        items:[
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysIdCodPlantillaHC'
                            },
                             {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                value: 1,
                                id: 'sysUsaGridSalida'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                value: 0,
                                id: 'sysYaGuardoHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysPlantillaHC',
                                name: 'PLANTILLA'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptMx'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptExa'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysRutaRptRem'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Actividad',
                                style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                                id: 'sysActividadHC',
                                name: 'PLANTILLA'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Empresa',
                                id: 'sysEmpresaHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'IPS',
                                id: 'sysIPSHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuarioHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Profesional',
                                id: 'sysProfesionalHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Paciente',
                                id: 'sysIdPacienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Apertura',
                                id: 'sysAperturaHC'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Cliente',
                                id: 'sysClienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdClienteHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdPlanHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdSubPlanHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Plantilla',
                                id: 'sysIdContratoHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroPacHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Edad',
                                id: 'sysEdadPacHC'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Profesional',
                                id: 'sysProfesionalAgendaHC'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoDetalle',
                                id: 'sysConsecutivoDetalleHC'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysFechaHC',
                                        value: 'Fecha: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysFechaHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysHoraHC',
                                        value: 'Hora: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysHoraHC'
                                    },
                                    {
                                        xtype: 'displayfield',
                                        id: 'sysLegalizacionHC',
                                        value: 'Legalización: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysLegalizaHC'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Paciente',
                                value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                id: 'sysPacienteHC'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Genero',
                                        id: 'sysGeneroHC'
                                    },
                                    {
                                        html: 'Fecha Nac:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 100,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysFechaNac'
                                    },
                                    {
                                        html: 'Edad:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 350,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysEdadHC'
                                    }
                                ]
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'Tipo Afiliado',
                                        id: 'sysTipoAfiliadoHC'
                                    },
                                    {
                                        html: 'Rango:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 30,
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'sysRangoAfiliadoHC'
                                    },
                                    {
                                        html: 'Cuota Moderadora:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'sysCMAfiliadoHC',
                                        readOnly: true
                                    },
                                    {
                                        html: '% Copagos:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "%",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 3,
                                        allowBlank: false,
                                        id: 'sysPorCopagoAfiliadoHC',
                                        readOnly: true
                                    }
                                ]
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            }
                        ]
                    },
                    {
                        xtype: 'tabpanel',
                        width: 970,
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolucion',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Afiliado',
                                                        name: 'Tipo de Afiliado',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: stTipoAfiliadoOdo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strTipoAfiliadoHC',
                                                        listeners:{
                                                            select : function(cmb, rec, idx){
                                                                if(cmb.getValue() !== "" && cmb.getValue() !== null){
                                                                    Ext.getCmp('sysTipoAfiliadoHC').setValue(cmb.getValue());
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: 'Tipo de Atencion'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Tipo de Atencion',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: stTipoAtencionOdo,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strTipoAtencionHC'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO CONSULTA',
                                                        name: 'MOTIVO CONSULTA',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        anchor: '100%',
                                                        fieldLabel: 'Telefonos',
                                                        name: 'Telefonos',
                                                        allowBlank: false,
                                                        id: 'strTelefonosHC'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 86,
                                                                allowBlank: false,
                                                                fieldLabel: 'Ocupacion',
                                                                name: 'Ocupacion',
                                                                id: 'strOcupacionHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysOcupacionHCNom').getValue() === null || Ext.getCmp('sysOcupacionHCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('strOcupacionHC').getValue() !== "" && Ext.getCmp('strOcupacionHC').getValue() !== null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('strOcupacionHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 615,
                                                                height: 22,
                                                                id: 'sysOcupacionHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Ocupacion',
                                                                id: 'btnSearchOcupacionHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarciuo('strOcupacionHC','sysOcupacionHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Etnia',
                                                        name: 'Etnia',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreEtnia4505',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intEtniaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Escolaridad',
                                                        name: 'Escolaridad',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: 'StoreEscolaridad4505',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intEscolaridadHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Fluorosis Dental',
                                                        name: 'Paciente con Fluorosis Dental',
                                                        anchor: '100%',
                                                        allowBlank: false,
                                                        store: stFluorosisDental,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'intIdentificacionRiesgoFluorosisDental'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Patologicos',
                                                        name: 'Patologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOPatologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOPatologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Farmacologicos',
                                                        name: 'Farmacologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOFarmacologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOFarmacologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Toxicologicos',
                                                        name: 'Toxicologicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOToxicologicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOToxicologicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Alergicos',
                                                        name: 'Alergicos',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOAlergicos',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOAlergicos').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        anchor: '100%',
                                                        layout: {
                                                            columns: 3,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'HTA',
                                                                        name: 'HTA',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOHTA'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'VIH',
                                                                        name: 'VIH',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSOVIH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Diabetes',
                                                                        name: 'Diabetes',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolANTPERSODiabetes'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        fieldLabel: 'Otros',
                                                        name: 'Otros',
                                                        allowBlank: false,
                                                        id: 'memANTPERSOOtros',
                                                        listeners: {
                                                            render: function( p ) {
                                                                p.getEl().on('dblclick', function (){
                                                                    Ext.getCmp('memANTPERSOOtros').setValue("No Refiere");
                                                                });
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES FAMILIARES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ANTECEDENTES FAMILIARES',
                                                        name: 'ANTECEDENTES FAMILIARES',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memAntecedentesFamiliares'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Tipo Paciente',
                                                fieldLabel: 'Tipo Paciente',
                                                width: 300,
                                                allowBlank: false,
                                                store: stTipoPaciente,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: "PACIENTE EN CONTROL",
                                                id: 'strTipoPaciente'
                                            },
                                            {
                                                xtype: 'textfield',
                                                anchor: '99%',
                                                fieldLabel: 'DIENTE Y/O ZONA',
                                                name: 'DIENTE Y/O ZONA',
                                                allowBlank: false,
                                                id: 'strDienteZona'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '1. Descripción de Historia de dolor y/o Trauma : ¿Qué?¿Cómo?¿Cuándo?¿Dónde?¿Por qué?',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'DESCRIPCION DE HIISTORIA DE DOLOR',
                                                        name: 'DESCRIPCION DE HIISTORIA DE DOLOR',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memHistoriaDolor'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '2. Sintomatología actual',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Intensidad',
                                                                name: 'Intensidad',
                                                                allowBlank: false,
                                                                store: stSintomatologiaIntensidad,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Intensidad'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_IntensidadH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Duración',
                                                                name: 'Duración',
                                                                allowBlank: false,
                                                                store: stSintomatologiaDuracion,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Duracion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_DuracionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Localización',
                                                                name: 'Localización',
                                                                allowBlank: false,
                                                                store: stSintomatologiaLocalizacion,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Localizacion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_LocalizacionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Categoría del Estimulo',
                                                                name: 'Categoría del Estimulo',
                                                                allowBlank: false,
                                                                store: stSintomatologiaEstimulo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_CategoriaEstimulo'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_CategoriaEstimuloH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Tipo de Estímulo',
                                                                name: 'Tipo de Estimulo',
                                                                allowBlank: false,
                                                                store: stSintomatologiaTipoEstimulo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_TipoEstimulo'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_TipoEstimuloH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Percusión',
                                                                name: 'Percusión',
                                                                allowBlank: false,
                                                                store: stSintomatologiaPositivoNegativo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Percusion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_PercusionH'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                width: 150,
                                                                fieldLabel: 'Palpación',
                                                                name: 'Palpación',
                                                                allowBlank: false,
                                                                store: stSintomatologiaPositivoNegativo,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strSintomatologia_Palpacion'
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                width: 650,
                                                                emptyText: 'DESCRIPCION',
                                                                name: 'DESCRIPCION',
                                                                grow: true,
                                                                allowBlank: true,
                                                                id: 'memSintomatologia_PalpacionH'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '3. Examen Clínico del Diente',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '99%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        autoScroll: true,
                                                        anchor: '100%',
                                                        frame: true,
                                                        border: false,
                                                        layout: 'table',
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '1. Caries',
                                                                        name: '1. Caries',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Caries',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CariesH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 1. Caries",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CariesH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '2. Pérdida del tejido dental',
                                                                        name: '2. Pérdida del tejido dental',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_PerdidaTejido',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_PerdidaTejidoH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS - 2. Pérdida del tejido dental",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_PerdidaTejidoH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '3. Cambio de Color',
                                                                        name: '3. Cambio de Color',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_CambioColor',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CambioColorH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CambioColorH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '4. Edema Intraoral',
                                                                        name: '4. Edema Intraoral',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_EdemaIntraoral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaIntraoralH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_EdemaIntraoralH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '5. Edema Extraoral',
                                                                        name: '5. Edema Extraoral',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_EdemaExtraoral',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_EdemaExtaoralH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_EdemaExtaoralH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '6. Tracto Sinusal (fístula)',
                                                                        name: '6. Tracto Sinusal (fístula)',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_TractoSinusal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_TractoSinusalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_TractoSinusalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '7. Compromiso Endo-Periodontal',
                                                                        name: '7. Compromiso Endo-Periodontal',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_CompromisoEndoPeriodontal',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_CompromisoEndoPeriodontalH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_CompromisoEndoPeriodontalH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '8. Sondaje (presencia de bolsa)',
                                                                        name: '8. Sondaje (presencia de bolsa)',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Sondaje',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_SondajeH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_SondajeH'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                width: 110,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: '9. Movilidad',
                                                                        name: '9. Movilidad',
                                                                        width: 100,
                                                                        allowBlank: false,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        value: "NO",
                                                                        id: 'strEXACLINICO_Movilidad',
                                                                        listeners:{
                                                                            select : function(cmb, rec, idx){
                                                                                if(cmb.getValue() == "NO"){
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').allowBlank = true;
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').setValue(null);
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').disable();
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').clearInvalid();
                                                                                }else{
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').enable();
                                                                                    Ext.getCmp('memEXACLINICO_MovilidadH').allowBlank = false;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel', 
                                                                width: 700,
                                                                layout: 'form',
                                                                labelAlign: 'top',
                                                                border: false,
                                                                autoHeight: true,
                                                                items: [
                                                                    {
                                                                        xtype: 'textarea',
                                                                        emptyText: 'HALLAZGOS',
                                                                        name:"HALLAZGOS",
                                                                        disabled: true,
                                                                        height: 20,
                                                                        anchor: '99%',
                                                                        grow: true,
                                                                        growMin: 20,
                                                                        growMax: 400,
                                                                        allowBlank: true,
                                                                        id: 'memEXACLINICO_MovilidadH'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: '4. Evaluación Radiográfica',
                                                layout: 'table',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        width: 850,
                                                        fieldLabel: 'EVALUACION RADIOGRAFICA',
                                                        name: 'EVALUACION RADIOGRAFICA',
                                                        grow: true,
                                                        allowBlank: false,
                                                        id: 'memEvaluacionRadiografica'
                                                    }
                                                ]
                                            },
                                            //
                                            {
                                                xtype: 'panel',
                                                title: '<center>TERAPIA DE CONDUCTOS</center>',
                                                layout: 'form',
                                                anchor: '100%',
                                                autoHeight: true,
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 5
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 270,
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>Variable</center>&nbsp;',
                                                                items: [               
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        name: 'Conducto',
                                                                        value: 'Conducto',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        style: 'background:transparent; border: none;',
                                                                        id: 'strTerapiaConductoVar1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        name: 'Referencia Cuspidea',
                                                                        value: 'Referencia Cuspidea',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        style: 'background:transparent; border: none;',
                                                                        id: 'strTerapiaConductoVar2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        name: 'Conductometria Tentativa (mm)',
                                                                        value: 'Conductometria Tentativa (mm)',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        style: 'background:transparent; border: none;',
                                                                        id: 'strTerapiaConductoVar3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        name: 'Secuencia de Limas Trabajo',
                                                                        value: 'Secuencia de Limas Trabajo',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        style: 'background:transparent; border: none;',
                                                                        id: 'strTerapiaConductoVar4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        name: 'Lima Apical Principal',
                                                                        value: 'Lima Apical Principal',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        style: 'background:transparent; border: none;',
                                                                        id: 'strTerapiaConductoVar5'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        name: 'Cono Principal',
                                                                        value: 'Cono Principal',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        style: 'background:transparent; border: none;',
                                                                        id: 'strTerapiaConductoVar6'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        name: 'Irrigador Utilizado',
                                                                        value: 'Irrigador Utilizado',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        style: 'background:transparent; border: none;',
                                                                        id: 'strTerapiaConductoVar7'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 250,
                                                                        name: 'Cemento Utilizado',
                                                                        value: 'Cemento Utilizado',
                                                                        allowBlank: true,
                                                                        readOnly: true,
                                                                        style: 'background:transparent; border: none;',
                                                                        id: 'strTerapiaConductoVar8'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 120,
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>1</center>&nbsp;',
                                                                items: [               
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Conducto 1 - Superficies',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto1_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Referencia Cuspidea 1',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto2_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Conductometria Tentativa (mm) 1',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto3_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Secuencia de Limas Trabajo 1',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto4_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Lima Apical Principal 1',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto5_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Cono Principal 1',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto6_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Irrigador Utilizado 1',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto7_1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Cemento Utilizado 1',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto8_1'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 120,
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>2</center>&nbsp;',
                                                                items: [               
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Conducto 2 - Superficies',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto1_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Referencia Cuspidea 2',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto2_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Conductometria Tentativa (mm) 2',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto3_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Secuencia de Limas Trabajo 2',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto4_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Lima Apical Principal 2',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto5_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Cono Principal 2',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto6_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Irrigador Utilizado 2',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto7_2'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Cemento Utilizado 2',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto8_2'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 120,
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>3</center>&nbsp;',
                                                                items: [               
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Conducto 3 - Superficies',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto1_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Referencia Cuspidea 3',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto2_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Conductometria Tentativa (mm) 3',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto3_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Secuencia de Limas Trabajo 3',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto4_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Lima Apical Principal 3',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto5_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Cono Principal 3',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto6_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Irrigador Utilizado 3',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto7_3'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Cemento Utilizado 3',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto8_3'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 120,
                                                                autoHeight: true,
                                                                labelWidth: 1,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                title: '<center>4</center>&nbsp;',
                                                                items: [               
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Conducto 4 - Superficies',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto1_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Referencia Cuspidea 4',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto2_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Conductometria Tentativa (mm) 4',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto3_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Secuencia de Limas Trabajo 4',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto4_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Lima Apical Principal 4',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto5_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Cono Principal 4',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto6_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Irrigador Utilizado 4',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto7_4'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        width: 100,
                                                                        name: 'Cemento Utilizado 4',
                                                                        allowBlank: true,
                                                                        id: 'strTerapiaConducto8_4'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            // aqui
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,            
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INCAPACIDAD',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Dias',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                width: 50,
                                                                name: 'INCAPACIDAD DIAS',
                                                                minValue: 0,
                                                                allowBlank: true,
                                                                style: 'text-align:center;',
                                                                id: 'intDiasIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        //new Date(año,mes,dia) 01/05/2010
                                                                        if(Ext.getCmp('fecDesdeIncapacidad').getValue() === null || Ext.getCmp('fecDesdeIncapacidad').getValue() === ""){
                                                                            Ext.getCmp('fecDesdeIncapacidad').setValue(new Date().format('d/m/Y'));
                                                                        }
                                                                        var xFecha = Ext.getCmp('fecDesdeIncapacidad').getValue().format('d/m/Y');
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(pNew > 0)
                                                                            DiasIncapacidad = pNew - 1;
                                                                        else
                                                                            DiasIncapacidad = pNew;
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncDsd',
                                                                value: 'Desde:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD DESDE',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecDesdeIncapacidad',
                                                                listeners:{
                                                                    change : function(f,pNew, pOld){
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(null);
                                                                        Ext.getCmp('fecHastaIncapacidad').setMinValue(pNew.format("d/m/Y"));
                                                                        Ext.getCmp('fecHastaIncapacidad').clearInvalid();
                                                                        var xFecha = pNew.format('d/m/Y');
                                                                        var xMes = xFecha.substr(3,2);
                                                                        var NewFecha = new Date(xFecha.substr(6,10),(xMes-1),xFecha.substr(0,2));
                                                                        if(Ext.getCmp('intDiasIncapacidad').getValue() > 0){
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue() - 1;
                                                                        }else{
                                                                            DiasIncapacidad = Ext.getCmp('intDiasIncapacidad').getValue();
                                                                        }
                                                                        NewFecha.setDate(NewFecha.getDate()+DiasIncapacidad);
                                                                        Ext.getCmp('fecHastaIncapacidad').setValue(NewFecha.format('d/m/Y'));
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'displayfield',
                                                                id: 'sysIncHst',
                                                                value: 'Hasta:'
                                                            },
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                name: 'INCAPACIDAD HASTA',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecHastaIncapacidad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        fieldLabel: 'Observaciones',
                                                        items: [
                                                            {
                                                                xtype: 'textarea',
                                                                anchor: '100%',
                                                                width: 615,
                                                                name: 'INCAPACIDAD OBSERVACIONES',
                                                                height: 50,
                                                                allowBlank: true,
                                                                id: 'memIncapacidadObserva'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnImprimir',
                                                                text: 'Imprimir Incapacidad',
                                                                tooltip: 'Imprimir Incapacidad',
                                                                id: 'btnPrintIncapacidadHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        if (Ext.getCmp('sysYaGuardoHC').getValue() === 1)
                                                                            window.open ("../../controlador/asistencial/printincapacidad0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() + "&pConsecutivo=" + Ext.getCmp('sysConsecutivoDetalleHC').getValue(),"Incapacidad");
                                                                        else{
                                                                            Ext.Msg.show({
                                                                                title: 'eOfiClinic',
                                                                                msg: 'Usted No ha Guardado la Evolución',
                                                                                buttons: Ext.Msg.OK,
                                                                                icon: Ext.Msg.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapsible: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                id: 'fsRips',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue() === null || Ext.getCmp('sysDiagPpalHCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() !== "" && Ext.getCmp('sysDiagPpalHC').getValue() !== null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue === null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() !== "" && Ext.getCmp('sysDiagRel1HC').getValue() !== null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue === null || Ext.getCmp('sysDiagRel2HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() !== "" && Ext.getCmp('sysDiagRel2HC').getValue() !== null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue === null || Ext.getCmp('sysDiagRel3HCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() !== "" && Ext.getCmp('sysDiagRel3HC').getValue() !== null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() !== Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }                            
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Carta Dental Inicial (LEY 38/93)',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaCartaDentalInicial',
                                items: [
                                    xCartaDental
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Diagrama Control de Placa Bacteriana',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                width: 1005,
                                id: 'fichaDiagramaControlPlaca',
                                items: [
                                    xControlPlaca
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Realizadas',
                                autoHeight: true,
                                autoScroll: true,
                                width: 1005,
                                frame: true,
                                border: false,
                                id: 'fichaActividades',
                                items: [
                                    xActividadesRealizdas
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Registro de Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Guias de Manejo / Recomendaciones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaGuiasManejo',
                                layout: 'form',
                                items: [
                                    xGuiasAtencion
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() === 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCOdontologia004').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCOdontologia004').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0){
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    fnGuardarRegistrosEndodoncia();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn === "yes")
                                                {
                                                    fnModificarRegistrosEndodoncia();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Ajax.request({
                    url: '../../controlador/estudios/controlador_estudios.php',
                    params:{
                        task: 'BUSCAR_PARAMETROS_COBRO',
                        pCAS: myCAS
                    },
                    success: function(response,options)
                    {
                        var el = Ext.get('response'); // get the LOG
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                            Ext.getCmp('sysTipoAfiliadoHC').setValue(null);
                            Ext.getCmp('sysRangoAfiliadoHC').setValue(null);
                            Ext.getCmp('sysCMAfiliadoHC').setValue(0);
                            Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(0);
                            Ext.getCmp('sysFacturarPacienteHC').setValue(0);
                            Ext.getCmp('sysFacturarParticularHC').setValue(0);
                            Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(0);
                            Ext.getCmp('sysFacturarCopagosHC').setValue(0);
                            Ext.getCmp('sysMaxCopagoHC').setValue(0);
                        } else {
                            switch(Contenido[0]){
                                case "B":
                                    Ext.getCmp('sysTipoAfiliadoHC').setValue("BENEFICIARIO");
                                    Ext.getCmp('strTipoAfiliadoHC').setValue("BENEFICIARIO");
                                    break;
                                case "C":
                                    Ext.getCmp('sysTipoAfiliadoHC').setValue("COTIZANTE");
                                    Ext.getCmp('strTipoAfiliadoHC').setValue("COTIZANTE");
                                    break;
                                default:
                                    switch(Contenido[9]){
                                        case "B":
                                            Ext.getCmp('sysTipoAfiliadoHC').setValue("BENEFICIARIO");
                                            Ext.getCmp('strTipoAfiliadoHC').setValue("BENEFICIARIO");
                                            break;
                                        case "C":
                                            Ext.getCmp('sysTipoAfiliadoHC').setValue("COTIZANTE");
                                            Ext.getCmp('strTipoAfiliadoHC').setValue("COTIZANTE");
                                            break;
                                        default:
                                            Ext.getCmp('sysTipoAfiliadoHC').setValue("");
                                            Ext.getCmp('strTipoAfiliadoHC').setValue("");
                                            break;
                                    }
                                    break;
                            }
                            Ext.getCmp('sysRangoAfiliadoHC').setValue(Contenido[1]);
                            Ext.getCmp('sysCMAfiliadoHC').setValue(Contenido[7]);
                            Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(Contenido[2]);
                            Ext.getCmp('sysFacturarPacienteHC').setValue(Contenido[3]);
                            Ext.getCmp('sysFacturarParticularHC').setValue(Contenido[4]);
                            Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(Contenido[5]);
                            Ext.getCmp('sysFacturarCopagosHC').setValue(Contenido[6]);
                            Ext.getCmp('sysMaxCopagoHC').setValue(Contenido[8]);
                        }
                    },
                    failure: function(response,options){
                        var el = Ext.get('response');
                        Ext.getCmp('sysTipoAfiliadoHC').setValue(null);
                        Ext.getCmp('sysRangoAfiliadoHC').setValue(null);
                        Ext.getCmp('sysCMAfiliadoHC').setValue(0);
                        Ext.getCmp('sysPorCopagoAfiliadoHC').setValue(0);
                        Ext.getCmp('sysFacturarPacienteHC').setValue(0);
                        Ext.getCmp('sysFacturarParticularHC').setValue(0);
                        Ext.getCmp('sysRecaudoAutomaticoParticularesHC').setValue(0);
                        Ext.getCmp('sysFacturarCopagosHC').setValue(0);
                        Ext.getCmp('sysMaxCopagoHC').setValue(0);
                    },
                    scope:this 
                });
                Ext.Msg.hide();
                if(paramOpcion === "Nuevo"){ 
                    var frm = Ext.getCmp('frmHC').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/asistencial/evolucionhc2014.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pCAS: myCAS,
                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                            task: 'ImportarOdontologia'
                        },
                        success:function(form, action) {
                            var frm = Ext.getCmp('frmHC').getForm();
                            frm.doAction('load', {
                                url: '../../controlador/asistencial/evolucionhc2014.php',
                                waitMsg: 'Cargando Información...',
                                params:{
                                    pCAS: myCAS,
                                    pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                    task: 'ImportarFactoresRiesgo4505'
                                },
                                success:function(form, action) {

                                }
                            });
                        }
                    });
                    //Predefinir Comportamiento Campos
                    if(Ext.getCmp('sysFechaHC').getValue() !== null || Ext.getCmp('sysFechaHC').getValue() !== 0){
                       calculoEdadPacienteMeses();
                    }
                    //Cargar Guias de Atencion
                    Ext.getCmp('gridGuiasAtencion').store.load({
                        params: {
                            pPlantilla: Ext.getCmp('sysIdCodPlantillaHC').getValue()
                        }
                    });
                }
            }}
        });
        winHCOdontologia004Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosEndodoncia(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //ANTECEDENTES
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pNefropatias: Ext.getCmp('bolANTPERSONefropatias').getValue(),
                pInfertilidad: Ext.getCmp('bolANTPERSOInfertilidad').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCardiopatias: Ext.getCmp('bolANTPERSOCardiopatias').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pLactanciaHoy: Ext.getCmp('strANTGINECOLactanciaHoy').getValue(),
                pLactanciaPasado: Ext.getCmp('strANTGINECOLactanciaPasado').getValue(),
                pTiempoLactancia: Ext.getCmp('strANTGONECOTiempoLactancia').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pCiclosMeuales: Ext.getCmp('strANTGINECOCiclosMestruales').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                pGuardarAntecedentes: "NO"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosEndodoncia(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2014.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                
                /*
                //4505 IDENTIFICACION RIESGO
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pEnfermedadMental4505: Ext.getCmp('intIdentificacionRiesgoEnfermedadMental').getValue(),
                pTransmisionSexual4505: Ext.getCmp('intIdentificacionRiesgoInfeccionesTransmisionSexual').getValue(),
                pSintomaticoRespiratorio4505: Ext.getCmp('intIdentificacionRiesgoSintomaticoRespiratorio').getValue(),
                
                //ANTECEDENTES
                pPatologicos: Ext.getCmp('memANTPERSOPatologicos').getValue(),
                pFarmacologicos: Ext.getCmp('memANTPERSOFarmacologicos').getValue(),
                pQuirurgicos: Ext.getCmp('memANTPERSOQuirurgicos').getValue(),
                pTraumatologicos: Ext.getCmp('memANTPERSOTraumatologicos').getValue(),
                pToxicologicos: Ext.getCmp('memANTPERSOToxicologicos').getValue(),
                pAlergicos: Ext.getCmp('memANTPERSOAlergicos').getValue(),
                pHTA: Ext.getCmp('bolANTPERSOHTA').getValue(),
                pDiabetes: Ext.getCmp('bolANTPERSODiabetes').getValue(),
                pNefropatias: Ext.getCmp('bolANTPERSONefropatias').getValue(),
                pInfertilidad: Ext.getCmp('bolANTPERSOInfertilidad').getValue(),
                pVIH: Ext.getCmp('bolANTPERSOVIH').getValue(),
                pCardiopatias: Ext.getCmp('bolANTPERSOCardiopatias').getValue(),
                pGest: Ext.getCmp('intANTGINECOG').getValue(),
                pPartos: Ext.getCmp('intANTGINECOP').getValue(),
                pPVaginales: Ext.getCmp('intANTGINECOPV').getValue(),
                pAbortos: Ext.getCmp('intANTGINECOA').getValue(),
                pVivos: Ext.getCmp('intANTGINECOVivos').getValue(),
                pMuertos: Ext.getCmp('intANTGINECOMuertos').getValue(),
                pMola: Ext.getCmp('bolANTGINECOMola').getValue(),
                pEmbEctopico: Ext.getCmp('bolANTGINECOEmbEctopico').getValue(),
                pPreclampsia: Ext.getCmp('bolANTPERSOPreclampsia').getValue(),
                pEclampsia: Ext.getCmp('bolANTPERSOEclampsia').getValue(),
                pLactanciaHoy: Ext.getCmp('strANTGINECOLactanciaHoy').getValue(),
                pLactanciaPasado: Ext.getCmp('strANTGINECOLactanciaPasado').getValue(),
                pTiempoLactancia: Ext.getCmp('strANTGONECOTiempoLactancia').getValue(),
                pMenarquia: Ext.getCmp('strANTGINECOMenarquia').getValue(),
                pFum: Ext.getCmp('fecANTGINECOFum').getValue(),
                pFup: Ext.getCmp('fecANTGINECOFup').getValue(),
                pfecfuc: Ext.getCmp('fecANTGINECOFuc').getValue(),
                pFucRes: Ext.getCmp('strANTGINECOFucRes').getValue(),
                pMetodoPlanifica: Ext.getCmp('strANTGINECOMetodoPlanifica').getValue(),
                pCiclosMeuales: Ext.getCmp('strANTGINECOCiclosMestruales').getValue(),
                pActividadSexual: Ext.getCmp('strANTGINECOActividadSexual').getValue(),
                pPatologiaEmbarazo: Ext.getCmp('strANTGINECOPatologiaEmbarazo').getValue(),
                pMenopausia: Ext.getCmp('strANTGINECOMenopausia').getValue(),
                pAntFamiliares: Ext.getCmp('memAntecedentesFamiliares').getValue(),
                */
                pGuardarAntecedentes: "NO"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnEliminarRegistrosEndo(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}


function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}