/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCPostParto001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Post Parto ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHCPostParto',
    initComponent: function() {
        
        var fsDiagnosticosConsulta = new fsDiagnosticosConsultaUi();
        var fsRevisionxSistemas = new fsRevisionxSistemasUi();
        var fsAntecedentesPersonales = new fsAntecedentesPersonalesUi();
        var fsAntecedentesFamiliares = new fsAntecedentesFamiliaresUi();
        var fsExamenFisico = new fsExamenFisicoUi();
        var pnRecienNacido = new pnRecienNacidoUi();
        
        var xGridVacunacion = new GridVacunacionUi();
        var xGridActividadesAdicionales = new GridActividadesAdicionalesUi();
        
        
        //Guias Atencion
        var xGuiasAtencion = new GridGuiasAtencionUi();
        //Fichas de Notificacion
        var xFichasNotificacion = new GridFichasNotificacionUi();
        //Docuentos Anexos
        var xDocumentosAnexos = new GridDocumentosAnexosUi();
        
        
        //Reporte Paraclinicos
        var stReporteParaclinicos = new StoreGridReporteParaclinicos();
        stReporteParaclinicos.load({
            params: {
                pPaciente: wPaciente
            }
        });
        //Alertas Medicas
        var xAlertasxPaciente = new AlertasxPaciente001Ui();
        Ext.getCmp('gridAlertasPacientes').store.baseParams = {
            task: 'LISTAR_ALERTAS',
            pPaciente: wPaciente,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridAlertasPacientes').store.load({
            params: {
                pPaciente: wPaciente
            }
        });
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });
        //
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHCPostParto',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Acompañante',
                                                        name: 'Acompañante',
                                                        width: 350,
                                                        allowBlank: true,
                                                        id: 'strDATINGPROGAcompanante'
                                                    },
                                                    {
                                                        html: '   Parentesco:'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Parentezco',
                                                        width: 350,
                                                        allowBlank: true,
                                                        store: stParentesco,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        id: 'strDATINGPROGParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ENFERMEDAD ACTUAL',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'ENFERMEDAD ACTUAL',
                                                        name: 'ENFERMEDAD ACTUAL',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEnfermedadActual'
                                                    }
                                                ]
                                            },
                                            fsRevisionxSistemas,
                                            fsAntecedentesPersonales,
                                            fsAntecedentesFamiliares,
                                            fsExamenFisico,
                                            pnRecienNacido,
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'FORMULACION POST-FECHA',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Realizar Formulacion para',
                                                        name: 'Realizar Formulacion para',
                                                        width: 250,
                                                        allowBlank: true,
                                                        store: stMesesFormulacion,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 1,
                                                        id: 'sysFormulacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'INFORMACION PROXIMA CITA',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 5,
                                                items: [
                                                        {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                width: 120,
                                                                fieldLabel: 'Fecha Probable Proxima Cita',
                                                                name: 'Fecha Probable Proxima Cita',
                                                                allowBlank: true,
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecPROXCITACita'
                                                            },
                                                            {
                                                                html: 'Profesional que Atiende'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Profesional que Atiende',
                                                                width: 250,
                                                                allowBlank: true,
                                                                store: stProfesionalAtiende,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strPROXCITAProfesionalAtiende'
                                                            },
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'Observacion',
                                                        name: 'Observacion',
                                                        height: 100,
                                                        allowBlank: true,
                                                        id: 'memPROXCITAObservacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'CONDUCTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'CONDUCTA',
                                                        name: 'CONDUCTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memConducta'
                                                    }
                                                ]
                                            },
                                            fsDiagnosticosConsulta
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Ver Documentos Anexos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaDocumentosAnexos',
                                layout: 'form',
                                items: [
                                    xDocumentosAnexos
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Reporte de Paraclinicos y/o Examenes',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaParaclinicos',
                                layout: 'form',
                                items: [
                                     {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridReporteParaclinicos',
                                        store: stReporteParaclinicos,
                                        anchor: "100%",
                                        height: 320,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'IdConsecutivoReporte'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Descripcion',
                                                sortable: false,
                                                width: 300,
                                                dataIndex: 'DescProced'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Solicitud',
                                                sortable: false,
                                                width: 90,
                                                dataIndex: 'FechaSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha Realiza',
                                                sortable: false,
                                                width: 120,
                                                dataIndex: 'FechaRealizacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Reporte',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderValorReporte,
                                                dataIndex: 'ReporteTxt'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Observaciones',
                                                sortable: false,
                                                width: 150,
                                                renderer: renderObservaReporte,
                                                dataIndex: 'Observaciones'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Clasificacion',
                                                sortable: false,
                                                width: 80,
                                                renderer: renderClasificacionReporte,
                                                dataIndex: 'Clasificacion'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Solicitante',
                                                sortable: false,
                                                width: 150,
                                                dataIndex: 'Solicitante'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        viewConfig: {
                                            getRowClass: function(record, index) {
                                                if (record.get('Estado') === 'S')
                                                    return 'Negado';
                                                else
                                                    return;
                                            }
                                        },
                                        iconCls:'icon-grid',
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Adicionar',
                                                        iconCls: 'btnAddRow',
                                                        listeners: {
                                                            click : function() {
                                                                var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(0);
                                                                winReporteParaclinicos.show();
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Reportar',
                                                        iconCls: 'btnEditRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if(parseInt(selections[0].json.CASReporte) === parseInt(wCAS)){
                                                                        var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                        Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                        Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                        Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                        Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                        Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                        Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                        Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                        Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                        Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                        Ext.getCmp('strResultadoReporteParaclin').setValue(selections[0].json.ReporteTxt);
                                                                        Ext.getCmp('intValorReporteParaclin').setValue(selections[0].json.ReporteVal);
                                                                        Ext.getCmp('strClasificacionReporteParaclin').setValue(selections[0].json.Clasificacion);
                                                                        Ext.getCmp('strObservacionesReporteParaclin').setValue(selections[0].json.Observaciones);
                                                                        Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                        winReporteParaclinicos.show();
                                                                    }else{
                                                                        if(selections[0].json.Estado === "S"){
                                                                            var winReporteParaclinicos = new winReporteParaclinicos001Ui();
                                                                            Ext.getCmp('intPacienteReporteParaclin').setValue(wPaciente);
                                                                            Ext.getCmp('intCASReporteParaclin').setValue(wCAS);
                                                                            Ext.getCmp('intUsuarioReporteParaclin').setValue(ID_USUARIO);
                                                                            Ext.getCmp('intIdConsecutivoReporteParaclin').setValue(selections[0].json.IdConsecutivoReporte);
                                                                            Ext.getCmp('intConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.IdProced);
                                                                            Ext.getCmp('strNomConceptoOfiMedicalReporteParaclin').setValue(selections[0].json.DescProced);
                                                                            Ext.getCmp('strNomQuienSolicitaReporteParaclin').setValue(selections[0].json.Solicitante);
                                                                            //Ext.getCmp('strNomQuienSolicitaReporteParaclin').setReadOnly(true);
                                                                            Ext.getCmp('fecFecSolicitudReporteParaclin').setValue(selections[0].json.FechaSolicitud);
                                                                            Ext.getCmp('fecFecRealizacionReporteParaclin').setValue(selections[0].json.FechaRealizacion);
                                                                            Ext.getCmp('sysSearchReporteParaclin').setVisible(false);
                                                                            winReporteParaclinicos.show();
                                                                        }else{
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error',
                                                                                msg: 'El registro no esta disponible para ser reportado',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Eliminar',
                                                        iconCls: 'btnDelRow',
                                                        listeners: {
                                                            click : function() {
                                                                if(Ext.getCmp('gridReporteParaclinicos').selModel.getCount() === 1){
                                                                    var selections = Ext.getCmp('gridReporteParaclinicos').selModel.getSelections();
                                                                    if((selections[0].json.CAS === null || selections[0].json.CAS === "") && selections[0].json.Estado === "S" && parseInt(selections[0].json.Usuario) === parseInt(Ext.getCmp('sysUsuarioHC').getValue())){
                                                                        Ext.Msg.show({
                                                                            title: 'Reporte Paraclinicos',
                                                                            msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.DescProced + '?',
                                                                            buttons: Ext.Msg.YESNO,
                                                                            icon: Ext.Msg.QUESTION,
                                                                            fn: function(btn){
                                                                                if(btn ==="yes"){
                                                                                    fnEliminarRegistrosReporteParaclinicos001("../../controlador/asistencial/evolucionhc2013.php",{task: "ELIMINAR_REPORTEEXA", pIdReporte: selections[0].json.IdConsecutivoReporte}, 'gridReporteParaclinicos');
                                                                                }
                                                                            }
                                                                        });
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'No podemos eliminar los registro en estos momentos',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    new Ext.app.SearchField({
                                                        id: 'qryReporteParaclin',
                                                        store: stReporteParaclinicos,
                                                        ValparamP1: wPaciente,
                                                        emptyText: 'Escriba el criterio que desea buscar',
                                                        width: 120,
                                                        pLoadGrid: false,
                                                        pGrid: 'gridReporteParaclinicos',
                                                        parrParam: {params:{pPaciente: wPaciente}}
                                                    })
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Actividades Adicionales',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaActividadesAdicionales',
                                layout: 'form',
                                items: [
                                    xGridActividadesAdicionales
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Vacunacion',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaVacunacion',
                                layout: 'form',
                                items: [
                                    xGridVacunacion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Registro de Alertas',
                                height: 380,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaAlertas',
                                items: [
                                    xAlertasxPaciente
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Guias de Manejo / Recomendaciones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaGuiasManejo',
                                layout: 'form',
                                items: [
                                    xGuiasAtencion
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Fichas de Notificacion',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaFichasNotificacion',
                                layout: 'form',
                                items: [
                                    xFichasNotificacion
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCPostParto').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHCPostParto').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosPostParto();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosPostParto();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos

                    if(Ext.getCmp('sysFechaHC').getValue() != null || Ext.getCmp('sysFechaHC').getValue() != 0){
                       calculoEdadPacienteMeses()
                    }

                    Ext.getCmp('sysFinalidadConsultaHC').setValue(01);
                    
                    //EVALUAR EDADES
                    //COMPANANTE MENOR A 14 ANOS
                    
                    if(MesesCumplidos <= 179){
                        Ext.getCmp('strDATINGPROGAcompanante').allowBlank = false;
                        Ext.getCmp('strDATINGPROGParentesco').allowBlank = false;
                    }else{
                        Ext.getCmp('strDATINGPROGAcompanante').allowBlank = true;
                        Ext.getCmp('strDATINGPROGParentesco').allowBlank = true;
                    }
                                        
                    //IDENTIFICACION DEL RIESGO FILTROS
                    if(Ext.getCmp('sysGeneroHC').getValue()=="FEMENINO" && MesesCumplidos >= 121){
                        Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoGestacion').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoGestacion').disable();
                    }
                    if(Ext.getCmp('sysGeneroHC').getValue()=="FEMENINO" || MesesCumplidos <= 216){
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').disable();
                    }
                    if(MesesCumplidos <= 36){
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').disable();
                    }
                    
                    //CARGAR ANTECEDENTES
                    if(paramOpcion === "Nuevo"){ 
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/evolucionhc.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: myCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesFamiliares'
                            },
                            success: function(result, request)
                            {
                                var jsonAntFamiliares = Ext.util.JSON.decode(result.responseText);
                                CargarDataHCAntecedentes(jsonAntFamiliares.data.sysEvolucion);
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            },
                            scope:this
                        });
                    }
                }
            }
        });
        winHCPostParto001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosPostParto(){
    var frm = Ext.getCmp('frmHCPostParto').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosPostParto(){
    var frm = Ext.getCmp('frmHCPostParto').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: Ext.getCmp('sysFormulacion').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoRiesgoReproductivo(){
    var TotatRiegoReproductivo = 0;
    var valEdadMujer = 0;
    var valParidad = 0;
    var valSocioEconomico = 0;
    var valIntervaloEmbarazos = 0;
    var valAbortos = 0;
    var valCesarea = 0;
    var valMortinato = 0;
    var valPrematuros = 0;
    var valHipertension = 0;
    var valPreclampsia = 0;
    var valCardiopatia = 0;
    var valOtraPatologia = 0;


    valEdadMujer = Ext.getCmp('strPOSTPAREdadMujer').getValue();
    valParidad = Ext.getCmp('strPOSTPARParidad').getValue();
    valSocioEconomico = Ext.getCmp('strPOSTPARSocioEconomico').getValue();
    valIntervaloEmbarazos = Ext.getCmp('strPOSTPARIntervaloEmbarazos').getValue();
    valAbortos = Ext.getCmp('strPOSTPARAbortos').getValue();
    valCesarea = Ext.getCmp('strPOSTPARCesarea').getValue();
    valMortinato = Ext.getCmp('strPOSTPARMortinato').getValue();
    valPrematuros = Ext.getCmp('strPOSTPARPrematuros').getValue();
    valHipertension = Ext.getCmp('strPOSTPARHipertension').getValue();
    valPreclampsia = Ext.getCmp('strPOSTPARPreclampsia').getValue();
    valCardiopatia = Ext.getCmp('strPOSTPARCardiopatia').getValue();
    valOtraPatologia = Ext.getCmp('strPOSTPAROtraPatologia').getValue();




    TotatRiegoReproductivo = valEdadMujer + valParidad + valSocioEconomico + valIntervaloEmbarazos + valAbortos + valCesarea + valMortinato + valPrematuros + valHipertension + valPreclampsia + valCardiopatia + valOtraPatologia;

    if(TotatRiegoReproductivo<5){
        Ext.getCmp('strPOSTPARRiesgoTotal').setValue(TotatRiegoReproductivo + " - RIESGO BAJO");
    }else{
        if(TotatRiegoReproductivo<10){
            Ext.getCmp('strPOSTPARRiesgoTotal').setValue(TotatRiegoReproductivo + " - RIESGO MEDIO");
        }else{
            Ext.getCmp('strPOSTPARRiesgoTotal').setValue(TotatRiegoReproductivo + " - RIESGO ALTO");
        }
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}