/*
* @category    Formulario Modelo Evolucion Historia Clinica Prioritaria
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winHCConsultas4505Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Consultas 4505 ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
        
        //
        
        var dataConsultas4505 = [
            [1,'Planificacion Familiar Primera Vez'],
            [2,'Atencion Prenatal Primera Vez'],
            [3,'Atencion Prenatal Control'],
            [4,'Agudeza Visual'],
            [5,'Oftalmologia'],
            [6,'Consulta Maltrato'],
            [7,'Consulta Violencia Sexual'],
            [8,'Nutricion'],
            [9,'Psicologia'],
            [10,'Crecimiento y Desarrollo Primera Vez'],
            [11,'Joven Primera Vez'],
            [12,'Adulto Primera Vez'],
            [13,'Asesoria Pre Test VIH'],
            [14,'Asesoria Post Test VIH']
        ];
        var stConsultas4505 = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stConsultas4505.loadData(dataConsultas4505);


        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 120,
                                                name: 'Fecha Servicio',
                                                allowBlank: false,
                                                hidden: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'fecServicio'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Tipo Consulta Realizada',
                                                fieldLabel: 'Tipo Consulta Realizada',
                                                width: 250,
                                                allowBlank: false,
                                                store: stConsultas4505,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                id: 'sysTipoConsulta',
                                                listeners:{
                                                    change : function( t, newValue, oldValue){
                                                        if(Ext.getCmp('fecServicio').getValue()== null || Ext.getCmp('fecServicio').getValue() == ""){
                                                            Ext.MessageBox.show({
                                                                title: 'Tipo Servicio',
                                                                msg: 'Por favor verifique que el campo "Fecha Servicio" este diligenciado',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                            Ext.getCmp('sysTipoConsulta').setValue(null);
                                                        }else{
                                                            if(Ext.getCmp('sysTipoConsulta').getValue()==1){
                                                                Ext.getCmp('sysPlanificacion4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'));
                                                                Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null);
                                                                Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                Ext.getCmp('sysNutricion4505').setValue(null);
                                                                Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                            }else{
                                                                if(Ext.getCmp('sysTipoConsulta').getValue()==2){
                                                                    Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                    Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                    Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                    Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                    Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                    Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                    Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                    Ext.getCmp('sysNutricion4505').setValue(null);
                                                                    Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                    Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                    Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                    Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                    Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                    Ext.getCmp('sysPostTestVIH4505').setValue(null)

                                                                }else{
                                                                    if(Ext.getCmp('sysTipoConsulta').getValue()==3){
                                                                        Ext.getCmp('sysPrenatalControl4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                        Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                        Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                        Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                        Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                        Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                        Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                        Ext.getCmp('sysNutricion4505').setValue(null);
                                                                        Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                        Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                        Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                        Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                        Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                        Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                    }else{
                                                                        if(Ext.getCmp('sysTipoConsulta').getValue()==4){
                                                                            Ext.getCmp('sysAgudezaVisual4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                            Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                            Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                            Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                            Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                            Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                            Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                            Ext.getCmp('sysNutricion4505').setValue(null);
                                                                            Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                            Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                            Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                            Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                            Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                            Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                        }else{
                                                                            if(Ext.getCmp('sysTipoConsulta').getValue()==5){
                                                                                Ext.getCmp('sysOftalmologia4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                                Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                            }else{
                                                                                if(Ext.getCmp('sysTipoConsulta').getValue()==6){
                                                                                    Ext.getCmp('sysMaltrato4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                    Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                    Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                    Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                    Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                    Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                    Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                    Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                    Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                    Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                    Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                    Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                    Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                                    Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                                }else{
                                                                                    if(Ext.getCmp('sysTipoConsulta').getValue()==7){
                                                                                        Ext.getCmp('sysViolenciaSexual4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                        Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                        Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                        Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                        Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                        Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                        Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                        Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                        Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                        Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                        Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                        Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                        Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                                        Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                                    }else{
                                                                                        if(Ext.getCmp('sysTipoConsulta').getValue()==8){
                                                                                            Ext.getCmp('sysNutricion4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                            Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                            Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                            Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                            Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                            Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                            Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                            Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                            Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                            Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                            Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                            Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                            Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                                            Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                                        }else{
                                                                                            if(Ext.getCmp('sysTipoConsulta').getValue()==9){
                                                                                                Ext.getCmp('sysPsicologia4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                                Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                                Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                                Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                                Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                                Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                                Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                                Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                                Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                                Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                                Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                                Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                                Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                                                Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                                            }else{
                                                                                                if(Ext.getCmp('sysTipoConsulta').getValue()==10){
                                                                                                    Ext.getCmp('sysCyDPrimeraVez4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                                    Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                                    Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                                    Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                                    Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                                    Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                                    Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                                    Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                                    Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                                    Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                                    Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                                    Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                                    Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                                                    Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                                                }else{
                                                                                                    if(Ext.getCmp('sysTipoConsulta').getValue()==11){
                                                                                                        Ext.getCmp('sysJovenPrimeraVez4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                                        Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                                        Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                                        Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                                        Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                                        Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                                        Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                                        Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                                        Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                                        Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                                        Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                                        Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                                        Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                                                        Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                                                    }else{
                                                                                                        if(Ext.getCmp('sysTipoConsulta').getValue()==12){
                                                                                                            Ext.getCmp('sysAdultoPrimeraVez4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                                            Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                                            Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                                            Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                                            Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                                            Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                                            Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                                            Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                                            Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                                            Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                                            Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                                            Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                                            Ext.getCmp('sysPreTestVIH4505').setValue(null);
                                                                                                            Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                                                        }else{
                                                                                                            if(Ext.getCmp('sysTipoConsulta').getValue()==13){
                                                                                                                Ext.getCmp('sysPreTestVIH4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                                                Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                                                Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                                                Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                                                Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                                                Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                                                Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                                                Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                                                Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                                                Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                                                Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                                                Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                                                Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                                                Ext.getCmp('sysPostTestVIH4505').setValue(null)
                                                                                                            }else{
                                                                                                                if(Ext.getCmp('sysTipoConsulta').getValue()==14){
                                                                                                                    Ext.getCmp('sysPostTestVIH4505').setValue(Ext.getCmp('fecServicio').getValue().format('Y-m-d'))
                                                                                                                    Ext.getCmp('sysPlanificacion4505').setValue(null);
                                                                                                                    Ext.getCmp('sysPrenatalPrimeraVez4505').setValue(null)
                                                                                                                    Ext.getCmp('sysPrenatalControl4505').setValue(null);
                                                                                                                    Ext.getCmp('sysAgudezaVisual4505').setValue(null);
                                                                                                                    Ext.getCmp('sysOftalmologia4505').setValue(null);
                                                                                                                    Ext.getCmp('sysMaltrato4505').setValue(null);
                                                                                                                    Ext.getCmp('sysViolenciaSexual4505').setValue(null);
                                                                                                                    Ext.getCmp('sysNutricion4505').setValue(null);
                                                                                                                    Ext.getCmp('sysPsicologia4505').setValue(null);
                                                                                                                    Ext.getCmp('sysCyDPrimeraVez4505').setValue(null);
                                                                                                                    Ext.getCmp('sysJovenPrimeraVez4505').setValue(null);
                                                                                                                    Ext.getCmp('sysAdultoPrimeraVez4505').setValue(null);
                                                                                                                    Ext.getCmp('sysPreTestVIH4505').setValue(null)
                                                                                                                }else{
                                                                                                                    alert("Seleccione un Tipo de Consulta")
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Planificacion',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysPlanificacion4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Prenatal Primera Vez',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysPrenatalPrimeraVez4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Prenatal Control',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysPrenatalControl4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Agudeza Visual',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysAgudezaVisual4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Oftalmologia',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysOftalmologia4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Maltrato',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysMaltrato4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Violencia Sexual',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysViolenciaSexual4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Nutricion',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysNutricion4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Psicologia',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysPsicologia4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'CyD Primera Vez',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysCyDPrimeraVez4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Joven Primera Vez',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysJovenPrimeraVez4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'Adulto Primera Vez',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysAdultoPrimeraVez4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'PreTest VIH',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysPreTestVIH4505'
                                            },
                                            {
                                                xtype: 'textfield',
                                                name: 'PostTest VIH',
                                                allowBlank: true,
                                                hidden: true,
                                                id: 'sysPostTestVIH4505'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IDENTIFICACION DEL RIESGO',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                labelSeparator: '',
                                                autoHeight: true,
                                                id: 'fsIdentificacionRiesgo',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 86,
                                                                allowBlank: false,
                                                                fieldLabel: 'Ocupacion',
                                                                name: 'Ocupacion',
                                                                id: 'strOcupacionHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                                        {
                                                                            if (f.getValue() !== "" && f.getValue() !== null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysOcupacionHCNom').getValue() === null || Ext.getCmp('sysOcupacionHCNom').getValue() === "")
                                                                        {
                                                                            if (Ext.getCmp('strOcupacionHC').getValue() !== "" && Ext.getCmp('strOcupacionHC').getValue() !== null){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('strOcupacionHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 615,
                                                                height: 22,
                                                                id: 'sysOcupacionHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Ocupacion',
                                                                id: 'btnSearchOcupacionHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarciuo('strOcupacionHC','sysOcupacionHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Etnia',
                                                                name: 'Etnia',
                                                                width: 330,
                                                                allowBlank: false,
                                                                store: 'StoreEtnia4505',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'intEtniaHC'
                                                            },
                                                            {
                                                                html: 'Escolaridad:'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                name: 'Escolaridad',
                                                                width: 330,
                                                                allowBlank: false,
                                                                store: 'StoreEscolaridad4505',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'intEscolaridadHC'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        html: '<br>'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        layout: 'table',
                                                        anchor: '100%',
                                                        padding: 0,
                                                        layoutConfig: {
                                                            columns: 2
                                                        },
                                                        autoHeight: true,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 400,
                                                                height: 310,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente en Gestacion?',
                                                                        fieldLabel: 'Paciente en Gestacion?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stGestacion,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoGestacion',
                                                                        listeners:{
                                                                            change : function( t, newValue, oldValue){
                                                                                if(newValue == 21 || newValue == 1){
                                                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').setValue(21);
                                                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').enable();
                                                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(21);
                                                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').enable();
                                                                                }else{
                                                                                    Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').setValue(0);
                                                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(0);
                                                                                    Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').disable();
                                                                                }
                                                                            }
                                                                        }
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Sifilis Gestacional o Congenita?',
                                                                        fieldLabel: 'Paciente con Sifilis Gestacional o Congenita?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stSifilisGestacional,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoSifilisGestacional'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Hipertension Gestacional?',
                                                                        fieldLabel: 'Paciente con Hipertension Gestacional?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stHipertencionGestacional,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoHipertencionGestacional'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Hipotiroidismo Congenito?',
                                                                        fieldLabel: 'Paciente con Hipotiroidismo Congenito?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stHipotiroidismoCongenito,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoHipotiroidismoCongenito'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Sintomático Respiratorio?',
                                                                        fieldLabel: 'Sintomático Respiratorio?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stSintomaticoRespiratorio,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoSintomaticoRespiratorio'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente Tuberculosis Multidrogoresistente?',
                                                                        fieldLabel: 'Paciente Tuberculosis Multidrogoresistente?',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stTuberculosisMultidrogoresistente,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoTuberculosisMultidrogoresistente'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                layout: 'form',
                                                                width: 400,
                                                                height: 310,
                                                                labelSeparator: '',
                                                                labelStyle: 'color:blue;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Lepra?',
                                                                        fieldLabel: 'Paciente con Lepra',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stLepra,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoLepra'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente Victima Maltrato',
                                                                        fieldLabel: 'Paciente Victima Maltrato',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stVictimaMaltrato,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoVictimaMaltrato'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente Victima Violencia Sexual',
                                                                        fieldLabel: 'Paciente Victima Violencia Sexual',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stViolenciaSexual,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoViolenciaSexual'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Infecciones de Trasmisión Sexual',
                                                                        fieldLabel: 'Infecciones de Trasmisión Sexual',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stInfeccionTransmiteSexual,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoInfeccionesTransmisionSexual'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Enfermedad Mental',
                                                                        fieldLabel: 'Enfermedad Mental',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stEnfermedadMental,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoEnfermedadMental'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        name: 'Paciente con Fluorosis Dental',
                                                                        fieldLabel: 'Paciente con Fluorosis Dental',
                                                                        width: 250,
                                                                        allowBlank: false,
                                                                        store: stFluorosisDental,
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        //value: 21,
                                                                        id: 'intIdentificacionRiesgoFluorosisDental'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EVOLUCION',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'EVOLUCION',
                                                        name: 'EVOLUCION',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memEvolucion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysCausaExternaHC'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos
                    if(Ext.getCmp('sysFechaHC').getValue() != null || Ext.getCmp('sysFechaHC').getValue() != 0){
                       calculoEdadPacienteMeses()
                       var pFec2Anio = Ext.getCmp('sysFechaHC').getValue().substr(0,4);
                       var pFec2Mes = Ext.getCmp('sysFechaHC').getValue().substr(5,2);
                       var pFec2Dia = Ext.getCmp('sysFechaHC').getValue().substr(8,2);
                       Ext.getCmp('fecServicio').setValue(pFec2Dia+"/"+pFec2Mes+"/"+pFec2Anio);
                    }
                    //IDENTIFICACION DEL RIESGO FILTROS
                    if(Ext.getCmp('sysGeneroHC').getValue()=="FEMENINO" && MesesCumplidos >= 121){
                        Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoGestacion').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoGestacion').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoGestacion').disable();
                        Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').disable();
                    }
                    if(Ext.getCmp('sysGeneroHC').getValue()=="FEMENINO" || MesesCumplidos <= 216){
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').disable();
                    }
                    if(MesesCumplidos <= 36){
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(21);
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').enable();
                    }else{
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').setValue(0);
                        Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').disable();
                    }
                    
                    //CARGAR ANTECEDENTES
                    if(paramOpcion === "Nuevo"){ 
                        Ext.Ajax.request({
                            url: '../../controlador/asistencial/evolucionhc.php',
                            waitMsg: 'Cargando Información...',
                            params:{
                                pCAS: wCAS,
                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                task: 'ImportarAntecedentesFamiliares'
                            },
                            success: function(result, request)
                            {
                                var jsonAntFamiliares = Ext.util.JSON.decode(result.responseText);
                                CargarDataHCAntecedentes(jsonAntFamiliares.data.sysEvolucion);
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: wCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            },
                            scope:this
                        });
                    }
                }
            }
        });
        winHCConsultas4505Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pPostTestVIH4505: Ext.getCmp('sysPostTestVIH4505').getValue(),
                pPreTestVIH4505: Ext.getCmp('sysPreTestVIH4505').getValue(),
                pAdultoPrimeraVez4505: Ext.getCmp('sysAdultoPrimeraVez4505').getValue(),
                pJovenPrimeraVez4505: Ext.getCmp('sysJovenPrimeraVez4505').getValue(),
                pCyDPrimeraVez4505: Ext.getCmp('sysCyDPrimeraVez4505').getValue(),
                pPsicologia4505: Ext.getCmp('sysPsicologia4505').getValue(),
                pNutricion4505: Ext.getCmp('sysNutricion4505').getValue(),
                pConsultaViolenciaSexual4505: Ext.getCmp('sysViolenciaSexual4505').getValue(),
                pMaltrato4505: Ext.getCmp('sysMaltrato4505').getValue(),
                pOftalmologia4505: Ext.getCmp('sysOftalmologia4505').getValue(),
                pAgudezaVisual4505: Ext.getCmp('sysAgudezaVisual4505').getValue(),
                pPrenatalControl4505: Ext.getCmp('sysPrenatalControl4505').getValue(),
                pPrenatalPrimeraVez4505: Ext.getCmp('sysPrenatalPrimeraVez4505').getValue(),
                pPlanificacion4505: Ext.getCmp('sysPlanificacion4505').getValue(),
                pGuardarSignos: "SI"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pFormulacion: 1,
                pOcupacion4505: Ext.getCmp('strOcupacionHC').getValue(),
                pEtnia4505: Ext.getCmp('intEtniaHC').getValue(),
                pEscolaridad4505: Ext.getCmp('intEscolaridadHC').getValue(),
                pGestacion4505: Ext.getCmp('intIdentificacionRiesgoGestacion').getValue(),
                pSifilisGestacional4505: Ext.getCmp('intIdentificacionRiesgoSifilisGestacional').getValue(),
                pHipertencionGestacional4505: Ext.getCmp('intIdentificacionRiesgoHipertencionGestacional').getValue(),
                pHipotiroidismoCongenito4505: Ext.getCmp('intIdentificacionRiesgoHipotiroidismoCongenito').getValue(),
                pTuberculosisMultidrogoresistente4505: Ext.getCmp('intIdentificacionRiesgoTuberculosisMultidrogoresistente').getValue(),
                pLepra4505: Ext.getCmp('intIdentificacionRiesgoLepra').getValue(),
                pVictimaMaltrato4505: Ext.getCmp('intIdentificacionRiesgoVictimaMaltrato').getValue(),
                pViolenciaSexual4505: Ext.getCmp('intIdentificacionRiesgoViolenciaSexual').getValue(),
                pFluorosisDental4505: Ext.getCmp('intIdentificacionRiesgoFluorosisDental').getValue(),
                pGuardarSignos: "SI",
                pPostTestVIH4505: Ext.getCmp('sysPostTestVIH4505').getValue(),
                pPreTestVIH4505: Ext.getCmp('sysPreTestVIH4505').getValue(),
                pAdultoPrimeraVez4505: Ext.getCmp('sysAdultoPrimeraVez4505').getValue(),
                pJovenPrimeraVez4505: Ext.getCmp('sysJovenPrimeraVez4505').getValue(),
                pCyDPrimeraVez4505: Ext.getCmp('sysCyDPrimeraVez4505').getValue(),
                pPsicologia4505: Ext.getCmp('sysPsicologia4505').getValue(),
                pNutricion4505: Ext.getCmp('sysNutricion4505').getValue(),
                pConsultaViolenciaSexual4505: Ext.getCmp('sysViolenciaSexual4505').getValue(),
                pMaltrato4505: Ext.getCmp('sysMaltrato4505').getValue(),
                pOftalmologia4505: Ext.getCmp('sysOftalmologia4505').getValue(),
                pAgudezaVisual4505: Ext.getCmp('sysAgudezaVisual4505').getValue(),
                pPrenatalControl4505: Ext.getCmp('sysPrenatalControl4505').getValue(),
                pPrenatalPrimeraVez4505: Ext.getCmp('sysPrenatalPrimeraVez4505').getValue(),
                pPlanificacion4505: Ext.getCmp('sysPlanificacion4505').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var pFec2Anio = 0;
    var pFec2Mes = 0;
    var pFec2Dia = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;
    AniosCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaHC').getValue();
    pFec2Anio = Ext.getCmp('sysFechaNac').getValue().substr(6,4);
    pFec2Mes = Ext.getCmp('sysFechaNac').getValue().substr(3,2);
    pFec2Dia = Ext.getCmp('sysFechaNac').getValue().substr(0,2);
    
    valFecha2 =  pFec2Anio + "/" + pFec2Mes + "/" + pFec2Dia;

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
    
    AniosCumplidos = MostrarEdadAnios(valFecha1, valFecha2);
}
