/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmVerAgenda = Ext.extend(winFrmVerAgendaUi, {
    initComponent: function() {
        winFrmVerAgenda.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: {'pPerfil': ID_PERFIL}
        });
        Ext.getCmp('sysProfeAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pUsuario: ID_USUARIO
            }
        }); 
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("");
        
        var sysProfesionalAgenda = Ext.getCmp('sysProfeAgenda').on("select",this.CargaUbicacionAgenda,this);
        var sysFechaAgenda = Ext.getCmp('sysFechaAgenda').on("select",this.CargaDetalleAgenda,this);
        var btnInasistenciaCita = Ext.getCmp('btnInasistenciaCita').on("click",this.InasistenciaCita,this);
        var btnActualizarAgenda = Ext.getCmp('btnActualizarAgenda').on("click",this.ActualizarAgenda,this);
        var btnEvolucionar = Ext.getCmp('btnEvolucionar').on("click",this.EvolucionarPaciente,this);
        var btnSalir = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion, this);
    },
    EvolucionarPaciente: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            //if (parseInt(selections[0].json.YaLegalizado) === 1){
                var winSeleccionPlantillaOpenHC = new winSeleccionPlantillaOpenHCUi();
                Ext.getCmp('sysEmpresaPlantillaHC').setValue(ID_EMPRESA);
                Ext.getCmp('sysSedePlantillaHC').setValue(ID_SEDE);
                Ext.getCmp('sysIPSPlantillaHC').setValue(ID_IPS);
                Ext.getCmp('sysUsuarioPlantillaHC').setValue(ID_USUARIO);
                Ext.getCmp('sysProfesionalPlantillaHC').setValue(Ext.getCmp('sysProfeAgenda').getValue());
                Ext.getCmp('sysPacientePlantillaHC').setValue(selections[0].json.Paciente);
                Ext.getCmp('sysUbicacionPlantillaHC').setValue(1);
                Ext.getCmp('sysCASPlantillaHC').setValue(selections[0].json.CAS);
                Ext.getCmp('sysConsecutivoDetalle_HC').setValue(selections[0].json.ConsecutivoDetalle);
                Ext.getCmp('sysNomProfesionalPlantillaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysProfeAgenda').getRawValue()));
                Ext.getCmp('sysConsultorioPlantillaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('sysUbicacionAgenda').getRawValue()));
                Ext.getCmp('sysFechaPlantillaHC').setValue(selections[0].json.FechaCita);
                Ext.getCmp('sysHoraPlantillaHC').setValue(selections[0].json.HoraAgenda);
                Ext.getCmp('sysHoraEstimadaPlantillaHC').setValue(selections[0].json.HoraAtencion);
                Ext.getCmp('sysFechaLegalizaPlantillaHC').setValue(selections[0].json.FechaLegaliza);
                Ext.getCmp('sysClientePlantillaHC').setValue(selections[0].json.Cliente);
                Ext.getCmp('sysActividadPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.Actividad));
                Ext.getCmp('sysNomPacientePlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.TipDoc + '-' + selections[0].json.Documento + ' ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido));
                Ext.getCmp('sysFecNacPaciente_HC').setValue(PonerAcentosMayusculas(selections[0].json.FecNac));
                Ext.getCmp('fecFecNac').setValue(PonerAcentosMayusculas(selections[0].json.FecNac));
                Ext.getCmp('sysGeneroPlantillaHC').setValue(PonerAcentosMayusculas(selections[0].json.Genero));
                Ext.getCmp('sysGeneroPaciente_HC').setValue(PonerAcentosMayusculas(selections[0].json.Genero));
                Ext.getCmp('sysEdadPaciente_HC').setValue(PonerAcentosMayusculas(selections[0].json.Edad));
                Ext.getCmp('strEdad').setValue(PonerAcentosMayusculas(selections[0].json.Edad));
                Ext.getCmp('sysIdCliente_HC').setValue(selections[0].json.idCliente);
                Ext.getCmp('sysIdPlan_HC').setValue(selections[0].json.idPlan);
                Ext.getCmp('sysIdSubPlan_HC').setValue(selections[0].json.idSubPlan);
                Ext.getCmp('sysIdContrato_HC').setValue(selections[0].json.idContrato);
                winSeleccionPlantillaOpenHC.show();
            //}else{
            //    Ext.MessageBox.show({
            //        title: 'eOfiClinic',
            //        msg: 'El Paciente: " ' + selections[0].json.PrimerNombre + ' ' + selections[0].json.SegundoNombre + ' ' + selections[0].json.PrimerApellido + ' ' + selections[0].json.SegundoApellido + '", No ha legalizado la cita.',
            //        buttons: Ext.MessageBox.OK,
            //        icon: Ext.MessageBox.ERROR
            //    });
            //}
        }
    },
    ActualizarAgenda: function(){
        Ext.getCmp('gridFormulario').store.reload();
    },
    InasistenciaCita: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if (selections[0].json.YaLegalizado == '0'){
                xCAS = selections[0].json.CAS;
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'ATENCIÓN: Recuerde Actualizar la Agenda para estar seguro que desea marcar inasistente la cita Nro. ' + xCAS + ' ?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            var winInasistenciaCitas = new winInasistenciaCitaUi();
                            Ext.getCmp('sysIdAgendaManualInasistencia').setValue(selections[0].json.IdAgendaManual);
                            Ext.getCmp('sysCASAgendaManualInasistencia').setValue(selections[0].json.CAS);
                            Ext.getCmp('sysProfesionalAgendaManualInasistencia').setValue(Ext.getCmp('sysProfeAgenda').getRawValue());
                            Ext.getCmp('sysFechaAgendaManualInasistencia').setValue(selections[0].json.FecCita);
                            Ext.getCmp('sysUsuarioAgendaManualInasistencia').setValue(ID_USUARIO);
                            Ext.getCmp('sysHoraAgendaManualInasistencia').setValue(selections[0].json.HoraCita);
                            winInasistenciaCitas.show();
                        }
                    }
                });
            }
        }
    },
    CargaDetalleAgenda: function(cmb, rec, idx) {
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS, 
                pProfesional: Ext.getCmp('sysProfeAgenda').getValue(),
                pFecha: cmb.getValue(),
                pEstado: 'A'
            }
        }); 
    },
    CargaUbicacionAgenda: function(cmb, rec, idx) {
        Ext.getCmp('sysFechaAgenda').clearValue();
        Ext.getCmp('sysFechaAgenda').enable();
        Ext.getCmp('gridFormulario').store.load({
            params: {
                pEmpresa: ID_EMPRESA,
                pIPS: ID_IPS,
                pProfesional: 0
            }
        }); 
        Ext.getCmp('sysFechaAgenda').store.load({
            params: {
                pIPS: ID_IPS, 
                pProfesional: Ext.getCmp('sysProfeAgenda').getValue()
            }
        }); 
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});

