/*
* @category    Fieldset Antecedentes Personales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsAntecedentesPersonalesUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ANTECEDENTES PERSONALES',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsAntecedentesPersonales',
    initComponent: function() {
        this.items = [
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Patologicos',
                name: 'Patologicos',
                allowBlank: false,
                id: 'memANTPERSOPatologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOPatologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Farmacologicos',
                name: 'Farmacologicos',
                allowBlank: false,
                id: 'memANTPERSOFarmacologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOFarmacologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Quirurgicos',
                name: 'Quirurgicos',
                allowBlank: false,
                id: 'memANTPERSOQuirurgicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOQuirurgicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Traumatologicos',
                name: 'Traumatologicos',
                allowBlank: false,
                id: 'memANTPERSOTraumatologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOTraumatologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Toxicologicos',
                name: 'Toxicologicos',
                allowBlank: false,
                id: 'memANTPERSOToxicologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOToxicologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Alergicos',
                name: 'Alergicos',
                allowBlank: false,
                id: 'memANTPERSOAlergicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOAlergicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'panel',
                autoHeight: true,
                anchor: '100%',
                layout: {
                    columns: 3,
                    type: 'table'
                },
                items: [
                    {
                        xtype: 'panel',
                        autoHeight: true,
                        width: 280,
                        layout: {
                            type: 'form'
                        },
                        items: [
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'TBC',
                                name: 'TBC',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOTBC'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Diabetes',
                                name: 'Diabetes',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSODiabetes'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'HTA',
                                name: 'HTA',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOHTA'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Preclampsia',
                                name: 'Preclampsia',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOPreclampsia'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        autoHeight: true,
                        width: 280,
                        layout: {
                            type: 'form'
                        },
                        items: [
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Eclampsia',
                                name: 'Eclampsia',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOEclampsia'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Infertilidad',
                                name: 'Infertilidad',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOInfertilidad'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'VIH',
                                name: 'VIH',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOVIH'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Cx Pelvicas',
                                name: 'Cx Pelvicas',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOCxPelvicas'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        autoHeight: true,
                        width: 280,
                        layout: {
                            type: 'form'
                        },
                        items: [
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Cardiopatias',
                                name: 'Cardiopatias',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOCardiopatias'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Nefropatias',
                                name: 'Nefropatias',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSONefropatias'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Condicion Medica Grave',
                                name: 'Condicion Medica Grave',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOCondicionGrave'
                            }
                        ]
                    }
                ]
            },
            {
                html: '<br>'
            },
            {
                xtype: 'fieldset',
                title: 'ANTECEDENTES GINECO-OBSTETRICOS',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                labelSeparator: '',
                autoHeight: true,
                id: 'fsANTGINECO',
                items: [
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'G'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'G',
                                emptyText: 'Gestaciones',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intANTGINECOG',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == 0 || newValue ==  null){
                                            Ext.getCmp('fecANTGINECOFup').allowBlank = true;
                                            Ext.getCmp('fecANTGINECOFup').setValue(null);
                                            Ext.getCmp('fecANTGINECOFup').disable();
                                            Ext.getCmp('fecANTGINECOFup').clearInvalid();
                                        }else{
                                            Ext.getCmp('fecANTGINECOFup').enable();
                                            Ext.getCmp('fecANTGINECOFup').allowBlank = true;
                                        }
                                    }
                                }
                            },
                            {
                                html: 'P'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'P',
                                emptyText: 'Partos',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intANTGINECOP'
                            },
                            {
                                html: 'P.V'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'PV',
                                emptyText: 'Vaginales',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intANTGINECOPV'
                            },
                            {
                                html: 'P.C'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'PC',
                                emptyText: 'Cesarea',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intANTGINECOPC'
                            },
                            {
                                html: 'A'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'A',
                                emptyText: 'Abortos',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intANTGINECOA'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'Vivos'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'V',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intANTGINECOVivos'
                            },
                            {
                                html: 'Muertos'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'M',
                                width: 68,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intANTGINECOMuertos'
                            },
                            {
                                html: 'Mola'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Mola',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTGINECOMola'
                            },
                            {
                                html: 'Embarazo Ectopico'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Embarazo Ectopico',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTGINECOEmbEctopico'
                            }
                        ]
                    },
                    {
                        html: '<br>'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Esta Lactando Actualmente',
                                name: 'Esta Lactando Actualmente',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                value: "NO",
                                id: 'strANTGINECOLactanciaHoy'
                            },
                            {
                                html:'Ha Lactando en el Pasado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Ha Lactando en el Pasado',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                value: "NO",
                                id: 'strANTGINECOLactanciaPasado',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('strANTGONECOTiempoLactancia').allowBlank = true;
                                            Ext.getCmp('strANTGONECOTiempoLactancia').setValue(null);
                                            Ext.getCmp('strANTGONECOTiempoLactancia').disable();
                                            Ext.getCmp('strANTGONECOTiempoLactancia').clearInvalid();
                                        }else{
                                            Ext.getCmp('strANTGONECOTiempoLactancia').enable();
                                            Ext.getCmp('strANTGONECOTiempoLactancia').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html:'Tiempo de Lactancia:'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Tiempo Lactancia',
                                width: 50,
                                allowBlank: true,
                                disabled: true,
                                id: 'strANTGONECOTiempoLactancia'
                            },
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Menarquia<br>&nbsp;',
                                name: 'Menarquia',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOFum_1',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('fecANTGINECOFum').disable();
                                            Ext.getCmp('fecANTGINECOFum').clearInvalid();
                                            Ext.getCmp('fecANTGINECOFum').setValue(null);
                                            Ext.getCmp('fecANTGINECOFum').allowBlank = true;
                                            Ext.getCmp('strANTGINECOMenarquia').disable();
                                            Ext.getCmp('strANTGINECOMenarquia').clearInvalid();
                                            Ext.getCmp('strANTGINECOMenarquia').setValue(null);
                                            Ext.getCmp('strANTGINECOMenarquia').allowBlank = true;
                                        }else{  
                                            Ext.getCmp('fecANTGINECOFum').enable();
                                            Ext.getCmp('fecANTGINECOFum').allowBlank = false;
                                            Ext.getCmp('strANTGINECOMenarquia').enable();
                                            Ext.getCmp('strANTGINECOMenarquia').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html: '-'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Menarquia Descripcion',
                                width: 370,
                                allowBlank: true,
                                disabled: true,
                                id: 'strANTGINECOMenarquia'
                            },
                            {
                                html: 'FUM'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'FUM',
                                allowBlank: true,
                                disabledDates: '',
                                disabled: true,
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFum'
                            },
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'FUP',
                                fieldLabel: 'FUP<br>&nbsp;',
                                allowBlank: true,
                                disabled: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFup'
                            },
                            {
                                html: 'Ultima Citologia'
                            },
                            {
                                xtype: 'combo',
                                name: 'Ultima Citologia',
                                width: 60,
                                allowBlank: true,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                value: "NO",
                                id: 'strANTGINECOFuc',
                                listeners:{
                                    change : function( t, newValue, oldValue){
                                        if(newValue == "NO"){
                                            Ext.getCmp('fecANTGINECOFuc').disable();
                                            Ext.getCmp('fecANTGINECOFuc').clearInvalid();
                                            Ext.getCmp('fecANTGINECOFuc').setValue(null);
                                            Ext.getCmp('fecANTGINECOFuc').allowBlank = true;
                                            Ext.getCmp('strANTGINECOFucRes').disable();
                                            Ext.getCmp('strANTGINECOFucRes').clearInvalid();
                                            Ext.getCmp('strANTGINECOFucRes').setValue(null);
                                            Ext.getCmp('strANTGINECOFucRes').allowBlank = true;
                                        }else{  
                                            Ext.getCmp('fecANTGINECOFuc').enable();
                                            Ext.getCmp('fecANTGINECOFuc').allowBlank = false;
                                            Ext.getCmp('strANTGINECOFucRes').enable();
                                            Ext.getCmp('strANTGINECOFucRes').allowBlank = false;
                                        }
                                    }
                                }
                            },
                            {
                                html: 'Fecha:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Ultima Citologia',
                                allowBlank: true,
                                disabled: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFuc'
                            },
                            {
                                html: 'Resultado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Resultado',
                                width: 150,
                                allowBlank: true,
                                disabled: true,
                                store: stResultadoCitologia,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOFucRes'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Metodo Planificacion',
                        name: 'Metodo Planificacion',
                        anchor: '100%',
                        allowBlank: true,
                        store: 'StoreMetodosPlanificacion',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        value: "NO PLANIFICA",
                        id: 'strANTGINECOMetodoPlanifica'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Ciclos Mestruales<br>&nbsp;',
                        name: 'Ciclos Mestruales',
                        allowBlank: true,
                        id: 'strANTGINECOCiclosMestruales',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOCiclosMestruales').setValue("Negativo");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Actividad Sexual<br>&nbsp;',
                        name: 'Actividad Sexual',
                        allowBlank: true,
                        id: 'strANTGINECOActividadSexual',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOActividadSexual').setValue("Negativo");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Patologias Relacionadas Emb.',
                        name: 'Patologias Relacionadas Emb.',
                        allowBlank: true,
                        id: 'strANTGINECOPatologiaEmbarazo',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOPatologiaEmbarazo').setValue("Negativo");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Menopausia',
                        name: 'Menopausia',
                        allowBlank: true,
                        id: 'strANTGINECOMenopausia',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOMenopausia').setValue("Negativo");
                                });
                            }
                        }
                    }
                ]
            }
        ];
        fsAntecedentesPersonalesUi.superclass.initComponent.call(this);
    }
});
