/*
* @category    Fieldset Antecedentes Personales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


fsAntecedentesPersonalesUi = Ext.extend(Ext.form.FieldSet, {
    anchor: '100%',
    autoHeight: true,
    layout: 'form',
    title: 'ANTECEDENTES PERSONALES',
    collapseFirst: false,
    collapsible: true,
    animCollapse: true,
    titleCollapse: true,
    padding: 0,
    id: 'fsAntecedentesPersonales',
    initComponent: function() {
        this.items = [
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Patologicos',
                name: 'Patologicos',
                allowBlank: false,
                id: 'memANTPERSOPatologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOPatologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Farmacologicos',
                name: 'Farmacologicos',
                allowBlank: false,
                id: 'memANTPERSOFarmacologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOFarmacologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Quirurgicos',
                name: 'Quirurgicos',
                allowBlank: false,
                id: 'memANTPERSOQuirurgicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOQuirurgicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Traumatologicos',
                name: 'Traumatologicos',
                allowBlank: false,
                id: 'memANTPERSOTraumatologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOTraumatologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Toxicologicos',
                name: 'Toxicologicos',
                allowBlank: false,
                id: 'memANTPERSOToxicologicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOToxicologicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'textarea',
                anchor: '100%',
                fieldLabel: 'Alergicos',
                name: 'Alergicos',
                allowBlank: false,
                id: 'memANTPERSOAlergicos',
                listeners: {
                    render: function( p ) {
                        p.getEl().on('dblclick', function (){
                            Ext.getCmp('memANTPERSOAlergicos').setValue("No Refiere");
                        });
                    }
                }
            },
            {
                xtype: 'panel',
                autoHeight: true,
                anchor: '100%',
                layout: {
                    columns: 3,
                    type: 'table'
                },
                items: [
                    {
                        xtype: 'panel',
                        autoHeight: true,
                        width: 280,
                        layout: {
                            type: 'form'
                        },
                        items: [
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'TBC',
                                name: 'TBC',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOTBC'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Diabetes',
                                name: 'Diabetes',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSODiabetes'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'HTA',
                                name: 'HTA',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOHTA'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Preclampsia',
                                name: 'Preclampsia',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOPreclampsia'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        autoHeight: true,
                        width: 280,
                        layout: {
                            type: 'form'
                        },
                        items: [
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Eclampsia',
                                name: 'Eclampsia',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOEclampsia'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Infertilidad',
                                name: 'Infertilidad',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOInfertilidad'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'VIH',
                                name: 'VIH',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOVIH'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        autoHeight: true,
                        width: 280,
                        layout: {
                            type: 'form'
                        },
                        items: [
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Cardiopatias',
                                name: 'Cardiopatias',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOCardiopatias'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Nefropatias',
                                name: 'Nefropatias',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSONefropatias'
                            },
                            {
                                xtype: 'checkbox',
                                fieldLabel: 'Condicion Medica Grave',
                                name: 'Condicion Medica Grave',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTPERSOCondicionGrave'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'fieldset',
                title: 'ANTECEDENTES GINECO-OBSTETRICOS',
                layout: 'form',
                collapseFirst: false,
                collapsible: true,
                animCollapse: true,
                titleCollapse: true,
                anchor: '100%',
                autoHeight: true,
                id: 'fsANTGINECO',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'G:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'G',
                                emptyText: 'Gestaciones',
                                width: 70,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOG'
                            },
                            {
                                html: 'P:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'P',
                                emptyText: 'Partos',
                                width: 70,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOP'
                            },
                            {
                                html: 'P.V:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'PV',
                                emptyText: 'Vaginales',
                                width: 70,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOPV'
                            },
                            {
                                html: 'P.C:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'PC',
                                emptyText: 'Por Cesarea',
                                width: 70,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOPC'
                            },
                            {
                                html: 'A:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'A',
                                emptyText: 'Abortos',
                                width: 70,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOA'
                            },
                            {
                                html: 'Vivos:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'V',
                                width: 70,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOVivos'
                            },
                            {
                                html: 'Muertos:'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'M',
                                width: 70,
                                minValue: 0,
                                maxValue: 20,
                                decimalPrecision: 0,
                                allowBlank: false,
                                id: 'intANTGINECOMuertos'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                html: 'Mola:'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Mola',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTGINECOMola'
                            },
                            {
                                html: 'Embarazo Ectopico:'
                            },
                            {
                                xtype: 'checkbox',
                                name: 'Embarazo Ectopico',
                                anchor: '100%',
                                value: 'false',
                                id: 'bolANTGINECOEmbEctopico'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Esta Lactando Actualmente',
                                name: 'Esta Lactando Actualmente',
                                width: 60,
                                allowBlank: false,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOLactanciaHoy'
                            },
                            {
                                html:'Ha Lactando en el Pasado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Ha Lactando en el Pasado',
                                width: 60,
                                allowBlank: false,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOLactanciaPasado'
                            },
                            {
                                html:'Tiempo de Lactancia:'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Tiempo Lactancia',
                                width: 50,
                                allowBlank: false,
                                id: 'strANTGONECOTiempoLactancia'
                            },
                        ]
                    },

                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Menarquia',
                                name: 'Menarquia',
                                width: 370,
                                allowBlank: true,
                                id: 'strANTGINECOMenarquia'
                            },
                            {
                                html: 'Menopausia:'
                            },
                            {
                                xtype: 'textfield',
                                name: 'Menopausia',
                                width: 300,
                                allowBlank: true,
                                id: 'strANTGINECOMenopausia'
                            }
                        ]
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'FUM',
                                name: 'FUM',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFum'
                            },
                            {
                                html: 'FUP:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'FUP',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFup'
                            },
                            {
                                html: 'Ultima Citologia:'
                            },
                            {
                                xtype: 'datefield',
                                width: 120,
                                name: 'Ultima Citologia',
                                allowBlank: true,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'fecANTGINECOFuc'
                            },
                            {
                                html: 'Resultado:'
                            },
                            {
                                xtype: 'combo',
                                name: 'Resultado',
                                width: 150,
                                allowBlank: false,
                                store: stResultadoCitologia,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strANTGINECOFucRes'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Metodo Planificacion',
                        name: 'Metodo Planificacion',
                        anchor: '100%',
                        allowBlank: false,
                        store: 'StoreMetodosPlanificacion',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'strANTGINECOMetodoPlanifica'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Ciclos Mestruales',
                        name: 'Ciclos Mestruales',
                        allowBlank: false,
                        id: 'strANTGINECOCiclosMestruales',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOCiclosMestruales').setValue("Negativo");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Actividad Sexual',
                        name: 'Actividad Sexual',
                        allowBlank: false,
                        id: 'strANTGINECOActividadSexual',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOActividadSexual').setValue("Negativo");
                                });
                            }
                        }
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Patologias Relacionadas Emb.',
                        name: 'Patologias Relacionadas Emb.',
                        allowBlank: false,
                        id: 'strANTGINECOPatologiaEmbarazo',
                        listeners: {
                            render: function( p ) {
                                p.getEl().on('dblclick', function (){
                                    Ext.getCmp('strANTGINECOPatologiaEmbarazo').setValue("Negativo");
                                });
                            }
                        }
                    }
                ]
            }
        ];
        fsAntecedentesPersonalesUi.superclass.initComponent.call(this);
    }
});
