/*
* @category    Formulario Ver Formulacion HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winViewFormulacionUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Ver Historial Formulaciones ::.',
    width: 970,
    height: 570,
    border: false,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winViewFormulacion',
    initComponent: function() {
        el = Ext.get('idaplicacion');
        //NOMAPLICACION = el.getValue();
        NOMAPLICACION = "OfiClinic";
        
        function VerInfoServicio(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<h3><b>' + value + '</b></h3>' + '</br><h4>' + record.get('Actividad') + '</br><span style="color: darkblue;">Profesional: ' + record.get('NomProfe') + '</span></br></br><span style="color: #B40404;">Programa: ' + record.get('Programa') + '</span></h4>';  
        }
        
        var viewResumenFormulacion = new Ext.Panel({
            id:'viewResumenFormulacion',
            width: 620,
            height: 475,
            autoScroll:true,
            closable:false
        });
        
        this.bbar = [
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Importar Formulacion',
                iconCls: 'btnAceptar',
                id: 'btnAddFormulacionHC',
                listeners: {
                    click : function() {
                        if(parseInt(Ext.getCmp('gridHistorialFormulaciones').selModel.getCount()) === 1){
                            var selections = Ext.getCmp('gridHistorialFormulaciones').selModel.getSelections();
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea cargar los medicamentos de la formula seleccionada?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn){
                                    if(btn=="yes"){
                                        Ext.Ajax.request({
                                            waitMsg: 'Por favor Espere...',
                                            url: "../../controlador/solmx/controlador_solmx.php",
                                            params: {
                                                task: "CARGAR_MX_FORMULASELECCIONADA",
                                                pEmpresa: ID_EMPRESA,
                                                pSEDE: ID_SEDE, 
                                                pIPS: ID_IPS, 
                                                pCASOrigen:  selections[0].json.CAS,
                                                pCASDestino: Ext.getCmp('CASImportarFormulacion').getValue()
                                            },
                                            success: function(response)
                                            {
                                                var result = response.responseText.split("^");
                                                Ext.getCmp('gridMedicamentosHC').store.reload();
                                                Ext.getCmp('winViewFormulacion').close();;
                                            },
                                            failure: function(response){
                                                var result = response.responseText;
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'Error de conexión - No podemos adicionar los medicamentos en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: NOMAPLICACION,
                                msg: 'Debe Seleccionar una Evolución.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners: {
                    click : function() {
                        Ext.getCmp('winViewFormulacion').close();
                    }
                }
            }
        ];
        
        this.items = [
            {
                xtype: 'hidden',
                id: 'CASImportarFormulacion'
            },
            {
                xtype: 'panel',
                title: 'Historial de Formulaciones',
                layout: 'hbox',
                //width: 900,
                anchor: '100%',
                height: 500,
                items: [
                    {
                        xtype: 'grid',
                        store: 'StoreGridFormulacionesHC',
                        title: 'Atenciones',
                        width: 320,
                        height: 485,
                        flex: 1,
                        id: 'gridHistorialFormulaciones',
                        columns: [
                            {
                                xtype: 'gridcolumn',
                                header: 'Fecha',
                                sortable: true,
                                width: 120,
                                dataIndex: 'FechaAtencion',
                                renderer: VerInfoServicio,
                                hideable: false
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true})
                    },
                    viewResumenFormulacion
                ]
            }
        ];
        winViewFormulacionUi.superclass.initComponent.call(this);
    }
});
