/*
* @category    Solicitud Consentimientos Informados
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
        
GridGuiasAtencionUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        
        function VerInfoGuia(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        var viewGuiasManejo = new Ext.Panel({
            id:'viewGuiasManejo',
            width: 618,
            height: 320,
            autoScroll:true,
            closable:false,
            items: [
                { 
                    xtype: 'component',
                    html : '<iframe src="" width="100%" height="100%"></iframe>',
                    id: 'sysShowPDFGuia'
                }
            ]
        });
        
        this.items = [
            {
                xtype: 'panel',
                layout: 'hbox',
                anchor: '100%',
                height: 320,
                items: [
                    {
                        xtype: 'grid',
                        store: 'StoreGridGuiaAtencion',
                        width: 320,
                        height: 300,
                        flex: 1,
                        id: 'gridGuiasAtencion',
                        columns: [
                            {
                                xtype: 'gridcolumn',
                                header: 'Descripcion',
                                sortable: true,
                                width: 120,
                                dataIndex: 'Guia',
                                renderer: VerInfoGuia,
                                hideable: false
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        listeners: {
                            rowclick: function(t, rowIndex, e){
                                var selections = Ext.getCmp('gridGuiasAtencion').selModel.getSelections();
                                if(selections[0].json.RutaGuia !== "" && selections[0].json.RutaGuia !== null){
                                    Ext.getCmp('sysShowPDFGuia').update('<iframe src="../../../empresas/' + ID_EMPRESA + '/guias/' + selections[0].json.RutaGuia + '" width="98%" height="98%"></iframe>');
                                }else{
                                    Ext.getCmp('sysShowPDFGuia').update('<span>Documento No Encontrado...!</span>');
                                }
                            }
                        }
                    },
                    viewGuiasManejo
                ]
            }
        ];
        GridGuiasAtencionUi.superclass.initComponent.call(this);
    }
});