
winHCFISIOCENTER003Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: INFORME MENSUAL DE TERAPIA DE NEURODESARROLLO ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmHC',
                padding: 10,
                border: false,
                height: 610,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'intConsecutivoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Proceso',
                        id: 'sysProcesoHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Periodo',
                        id: 'sysPeriodoHC'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'EVOLUCIÓN FINAL TERAPIA FISICA',
                        name: 'EVOLUCIÓN FINAL TERAPIA FISICA',
                        height: 100,            
                        allowBlank: true,
                        id: 'memEvolucionTerapiaFisica'
                    },
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        listWidth: 670,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionalesxIPS,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        fieldLabel: 'Responsable',
                        id: 'intProfesionalTerapiaFisica'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'EVOLUCIÓN FINAL FONOAUDIOLOGIA',
                        name: 'EVOLUCIÓN FINAL FONOAUDIOLOGIA',
                        height: 100,            
                        allowBlank: true,
                        id: 'memEvolucionFonoaudiologia'
                    },
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        listWidth: 670,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionalesxIPS,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        fieldLabel: 'Responsable',
                        id: 'intProfesionalFonoaudiologia'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'EVOLUCIÓN FINAL TERAPIA OCUPACIONAL',
                        name: 'EVOLUCIÓN FINAL TERAPIA OCUPACIONAL',
                        height: 100,            
                        allowBlank: true,
                        id: 'memEvolucionTerapiaOcupacional'
                    },
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        listWidth: 670,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionalesxIPS,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        fieldLabel: 'Responsable',
                        id: 'intProfesionalTerapiaOcupacional'
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'CONCLUSIONES',
                        name: 'CONCLUSIONES',
                        height: 100,            
                        allowBlank: true,
                        id: 'memConclusiones'
                    },
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        listWidth: 670,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionalesxIPS,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        fieldLabel: 'Responsable',
                        id: 'intProfesionalConclusiones'
                    },
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1) 
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Informe',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 0) 
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea guardar la evolución, si hace esto ya no podra realizar ningun cambio?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistros();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'La evolución ya se guardo y no podra ser modificada nuevamente',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winHCFISIOCENTER003Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistros(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc.php',
            params:{
                task: 'guardar_resumen_neurodesarrollo',
                CAMPOS: listacampos,
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pProceso: Ext.getCmp('sysProcesoHC').getValue()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1); 
                        Ext.getCmp('gridHistorialEvoluciones').store.reload();
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
