/*
* @category    Fichas de Notificacion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
        
GridFichasNotificacionUi = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        
        function VerInfoFicha(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return value;  
        }
        
        var viewFichasNotificacion = new Ext.Panel({
            id:'viewFichasNotificacion',
            width: 618,
            height: 320,
            autoScroll:true,
            closable:false,
            items: [
                { 
                    xtype: 'component',
                    html : '<iframe src="" width="100%" height="100%"></iframe>',
                    id: 'sysShowPDFFicha'
                }
            ]
        });
        
        this.items = [
            {
                xtype: 'panel',
                layout: 'hbox',
                anchor: '100%',
                height: 320,
                items: [
                    {
                        xtype: 'grid',
                        store: 'StoreGridFichaNotificacion',
                        width: 320,
                        height: 300,
                        flex: 1,
                        id: 'gridFichasNotificacion',
                        columns: [
                            {
                                xtype: 'gridcolumn',
                                header: 'Descripcion',
                                sortable: true,
                                width: 120,
                                dataIndex: 'Ficha',
                                renderer: VerInfoFicha,
                                hideable: false
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        listeners: {
                            rowclick: function(t, rowIndex, e){
                                var selections = Ext.getCmp('gridFichasNotificacion').selModel.getSelections();
                                if(selections[0].json.RutaFicha !== "" && selections[0].json.RutaFicha !== null){
                                    Ext.getCmp('sysShowPDFFicha').update('<iframe src="../../../empresas/' + ID_EMPRESA + '/fichasnot/' + selections[0].json.RutaFicha + '" width="98%" height="98%"></iframe>');
                                }else{
                                    Ext.getCmp('sysShowPDFFicha').update('<span>Documento No Encontrado...!</span>');
                                }
                            }
                        }
                    },
                    viewFichasNotificacion
                ]
            }
        ];
        GridFichasNotificacionUi.superclass.initComponent.call(this);
    }
});