/*
* @category    Formulario Modelo Evolucion Historia Clinica
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEvaluacionVoz001 = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Plantilla HC Joven ::.',
    width: 990,
    height: 636,
    closable: false,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winHC',
    initComponent: function() {
        
      
        
        tmpmx = objMX;
        tmpmxadd = objMXADD;
        tmpexa = objEXA;
        tmprem = objREM;
        myPaciente = 0;
        myCAS = 0;

        try {
            var campo = Ext.getCmp('sysPacientePlantillaHC');
            if ( campo != null ) {
                myPaciente = Ext.getCmp('sysPacientePlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myPaciente == 0){
            try {
                var campo1 = Ext.getCmp('sysIdPacienteHC');
                if ( campo1 != null ) {
                    myPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myPaciente == 0){
            try {
                var campo5 = Ext.getCmp('sysPacienteRefHC');
                if ( campo5 != null ) {
                    myPaciente = Ext.getCmp('sysPacienteRefHC').getValue();
                }
            }catch(ex){
            }
        }
        try {
            var campo2 = Ext.getCmp('sysCASPlantillaHC');
            if ( campo2 != null ) {
                myCAS = Ext.getCmp('sysCASPlantillaHC').getValue();
            }
        }catch(ex){
        }
        if(myCAS == 0){
            try {
                var campo3 = Ext.getCmp('sysCASHC');
                if ( campo3 != null ) {
                    myCAS = Ext.getCmp('sysCASHC').getValue();
                }
            }catch(ex){
            }
        }
        if(myCAS == 0){
            try {
                var campo4 = Ext.getCmp('sysCASRefHC');
                if ( campo4 != null ) {
                    myCAS = Ext.getCmp('sysCASRefHC').getValue();
                }
            }catch(ex){
            }
        }
        if (objMX != "NA"){
            var xSolMX = eval(objMX);
            Ext.getCmp('gridMedicamentosHC').store.load({
                params: {
                    task: 'MX_IPS_BASICA',
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }
        else{
            var xSolMX = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objEXA != "NA"){
            var xSolEXA = eval(objEXA);
            Ext.getCmp('gridExamenesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolEXA = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        if (objREM != "NA"){
            var xSolREM = eval(objREM);
            Ext.getCmp('gridRemisionesHC').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: wPaciente,
                    pCAS: wCAS
                }
            });
        }else{
            var xSolREM = Ext.extend(Ext.form.Hidden, {
                initComponent: function() {
                    MyHiddenFieldUi.superclass.initComponent.call(this);
                }
            });
        }
        var xSolNOPOS = new SolNOPOS001Ui();
        Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
            params: {
                task: 'LISTAR_NOPOS',
                pPaciente: myPaciente
            }
        });
        //
        
        var dataAsimetriaHombros = [
            ['Normal'],
            ['Leve'],
            ['Severa']
        ];
        var stAsimetriaHombros = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAsimetriaHombros.loadData(dataAsimetriaHombros);
        
        var dataPosicionCabeza = [
            ['Normal'],
            ['Levemente Adelantada'],
            ['Severamente adelantada']
        ];
        var stPosicionCabeza = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPosicionCabeza.loadData(dataPosicionCabeza);
        
        
        var dataColumnaVertebral = [
            ['Normal'],
            ['Hiperlordosis'],
            ['Hipercifosis']
        ];
        var stColumnaVertebral = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stColumnaVertebral.loadData(dataColumnaVertebral);
        
        
        var dataEscapula = [
            ['Normal'],
            ['Aladas']
        ];
        var stEscapula = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stEscapula.loadData(dataEscapula);
        
        
        var dataAlturaLaringea = [
            ['Normal'],
            ['Anormal']
        ];
        var stAlturaLaringea = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAlturaLaringea.loadData(dataAlturaLaringea);
        
        
        var dataCuelloHombros = [
            ['Normal'],
            ['Limitada']
        ];
        var stCuelloHombros = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCuelloHombros.loadData(dataCuelloHombros);
        
        
        var dataTipoRespiratorio = [
            ['Clavicular'],
            ['Abdominal'],
            ['Costodiafragmatico']
        ];
        var stTipoRespiratorio = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoRespiratorio.loadData(dataTipoRespiratorio);
        
        
        
        var dataModoRespiratorio = [
            ['Oral'],
            ['Nasal'],
            ['Mixto']
        ];
        var stModoRespiratorio = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stModoRespiratorio.loadData(dataModoRespiratorio);
        
        
        var dataCoordinacionFonoRespiratoria = [
            ['Adecuada'],
            ['Inadecuada']
        ];
        var stCoordinacionFonoRespiratoria = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCoordinacionFonoRespiratoria.loadData(dataCoordinacionFonoRespiratoria);
        
        
        var dataPresenteAusente = [
            ['Presente'],
            ['Ausente']
        ];
        var stPresenteAusente = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stPresenteAusente.loadData(dataPresenteAusente);
        
        
        var dataIntensidad = [
            ['Normal'],
            ['Alto'],
            ['Bajo']
        ];
        var stIntensidad = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stIntensidad.loadData(dataIntensidad);
        
        
        var dataTono = [
            ['Normal'],
            ['Desv. Graves'],
            ['Desv. Agudos'],
            ['Inestable']
        ];
        var stTono = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTono.loadData(dataTono);
        
        
        
        var dataAtaqueVocal = [
            ['Normal'],
            ['Duro'],
            ['Soplado']
        ];
        var stAtaqueVocal = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAtaqueVocal.loadData(dataAtaqueVocal);
        
        
        
        var dataResonancia = [
            ['Oral'],
            ['Hiponasal'],
            ['Hipernasal'],
            ['Faringea'],
            ['Pectoral']
        ];
        var stResonancia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stResonancia.loadData(dataResonancia);
        
        
        
        var dataRitmo = [
            ['Normal'],
            ['Pausado'],
            ['Precipitado'],
            ['Irregular']
        ];
        var stRitmo = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stRitmo.loadData(dataRitmo);
        
        
        
        var dataProsodia = [
            ['Adecuada'],
            ['Pausada'],
            ['Precipitada']
        ];
        var stProsodia = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stProsodia.loadData(dataProsodia);
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCodPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 1,
                        id: 'sysUsaGridSalida'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        value: 0,
                        id: 'sysYaGuardoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysPlantillaHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptMx'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptExa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysRutaRptRem'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad',
                        style: 'background:transparent;font-size:16px;font-weight:bolder;border:none;color:blue;',
                        id: 'sysActividadHC',
                        name: 'PLANTILLA'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPSHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysIdPacienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Apertura',
                        id: 'sysAperturaHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdClienteHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdSubPlanHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Plantilla',
                        id: 'sysIdContratoHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Genero',
                        id: 'sysGeneroPacHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Edad',
                        id: 'sysEdadPacHC'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysProfesionalAgendaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'ConsecutivoDetalle',
                        id: 'sysConsecutivoDetalleHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'CAS',
                                id: 'sysCASHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysFechaHC',
                                value: 'Fecha: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysHoraHC',
                                value: 'Hora: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraHC'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'sysLegalizacionHC',
                                value: 'Legalización: '
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysLegalizaHC'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                        id: 'sysPacienteHC'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Genero',
                                id: 'sysGeneroHC'
                            },
                            {
                                html: 'Fecha Nac:'
                            },
                            {
                                xtype: 'textfield',
                                width: 100,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysFechaNac'
                            },
                            {
                                html: 'Edad:'
                            },
                            {
                                xtype: 'textfield',
                                width: 350,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysEdadHC'
                            }
                        ]
                    },
                    /*{
                        xtype: 'button',
                        iconCls: 'btnImprimir',
                        text: 'Cargar Antecedentes',
                        tooltip: 'Cargar Antecedentes',
                        listeners:{
                            click : function(){
                                Ext.Ajax.request({
                                    url: '../../controlador/asistencial/evolucionhc.php',
                                    waitMsg: 'Cargando Información...',
                                    params:{
                                        pCAS: myCAS,
                                        pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                                        task: 'ImportarAntecedentesPersonalesOfiClinic001'
                                    },
                                    success: function(result, request)
                                    {
                                        var jsonAntPersonales = Ext.util.JSON.decode(result.responseText);
                                        UtilCargarAntecedentesOfiClinic001(jsonAntPersonales.data);
                                    },
                                    scope:this
                                });
                            }
                        }
                    },*/
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'tabpanel',
                        anchor: '99%',
                        autoHeight: true,
                        border: false,
                        enableTabScroll: true,
                        ref: 'fTabPanel',
                        id: 'fTabPanel',
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Evolución',
                                autoHeight: true,
                                autoScroll: true,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaEvolucion',
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'form',
                                        frame: true,
                                        anchor: '100%',
                                        id: 'frmHC',
                                        padding: 10,
                                        border: false,
                                        autoScroll: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Ocupacion',
                                                name: 'Ocupacion',
                                                anchor: '100%',
                                                readOnly: true,
                                                allowBlank: true,
                                                id: 'strOcupacion'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                fieldLabel: 'N. Hras usa Voz',
                                                name: 'N. Hras usa Voz',
                                                width: 100,
                                                minValue: 0,
                                                decimalPrecision: 0,
                                                allowBlank: true,
                                                id: 'intHorasUsaVoz'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Asignaturas',
                                                name: 'Asignaturas',
                                                anchor: '100%',
                                                readOnly: true,
                                                allowBlank: true,
                                                id: 'strAsignaturas'
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'MOTIVO DE CONSULTA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'MOTIVO DE CONSULTA',
                                                        name: 'MOTIVO DE CONSULTA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memMotivoConsulta'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'ANTECEDENTES PERSONALES',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                labelSeparator: '',
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Exposicion al Ruido',
                                                        name: 'Exposicion al Ruido',
                                                        anchor: '100%',
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        id: 'strExposicionRuido'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Audicion<br>',
                                                        name: 'Audicion',
                                                        anchor: '100%',
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        id: 'strAudicion'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Cuadro Respiratorio',
                                                        name: 'Cuadro Respiratorio',
                                                        anchor: '100%',
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        id: 'strCuadroRespiratorio'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Ingesta Medicamentos',
                                                        name: 'Ingesta Medicamentos',
                                                        anchor: '100%',
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        id: 'strIngestaMedicamentos'
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Operaciones Laringe',
                                                        name: 'Operaciones Laringe',
                                                        anchor: '100%',
                                                        readOnly: true,
                                                        allowBlank: true,
                                                        id: 'strOperacionesLaringe'
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        title: 'Habitos',
                                                        labelSeparator: '',
                                                        width: 540,
                                                        layout: {
                                                            type: 'form'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Fuma<br>',
                                                                        name: 'Fuma',
                                                                        width: 60,
                                                                        allowBlank: true,
                                                                        store: 'StoreSiNo',
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFuma'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        emptyText: 'Frecuencia',
                                                                        name: 'Frecuencia',
                                                                        width: 350,
                                                                        readOnly: true,
                                                                        allowBlank: true,
                                                                        id: 'strFrecuencia'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Antecedentes Disfonia<br>',
                                                                name: 'Antecedentes Disfonia',
                                                                width: 60,
                                                                allowBlank: true,
                                                                store: 'StoreSiNo',
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAntecedentesDisfonia'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                emptyText: 'Episodios en el ultimo año',
                                                                name: 'Episodios en el ultimo año',
                                                                width: 350,
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strEpisodioDisfonia'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        autoHeight: true,
                                                        width: 580,
                                                        title: 'Padece o Padecio',
                                                        layout: {
                                                            columns: 2,
                                                            type: 'table'
                                                        },
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Laringitis Cronica',
                                                                        name: 'Laringitis Cronica',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolLaringitisCronica'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'De las Cuerdas Vocales',
                                                                        name: 'De las Cuerdas Vocales',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolCuerdasVocales'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Dificultad para Tragar',
                                                                        name: 'Dificultad para Tragar',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolDificultadTragar'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Tiroides',
                                                                        name: 'Tiroides',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolTiroides'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                width: 280,
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Problemas Hormonales',
                                                                        name: 'Problemas Hormonales',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolProblemasHormonales'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Reflujo Gastrico',
                                                                        name: 'Reflujo Gastrico',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolReflujoGastrico'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Nodulos Laringeos',
                                                                        name: 'Nodulos Laringeos',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolNodulosLaringeos'
                                                                    },
                                                                    {
                                                                        xtype: 'checkbox',
                                                                        fieldLabel: 'Traumas de Garganta',
                                                                        name: 'Traumas de Garganta',
                                                                        anchor: '100%',
                                                                        value: 'false',
                                                                        id: 'bolTraumaGarganta'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'EXAMEN DE LA VOZ',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'EVALUACION OROFACIAL',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Nariz',
                                                                name: 'Nariz',
                                                                anchor: '100%',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strNariz'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Boca',
                                                                name: 'Boca',
                                                                anchor: '100%',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strBoca'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Labios',
                                                                name: 'Labios',
                                                                anchor: '100%',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strLabios'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Lengua',
                                                                name: 'Lengua',
                                                                anchor: '100%',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strLengua'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Paladar',
                                                                name: 'Paladar',
                                                                anchor: '100%',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strPaladar'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Velo Paladar',
                                                                name: 'Velo Paladar',
                                                                anchor: '100%',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strVeloPaladar'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Maxilar Inferior',
                                                                name: 'Maxilar Inferior',
                                                                anchor: '100%',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strMaxilarInferior'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'ATM',
                                                                name: 'ATM',
                                                                anchor: '100%',
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                id: 'strATM'
                                                            },
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        html: 'Diastemas'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        fieldLabel: 'Dientes',
                                                                        name: 'Dientes Diastemas',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intDientesDiastemas'
                                                                    },
                                                                    {
                                                                        html: 'Ausencias'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Dientes Ausencias',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intDientesAusencias'
                                                                    },
                                                                    {
                                                                        html: 'Implantaciones'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Dientes Implantaciones',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intDientesImplantaciones'
                                                                    },
                                                                    {
                                                                        html: 'Protesis'
                                                                    },
                                                                    {
                                                                        xtype: 'numberfield',
                                                                        name: 'Dientes Protesis',
                                                                        width: 50,
                                                                        minValue: 0,
                                                                        decimalPrecision: 0,
                                                                        allowBlank: true,
                                                                        id: 'intDientesProtesis'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'EVALUACION POSTURAL',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: 'Vista Anterior',
                                                                anchor: '100%',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Asimetria de Hombros',
                                                                        name: 'Asimetria de Hombros',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stAsimetriaHombros,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strAsimetriaHombros'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: 'Lateral',
                                                                anchor: '100%',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Posicion de Cabeza',
                                                                        name: 'Posicion de Cabeza',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stPosicionCabeza,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strPosicionCabeza'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Columna Vertebral',
                                                                        name: 'Columna Vertebral',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stColumnaVertebral,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strColumnaVertebral'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: 'Posterior',
                                                                anchor: '100%',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Escapula',
                                                                        name: 'Escapula',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stEscapula,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strEscapula'
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        autoHeight: true,
                                                                        title: 'Exploracion Muscular Laringea',
                                                                        anchor: '100%',
                                                                        layout: {
                                                                            type: 'form'
                                                                        },
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Altura Laringea',
                                                                                name: 'Altura Laringea',
                                                                                width: 350,
                                                                                allowBlank: true,
                                                                                store: stAlturaLaringea,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strAlturaLaringea'
                                                                            },
                                                                            {
                                                                                xtype: 'textfield',
                                                                                fieldLabel: 'Musculos Suprahioideos',
                                                                                name: 'Musculos Suprahioideos',
                                                                                width: 350,
                                                                                readOnly: true,
                                                                                allowBlank: true,
                                                                                id: 'strMusculosSuprahioideos'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        xtype: 'panel',
                                                                        autoHeight: true,
                                                                        title: 'Exploracion Muscular Dinamica: Cuello y Hombros',
                                                                        anchor: '100%',
                                                                        layout: {
                                                                            type: 'form'
                                                                        },
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Rotacion Cabeza',
                                                                                name: 'Rotacion Cabeza',
                                                                                width: 350,
                                                                                allowBlank: true,
                                                                                store: stCuelloHombros,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strRotacionCabeza'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Hombros Arriba Abajo',
                                                                                name: 'Hombros Arriba Abajo',
                                                                                width: 350,
                                                                                allowBlank: true,
                                                                                store: stCuelloHombros,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strHombrosArribaAbajo'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Hombros Delante Atras',
                                                                                name: 'Hombros Delante Atras',
                                                                                width: 350,
                                                                                allowBlank: true,
                                                                                store: stCuelloHombros,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strHombrosDelanteAtras'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Hombros Rotacion',
                                                                                name: 'Hombros Rotacion',
                                                                                width: 350,
                                                                                allowBlank: true,
                                                                                store: stCuelloHombros,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strHombrosRotacion'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Extension Lateral',
                                                                                name: 'Extension Lateral',
                                                                                width: 350,
                                                                                allowBlank: true,
                                                                                store: stCuelloHombros,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strExtensionLateral'
                                                                            }
                                                                        ]
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'RESPIRACION',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: 'En Reposo',
                                                                anchor: '100%',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Tipo Respiratorio',
                                                                        name: 'Tipo Respiratorio',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stTipoRespiratorio,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strTipoRespiratorioReposo'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Modo Respiratorio',
                                                                        name: 'Modo Respiratorio',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stModoRespiratorio,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strModoRespiratorioReposo'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: 'En Fonacion',
                                                                anchor: '100%',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Tipo Respiratorio',
                                                                        name: 'Tipo Respiratorio Fonacion',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stTipoRespiratorio,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strTipoRespiratorioFonacion'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Modo Respiratorio',
                                                                        name: 'Modo Respiratorio Fonacion',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stModoRespiratorio,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strModoRespiratorioFonacion'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Modo Respiratorio',
                                                                        name: 'Modo Respiratorio Fonacion',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stModoRespiratorio,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strModoRespiratorioFonacion'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Coordinacion Fono-Respiratoria',
                                                                        name: 'Coordinacion Fono-Respiratoria',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stCoordinacionFonoRespiratoria,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strCoordinacionFonoRespiratoria'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Apoyo Respiratorio',
                                                                        name: 'Apoyo Respiratorio',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stPresenteAusente,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strApoyoRespiratorio'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Apnea Prefonatoria',
                                                                        name: 'Apnea Prefonatoria',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stPresenteAusente,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strApneaPrefonatoria'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'fieldset',
                                                        title: 'PARAMETROS VOCALES: CUALIDADADES DE LA VOZ',
                                                        layout: 'form',
                                                        collapseFirst: false,
                                                        collapsible: true,
                                                        animCollapse: true,
                                                        titleCollapse: true,
                                                        anchor: '100%',
                                                        autoHeight: true,
                                                        padding: 7,
                                                        items: [
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: 'Intensidad',
                                                                anchor: '100%',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Voz Conversacional',
                                                                        name: 'Voz Conversacional',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strVozConversacional'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Voz en Lectura',
                                                                        name: 'Voz en Lectura',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strVozLectura'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Emision de Vocales',
                                                                        name: 'Emision de Vocales',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strEmisionVocales'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Voz Susurrada',
                                                                        name: 'Voz Susurrada',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strVozSusurrada'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Voz de Llamada',
                                                                        name: 'Voz de Llamada',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stIntensidad,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strVozLlamada'
                                                                    },
                                                                    {
                                                                        html: '<br>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Variaciones',
                                                                        name: 'Variaciones',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stCoordinacionFonoRespiratoria,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strVariaciones'
                                                                    }
                                                                ]
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tono',
                                                                name: 'Tono',
                                                                width: 350,
                                                                allowBlank: true,
                                                                store: stTono,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strTono'
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Ataque Vocal',
                                                                name: 'Ataque Vocal',
                                                                width: 350,
                                                                allowBlank: true,
                                                                store: stAtaqueVocal,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strAtaqueVocal'
                                                            },
                                                            {
                                                                html: '<br>'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Resonancia',
                                                                name: 'Resonancia',
                                                                width: 350,
                                                                allowBlank: true,
                                                                store: stResonancia,
                                                                valueField: 'Descripcion',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                triggerAction: 'all',
                                                                id: 'strResonancia'
                                                            },
                                                            {
                                                                xtype: 'panel',
                                                                autoHeight: true,
                                                                title: 'Habla - Aspectos Suprasegmentales',
                                                                anchor: '100%',
                                                                layout: {
                                                                    type: 'form'
                                                                },
                                                                items: [
                                                                    {
                                                                        xtype: 'panel',
                                                                        autoHeight: true,
                                                                        title: 'Ritmo',
                                                                        anchor: '100%',
                                                                        layout: {
                                                                            type: 'form'
                                                                        },
                                                                        items: [
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'En Fonacion',
                                                                                name: 'Ritmo En Fonacion',
                                                                                width: 350,
                                                                                allowBlank: true,
                                                                                store: stRitmo,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strRitmoFonacion'
                                                                            },
                                                                            {
                                                                                xtype: 'combo',
                                                                                fieldLabel: 'Al Leer',
                                                                                name: 'Ritmo Al Leer',
                                                                                width: 350,
                                                                                allowBlank: true,
                                                                                store: stRitmo,
                                                                                valueField: 'Descripcion',
                                                                                displayField: 'Descripcion',
                                                                                mode: 'local',
                                                                                forceSelection: true,
                                                                                typeAhead: true,
                                                                                typeAheadDelay: 10,
                                                                                triggerAction: 'all',
                                                                                id: 'strRitmoAlLeer'
                                                                            }
                                                                        ]
                                                                    },
                                                                    {
                                                                        html: '<br>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Prosodia',
                                                                        name: 'Prosodia',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stProsodia,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strProsodia'
                                                                    },
                                                                    {
                                                                        html: '<br>'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        fieldLabel: 'Fluidez',
                                                                        name: 'Fluidez',
                                                                        width: 350,
                                                                        allowBlank: true,
                                                                        store: stCoordinacionFonoRespiratoria,
                                                                        valueField: 'Descripcion',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 10,
                                                                        triggerAction: 'all',
                                                                        id: 'strFluidez'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'OBSERVACIONES',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'OBSERVACIONES',
                                                        name: 'OBSERVACIONES',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memObservaciones'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'IMPRESION DIAGNOSTICA',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'textarea',
                                                        anchor: '100%',
                                                        width: 880,
                                                        fieldLabel: 'IMPRESION DIAGNOSTICA',
                                                        name: 'IMPRESION DIAGNOSTICA',
                                                        height: 100,
                                                        allowBlank: false,
                                                        id: 'memImpresionDiagnostica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'RIPS',
                                                layout: 'form',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                anchor: '100%',
                                                autoHeight: true,
                                                padding: 7,
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: false,
                                                                fieldLabel: 'Diagnostico Principal',
                                                                id: 'sysDiagPpalHC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagPpalHCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                id: 'btnSearchDiagPpalHC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                                id: 'sysDiagRel1HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel1HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                id: 'btnSearchDiagRel1HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                                id: 'sysDiagRel2HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel2HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                id: 'btnSearchDiagRel2HC1',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        style: 'background:transparent;',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                width: 96,
                                                                allowBlank: true,
                                                                fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                                id: 'sysDiagRel3HC',
                                                                listeners:{
                                                                    specialkey: function(f,e){
                                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                                        {
                                                                            if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: f.getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == "")
                                                                        {
                                                                            if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                                                Ext.Ajax.request(
                                                                                {
                                                                                    url: '../../controlador/cie10/controlador_cie10.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR',
                                                                                        pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                                    },
                                                                                    success: function(response,options)
                                                                                    {
                                                                                        var el = Ext.get('response'); // get the LOG
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                        } else {
                                                                                            Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }else{
                                                                                Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                                Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textarea',
                                                                readOnly: true,
                                                                width: 625,
                                                                height: 22,
                                                                id: 'sysDiagRel3HCNom'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado3',
                                                                id: 'btnSearchDiagRel3HC',
                                                                listeners:{
                                                                    click : function(){
                                                                        buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Diagnostico',
                                                        width:750,
                                                        name: 'Tipo de Diagnostico',
                                                        allowBlank: false,
                                                        store: 'StoreTipoDiagnostico',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        id: 'sysTipoDiagosticoHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Finalidad Consulta',
                                                        width:750,
                                                        name: 'Finalidad Consulta',
                                                        allowBlank: false,
                                                        store: 'StoreFinalidadConsulta',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 10,
                                                        id: 'sysFinalidadConsultaHC'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Causa Externa',
                                                        width:750,
                                                        name: 'Causa Externa',
                                                        allowBlank: false,
                                                        store: 'StoreCausaExterna',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione....',
                                                        submitValue: true,
                                                        value: 13,
                                                        id: 'sysCausaExternaHC'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }/*,
                            {
                                xtype: 'panel',
                                title: 'Solicitud Medicamentos',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaMedicamentos',
                                items: [
                                    xSolMX
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Servicios',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaServicios',
                                items: [
                                    xSolEXA
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud Remisiones',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaRemisiones',
                                items: [
                                    xSolREM
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Solicitud NO POS',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaNOPOS',
                                items: [
                                    xSolNOPOS
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Consentimientos Informados',
                                height: 355,
                                width: 921,
                                frame: true,
                                border: false,
                                id: 'fichaConsentimientos',
                                items: [
                                ]
                            },*/
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btnSalirEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 1)
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución del Paciente y Se Perdera la Información, Esta seguro que desea cerrar la ventana?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.getCmp('winHC').close();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                tbar:{
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historia Clínica',
                            iconCls: 'btnVerHC',
                            id: 'btnVerHC',
                            listeners:{
                                click : function(){
                                    var cmpResumenHC = new winFrmVerHistorialHC({
                                        renderTo: Ext.getBody()
                                    });
                                    Ext.getCmp('winViewEvolucionHC').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                    Ext.getCmp('gridHistorialEvoluciones').store.load({
                                        params: {
                                            pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                            pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                        }
                                    });
                                    cmpResumenHC.show();
                                }
                            }
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Evolución',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarEvolucion',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysYaGuardoHC').getValue() == 0)
                                    {
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Guardar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnGuardarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Esta seguro que desea Modificar la evolución?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn)
                                            {
                                                if(btn=="yes")
                                                {
                                                    fnModificarRegistrosMedicinaGeneral();
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winEvaluacionVoz001.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pidPlantillaHC : Ext.getCmp('sysIdCodPlantillaHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pGuardarSignos: "NO"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosMedicinaGeneral(){
    var frm = Ext.getCmp('frmHC').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrmHC(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                pIPS: Ext.getCmp('sysIPSHC').getValue(),
                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue(),
                pProfesional: Ext.getCmp('sysProfesionalHC').getValue(),
                pCAS: Ext.getCmp('sysCASHC').getValue(),
                pFechaAtencion: Ext.getCmp('sysFechaHC').getValue(),
                pHoraApertura: Ext.getCmp('sysAperturaHC').getValue(),
                pActividad: Ext.getCmp('sysActividadHC').getValue(),
                pPlantilla: Ext.getCmp('sysPlantillaHC').getValue(),
                pRutaRptHC: Ext.getCmp('sysRutaRptHC').getValue(),
                pRutaRptMx: Ext.getCmp('sysRutaRptMx').getValue(),
                pRutaRptExa: Ext.getCmp('sysRutaRptExa').getValue(),
                pRutaRptRem: Ext.getCmp('sysRutaRptRem').getValue(),
                pDiagppal: Ext.getCmp('sysDiagPpalHC').getValue(),
                pDiagrel1: Ext.getCmp('sysDiagRel1HC').getValue(),
                pDiagrel2: Ext.getCmp('sysDiagRel2HC').getValue(),
                pDiagrel3: Ext.getCmp('sysDiagRel3HC').getValue(),
                pTipodiag: Ext.getCmp('sysTipoDiagosticoHC').getValue(),
                pFinalidad: Ext.getCmp('sysFinalidadConsultaHC').getValue(),
                pCausa: Ext.getCmp('sysCausaExternaHC').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioHC').getValue(),
                pIdCliente: Ext.getCmp('sysIdClienteHC').getValue(),
                pIdPlan: Ext.getCmp('sysIdPlanHC').getValue(),
                pIdSubPlan: Ext.getCmp('sysIdSubPlanHC').getValue(),
                pIdContrato: Ext.getCmp('sysIdContratoHC').getValue(),
                pConsecutivoDetalle: Ext.getCmp('sysConsecutivoDetalleHC').getValue(),
                pGuardarSignos: "NO"
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysYaGuardoHC').setValue(1);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
