/*
* @category    Programacion Eventos Formulario Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmPacientes = Ext.extend(winPacientesUi, {
    initComponent: function() {
        winFrmPacientes.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        var ID_CONSULTORIO = el.getValue();
        el = Ext.get('usaPatrocinador');
        USA_PATROCINADOR = el.getValue();
        el = Ext.get('urlPrintHC');
        URLPrintHC = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        wURL = "";
        wNomImagen = "";
        winImgxPac = "";
        winDocxPac = "";
        paramOpcion = "Nuevo";
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        this.setPagePosition((screen.width - 1004)/2, 5);
        this.fNomEmpresa.setValue("Consultorio Virtual: " + Ext.get('nomConsultorio').getValue());
        this.fNomSede.setValue();
        this.fNomIPS.setValue();
        this.fNomUSR.setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        //fsPublicidad
        if(USA_PATROCINADOR == "SI"){
            Ext.getCmp('Publicidad').setVisible(true);
        }else{
            Ext.getCmp('Publicidad').setVisible(false);
        }
        
        Ext.getCmp('btn_ModificarItemFrm').setVisible(false);
        
        var fFecNac = Ext.getCmp('fecFecNac').on("Blur",this.MostrarEdad,this);
        var btn_SalirItemFrm = Ext.getCmp('btnSalir').on("click",this.CerrarVentana,this);
        var btnNuevoFrm = Ext.getCmp('btnNuevoFrm').on("click",this.NuevoPaciente,this);
        var btnBuscarPacienteFrm = Ext.getCmp('btnBuscarPacienteFrm').on("click",this.BuscarPaciente,this);
        var btn_AdicionarItemFrm = Ext.getCmp('btn_AdicionarItemFrm').on("click",this.GuardarItem,this);
        var btn_ModificarItemFrm = Ext.getCmp('btn_ModificarItemFrm').on("click",this.ModificarItem,this);
        var btnAddEvolucionHC = Ext.getCmp('btnAddEvolucionHC').on("click",this.AdicionarEvolucion,this);
        var btnPrintIncapacidadHC = Ext.getCmp('btnPrintIncapacidadHC').on("click",this.ImprimirIncapacidad,this);
        var btnPrintAllHC = Ext.getCmp('btnPrintAllHC').on("click",this.ImprimirAllHC,this);
        var btnPrintEvolucionHC = Ext.getCmp('btnPrintEvolucionHC').on("click",this.ImprimirEvolucionHC,this);
        var btnPrintMxHC = Ext.getCmp('btnPrintMxHC').on("click",this.ImprimirMxHC,this);
        var btnPrintMxNOPOSHC = Ext.getCmp('btnPrintMxNOPOSHC').on("click",this.ImprimirMxNOPOSHC,this);
        var btnPrintExamenesHC = Ext.getCmp('btnPrintExamenesHC').on("click",this.ImprimirExaHC,this);
        var btnPrintRemiHC = Ext.getCmp('btnPrintRemiHC').on("click",this.ImprimirRemHC,this);
        var strDocID = Ext.getCmp('strDocID').on("specialkey",this.ValidarDocPaciente,this);
        var btnImgxPacFrm1 = Ext.getCmp('btnImgxPacFrm1').on("click",this.ViewImgxPac,this);
        var btnDocxPacFrm1 = Ext.getCmp('btnDocxPacFrm1').on("click",this.ViewDocxPac,this);
    },
    ViewImgxPac: function(){
        if(Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('intIdPaciente').getValue() != null)
        {
            if(!winImgxPac){
                winImgxPac = new winImagenAsocxPac({
                    url:'../../controlador/pacientes/controlador_filesasoc.php',
                    width:515,
                    height:350
                });
            }
            winImgxPac.show();
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar un Paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ViewDocxPac: function(){
        if(Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('intIdPaciente').getValue() != null)
        {
            if(!winDocxPac){
                winDocxPac = new winDocumentoAsocxPac({
                    url:'../../controlador/pacientes/controlador_docsasoc.php',
                    width:515,
                    height:350
                });
            }
            winDocxPac.show();
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar un Paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ValidarDocPaciente:function(f,e){
        if ((e.getKey() == e.ENTER || e.getKey() == e.TAB) && (Ext.getCmp('strTdoc').getValue() != "")){
            Ext.Msg.wait('Buscando Paciente... por favor espere!');
            Ext.Ajax.request({
                url: '../../controlador/pacientes/controlador_pacientes.php',
                params:{
                    task: 'BuscarxDoc',
                    pTdoc: Ext.getCmp('strTdoc').getValue(),
                    pDocumento: f.getValue()
                },
                success: function(response,options)
                {
                    var el = Ext.get('response'); // get the LOG
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                        //Paciente No Existe
                    } else {
                        Ext.MessageBox.show({
                            title: NOM_APLICACION,
                            msg: 'El Documento de identidad ya existe en el sistema, por favor busque el paciente.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        Ext.getCmp('strDocID').setValue(null)
                    }
                }
            });
        }
    },
    ImprimirRemHC: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            window.open ("../../controlador/asistencial/printordenrem0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pCAS=" + selections[0].json.CAS,"Remisiones");
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar una Evolución.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirExaHC: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            window.open ("../../controlador/asistencial/printordenexacvm0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + + selections[0].json.Paciente + "&pCAS=" + selections[0].json.CAS,"Ordenamientos");
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar una Evolución.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirMxHC: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            window.open ("../../controlador/asistencial/printformula0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + + selections[0].json.Paciente + "&pCAS=" + selections[0].json.CAS,"Formula Medica");
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar una Evolución.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirMxNOPOSHC: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            window.open ("../../controlador/asistencial/printformulanopos2013.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pCAS=" + selections[0].json.CAS,"Formula Medica NO POS");
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar una Evolución.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirEvolucionHC: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            if(URLPrintHC == "NA"){
                window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
            }else{
                var urlPrintHC = "../../controlador/asistencial/" + URLPrintHC;
                //window.open (urlPrintHC + "?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
                window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Historia Clinica");
            }
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar una Evolución.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirAllHC: function(){
        if (Ext.getCmp('intIdPaciente').getValue() > 0 && Ext.getCmp('sysPacienteValido').getValue() > 0){
            if(URLPrintHC == "NA"){
                window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('intIdPaciente').getValue() + "&pEvolucion=0","Historia Clinica");
            }else{
                var urlPrintHC = "../../controlador/asistencial/" + URLPrintHC;
                //window.open (urlPrintHC + "?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('intIdPaciente').getValue() + "&pEvolucion=0","Historia Clinica");
                window.open ("../../controlador/asistencial/imprimirhc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('intIdPaciente').getValue() + "&pEvolucion=0","Historia Clinica");
            }
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar un Paciente o No se ha guardado la información del Paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ImprimirIncapacidad: function(){
        if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
        {
            var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
            window.open ("../../controlador/asistencial/cvmprintformularx.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + selections[0].json.Paciente + "&pEvolucion=" + selections[0].json.ConsecutivoHC,"Formula de Anteojos");
        }else{
            Ext.MessageBox.show({
                title: NOM_APLICACION,
                msg: 'Debe Seleccionar una Evolución.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    AdicionarEvolucion: function(){
        if (Ext.getCmp('intIdPaciente').getValue() != 0 && Ext.getCmp('sysPacienteValido').getValue() != 0){
            Ext.Ajax.request({
                waitMsg: 'Por favor Espere...',
                url: "../../controlador/asistencial/ofimedicalhc.php",
                params:{
                    task: "BorrarESTUDIOSSinEvolucionar",
                    pEmpresa: ID_EMPRESA,
                    pIPS: ID_IPS,
                    pPaciente: Ext.getCmp('intIdPaciente').getValue()
                },
                callback: function(o,s,r){
                    var frmAddEvolucionOfimedical = new winAddEvolucionOfimedicalUi();
                    Ext.getCmp('gridSeleccionarPlantillaHC').setVisible(false);
                    Ext.getCmp('sysEmpresaPlantillaHC').setValue(ID_EMPRESA);
                    Ext.getCmp('sysSedePlantillaHC').setValue(ID_SEDE);
                    Ext.getCmp('sysIPSPlantillaHC').setValue(ID_IPS);
                    Ext.getCmp('sysUsuarioPlantillaHC').setValue(ID_USUARIO);
                    Ext.getCmp('sysProfesionalPlantillaHC').setValue(1);
                    Ext.getCmp('sysPacientePlantillaHC').setValue(Ext.getCmp('intIdPaciente').getValue());
                    Ext.getCmp('sysNomProfesionalPlantillaHC').setValue("");
                    Ext.getCmp('sysNomPacientePlantillaHC').setValue(PonerAcentosMayusculas(Ext.getCmp('strTdoc').getValue() + '-' + Ext.getCmp('strDocID').getValue() + ' ' + Ext.getCmp('strNom1').getValue() + ' ' + Ext.getCmp('strNom2').getValue() + ' ' + Ext.getCmp('strApe1').getValue() + ' ' + Ext.getCmp('strApe2').getValue()));
                    frmAddEvolucionOfimedical.show();
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'El Paciente no es valido o no ha sido creado',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    ModificarItem: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Pacientes',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR","NO","winPacientesUi","frmPacientes","../../controlador/pacientes/controlador_ofimedical.php","NA","NA","NA","NO","NO");
                }
            }
        });
    },
    GuardarItem: function(){ //ok
        Ext.Msg.show({
            title: 'Guardar Pacientes',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnInsertarRegistros("INSERTAR","SI","winPacientesUi","frmPacientes","../../controlador/pacientes/controlador_ofimedical.php","NA");
                }
            }
        });
    },
    
    BuscarPaciente: function(){
        buscarpacienteofimedical();
    },
    NuevoPaciente: function(){
        Ext.Msg.show({
            title: 'Nuevo Registro',
            msg: 'Esta seguro que desea hacer un nuevo registro, si hace este se perdera la información ingresada hasta ahora',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmPacientes').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    Ext.getCmp('sysInfoPaciente').setValue(null);
                    Ext.getCmp('intIdPaciente').setValue(0);
                    Ext.getCmp('btn_AdicionarItemFrm').setVisible(true);
                    Ext.getCmp('btn_ModificarItemFrm').setVisible(false);
                    Ext.getCmp('gridFormulario').store.load({
                        params: {
                            pPaciente: 0
                        }
                    });
                }
            }
        });
    },
    MostrarEdad: function(f) {
        Ext.getCmp('strEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
    },
    CerrarVentana: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                  window.close();
                }
            }
        });
    }
    
});

function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnInsertarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                var Respuesta = req.result.requestedId;
                var Contenido = Respuesta.split('^');
                if(Contenido[0]=="0" || Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                    Ext.getCmp('intIdPaciente').setValue(0);
                    Ext.getCmp('sysPacienteValido').setValue(0);
                    Ext.Msg.hide();
                    Ext.MessageBox.show({
                        title: 'Guardando Paciente',
                        msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                } else {
                    Ext.getCmp('intIdPaciente').setValue(Contenido[0]);
                    Ext.getCmp('sysPacienteValido').setValue(1);
                    Ext.getCmp('sysInfoPaciente').setValue(Ext.getCmp('strDocID').getValue() + " - " + Ext.getCmp('strNom1').getValue() + " " + Ext.getCmp('strNom2').getValue() + " " + Ext.getCmp('strApe1').getValue() + " " + Ext.getCmp('strApe2').getValue());
                    Ext.getCmp('gridFormulario').store.load({
                        params: {
                            pPaciente: 0
                        }
                    });
                    Ext.getCmp('strProfesionPac').store.reload();
                    Ext.getCmp('btn_AdicionarItemFrm').setVisible(false);
                    Ext.getCmp('btn_ModificarItemFrm').setVisible(true);
                    Ext.MessageBox.hide();
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Se Guardo la Información con Exito.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

                                                
function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        Ext.getCmp('sysInfoPaciente').setValue(Ext.getCmp('strDocID').getValue() + " - " + Ext.getCmp('strNom1').getValue() + " " + Ext.getCmp('strNom2').getValue() + " " + Ext.getCmp('strApe1').getValue() + " " + Ext.getCmp('strApe2').getValue());
                        Ext.getCmp('strProfesionPac').store.reload();
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.hide();
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

