/*
* @category    Formulario Adicionar Solicitud Consentimeinto Informado
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddSolConentimientoInformado001Ui = Ext.extend(Ext.Window, {
    title: '.:: Consentimiento Informado ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddSolConsentimiento001',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddSolConentimiento',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intPacienteSolConsentimento',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioSolConsentimento',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdConsecutivoSolConsentimento',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Consentimiento',
                                name: 'Consentimiento',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreConsentimientoInformado',
                                valueField: 'IdConsentimiento',
                                displayField: 'NombreConsentimiento',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'intConsentimientoSolConsentimento'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Responsable',
                                        width: 533,
                                        allowBlank: false,
                                        readOnly: true,
                                        id: 'strResponsableSolConsentimento'
                                    },    
                                    {
                                        html: 'Fecha Solicitud:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        allowBlank: false,
                                        readOnly: true,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        value: new Date().format('d/m/Y'),
                                        id: 'fecFecSolicitudSolConsentimento'
                                    }
                                ]
                            },
                            {
                                html: '<hr>'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Observaciones',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'memObservacionesSolConsentimento'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemConsentimiento001("GUARDAR_CONSENTIMIENTO","SI","winAddSolConsentimiento001","frmAddSolConentimiento","../../controlador/consentimientoinformado/controlador_consentimiento.php","gridConsentimientosInformadosxPac");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddSolConentimientoInformado001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemConsentimiento001(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                pPaciente: Ext.getCmp('intPacienteSolConsentimento').getValue(),
                pUsuario: Ext.getCmp('intUsuarioSolConsentimento').getValue(),
                pIdConsecutivo: Ext.getCmp('intIdConsecutivoSolConsentimento').getValue(),
                pConsentimiento: Ext.getCmp('intConsentimientoSolConsentimento').getValue(),
                pResponsable: Ext.getCmp('strResponsableSolConsentimento').getValue(),
                pFecSolicitud: Ext.getCmp('fecFecSolicitudSolConsentimento').getValue().format('Y-m-d'),
                pObservaciones: Ext.getCmp('memObservacionesSolConsentimento').getValue().toUpperCase()
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                                Ext.getCmp('winAddSolConsentimiento001').close();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.reload();
                                Ext.getCmp('winAddSolConsentimiento001').close();
                            }
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}