/*
* @category    Formulario Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winPacientesUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic .:: Clinica de Caidas ::.',
    width: 1014,
    height: 600,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winPacientesUi',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        
        wPaciente = 0;
        wCAS = 0;
        
        function DescripcionGrid(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }

        function DescripcionProfesional(val, x, store){
            if(store.data.ConceptoMedicoOcupacional == "" || store.data.ConceptoMedicoOcupacional == null){
                return "";
            }else{
                return val;
            }
        }
        
        var gridFormularioHC = new StoreGridEvolucionesxPacienteOfimedical();
        
        
        this.items = [
            {
                xtype: 'tabpanel',
                id: 'tbOpcionesPacientes',
                activeTab: 0,
                anchor: '100%',
                height: 570,
                //autoHeight: true,
                border: false,
                items: [
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Datos del Paciente',
                        items:[
                            {
                                xtype: 'form',
                                frame: true,
                                height: 542,
                                //autoHeight: true,
                                anchor: '100%',
                                autoScroll: true,
                                id: 'frmPacientes',
                                fileUpload: true,
                                padding: 10,
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        border: false,
                                        labelWidth: 130,
                                        items: [
                                            {
                                                xtype: 'hidden',
                                                id: 'intIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'fieldset',
                                                title: 'Datos del Paciente',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                width: 915,
                                                height: 380,
                                                id: 'fsPaciente',
                                                layoutConfig: {
                                                    columns: 4
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 221,
                                                        border: false,
                                                        id: 'pnTdoc',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Doc ID',
                                                                anchor: '100%',
                                                                name: 'cbTdoc',
                                                                allowBlank: false,
                                                                //store: 'StoreTdocPac',
                                                                store: 'StoreTdocPac',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Tipo Documento....',
                                                                mode: 'local',
                                                                triggerAction: 'all',
                                                                forceSelection: true,
                                                                id: 'strTdoc'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 269,
                                                        border: false,
                                                        id: 'pnDocID',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Documento ID',
                                                                        name: 'txtDocID',
                                                                        allowBlank: false,
                                                                        width: 200,
                                                                        id: 'strDocID'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnBuscar',
                                                                        tooltip: 'Buscar Paciente',
                                                                        id: 'btnBuscarPacienteFrm'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 172,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnGenero',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Genero',
                                                                anchor: '100%',
                                                                name: 'cbGenero',
                                                                allowBlank: false,
                                                                store: 'StoreGenero',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Genero....',
                                                                forceSelection: true,
                                                                id: 'strGenero'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe1',
                                                                style: 'text-transform:uppercase;',
                                                                allowBlank: false,
                                                                id: 'strApe1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strApe2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 215,
                                                        border: false,
                                                        id: 'pnNom1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Nombre',
                                                                anchor: '96%',
                                                                name: 'txtNom1',
                                                                allowBlank: false,
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        border: false,
                                                        width: 145,
                                                        id: 'pnNom2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Nombre',
                                                                anchor: '78%',
                                                                name: 'txtNom2',
                                                                style: 'text-transform:uppercase;',
                                                                id: 'strNom2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 146,
                                                        border: false,
                                                        id: 'pnFecNac',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Nacimiento',
                                                                anchor: '100%',
                                                                name: 'txtFecNac',
                                                                allowBlank: false,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                id: 'fecFecNac'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnEdad',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Edad Actual',
                                                                anchor: '100%',
                                                                name: 'txtEdad',
                                                                readOnly: true,
                                                                allowBlank: false,
                                                                style: 'color: blue;text-align:center',
                                                                id: 'strEdad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 366,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnDeptoMuni',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Municipio - Departamento',
                                                                anchor: '93%',
                                                                name: 'cbDeptoMuni',
                                                                allowBlank: false,
                                                                store: 'StoreDeptoMuni',
                                                                valueField: 'IdDeptoMunicipio',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Municipio - Departamento....',
                                                                mode: 'local',
                                                                listWidth: 450,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                id: 'strDeptoMuni'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                style: 'background:transparent;',
                                                                fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                                anchor: '100%',
                                                                id: 'composDatDirTel',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtDireccion',
                                                                        allowBlank: false,
                                                                        emptyText: 'Dirección....',
                                                                        style: 'text-transform:uppercase;',
                                                                        width: 280,
                                                                        id: 'strDireccion'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel1',
                                                                        allowBlank: false,
                                                                        emptyText: 'Teléfono',
                                                                        width: 160,
                                                                        id: 'strTel1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel2',
                                                                        emptyText: 'Teléfono (Otro - Cel.)',
                                                                        width: 160,
                                                                        id: 'strTel2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        fieldLabel: 'Zona',
                                                                        store: 'StoreZonaResidencia',
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        name: 'cbZona',
                                                                        emptyText: 'Zona....',
                                                                        allowBlank: false,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 80,
                                                                        value: 'Urbana',
                                                                        triggerAction: 'all',
                                                                        id: 'strZona'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmail',
                                                                        vtype: 'email',
                                                                        emptyText: 'Email....',
                                                                        width: 180,
                                                                        id: 'strEmail'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    
                                                    {
                                                        xtype: 'hidden',
                                                        name: 'txtEmpresaTrabaja',
                                                        width: 880,
                                                        id: 'strEmpresaTrabaja'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        flex: 1,
                                                        store: 'StoreEstadoCivil',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        emptyText: 'Estado Civil',
                                                        allowBlank: true,
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        width: 120,
                                                        triggerAction: 'all',
                                                        id: 'strEstadoCivilPac'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        flex: 1,
                                                        store: 'StoreEscolaridad',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        emptyText: 'Escolaridad',
                                                        allowBlank: true,
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        width: 180,
                                                        triggerAction: 'all',
                                                        id: 'strEscolaridadPac'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        flex: 1,
                                                        store: 'StoreProfesion',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        emptyText: 'Profesión',
                                                        allowBlank: true,
                                                        forceSelection: false,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        width: 570,
                                                        triggerAction: 'all',
                                                        id: 'strProfesionPac'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ],
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'button',
                                            text: 'Nuevo',
                                            iconCls: 'btnNuevo',
                                            id: 'btnNuevoFrm'
                                        },
                                        '-',
                                        {
                                            xtype: 'button',
                                            text: 'Imagenes Asociadas',
                                            iconCls: 'btnCargarFoto',
                                            id: 'btnImgxPacFrm1'
                                        },
                                        '-',
                                        {
                                            xtype: 'button',
                                            text: 'Documentos Asociados',
                                            iconCls: 'btnCargarFile',
                                            id: 'btnDocxPacFrm1'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_AdicionarItemFrm'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar',
                                            iconCls: 'btnGuardar',
                                            id: 'btn_ModificarItemFrm'
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Proceso de Atencion',
                        id: 'pntabEvaluacion',
                        items:[
                            {
                                xtype: 'hidden',
                                id: 'sysCASRefHC'
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPacienteRefHC'
                            },
                            {
                                xtype: 'textfield',
                                allowBlank: false,
                                style: 'background:transparent; color: darkblue; font-size:14px; text-align: center; text-transform:uppercase;',
                                width: 972,
                                height: 30,
                                border: false,
                                id: 'sysInfoPaciente'
                            },
                            {
                                xtype: 'grid',
                                id: 'gridFormulario',
                                store: 'StoreGridProcesosxPacienteClinicaCaidas',
                                title: '',
                                anchor: "100%",
                                border: false,
                                frame: true,
                                height: 510,
                                tbar:{
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            tooltip: 'Actualizar',
                                            id: 'btnActualizarInfoPac'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Adicionar Atencion',
                                            iconCls: 'btnAddRow',
                                            id: 'btnAddEvolucionHC'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Cerrar Atencion',
                                            iconCls: 'btnCerrar',
                                            id: 'btnCerrarProceso'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar Atencion',
                                            iconCls: 'btnDelRow',
                                            id: 'btnEliminarProceso'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Impimir Historia',
                                            iconCls: 'btnImprimir',
                                            tooltip: 'Imprimir Historia',
                                            id: 'btnPrintHCSO'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },/*
                                        {
                                            xtype: 'button',
                                            text: 'Orden Examenes',
                                            iconCls: 'btnImprimir',
                                            id: 'btnPrintExamenesHC'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Remisiones',
                                            iconCls: 'btnImprimir',
                                            id: 'btnPrintRemiHC'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }*/
                                    ]
                                },
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'FechaAtencion'
                                    },
                                    {
                                        header: 'Proceso Actual',
                                        dataIndex: 'ProcesoActual',
                                        sortable: true,
                                        width: 190
                                    },
                                    {
                                        header: 'Ubicación Actual',
                                        dataIndex: 'UbicacionActual',
                                        sortable: true,
                                        width: 190
                                    },
                                    {
                                        header: 'Estado',
                                        dataIndex: 'ConceptoFinal',
                                        sortable: true,
                                        width: 100
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                viewConfig: {
                                    getRowClass: function(record, index) {
                                        switch(record.get('ConceptoFinal')){
                                            case "CERRADO":
                                                return 'Apto';
                                                break;
                                            case "SIN FINALIZAR":
                                                return 'NoApto';
                                                break;
                                            default:
                                                break;
                                        }
                                    }
                                }
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        style: 'background:transparent;',
                        title: 'Seguimiento Telefonico',
                        id: 'pntabSeguimiento',
                        items:[
                            {
                                xtype: 'grid',
                                id: 'gridFormularioEvolucion',
                                store: gridFormularioHC,
                                title: '',
                                anchor: "100%",
                                border: false,
                                frame: true,
                                height: 510,
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'IdCliente',
                                        sortable: false,
                                        width: 1,
                                        hidden: true,
                                        hideable: false,
                                        dataIndex: 'IdCliente'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'CAS',
                                        sortable: false,
                                        width: 80,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'CAS'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha Seguimiento',
                                        sortable: false,
                                        width: 120,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'FechaAtencion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Funcionario',
                                        sortable: false,
                                        width: 300,
                                        hidden: false,
                                        hideable: false,
                                        dataIndex: 'NomProfesional'
                                    }
                                ],
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                /*bbar:
                                {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Actualizar',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnActualizarEvolucionHC'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },*/
                                tbar:
                                {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Listar Seguimientos',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnActualizarEvolucionHC'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Adicionar Seguimiento Telefonico',
                                            iconCls: 'btnAdd',
                                            id: 'btnSeguimientoTelefonico'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imprimir',
                                            iconCls: 'btnImprimir',
                                            id: 'btnPrintEvolucionHC'
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winPacientesUi.superclass.initComponent.call(this);
    }
});
