/*
* @category    Formulario Eliminar Proceso
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEliminaProcesoUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Eliminar Atencion ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winEliminarProceso',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmEliminarProceso',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASEliminaProceso'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Motivo',
                        name: 'strMotivo',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo...!',
                        id: 'strMotivoEliminaProceso'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Eliminar Proceso',
                            iconCls: 'btnBorrar',
                            id: 'btnEliminar_Proceso',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmEliminarProceso').getForm();
                                    if (frm.isValid()){
                                        frm.submit({
                                            url: '../../controlador/clinicacaidas/controlador_clinicacaidas.php',
                                            params: {
                                                task: 'ELIMINAR_PROCESO',
                                                pCAS: Ext.getCmp('sysCASEliminaProceso').getValue(),
                                                pMotivo: QuitarAcentosMayusculas(Ext.getCmp('strMotivoEliminaProceso').getValue())
                                            },
                                            success: function(res,req){
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.getCmp('gridFormulario').store.reload();
                                                        Ext.MessageBox.show({
                                                            title: 'Eliminar Atencion',
                                                            msg: 'Se Elimino la Atencion con Exito.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        Ext.getCmp('winEliminarProceso').close();
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Eliminar Atencion',
                                                            msg: 'Ocurrio un error al eliminar la atencion o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options){
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos Eliminar la Atencion en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Motivo es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winEliminaProcesoUi.superclass.initComponent.call(this);
    }
});
