
/*
* @category    Formulario Seleccion Plantilla HC y Apertura HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddEvolucionOfimedicalUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic .:: Apertura de Atencion Clinica de Caidas ::.',
    x: ((screen.width - 1004)/2) + 130,
    y: 50,
    width: 730,
    autoHeight: true,
    modal: true,
    closable: false,
    frame: true,
    padding: 10,
    labelWidth: 150,
    layout: 'form',
    id: 'winAddEvolucionOfimedicalUi',
    style: 'background:transparent;',
    initComponent: function() {
        
        //var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Formulario..."});
        //myMask.show();
        
        var stGrid = new StoreGridPlantillasHC();
        var stComboUbicacion = new StoreConsultoriosxIPS();
        var stConceptosxProfe = new StoreProcedimientosProgramadosxProfesional();
        stComboUbicacion.load({
            params: {
                pEmpresa: 1,
                pSede:1,
                pIPS: 1
            }
        });
        stConceptosxProfe.load({
            params: {
                pProfesional: 1
            }
        });
        stGrid.setBaseParam('pEmpresa', ID_EMPRESA);
        stGrid.load();
        this.bbar = [
            '->',
            {
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners: {
                    click : function() {
                        Ext.Msg.show({
                            title: 'eOfiClinic',
                            msg: 'Esta seguro que desea cerrar la ventana?',
                            buttons: Ext.Msg.YESNO,
                            icon: Ext.Msg.QUESTION,
                            fn: function(btn)
                            {
                                if(btn=="yes")
                                {
                                    Ext.getCmp('winAddEvolucionOfimedicalUi').close();
                                }
                            }
                        });
                    }
                }
            }
        ];
        this.items = [
            {
                xtype: 'form',
                id: 'frmParms',
                anchor: '100%',
                frame: true,
                autoHeight: true,
                items:[
                    {
                        xtype: 'hidden',
                        id: 'sysEmpresaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSedePlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysGeneroPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIPSPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysActividadPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPlantillaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysUsuarioPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysProfesionalPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPacientePlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysConsecutivoDetalle_HC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysHoraPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysFechaLegalizaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysHoraEstimadaPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'CAS',
                        id: 'sysCASPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Profesional',
                        id: 'sysNomProfesionalPlantillaHC'
                    },

                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Cliente',
                        id: 'sysClientePlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'sysIdPlan_HC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'sysIdSubPlan_HC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'sysIdContrato_HC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Actividad Programada',
                        id: 'sysActividadPlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        autoHeight: true,
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysNomPacientePlantillaHC'
                    },
                    {
                        xtype: 'hidden',
                        readOnly: true,
                        width: 96,
                        allowBlank: true,
                        style: 'color: #0000cc; font-weight: bold;',
                        id: 'sysCodConcepto'
                    },
                    {
                        xtype: 'hidden',
                        readOnly: true,
                        width: 455,
                        height: 50,
                        fieldLabel: 'Descripción',
                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                        id: 'sysDesConcepto'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIVA',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysVlrIVA',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysidTipoReg',
                        value: 0
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Ubicación / Consultorio',
                        anchor: '100%',
                        allowBlank: false,
                        store: stComboUbicacion,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        value: 1,
                        id: 'sysUbicacionPlantillaHC'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Cliente',
                        anchor: '100%',
                        allowBlank: false,
                        store: 'StoreCliente',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        value: 1,
                        id: 'sysIdCliente_HC'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Consulta / Procedimiento',
                        anchor: '100%',
                        allowBlank: false,
                        store: stConceptosxProfe,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'IdProced',
                        displayField: 'DesProced',
                        emptyText: 'Seleccione....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'intIdProcedimiento',
                        listeners:{
                            change : function(f,pNew, pOld){
                                stConceptosxProfe.filterBy(function(record,id){  
                                    return record.get('IdProced') == pNew;
                                });  
                                stConceptosxProfe.each(function(record){  
                                    Ext.getCmp('sysDesConcepto').setValue(record.get('DesProced'));
                                    Ext.getCmp('sysCodConcepto').setValue(record.get('CodProced'));
                                });  
                                stConceptosxProfe.clearFilter();  
                            }
                        }
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        fieldLabel: 'Fecha Cita',
                        items: [
                            {
                                xtype: 'datefield',
                                width: 120,
                                fieldLabel: 'Fecha Cita',
                                allowBlank: false,
                                disabledDates: '',
                                emptyText: '(dia/mes/año) ',
                                style: 'text-align:center;',
                                id: 'sysFechaPlantillaHC'
                            },
                            {
                                xtype: 'displayfield',
                                value: '&nbsp;'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnGuardar',
                                tooltip: 'Crear Registro de Evolución',
                                id: 'btnCrearHC',
                                text: 'Crear Registro de Evolución',
                                handler:function(){
                                    if(Ext.getCmp('sysUbicacionPlantillaHC').getValue() != "" && Ext.getCmp('sysUbicacionPlantillaHC').getValue() != null && Ext.getCmp('sysIdCliente_HC').getValue() != "" && Ext.getCmp('sysIdCliente_HC').getValue() != null && Ext.getCmp('sysFechaPlantillaHC').getValue() != "" && Ext.getCmp('sysFechaPlantillaHC').getValue() != null && Ext.getCmp('intIdProcedimiento').getValue() != "" && Ext.getCmp('intIdProcedimiento').getValue() != null && Ext.getCmp('intIdProcedimiento').getValue() != 0){
                                        var Municipio = " ";
                                        try {
                                            var campo = Ext.getCmp('strDeptoMuni');
                                            if ( campo != null ) {
                                                Municipio = Ext.getCmp('strDeptoMuni').getValue();
                                            }
                                            var campo1 = Ext.getCmp('strMunicipio');
                                            if ( campo1 != null ) {
                                                Municipio = Ext.getCmp('strMunicipio').getValue();
                                            }
                                        }catch(ex) {
                                            // aqui se atrapo el error y se le puede mandar un mensaje al usuario o hacer alguna acción que controle el error.
                                            //Ext.Msg('El campo no se encontro,' + ex.Message);
                                        }
                                        Ext.Ajax.request(
                                        {
                                            waitMsg: 'Por favor Espere...',
                                            url: "../../controlador/clinicacaidas/controlador_clinicacaidas.php",
                                            params:{
                                                task: "CrearESTUDIOS",
                                                pEmpresa: ID_EMPRESA,
                                                pConsultorio: Ext.getCmp('sysUbicacionPlantillaHC').getValue(),
                                                pCliente: Ext.getCmp('sysIdCliente_HC').getValue(),
                                                pFecha:  Ext.getCmp('sysFechaPlantillaHC').getValue().format('Y/m/d'),
                                                pProfesional: 1,
                                                pPaciente: Ext.getCmp('intIdPaciente').getValue(),
                                                pEdadPaciente: Ext.getCmp('strEdad').getValue(),
                                                pDeptoMunici: Municipio, 
                                                pIdProcedimiento: Ext.getCmp('intIdProcedimiento').getValue(), 
                                                pCodProcedimiento: Ext.getCmp('sysCodConcepto').getValue(), 
                                                pDesProcedimiento: Ext.getCmp('sysDesConcepto').getValue(),
                                                pUsuario: ID_USUARIO
                                            },
                                            success: function(response,options){
                                                var el = Ext.get('response'); 
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                var NroCAS = Contenido[0];
                                                if(NroCAS > 0){
                                                    Ext.getCmp('sysCASPlantillaHC').setValue(Contenido[0]);
                                                    Ext.getCmp('sysConsecutivoDetalle_HC').setValue(Contenido[1]);
                                                    Ext.getCmp('gridFormulario').store.reload();
                                                    Ext.Msg.hide();
                                                    Ext.MessageBox.show({
                                                        title: 'Crear Registro Evolución',
                                                        msg: 'Se creo el registro con exito.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.INFO
                                                    });
                                                    Ext.getCmp('winAddEvolucionOfimedicalUi').close();
                                                } else {
                                                    Ext.Msg.hide();
                                                    Ext.MessageBox.show({
                                                        title: 'Crear Registro Evolución',
                                                        msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            },
                                            failure: function(response,options){
                                                Ext.MessageBox.hide();
                                                Ext.MessageBox.show({
                                                    title: 'Crear Registro Evolución',
                                                    msg: 'Ocurrio un error al guardar la información o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los campos de la pantalla son requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        ],
                        buttonAlign: 'center',
                        listeners: {
                            viewready : function() {
                                myMask.hide();
                            }
                        }
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    var frm = Ext.getCmp('frmParms').getForm();
                    frm.doAction('load', {
                        url: '../../controlador/asistencial/ofimedicalhc.php',
                        waitMsg: 'Cargando Información...',
                        params:{
                            pIPS: ID_IPS,
                            task: 'CargarParametrosAddEvolucion'
                        }
                    });
                }
            } 
        });
        winAddEvolucionOfimedicalUi.superclass.initComponent.call(this);
    }
});
